/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.command;

import com.ibm.uma.NamedElement;
import com.ibm.uma.UmaPackage;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.validation.IValidator;

public class MethodElementCreateChildCommand
extends CreateChildCommand {
    private boolean executed = false;
    protected IValidator validator;

    public MethodElementCreateChildCommand(EditingDomain domain, EObject owner, EStructuralFeature feature, Object child, int index, Collection selection, CreateChildCommand.Helper helper) {
        super(domain, owner, feature, child, index, selection, helper);
    }

    private void superExecute() {
        super.execute();
    }

    protected IValidator getValidator() {
        if (this.validator == null) {
            this.validator = new IValidator(){

                public String isValid(String newText) {
                    if (newText.trim().length() == 0) {
                        String elementText = LibraryEditResources.getString("LibraryEdit.element.text");
                        return LibraryEditResources.formatString("LibraryEdit.emptyElementNameError.msg", elementText);
                    }
                    List children = (List)MethodElementCreateChildCommand.this.owner.eGet(MethodElementCreateChildCommand.this.feature);
                    Iterator iter = children.iterator();
                    while (iter.hasNext()) {
                        NamedElement child = (NamedElement)iter.next();
                        if (!child.getName().equalsIgnoreCase(newText)) continue;
                        return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", newText);
                    }
                    return null;
                }
            };
        }
        return this.validator;
    }

    public void execute() {
        String title = LibraryEditResources.formatString("LibraryEdit.newElement.text", this.helper.getCreateChildText((Object)this.owner, (Object)this.feature, this.child, this.selection));
        IValidator validator = this.getValidator();
        String name = UserInteractionHelper.requestName(this.child, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), title, validator);
        if (name != null) {
            ((NamedElement)this.child).setName(name);
            this.superExecute();
            this.executed = true;
        }
    }

    public Collection getAffectedObjects() {
        if (this.executed) {
            return super.getAffectedObjects();
        }
        return Collections.singletonList(this.owner);
    }

    public Collection getResult() {
        if (this.executed) {
            return super.getResult();
        }
        return Collections.EMPTY_LIST;
    }
}

