/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.itemsfilter;

import com.ibm.uma.Artifact;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Domain;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.VariabilityElement;
import commonj.sdo.DataObject;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterInitializer;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ModelStructure;

public class FilterHelper {
    private String pattern;
    private String type;
    private Pattern regex;
    private String tabStr;
    private Object contentElement;
    private List existingElements = new ArrayList();
    private boolean showPresentationName = false;

    public FilterHelper(Object contentElement, String tabStr, String pattern, String filterTypeStr, List alreadySelectedList) {
        this.contentElement = contentElement;
        this.tabStr = tabStr;
        this.type = filterTypeStr;
        this.existingElements = alreadySelectedList;
        this.pattern = pattern;
        this.showPresentationName = PresentationContext.INSTANCE.isShowPresentationNames();
    }

    public List getAlreadySelectedList() {
        return this.existingElements;
    }

    public void setAlreadySelectedList(List alreadySelectedList) {
        this.existingElements = alreadySelectedList;
    }

    public boolean matchPattern(Object obj) {
        return this.match(obj);
    }

    private boolean hasMatchedChildCustomCategory(CustomCategory topCategory) {
        List list = topCategory.getCategorizedElements();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof CustomCategory)) continue;
            CustomCategory category = (CustomCategory)object;
            if (this.matcher(category)) {
                return true;
            }
            if (!this.hasMatchedChildCustomCategory(category)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedArtifact(Artifact artifact) {
        List list = artifact.getContainedArtifacts();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (!(object instanceof Artifact)) continue;
            Artifact subartifact = (Artifact)object;
            if (this.matcher(subartifact)) {
                return true;
            }
            if (!this.hasMatchedArtifact(subartifact)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedChild(ContentPackage pkg) {
        Iterator iter = pkg.getChildPackages().iterator();
        while (iter.hasNext()) {
            Object childPkg = iter.next();
            if (!(childPkg instanceof ContentPackage)) continue;
            ContentPackage contentPkg = (ContentPackage)childPkg;
            if (this.matcher(contentPkg)) {
                return true;
            }
            if (!this.hasMatchedChild(contentPkg)) continue;
            return true;
        }
        return false;
    }

    private boolean hasMatchedSubDomains(Domain domain) {
        List list = domain.getSubdomains();
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            Object subdomain = iterator.next();
            if (this.matcher(subdomain)) {
                return true;
            }
            if (!this.hasMatchedSubDomains((Domain)subdomain)) continue;
            return true;
        }
        return false;
    }

    public String getFilterTypeStr() {
        while (this.type != null && this.type.indexOf("-") > -1 && !this.type.equals(FilterConstants.METHO_PLUGINS)) {
            this.type = this.type.substring(this.type.indexOf("-") + 1, this.type.length());
        }
        return this.type;
    }

    public String getPattern() {
        return this.pattern;
    }

    public Pattern getRegexPattern() {
        return this.regex;
    }

    public String getTabStr() {
        return this.tabStr;
    }

    public boolean checkVariability(Object obj) {
        VariabilityElement variabilityObject;
        return this.contentElement instanceof ContentElement && (variabilityObject = ((ContentElement)this.contentElement).getVariabilityBasedOnElement()) != null && obj.equals(variabilityObject);
    }

    public Object getContentElement() {
        return this.contentElement;
    }

    public void setContentElement(Object contentElement) {
        this.contentElement = contentElement;
    }

    public void setFilterTypeStr(String filterTypeStr) {
        this.type = filterTypeStr;
    }

    public void setPattern(String pattern) {
        this.pattern = pattern;
    }

    public void setRegexPattern(Pattern regexPattern) {
        this.regex = regexPattern;
    }

    public void setTabStr(String tabStr) {
        this.tabStr = tabStr;
    }

    public String[] getPathBasedOnTabString(String tabStr) {
        if (FilterConstants.contentElementStrs.contains(tabStr)) {
            return ModelStructure.DEFAULT.coreContentPath;
        }
        if (tabStr.equals(FilterConstants.ROLESETS) || tabStr.equals(FilterConstants.ROLE_SET_GROUPINGS)) {
            return ModelStructure.DEFAULT.roleSetPath;
        }
        if (tabStr.equals(FilterConstants.DISCIPLINES) || tabStr.equals(FilterConstants.DISCIPLINE_GROUPINGS)) {
            return ModelStructure.DEFAULT.disciplineDefinitionPath;
        }
        if (tabStr.equals(FilterConstants.TOOLS)) {
            return ModelStructure.DEFAULT.toolPath;
        }
        if (tabStr.equals(FilterConstants.WORKPRODUCTTYPES)) {
            return ModelStructure.DEFAULT.workProductTypePath;
        }
        if (tabStr.equals(FilterConstants.DOMAINS)) {
            return ModelStructure.DEFAULT.domainPath;
        }
        if (tabStr.equals(FilterConstants.CUSTOM_CATEGORIES)) {
            return ModelStructure.DEFAULT.customCategoryPath;
        }
        return ModelStructure.DEFAULT.coreContentPath;
    }

    public boolean checkObjectAccepted(Object obj) {
        if (!this.match(obj)) {
            return false;
        }
        if (this.getAlreadySelectedList() != null && this.getAlreadySelectedList().contains(obj)) {
            return false;
        }
        if (this.checkVariability(obj)) {
            return false;
        }
        return obj instanceof MethodPlugin || this.contentElement == null || !obj.equals(this.contentElement);
    }

    public boolean acceptMethodPlugin(Object obj) {
        if (this.contentElement != null) {
            return MethodElementUtil.getAllModels(this.contentElement).contains(obj);
        }
        return true;
    }

    public boolean acceptContentPackage(Object obj) {
        return !((ContentPackage)obj).getChildPackages().isEmpty() || !((ContentPackage)obj).getContentElements().isEmpty();
    }

    public boolean isObjectInSelectedItems(Object obj) {
        return this.getAlreadySelectedList() == null || !this.getAlreadySelectedList().contains(obj);
    }

    public boolean isContributor(ContentElement element) {
        return false;
    }

    public boolean matchPatternBasedOnType(Object obj) {
        return this.match(obj);
    }

    public boolean matchPatternOnPresentationName(Object obj) {
        return this.match(obj);
    }

    public boolean isShowPresentationName() {
        return this.showPresentationName;
    }

    public void setShowPresentationName(boolean showPresentationName) {
        this.showPresentationName = showPresentationName;
    }

    private boolean match(Object obj) {
        if (this.type == null || this.pattern == null || this.pattern.equalsIgnoreCase("")) {
            return true;
        }
        if (this.type.equals(FilterConstants.CONTENT_PACKAGES)) {
            DataObject container;
            if (obj instanceof ContentPackage) {
                return this.matcher(obj) || this.hasMatchedChild((ContentPackage)obj);
            }
            return !(obj instanceof ContentElement) || !((container = ((ContentElement)obj).getContainer()) instanceof ContentPackage) || this.matcher(container);
        }
        if (this.type.equals(FilterConstants.METHO_PLUGINS)) {
            if (obj instanceof MethodPlugin) {
                return this.matcher(obj);
            }
            return true;
        }
        if (this.type != null) {
            if (obj instanceof ContentElement || obj instanceof ProcessComponent || obj instanceof Process) {
                Class cls;
                if (this.type.indexOf("-") > -1) {
                    this.type = this.type.substring(this.type.indexOf("-"), this.type.length());
                }
                if ((cls = FilterInitializer.getInstance().getClassForType(this.type)) != null && !cls.isInstance(obj)) {
                    return true;
                }
                if (this.matcher(obj)) {
                    return true;
                }
                if (obj instanceof CustomCategory) {
                    return this.hasMatchedChildCustomCategory((CustomCategory)obj);
                }
                if (obj instanceof Artifact) {
                    return this.hasMatchedArtifact((Artifact)obj);
                }
                if (obj instanceof Domain) {
                    return this.hasMatchedSubDomains((Domain)obj);
                }
                return false;
            }
            return true;
        }
        return true;
    }

    public boolean matcher(Object obj) {
        Matcher m = this.regex.matcher(((MethodElement)obj).getName());
        if (this.showPresentationName && obj instanceof DescribableElement && ((DescribableElement)obj).getPresentationName() != null) {
            m = this.regex.matcher(((DescribableElement)obj).getPresentationName());
        }
        return m.matches();
    }
}

