/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process;

import com.ibm.uma.Activity;
import com.ibm.uma.Descriptor;
import com.ibm.uma.Milestone;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TeamProfile;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.Disposable;
import org.eclipse.emf.edit.provider.IWrapperItemProvider;
import org.eclipse.epf.library.edit.LibraryEditPlugin;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.BSActivityItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.RoleDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TeamProfileWrapperItemProvider;
import org.eclipse.epf.library.edit.process.command.OBSDragAndDropCommand;
import org.eclipse.epf.library.edit.process.command.OBSDropCommand;
import org.eclipse.epf.library.edit.util.Comparators;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class OBSActivityItemProvider
extends BSActivityItemProvider {
    private Disposable rolledUpWrappers;
    static /* synthetic */ Class class$0;

    public OBSActivityItemProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    protected void collectNewChildDescriptors(Collection newChildDescriptors, Object object) {
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createPhase()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createIteration()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createActivity()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createRoleDescriptor()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createTeamProfile()));
        newChildDescriptors.add(this.createChildParameter(UmaPackage.eINSTANCE.getActivity_BreakdownElements(), UmaFactory.eINSTANCE.createMilestone()));
    }

    protected boolean acceptAsChild(Object child) {
        if ((child = TngUtil.unwrap(child)) instanceof Activity || child instanceof RoleDescriptor || child instanceof TeamProfile || child instanceof Milestone) {
            return super.acceptAsChild(child);
        }
        return false;
    }

    protected Object getObject(Descriptor descriptor) {
        try {
            return ((RoleDescriptor)descriptor).getRole();
        }
        catch (ClassCastException e) {
            LibraryEditPlugin.getDefault().getLogger().logError((Throwable)e);
            throw e;
        }
    }

    public IResourceAwareCommand createDropCommand(Object owner, List dropElements) {
        return new OBSDropCommand((Activity)owner, dropElements);
    }

    protected Command createDragAndDropCommand(EditingDomain domain, Object owner, float location, int operations, int operation, Collection collection) {
        OBSDragAndDropCommand cmd = new OBSDragAndDropCommand(domain, owner, location, operations, operation, collection);
        return cmd;
    }

    protected boolean isNewDescriptor(List children, Object child) {
        Object obj = TngUtil.unwrap(child);
        if (obj instanceof RoleDescriptor) {
            return true;
        }
        return super.isNewDescriptor(children, obj);
    }

    public Collection getChildren(Object object) {
        if (this.rolledUpWrappers != null) {
            this.rolledUpWrappers.dispose();
        }
        if (this.isRolledUp()) {
            Object e;
            ArrayList teamProfiles = new ArrayList();
            ArrayList<TeamRoleDescriptorItemProvider> roleDescriptors = new ArrayList<TeamRoleDescriptorItemProvider>();
            HashSet<RoleTeamPair> roleTeamPairs = new HashSet<RoleTeamPair>();
            HashSet<Object> roleDescriptorsWithoutLinkedElements = new HashSet<Object>();
            ArrayList<TeamRoleDescriptorItemProvider> children = super.getChildren(object);
            HashSet<Object> validTeamProfiles = new HashSet<Object>();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Object o = iter.next();
                e = TngUtil.unwrap(o);
                if (!(e instanceof TeamProfile) || !validTeamProfiles.add(e)) continue;
                teamProfiles.add(o);
            }
            iter = children.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                e = TngUtil.unwrap(child);
                if (!(e instanceof RoleDescriptor)) continue;
                RoleDescriptor desc = (RoleDescriptor)e;
                List list = AssociationHelper.getTeamProfiles((RoleDescriptor)desc);
                int size = list.size();
                if (size > 1) {
                    if (this.rolledUpWrappers == null) {
                        this.rolledUpWrappers = new Disposable();
                    }
                    boolean readOnly = false;
                    if (child instanceof BreakdownElementWrapperItemProvider) {
                        readOnly = ((BreakdownElementWrapperItemProvider)child).isReadOnly();
                    }
                    Iterator iterator = list.iterator();
                    while (iterator.hasNext()) {
                        TeamRoleDescriptorItemProvider itemProvider = new TeamRoleDescriptorItemProvider(desc, object, this.adapterFactory);
                        itemProvider.readOnly = readOnly;
                        TeamProfile team = (TeamProfile)iterator.next();
                        itemProvider.team = team;
                        this.rolledUpWrappers.add((Object)itemProvider);
                        roleDescriptors.add(itemProvider);
                        roleTeamPairs.add(new RoleTeamPair((Role)this.getObject((Descriptor)desc), team));
                    }
                    continue;
                }
                Role role = (Role)this.getObject((Descriptor)desc);
                TeamProfile team = size == 1 ? list.get(0) : null;
                if (role == null) {
                    if (roleDescriptorsWithoutLinkedElements.contains(e)) continue;
                    roleDescriptors.add((TeamRoleDescriptorItemProvider)child);
                    roleDescriptorsWithoutLinkedElements.add(e);
                    continue;
                }
                RoleTeamPair roleTeamPair = new RoleTeamPair(role, team);
                if (roleTeamPairs.contains(roleTeamPair)) continue;
                roleDescriptors.add((TeamRoleDescriptorItemProvider)child);
                roleTeamPairs.add(roleTeamPair);
            }
            roleTeamPairs.clear();
            roleTeamPairs = null;
            Collections.sort(teamProfiles, Comparators.PRESENTATION_NAME_COMPARATOR);
            Collections.sort(roleDescriptors, Comparators.PRESENTATION_NAME_COMPARATOR);
            children = new ArrayList<TeamRoleDescriptorItemProvider>(teamProfiles);
            children.addAll(roleDescriptors);
            this.updateCachedChildren(children);
            return children;
        }
        Collection children = super.getChildren(object);
        this.updateCachedChildren(children);
        return children;
    }

    public Collection getEClasses() {
        return ProcessUtil.getOBSEclasses();
    }

    private void addTeamProfiles(Object owner, Collection teamProfiles, TeamProfile teamProfile) {
        if (!TngUtil.checkExist(teamProfiles, teamProfile)) {
            TeamProfileWrapperItemProvider wrapper = new TeamProfileWrapperItemProvider(teamProfile, owner, this.adapterFactory){

                public Collection getChildren(Object object) {
                    Collection children = super.getChildren(object);
                    return children;
                }
            };
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            IBSItemProvider adapter = (IBSItemProvider)this.adapterFactory.adapt((Notifier)teamProfile, (Object)clazz);
            wrapper.readOnly = this.getTopItem() != adapter.getTopItem();
            teamProfiles.add(wrapper);
        }
    }

    private static class TeamRoleDescriptorItemProvider
    extends RoleDescriptorWrapperItemProvider {
        private TeamProfile team;

        public TeamRoleDescriptorItemProvider(RoleDescriptor value, Object owner, AdapterFactory adapterFactory) {
            super(value, owner, adapterFactory);
            this.readOnly = false;
        }

        public String getAttribute(Object object, String property) {
            if (property == "teams" && this.team != null) {
                return TngUtil.getPresentationName(this.team);
            }
            return super.getAttribute(object, property);
        }

        protected IWrapperItemProvider createWrapper(Object value, Object owner, AdapterFactory adapterFactory) {
            BreakdownElementWrapperItemProvider wrapper = (BreakdownElementWrapperItemProvider)super.createWrapper(value, owner, adapterFactory);
            wrapper.readOnly = this.readOnly;
            return wrapper;
        }
    }

    private static class RoleTeamPair {
        private Role role;
        private TeamProfile team;

        RoleTeamPair(Role role, TeamProfile team) {
            this.role = role;
            this.team = team;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof RoleTeamPair) {
                RoleTeamPair other = (RoleTeamPair)obj;
                return this.role == other.role && (this.team == other.team || this.team == null && other.team == null);
            }
            return false;
        }

        public int hashCode() {
            String str = this.role.getGuid();
            if (this.team != null) {
                str = String.valueOf(str) + this.team.getGuid();
            }
            return str.hashCode();
        }
    }
}

