/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.process.command;

import com.ibm.uma.Descriptor;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkProductDescriptor;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.command.AbstractCommand;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.edit.Providers;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.command.BSDropCommand;
import org.eclipse.epf.library.edit.util.ProcessUtil;

public class BasicSynchronizeDescriptorCommand
extends AbstractCommand
implements IResourceAwareCommand {
    public static final Set NONEMPTY_ATTRIBUTES = new HashSet<EStructuralFeature>(Arrays.asList(UmaPackage.eINSTANCE.getNamedElement_Name(), UmaPackage.eINSTANCE.getDescribableElement_PresentationName()));
    protected Descriptor descriptor;
    protected Set synchFeatures;
    protected MethodConfiguration config;
    private HashMap featureMap;

    public BasicSynchronizeDescriptorCommand(Descriptor descriptor, Set synchFeatures, MethodConfiguration config) {
        this.descriptor = descriptor;
        this.synchFeatures = synchFeatures == null ? BSDropCommand.DEFAULT_SYNCH_FEATURES : synchFeatures;
        this.config = config;
    }

    public Collection getModifiedResources() {
        if (this.descriptor.eResource() != null) {
            return Collections.singletonList(this.descriptor.eResource());
        }
        return Collections.EMPTY_LIST;
    }

    private void saveOldFeatureValue(EStructuralFeature feature) {
        if (this.featureMap == null) {
            this.featureMap = new HashMap();
        }
        this.featureMap.put(feature, this.descriptor.eGet(feature));
    }

    public void execute() {
        MethodElement e = ProcessUtil.getAssociatedElement(this.descriptor);
        Object resolved = Providers.getConfigurationApplicator().resolve(e, this.config);
        if (resolved != e) {
            Object feature = this.descriptor instanceof TaskDescriptor ? UmaPackage.eINSTANCE.getTaskDescriptor_Task() : (this.descriptor instanceof WorkProductDescriptor ? UmaPackage.eINSTANCE.getWorkProductDescriptor_WorkProduct() : (this.descriptor instanceof RoleDescriptor ? UmaPackage.eINSTANCE.getRoleDescriptor_Role() : null));
            this.saveOldFeatureValue((EStructuralFeature)feature);
            e = (MethodElement)resolved;
            this.descriptor.eSet((EStructuralFeature)feature, (Object)e);
        }
        Iterator iter = this.synchFeatures.iterator();
        while (iter.hasNext()) {
            EAttribute attrib;
            EAttribute descAttrib;
            Object f = iter.next();
            if (!(f instanceof EAttribute) || (descAttrib = (EAttribute)BSDropCommand.FEATURE_MAP.get(attrib = (EAttribute)f)) == null) continue;
            if (NONEMPTY_ATTRIBUTES.contains(attrib)) {
                Object value = e instanceof VariabilityElement ? (String)Providers.getConfigurationApplicator().getAttribute((VariabilityElement)e, attrib, this.config) : e.eGet((EStructuralFeature)attrib);
                Object descValue = this.descriptor.eGet((EStructuralFeature)descAttrib);
                if ((value != null || descValue == null) && (value == null || value.equals(descValue))) continue;
                this.saveOldFeatureValue((EStructuralFeature)descAttrib);
                this.descriptor.eSet((EStructuralFeature)descAttrib, value);
                continue;
            }
            this.saveOldFeatureValue((EStructuralFeature)descAttrib);
            this.descriptor.eSet((EStructuralFeature)descAttrib, descAttrib.getDefaultValue());
        }
    }

    public void redo() {
        this.execute();
    }

    protected boolean prepare() {
        return true;
    }

    public void undo() {
        if (this.featureMap != null) {
            Iterator iterator = this.featureMap.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                EStructuralFeature feature = (EStructuralFeature)entry.getKey();
                this.descriptor.eSet(feature, entry.getValue());
            }
            this.featureMap.clear();
        }
    }

    public void dispose() {
        if (this.featureMap != null) {
            this.featureMap.clear();
            this.featureMap = null;
        }
        super.dispose();
    }
}

