/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.VariabilityType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.command.CopyCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;

public class ActivityHandler {
    private ArrayList procPackages;
    private ArrayList procPackagesToDeepCopy;
    private ArrayList activities = new ArrayList();

    public ActivityHandler() {
        this.procPackagesToDeepCopy = new ArrayList();
        this.procPackages = new ArrayList();
    }

    public void copy(Activity activity) {
        this.procPackages.add(activity.eContainer());
    }

    public void deepCopy(Activity activity) {
        this.procPackagesToDeepCopy.add(activity.eContainer());
    }

    public void extend(Activity act) {
        Activity extendedAct = ProcessUtil.generalize(act, VariabilityType.EXTENDS_LITERAL);
        this.activities.add(extendedAct);
    }

    public List getActivities() {
        if (!this.procPackages.isEmpty() || !this.procPackagesToDeepCopy.isEmpty()) {
            AdapterFactoryEditingDomain editingDomain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (CommandStack)new BasicCommandStack());
            if (!this.procPackages.isEmpty()) {
                this.activities.addAll(ActivityHandler.copy((EditingDomain)editingDomain, this.procPackages));
            }
            if (!this.procPackagesToDeepCopy.isEmpty()) {
                List copyActivities = ActivityHandler.copy((EditingDomain)editingDomain, this.procPackagesToDeepCopy);
                int size = copyActivities.size();
                int i = 0;
                while (i < size) {
                    ActivityHandler.deepCopy(editingDomain, (Activity)copyActivities.get(i));
                    ++i;
                }
                this.activities.addAll(copyActivities);
            }
        }
        return this.activities;
    }

    private static Collection copyProcessPackages(EditingDomain editingDomain, Collection procPackages) {
        Collection collection;
        block2: {
            Command command = CopyCommand.create((EditingDomain)editingDomain, (Collection)procPackages);
            try {
                command.execute();
                collection = command.getResult();
                Object var3_4 = null;
                if (command == null) break block2;
            }
            catch (Throwable throwable) {
                block3: {
                    Object var3_5 = null;
                    if (command == null) break block3;
                    command.dispose();
                }
                throw throwable;
            }
            command.dispose();
        }
        return collection;
    }

    private static List copy(EditingDomain editingDomain, List procPackages) {
        Collection copyPackages = ActivityHandler.copyProcessPackages(editingDomain, procPackages);
        ArrayList<Object> activities = new ArrayList<Object>();
        Iterator iter = copyPackages.iterator();
        while (iter.hasNext()) {
            ProcessPackage copy = (ProcessPackage)iter.next();
            if (copy instanceof ProcessComponent) {
                Process actCopy = ((ProcessComponent)copy).getProcess();
                ProcessPackage pkgCopy = UmaFactory.eINSTANCE.createProcessPackage();
                pkgCopy.setName(actCopy.getName());
                pkgCopy.getProcessElements().add(actCopy);
                pkgCopy.getProcessElements().addAll(copy.getProcessElements());
                pkgCopy.getDiagrams().addAll(copy.getDiagrams());
                pkgCopy.getChildPackages().addAll(copy.getChildPackages());
                activities.add(actCopy);
                continue;
            }
            activities.add(ActivityHandler.findActivity(copy));
        }
        return activities;
    }

    private static void deepCopy(final AdapterFactoryEditingDomain editingDomain, Activity activity) {
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(editingDomain.getAdapterFactory(), activity){
            private static final long serialVersionUID = 1L;

            protected Iterator getChildren(Object object) {
                Activity parent = (Activity)TngUtil.unwrap(object);
                ProcessPackage parentPkg = (ProcessPackage)parent.eContainer();
                if (ProcessUtil.isExtendingOrContributing((BreakdownElement)parent)) {
                    Activity base = (Activity)parent.getVariabilityBasedOnElement();
                    IFilter filter = ProcessUtil.getFilter(editingDomain.getAdapterFactory());
                    List list = ActivityHandler.copy((EditingDomain)editingDomain, Collections.singletonList(base.eContainer()));
                    Activity baseCopy = (Activity)list.get(0);
                    int size = baseCopy.getBreakdownElements().size();
                    int i = 0;
                    while (i < size) {
                        BreakdownElement e = (BreakdownElement)baseCopy.getBreakdownElements().get(i);
                        if (!(e instanceof Activity) && (filter == null || filter.accept(e))) {
                            EcoreUtil.remove((EObject)e);
                            parentPkg.getProcessElements().add(e);
                            parent.getBreakdownElements().add(e);
                        }
                        ++i;
                    }
                    parent.setPresentationName(ProcessUtil.getPresentationName((BreakdownElement)parent));
                    parent.setVariabilityBasedOnElement(null);
                    parent.setVariabilityType(null);
                }
                LinkedList children = new LinkedList();
                Iterator iter = super.getChildren(object);
                while (iter.hasNext()) {
                    Object child = iter.next();
                    if (ProcessUtil.isInherited(child)) {
                        Activity act;
                        List list;
                        Object e = TngUtil.unwrap(child);
                        if (!(e instanceof Activity) || (list = ActivityHandler.copy((EditingDomain)editingDomain, Collections.singletonList((act = (Activity)e).eContainer()))).isEmpty()) continue;
                        Object copyAct = list.get(0);
                        if (children.isEmpty()) {
                            parent.getBreakdownElements().add(copyAct);
                        } else {
                            int index = parent.getBreakdownElements().indexOf(children.getLast());
                            if (index == parent.getBreakdownElements().size() - 1) {
                                parent.getBreakdownElements().add(copyAct);
                            } else {
                                parent.getBreakdownElements().add(index + 1, copyAct);
                            }
                        }
                        children.add(copyAct);
                        continue;
                    }
                    if (!(child instanceof Activity)) continue;
                    children.add(child);
                }
                return children.iterator();
            }
        };
        while (iter.hasNext()) {
            iter.next();
        }
    }

    private static Activity findActivity(ProcessPackage procPackage) {
        Iterator iterator = procPackage.getProcessElements().iterator();
        while (iterator.hasNext()) {
            Object element = iterator.next();
            if (!(element instanceof Activity)) continue;
            return (Activity)element;
        }
        return null;
    }
}

