/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.util;

import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Section;
import com.ibm.uma.Task;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.eclipse.emf.ecore.util.EcoreEList;
import org.eclipse.epf.library.edit.util.TngUtil;

public class StepList {
    private static final long serialVersionUID = 3257567325849858871L;
    private Task currentTask;
    private LinkedList stepLists;

    private static DescribableElement getDescribableElement(Section step) {
        return (DescribableElement)step.eContainer().eContainer();
    }

    public StepList(Task currentTask, List stepLists) {
        this.currentTask = currentTask;
        this.stepLists = new LinkedList(stepLists);
        this.reorder();
    }

    private void reorder() {
        HashMap<Object, EcoreEList> ownerSectionsMap = new HashMap<Object, EcoreEList>();
        int size = this.stepLists.size();
        int i = 0;
        while (i < size) {
            EcoreEList eList = (EcoreEList)this.stepLists.get(i);
            ownerSectionsMap.put(eList.getNotifier(), eList);
            ++i;
        }
        Iterator iter = new ArrayList(this.stepLists).iterator();
        while (iter.hasNext()) {
            List stepList = (List)iter.next();
            if (stepList.isEmpty()) continue;
            Section step = (Section)stepList.get(0);
            Section pred = step.getPredecessor();
            if (pred == null) {
                Section oldFirstStep;
                List oldFirstList = (List)this.stepLists.get(0);
                this.stepLists.remove(stepList);
                this.stepLists.add(0, stepList);
                if (oldFirstList.isEmpty() || !TngUtil.canReference((MethodElement)StepList.getDescribableElement(oldFirstStep = (Section)oldFirstList.get(0)), (MethodElement)StepList.getDescribableElement(step))) continue;
                oldFirstStep.setPredecessor(step);
                continue;
            }
            List predList = (List)ownerSectionsMap.get(pred.eContainer());
            this.stepLists.remove(predList);
            int id = this.stepLists.indexOf(stepList);
            this.stepLists.add(id, predList);
        }
    }

    public List getSteps() {
        ArrayList allSteps = new ArrayList();
        int size = this.stepLists.size();
        int i = 0;
        while (i < size) {
            List steps = (List)this.stepLists.get(i);
            Iterator iter = steps.iterator();
            while (iter.hasNext()) {
                allSteps.add(iter.next());
            }
            ++i;
        }
        return allSteps;
    }

    public boolean moveUp(Section step) {
        List steps = this.currentTask.getPresentation().getSections();
        int id = steps.indexOf(step);
        if (id == -1) {
            return false;
        }
        if (id > 0) {
            Collections.swap(steps, id - 1, id);
            return true;
        }
        id = this.stepLists.indexOf(steps);
        if (id == -1) {
            return false;
        }
        List predList = null;
        int predListId = id - 1;
        while (predListId > -1) {
            List list = (List)this.stepLists.get(predListId);
            if (!list.isEmpty()) {
                predList = list;
                break;
            }
            --predListId;
        }
        Section oldPred = ((Section)steps.get(0)).getPredecessor();
        List oldSuccessors = AssociationHelper.getSuccessors((Section)((Section)steps.get(steps.size() - 1)));
        if (predList != null) {
            this.stepLists.remove(steps);
            this.stepLists.add(predListId, steps);
            Section last = (Section)predList.get(predList.size() - 1);
            List oldPredSuccessors = AssociationHelper.getSuccessors((Section)last);
            if (TngUtil.canReference((MethodElement)this.currentTask, (MethodElement)StepList.getDescribableElement(last))) {
                step.setPredecessor(last);
                Iterator iter = oldPredSuccessors.iterator();
                while (iter.hasNext()) {
                    Section sect = (Section)iter.next();
                    sect.setPredecessor(step);
                }
            }
        } else {
            this.stepLists.add(0, steps);
        }
        DescribableElement oldPredTask = StepList.getDescribableElement(oldPred);
        Iterator iter = oldSuccessors.iterator();
        while (iter.hasNext()) {
            Section sect = (Section)iter.next();
            if (!TngUtil.canReference((MethodElement)StepList.getDescribableElement(sect), (MethodElement)oldPredTask)) continue;
            sect.setPredecessor(oldPred);
        }
        return true;
    }

    public boolean moveDown(Section step) {
        List steps = this.currentTask.getPresentation().getSections();
        int id = steps.indexOf(step);
        if (id == -1) {
            return false;
        }
        if (id < steps.size() - 1) {
            Collections.swap(steps, id + 1, id);
            return true;
        }
        id = this.stepLists.indexOf(steps);
        if (id == -1) {
            return false;
        }
        List succList = null;
        int succListId = id + 1;
        int size = this.stepLists.size();
        while (succListId < size) {
            List list = (List)this.stepLists.get(succListId);
            if (!list.isEmpty()) {
                succList = list;
                break;
            }
            ++succListId;
        }
        if (succList != null) {
            this.stepLists.remove(succList);
            this.stepLists.add(id, succList);
        } else {
            this.stepLists.add(steps);
        }
        return true;
    }
}

