/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.edit.validation.internal;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.CustomCategory;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.UmaPackage;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.LibraryEditResources;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.validation.IValidator;
import org.eclipse.epf.library.edit.validation.IValidatorFactory;
import org.eclipse.epf.library.edit.validation.internal.ContentElementNameValidator;
import org.eclipse.epf.library.edit.validation.internal.DoNothingValidator;
import org.eclipse.epf.library.edit.validation.internal.MethodConfigurationNameValidator;
import org.eclipse.epf.library.edit.validation.internal.ProcessComponentNameValidator;
import org.eclipse.epf.library.edit.validation.internal.UniquenessValidator;

public class ValidatorFactory
implements IValidatorFactory {
    static /* synthetic */ Class class$0;

    public IValidator createNameValidator(Object parent, ContentElement e) {
        if (parent instanceof CustomCategory && e instanceof CustomCategory) {
            return new ContentElementNameValidator((EObject)parent, (EStructuralFeature)UmaPackage.eINSTANCE.getCustomCategory_CategorizedElements(), e, new TypeFilter((EObject)e));
        }
        EObject container = null;
        if (parent instanceof EObject) {
            container = (EObject)parent;
        }
        return new ContentElementNameValidator(container, e, new TypeFilter((EObject)e));
    }

    public IValidator createPresentationNameValidator(Object parent, DescribableElement e) {
        if (e instanceof BreakdownElement && parent instanceof Process) {
            final Object parentx = parent;
            return new IValidator(){

                public String isValid(String newText) {
                    Process localparent = (Process)parentx;
                    List list = localparent.getBreakdownElements();
                    Iterator itor = list.iterator();
                    while (itor.hasNext()) {
                        BreakdownElement element = (BreakdownElement)itor.next();
                        if (!element.getPresentationName().equals(newText)) continue;
                        return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", newText);
                    }
                    return null;
                }
            };
        }
        if (e instanceof BreakdownElement && parent instanceof Activity) {
            final Object parentx = parent;
            return new IValidator(){

                public String isValid(String newText) {
                    Activity localparent = (Activity)parentx;
                    List list = localparent.getBreakdownElements();
                    Iterator itor = list.iterator();
                    while (itor.hasNext()) {
                        BreakdownElement element = (BreakdownElement)itor.next();
                        if (!element.getPresentationName().equals(newText)) continue;
                        return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", newText);
                    }
                    return null;
                }
            };
        }
        return DoNothingValidator.INSTANCE;
    }

    public IValidator createNameValidator(Object parent, final NamedElement e) {
        if (e instanceof ContentElement) {
            return this.createNameValidator(parent, (ContentElement)e);
        }
        if (e instanceof ProcessComponent && parent instanceof ProcessPackage) {
            return new ProcessComponentNameValidator((ProcessPackage)parent, (ProcessComponent)e);
        }
        if (e instanceof ContentPackage && parent instanceof ContentPackage || e instanceof ProcessPackage && parent instanceof ProcessPackage) {
            return new UniquenessValidator((EObject)parent, (EStructuralFeature)UmaPackage.eINSTANCE.getMethodPackage_ChildPackages(), new TypeFilter((EObject)e), (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), "name");
        }
        if (parent instanceof MethodLibrary) {
            final MethodLibrary lib = (MethodLibrary)parent;
            if (e == null || e instanceof MethodPlugin) {
                return new IValidator(){

                    public String isValid(String newText) {
                        File dir = new File(lib.eResource().getURI().toFileString()).getParentFile();
                        String elementTypeText = e != null ? TngUtil.getTypeText((EObject)e) : TngUtil.getTypeText("MethodPlugin");
                        return TngUtil.checkName(dir, lib.getMethodPlugins(), e, newText, elementTypeText, true);
                    }
                };
            }
            if (e instanceof MethodConfiguration) {
                return new MethodConfigurationNameValidator(lib, (MethodConfiguration)e);
            }
        } else if (e instanceof BreakdownElement && parent instanceof Process || parent instanceof ProcessComponent) {
            final Object parentx = parent;
            return new IValidator(){

                public String isValid(String newText) {
                    Process localparent = (Process)parentx;
                    List list = localparent.getBreakdownElements();
                    Iterator itor = list.iterator();
                    while (itor.hasNext()) {
                        BreakdownElement element = (BreakdownElement)itor.next();
                        if (!element.getPresentationName().equals(newText)) continue;
                        return LibraryEditResources.formatString("LibraryEdit.duplicateElementNameError.msg", newText);
                    }
                    return null;
                }
            };
        }
        return DoNothingValidator.INSTANCE;
    }

    public IValidator createNameValidator(NamedElement e, AdapterFactory adapterFactory) {
        EStructuralFeature containingFeature = TngUtil.getContainingFeature(e, adapterFactory);
        if (containingFeature != null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            EObject parent = (EObject)((ITreeItemContentProvider)adapterFactory.adapt((Notifier)e, (Object)clazz)).getParent((Object)e);
            if (e instanceof ContentElement) {
                return new ContentElementNameValidator(parent, containingFeature, (ContentElement)e, new TypeFilter((EObject)e));
            }
            if (e instanceof ProcessComponent && parent instanceof ProcessPackage) {
                return new ProcessComponentNameValidator((ProcessPackage)parent, (ProcessComponent)e);
            }
            return new UniquenessValidator(parent, containingFeature, new TypeFilter((EObject)e), (EObject)e, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), "name");
        }
        return this.createNameValidator((Object)e.eContainer(), e);
    }

    public IValidator createValidator(EObject object, EStructuralFeature feature, Object value) {
        throw new UnsupportedOperationException("No implemented yet");
    }

    public static class TypeFilter
    implements IFilter {
        private int classID;

        public TypeFilter(EObject obj) {
            this.classID = obj.eClass().getClassifierID();
        }

        public boolean accept(Object obj) {
            return obj instanceof EObject && this.classID == ((EObject)obj).eClass().getClassifierID();
        }
    }
}

