/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.msp.services;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.Descriptor;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Milestone;
import com.ibm.uma.Process;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.Task;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.WorkProduct;
import com.ibm.uma.WorkProductDescriptor;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.msp.ExportMspResources;
import org.eclipse.epf.export.msp.ExportProjectTemplateException;
import org.eclipse.epf.export.msp.PlanningServiceException;
import org.eclipse.epf.export.msp.services.ExportProjectTemplateOperation;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.TaskDescriptorWrapperItemProvider;
import org.eclipse.epf.library.edit.ui.UserInteractionHelper;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.publishing.services.AbstractViewBuilder;
import org.eclipse.epf.publishing.services.ConfigurationViewBuilder;
import org.eclipse.epf.publishing.services.PublishOptions;
import org.eclipse.epf.publishing.wizards.PublishProgressMonitorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.swt.widgets.Display;

public class ExportProjectTemplateService {
    public static final String ATTR_GUID_HAS_MULTIPLE_OCCURENCES = "_ns2-gNySEdmzPsiVEosaiA";
    public static final String ATTR_GUID_IS_EVENT_DRIVEN = "_qTm-UNySEdmzPsiVEosaiA";
    public static final String ATTR_GUID_IS_PLANNED = "_lmSTkNySEdmzPsiVEosaiA";
    public static final String ATTR_GUID_IS_OPTIONAL = "_mvD5gNySEdmzPsiVEosaiA";
    public static final String ATTR_GUID_IS_ONGOING = "_piIeENySEdmzPsiVEosaiA";
    public static final String ATTR_GUID_IS_REPEATABLE = "_oghQENySEdmzPsiVEosaiA";
    public static final String ATTR_NAME_HAS_MULTIPLE_OCCURENCES = "hasMultipleOccurrences";
    public static final String ATTR_NAME_IS_EVENT_DRIVEN = "isEventDriven";
    public static final String ATTR_NAME_IS_PLANNED = "isPlanned";
    public static final String ATTR_NAME_IS_OPTIONAL = "isOptional";
    public static final String ATTR_NAME_IS_ONGOING = "isOngoing";
    public static final String ATTR_NAME_IS_REPEATABLE = "isRepeatable";
    private static final Map projectAttributes = new HashMap();
    private static final String TAG_PROJECT_TEMPLATE = "project-template";
    private static final String TAG_SOURCE = "source";
    private static final String TAG_PROJECT_ATTRIBUTES = "project-attributes";
    private static final String TAG_PROJECT_ATTRIBUTE = "project-attribute";
    private static final String TAG_GUIDANCE_REFERENCES = "guidance-references";
    private static final String TAG_TASK_REFERENCES = "task-references";
    private static final String TAG_ROLES_REFERENCES = "role-references";
    private static final String TAG_WORK_PRODUCT_REFERENCES = "work-product-references";
    private static final String TAG_WBS = "wbs";
    private static final String TAG_BRIEF_DESCRIPTION = "brief-description";
    private static final String TAG_TASK_DESCRIPTOR = "task-descriptor";
    private static final String TAG_PRIMARY_PERFORMER = "primary-performer";
    private static final String TAG_ADDITIONAL_PERFORMER = "additional-performers";
    private static final String TAG_MANDATORY_INPUTS = "mandatory-inputs";
    private static final String TAG_OPTIONAL_INPUTS = "optional-inputs";
    private static final String TAG_OUTPUTS = "outputs";
    private static final String TAG_GUIDANCE = "guidance";
    private static final String TAG_PREDECESSORS = "predecessors";
    private static final String TAG_PREDECESSOR = "predecessor";
    private static final String TAG_INDENT = "\t";
    private static final String LINE_SEP;
    private AbstractViewBuilder viewBuilder;
    private String contentFolderName;
    private List referencedGuidance = new ArrayList();
    private List referencedTasks = new ArrayList();
    private List referencedRoles = new ArrayList();
    private List referencedWorkProducts = new ArrayList();
    private Map xmlTagNames = new HashMap();
    private StringBuffer indent;
    private boolean exportOnlyPlannedElements;

    static {
        projectAttributes.put(ATTR_GUID_HAS_MULTIPLE_OCCURENCES, ATTR_NAME_HAS_MULTIPLE_OCCURENCES);
        projectAttributes.put(ATTR_GUID_IS_EVENT_DRIVEN, ATTR_NAME_IS_EVENT_DRIVEN);
        projectAttributes.put(ATTR_GUID_IS_PLANNED, ATTR_NAME_IS_PLANNED);
        projectAttributes.put(ATTR_GUID_IS_OPTIONAL, ATTR_NAME_IS_OPTIONAL);
        projectAttributes.put(ATTR_GUID_IS_ONGOING, ATTR_NAME_IS_ONGOING);
        projectAttributes.put(ATTR_GUID_IS_REPEATABLE, ATTR_NAME_IS_REPEATABLE);
        LINE_SEP = System.getProperty("line.separator");
    }

    public boolean exportProjectTemplate(Process process, String templateName, File targetDir, boolean exportOnlyPlannedElements, PublishOptions publishConfigOptions) throws PlanningServiceException {
        block14: {
            block12: {
                block13: {
                    if (process == null || templateName == null || targetDir == null) {
                        throw new IllegalArgumentException();
                    }
                    MethodConfiguration methodConfig = null;
                    if (process instanceof DeliveryProcess) {
                        methodConfig = ((DeliveryProcess)process).getDefaultContext();
                    } else if (process instanceof CapabilityPattern) {
                        methodConfig = ((CapabilityPattern)process).getDefaultContext();
                    } else {
                        throw new IllegalArgumentException();
                    }
                    if (!targetDir.exists()) {
                        targetDir.mkdirs();
                    }
                    this.contentFolderName = methodConfig.getName();
                    if (publishConfigOptions == null) break block12;
                    File contentDir = new File(targetDir, this.contentFolderName);
                    if (!contentDir.exists()) {
                        contentDir.mkdirs();
                    }
                    this.viewBuilder = ConfigurationViewBuilder.getViewBuilder((String)contentDir.getAbsolutePath(), (MethodConfiguration)methodConfig, (PublishOptions)publishConfigOptions);
                    if (this.publishConfiguration()) break block12;
                    Object var8_9 = null;
                    if (this.viewBuilder == null) break block13;
                    this.viewBuilder.dispose();
                    this.viewBuilder = null;
                }
                return false;
            }
            try {
                this.exportOnlyPlannedElements = exportOnlyPlannedElements;
                File file = new File(targetDir, String.valueOf(templateName) + ".xml");
                this.generateTemplateXML(process, templateName, file);
                Object var8_10 = null;
                if (this.viewBuilder == null) break block14;
            }
            catch (Exception e) {
                try {
                    throw new ExportProjectTemplateException(e);
                }
                catch (Throwable throwable) {
                    block15: {
                        Object var8_11 = null;
                        if (this.viewBuilder == null) break block15;
                        this.viewBuilder.dispose();
                        this.viewBuilder = null;
                    }
                    throw throwable;
                }
            }
            this.viewBuilder.dispose();
            this.viewBuilder = null;
        }
        return true;
    }

    protected void generateTemplateXML(Process process, String templateName, File templateFile) throws Exception {
        this.indent = new StringBuffer();
        StringBuffer strBuf = new StringBuffer(1024);
        strBuf.append("<?xml version=\"1.0\" encoding=\"UTF-8\"?>").append(LINE_SEP).append("<project-template name=\"").append(XMLUtil.escapeAttr((String)templateName)).append("\">").append(LINE_SEP);
        this.generateXML(process, strBuf);
        strBuf.append("</project-template>").append(LINE_SEP);
        FileUtil.writeUTF8File((String)templateFile.getAbsolutePath(), (String)strBuf.toString());
    }

    /*
     * Exception decompiling
     */
    protected void generateXML(Process process, StringBuffer strBuf) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 2[TRYBLOCK] [2 : 225->229)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    protected void generateBriefDescriptionXML(MethodElement element, StringBuffer strBuf) {
        String briefDescription = element.getBriefDescription();
        if (briefDescription != null && briefDescription.length() > 0) {
            this.addIndent();
            strBuf.append(this.indent).append("<brief-description>").append(LINE_SEP).append(XMLUtil.escape((String)briefDescription)).append(LINE_SEP).append(this.indent).append("</brief-description>").append(LINE_SEP);
            this.removeIndent();
        }
    }

    protected void generateXML(MethodElement element, StringBuffer strBuf) {
        this.addIndent();
        StringBuffer briefDescriptionXML = null;
        String briefDescription = element.getBriefDescription();
        if (briefDescription != null && briefDescription.length() > 0) {
            briefDescriptionXML = new StringBuffer();
            this.generateBriefDescriptionXML(element, briefDescriptionXML);
        }
        StringBuffer guidanceXML = null;
        if (element instanceof Task || element instanceof Role || element instanceof WorkProduct) {
            guidanceXML = new StringBuffer();
            this.generateGuidanceXML(element, guidanceXML);
        }
        String tagName = this.getXMLTagName(element);
        strBuf.append(this.indent).append("<").append(this.getXMLTagName(element)).append(" guid=\"").append(element.getGuid()).append("\"").append(" name=\"").append(this.getDisplayName(element)).append("\"").append(" href=\"").append(this.getElementURL(element));
        if (briefDescriptionXML != null || guidanceXML != null && guidanceXML.length() != 0) {
            strBuf.append("\">").append(LINE_SEP);
            if (briefDescriptionXML != null) {
                strBuf.append(briefDescriptionXML);
            }
            if (guidanceXML != null) {
                strBuf.append(guidanceXML);
            }
            strBuf.append(this.indent).append("</").append(tagName).append(">").append(LINE_SEP);
        } else {
            strBuf.append("\"/>").append(LINE_SEP);
        }
        this.removeIndent();
    }

    protected void generateProjectattributesXML(StringBuffer strBuf) {
        this.addIndent();
        Iterator i = projectAttributes.keySet().iterator();
        while (i.hasNext()) {
            String guid = (String)i.next();
            String name = (String)projectAttributes.get(guid);
            strBuf.append(this.indent).append("<project-attribute").append(" guid=\"").append(guid).append("\"").append(" name=\"").append(name).append("\"/>").append(LINE_SEP);
        }
        this.removeIndent();
    }

    protected void generateReferencesXML(StringBuffer strBuf, int index) {
        StringBuffer referencesXML = new StringBuffer(2048);
        this.generateTaskReferencesXML(referencesXML);
        this.generateRoleReferencesXML(referencesXML);
        this.generateWorkProductReferencesXML(referencesXML);
        StringBuffer referencedGuidanceXML = new StringBuffer();
        this.generateGuidanceReferencesXML(referencedGuidanceXML);
        referencesXML.insert(0, (Object)referencedGuidanceXML);
        strBuf.insert(index, (Object)referencesXML);
    }

    protected void generateGuidanceReferencesXML(StringBuffer strBuf) {
        if (this.referencedGuidance.size() > 0) {
            strBuf.append(TAG_INDENT).append("<guidance-references>").append(LINE_SEP);
            Iterator i = this.referencedGuidance.iterator();
            while (i.hasNext()) {
                Guidance guidance = (Guidance)i.next();
                this.generateXML((MethodElement)guidance, strBuf);
            }
            strBuf.append(TAG_INDENT).append("</guidance-references>").append(LINE_SEP);
        }
    }

    protected void generateTaskReferencesXML(StringBuffer strBuf) {
        if (this.referencedTasks.size() > 0) {
            strBuf.append(TAG_INDENT).append("<task-references>").append(LINE_SEP);
            Iterator i = this.referencedTasks.iterator();
            while (i.hasNext()) {
                Task task = (Task)i.next();
                this.generateXML((MethodElement)task, strBuf);
            }
            strBuf.append(TAG_INDENT).append("</task-references>").append(LINE_SEP);
        }
    }

    protected void generateRoleReferencesXML(StringBuffer strBuf) {
        if (this.referencedRoles.size() > 0) {
            strBuf.append(TAG_INDENT).append("<role-references>").append(LINE_SEP);
            Iterator i = this.referencedRoles.iterator();
            while (i.hasNext()) {
                Role role = (Role)i.next();
                this.generateXML((MethodElement)role, strBuf);
            }
            strBuf.append(TAG_INDENT).append("</role-references>").append(LINE_SEP);
        }
    }

    protected void generateWorkProductReferencesXML(StringBuffer strBuf) {
        if (this.referencedWorkProducts.size() > 0) {
            strBuf.append(TAG_INDENT).append("<work-product-references>").append(LINE_SEP);
            Iterator i = this.referencedWorkProducts.iterator();
            while (i.hasNext()) {
                WorkProduct workProduct = (WorkProduct)i.next();
                this.generateXML((MethodElement)workProduct, strBuf);
            }
            strBuf.append(TAG_INDENT).append("</work-product-references>").append(LINE_SEP);
        }
    }

    protected void generateReferenceXML(MethodElement element, StringBuffer strBuf) {
        if (element != null) {
            this.addIndent();
            String tagName = String.valueOf(this.getXMLTagName(element)) + "-ref";
            strBuf.append(this.indent).append("<").append(tagName).append(" guid=\"").append(element.getGuid()).append("\"/>").append(LINE_SEP);
            this.removeIndent();
        }
    }

    protected void generateReferenceXML(Guidance guidance, StringBuffer strBuf) {
        if (guidance != null) {
            if (!this.referencedGuidance.contains(guidance)) {
                this.referencedGuidance.add(guidance);
            }
            this.generateReferenceXML((MethodElement)guidance, strBuf);
        }
    }

    protected void generateReferenceXML(Task task, StringBuffer strBuf) {
        if (task != null) {
            if (!this.referencedTasks.contains(task)) {
                this.referencedTasks.add(task);
            }
            this.generateReferenceXML((MethodElement)task, strBuf);
        }
    }

    protected void generateReferenceXML(Role role, StringBuffer strBuf) {
        if (role != null) {
            if (!this.referencedRoles.contains(role)) {
                this.referencedRoles.add(role);
            }
            this.generateReferenceXML((MethodElement)role, strBuf);
        }
    }

    protected void generateReferenceXML(WorkProduct workProduct, StringBuffer strBuf) {
        if (workProduct != null) {
            if (!this.referencedWorkProducts.contains(workProduct)) {
                this.referencedWorkProducts.add(workProduct);
            }
            this.generateReferenceXML((MethodElement)workProduct, strBuf);
        }
    }

    protected void generateXML(IStructuredContentProvider contentProvider, WorkBreakdownElement breakdownElement, StringBuffer strBuf) {
        if (breakdownElement instanceof WorkProductDescriptor || breakdownElement instanceof RoleDescriptor || this.exportOnlyPlannedElements && !breakdownElement.getIsPlanned().booleanValue()) {
            return;
        }
        this.addIndent();
        String elementTag = this.getXMLTagName((MethodElement)breakdownElement);
        ArrayList<RoleDescriptor> responsibleRoles = null;
        if (breakdownElement instanceof Activity && contentProvider != null) {
            TaskDescriptor descriptor;
            TaskDescriptor descriptor2;
            Object wrappedElement;
            Object element;
            boolean plannedTasks = false;
            Object[] elements = contentProvider.getElements((Object)breakdownElement);
            int i = 0;
            while (i < elements.length) {
                element = elements[i];
                if (element instanceof Activity) {
                    if (!this.exportOnlyPlannedElements || ((Activity)element).getIsPlanned().booleanValue()) {
                        plannedTasks = true;
                        break;
                    }
                } else if (element instanceof ActivityWrapperItemProvider) {
                    wrappedElement = TngUtil.unwrap((Object)element);
                    if (wrappedElement instanceof Activity && (!this.exportOnlyPlannedElements || ((Activity)wrappedElement).getIsPlanned().booleanValue())) {
                        plannedTasks = true;
                        break;
                    }
                } else if (element instanceof TaskDescriptor) {
                    descriptor2 = (TaskDescriptor)element;
                    if (!this.exportOnlyPlannedElements || descriptor2.getIsPlanned().booleanValue()) {
                        plannedTasks = true;
                        break;
                    }
                } else if (element instanceof TaskDescriptorWrapperItemProvider && (wrappedElement = TngUtil.unwrap((Object)element)) instanceof TaskDescriptor) {
                    descriptor = (TaskDescriptor)wrappedElement;
                    if (!this.exportOnlyPlannedElements || descriptor.getIsPlanned().booleanValue()) {
                        plannedTasks = true;
                        break;
                    }
                }
                ++i;
            }
            if (!plannedTasks) {
                elementTag = TAG_TASK_DESCRIPTOR;
                responsibleRoles = new ArrayList<RoleDescriptor>();
                i = 0;
                while (i < elements.length) {
                    RoleDescriptor roleDescriptor;
                    element = elements[i];
                    if (element instanceof TaskDescriptor) {
                        descriptor2 = (TaskDescriptor)element;
                        RoleDescriptor roleDescriptor2 = descriptor2.getPerformedPrimarilyBy();
                        if (roleDescriptor2 != null) {
                            responsibleRoles.add(roleDescriptor2);
                        }
                    } else if (element instanceof TaskDescriptorWrapperItemProvider && (wrappedElement = TngUtil.unwrap((Object)element)) instanceof TaskDescriptor && (roleDescriptor = (descriptor = (TaskDescriptor)wrappedElement).getPerformedPrimarilyBy()) != null) {
                        responsibleRoles.add(roleDescriptor);
                    }
                    ++i;
                }
            }
        }
        strBuf.append(this.indent).append("<").append(elementTag).append(" guid=\"").append(breakdownElement.getGuid()).append("\"").append(" name=\"").append(this.getDisplayName((MethodElement)breakdownElement)).append("\"").append(" href=\"").append(this.getElementURL((MethodElement)breakdownElement)).append("\"").append(" hasMultipleOccurrences=\"").append(breakdownElement.getHasMultipleOccurrences()).append("\"").append(" isEventDriven=\"").append(breakdownElement.getIsEventDriven()).append("\"").append(" isOngoing=\"").append(breakdownElement.getIsOngoing()).append("\"").append(" isOptional=\"").append(breakdownElement.getIsOptional()).append("\"").append(" isPlanned=\"").append(breakdownElement.getIsPlanned()).append("\"").append(" isRepeatable=\"").append(breakdownElement.getIsRepeatable()).append("\">").append(LINE_SEP);
        this.generateBriefDescriptionXML((MethodElement)breakdownElement, strBuf);
        if (breakdownElement instanceof TaskDescriptor) {
            this.generateXML((TaskDescriptor)breakdownElement, strBuf, false);
        }
        if (breakdownElement instanceof Activity && responsibleRoles != null && responsibleRoles.size() > 0) {
            strBuf.append(this.indent).append("<primary-performer>").append(LINE_SEP);
            this.generateXML((Descriptor)((RoleDescriptor)responsibleRoles.get(0)), strBuf);
            strBuf.append(this.indent).append("</primary-performer>").append(LINE_SEP);
            responsibleRoles.clear();
            responsibleRoles = null;
        }
        this.generatePredecessorsXML(breakdownElement, strBuf);
        if (contentProvider != null) {
            Object[] elements = contentProvider.getElements((Object)breakdownElement);
            int i = 0;
            while (i < elements.length) {
                Object element = elements[i];
                if (element instanceof BreakdownElementWrapperItemProvider) {
                    BreakdownElementWrapperItemProvider provider = (BreakdownElementWrapperItemProvider)element;
                    Object value = provider.getValue();
                    if (value instanceof Activity) {
                        this.generateXML(contentProvider, (WorkBreakdownElement)value, strBuf);
                    } else if (value instanceof TaskDescriptor) {
                        this.generateXML((TaskDescriptor)value, strBuf, true);
                    }
                } else if (element instanceof TaskDescriptor) {
                    this.generateXML((TaskDescriptor)element, strBuf, true);
                } else if (element instanceof Milestone) {
                    this.generateXML((MethodElement)element, strBuf);
                } else if (element instanceof WorkBreakdownElement) {
                    this.generateXML(contentProvider, (WorkBreakdownElement)element, strBuf);
                }
                ++i;
            }
        }
        strBuf.append(this.indent).append("</").append(elementTag).append(">").append(LINE_SEP);
        this.removeIndent();
    }

    protected void generateXML(TaskDescriptor taskDescriptor, StringBuffer strBuf, boolean generateRootTag) {
        Iterator i;
        List workProductDescriptors;
        List roleDescriptors;
        if (this.exportOnlyPlannedElements && !taskDescriptor.getIsPlanned().booleanValue()) {
            return;
        }
        if (generateRootTag) {
            this.addIndent();
            strBuf.append(this.indent).append("<").append(this.getXMLTagName((MethodElement)taskDescriptor)).append(" guid=\"").append(taskDescriptor.getGuid()).append("\"").append(" name=\"").append(this.getDisplayName((MethodElement)taskDescriptor)).append("\"").append(" href=\"").append(this.getElementURL((MethodElement)taskDescriptor)).append("\"").append(" hasMultipleOccurrences=\"").append(taskDescriptor.getHasMultipleOccurrences()).append("\"").append(" isEventDriven=\"").append(taskDescriptor.getIsEventDriven()).append("\"").append(" isOngoing=\"").append(taskDescriptor.getIsOngoing()).append("\"").append(" isOptional=\"").append(taskDescriptor.getIsOptional()).append("\"").append(" isPlanned=\"").append(taskDescriptor.getIsPlanned()).append("\"").append(" isRepeatable=\"").append(taskDescriptor.getIsRepeatable()).append("\">").append(LINE_SEP);
            this.generateBriefDescriptionXML((MethodElement)taskDescriptor, strBuf);
        }
        this.generatePredecessorsXML((WorkBreakdownElement)taskDescriptor, strBuf);
        Task task = taskDescriptor.getTask();
        this.generateReferenceXML(task, strBuf);
        this.addIndent();
        RoleDescriptor roleDescriptor = taskDescriptor.getPerformedPrimarilyBy();
        if (roleDescriptor != null && (!this.exportOnlyPlannedElements || roleDescriptor.getIsPlanned().booleanValue())) {
            strBuf.append(this.indent).append("<primary-performer>").append(LINE_SEP);
            this.generateXML((Descriptor)roleDescriptor, strBuf);
            strBuf.append(this.indent).append("</primary-performer>").append(LINE_SEP);
        }
        if ((roleDescriptors = taskDescriptor.getAdditionallyPerformedBy()) != null && roleDescriptors.size() > 0) {
            Iterator i2;
            boolean isPlanned = false;
            if (this.exportOnlyPlannedElements) {
                i2 = roleDescriptors.iterator();
                while (i2.hasNext()) {
                    if (!((RoleDescriptor)i2.next()).getIsPlanned().booleanValue()) continue;
                    isPlanned = true;
                    break;
                }
            } else {
                isPlanned = true;
            }
            if (isPlanned) {
                strBuf.append(this.indent).append("<additional-performers>").append(LINE_SEP);
                i2 = roleDescriptors.iterator();
                while (i2.hasNext()) {
                    this.generateXML((Descriptor)((RoleDescriptor)i2.next()), strBuf);
                }
                strBuf.append(this.indent).append("</additional-performers>").append(LINE_SEP);
            }
        }
        if ((workProductDescriptors = taskDescriptor.getMandatoryInput()) != null && workProductDescriptors.size() > 0) {
            boolean isPlanned = false;
            if (this.exportOnlyPlannedElements) {
                i = workProductDescriptors.iterator();
                while (i.hasNext()) {
                    if (!((WorkProductDescriptor)i.next()).getIsPlanned().booleanValue()) continue;
                    isPlanned = true;
                    break;
                }
            } else {
                isPlanned = true;
            }
            if (isPlanned) {
                strBuf.append(this.indent).append("<mandatory-inputs>").append(LINE_SEP);
                i = workProductDescriptors.iterator();
                while (i.hasNext()) {
                    this.generateXML((Descriptor)((WorkProductDescriptor)i.next()), strBuf);
                }
                strBuf.append(this.indent).append("</mandatory-inputs>").append(LINE_SEP);
            }
        }
        if ((workProductDescriptors = taskDescriptor.getOptionalInput()) != null && workProductDescriptors.size() > 0) {
            boolean isPlanned = false;
            if (this.exportOnlyPlannedElements) {
                i = workProductDescriptors.iterator();
                while (i.hasNext()) {
                    if (!((WorkProductDescriptor)i.next()).getIsPlanned().booleanValue()) continue;
                    isPlanned = true;
                    break;
                }
            } else {
                isPlanned = true;
            }
            if (isPlanned) {
                strBuf.append(this.indent).append("<optional-inputs>").append(LINE_SEP);
                i = workProductDescriptors.iterator();
                while (i.hasNext()) {
                    this.generateXML((Descriptor)((WorkProductDescriptor)i.next()), strBuf);
                }
                strBuf.append(this.indent).append("</optional-inputs>").append(LINE_SEP);
            }
        }
        if ((workProductDescriptors = taskDescriptor.getOutput()) != null && workProductDescriptors.size() > 0) {
            boolean isPlanned = false;
            if (this.exportOnlyPlannedElements) {
                i = workProductDescriptors.iterator();
                while (i.hasNext()) {
                    if (!((WorkProductDescriptor)i.next()).getIsPlanned().booleanValue()) continue;
                    isPlanned = true;
                    break;
                }
            } else {
                isPlanned = true;
            }
            if (isPlanned) {
                strBuf.append(this.indent).append("<outputs>").append(LINE_SEP);
                i = workProductDescriptors.iterator();
                while (i.hasNext()) {
                    this.generateXML((Descriptor)((WorkProductDescriptor)i.next()), strBuf);
                }
                strBuf.append(this.indent).append("</outputs>").append(LINE_SEP);
            }
        }
        this.removeIndent();
        if (generateRootTag) {
            strBuf.append(this.indent).append("</task-descriptor>").append(LINE_SEP);
            this.removeIndent();
        }
    }

    protected void generateXML(Descriptor descriptor, StringBuffer strBuf) {
        if (this.exportOnlyPlannedElements && !descriptor.getIsPlanned().booleanValue()) {
            return;
        }
        this.addIndent();
        String xmlTag = this.getXMLTagName((MethodElement)descriptor);
        strBuf.append(this.indent).append("<").append(xmlTag).append(" guid=\"").append(descriptor.getGuid()).append("\"").append(" name=\"").append(this.getDisplayName((MethodElement)descriptor)).append("\"").append(" href=\"").append(this.getElementURL((MethodElement)descriptor)).append("\">").append(LINE_SEP);
        this.generateBriefDescriptionXML((MethodElement)descriptor, strBuf);
        if (descriptor instanceof RoleDescriptor) {
            RoleDescriptor roleDescriptor = (RoleDescriptor)descriptor;
            Role role = roleDescriptor.getRole();
            if (role == null) {
                role = UmaFactory.eINSTANCE.createRole();
                role.setName(roleDescriptor.getName());
                role.setGuid(roleDescriptor.getGuid());
            }
            this.generateReferenceXML(role, strBuf);
        } else if (descriptor instanceof WorkProductDescriptor) {
            WorkProduct workProduct = ((WorkProductDescriptor)descriptor).getWorkProduct();
            this.generateReferenceXML(workProduct, strBuf);
        }
        strBuf.append(this.indent).append("</").append(xmlTag).append(">").append(LINE_SEP);
        this.removeIndent();
    }

    protected void generateGuidanceXML(MethodElement methodElement, StringBuffer strBuf) {
        List guidanceList;
        if (methodElement != null && (guidanceList = MethodElementUtil.getSelectedGuidances((EObject)methodElement)) != null && guidanceList.size() > 0) {
            this.addIndent();
            strBuf.append(this.indent).append("<guidance>").append(LINE_SEP);
            Iterator i = guidanceList.iterator();
            while (i.hasNext()) {
                this.generateReferenceXML((Guidance)i.next(), strBuf);
            }
            strBuf.append(this.indent).append("</guidance>").append(LINE_SEP);
            this.removeIndent();
        }
    }

    protected void generatePredecessorsXML(WorkBreakdownElement breakdownElement, StringBuffer strBuf) {
        List predecessors = breakdownElement.getLinkToPredecessor();
        if (predecessors != null && predecessors.size() > 0) {
            this.addIndent();
            strBuf.append(this.indent).append("<predecessors>").append(LINE_SEP);
            Iterator i = predecessors.iterator();
            while (i.hasNext()) {
                this.generateXML((WorkOrder)i.next(), strBuf);
            }
            strBuf.append(this.indent).append("</predecessors>").append(LINE_SEP);
            this.removeIndent();
        }
    }

    protected void generateXML(WorkOrder workOrder, StringBuffer strBuf) {
        WorkBreakdownElement predecessor = workOrder.getPred();
        if (predecessor != null) {
            this.addIndent();
            strBuf.append(this.indent).append("<predecessor guid=\"").append(predecessor.getGuid()).append("\"").append(" linkType=\"").append(workOrder.getLinkType().getName()).append("\"/>").append(LINE_SEP);
            this.removeIndent();
        }
    }

    protected void addIndent() {
        this.indent.append(TAG_INDENT);
    }

    protected void removeIndent() {
        this.indent.delete(this.indent.length() - TAG_INDENT.length(), this.indent.length());
    }

    protected String getElementURL(MethodElement element) {
        String elementPath = ResourceHelper.getElementPath((MethodElement)element);
        String elementFileName = ResourceHelper.getFileName((MethodElement)element, (String)".html");
        if (elementPath != null && elementFileName != null) {
            elementPath = elementPath.replace('\\', '/');
            elementFileName = elementFileName.replace('\\', '/');
            String url = String.valueOf(this.contentFolderName) + "/" + elementPath + elementFileName;
            return XMLUtil.escapeAttr((String)url);
        }
        return "";
    }

    protected String getDisplayName(MethodElement element) {
        String name = null;
        if (element instanceof BreakdownElement) {
            name = ProcessUtil.getPresentationName((BreakdownElement)((BreakdownElement)element));
        } else if (element instanceof DescribableElement) {
            name = ((DescribableElement)element).getPresentationName();
        }
        if (name == null || name.length() == 0) {
            name = element.getName();
        }
        return XMLUtil.escapeAttr((String)name);
    }

    protected String getXMLTagName(MethodElement element) {
        if (element == null) {
            return "null";
        }
        String className = element.getClass().getName();
        String tagName = (String)this.xmlTagNames.get(className);
        if (tagName == null) {
            int lastIndex = className.lastIndexOf(46);
            tagName = className.substring(lastIndex + 1);
            if (tagName.endsWith("Impl")) {
                tagName = tagName.substring(0, tagName.length() - 4);
            }
            StringBuffer result = new StringBuffer();
            int i = 0;
            while (i < tagName.length()) {
                char ch = tagName.charAt(i);
                if (i > 0 && Character.isUpperCase(ch)) {
                    result.append('-');
                }
                result.append(Character.toLowerCase(ch));
                ++i;
            }
            tagName = result.toString();
            this.xmlTagNames.put(className, tagName);
        }
        return tagName;
    }

    protected boolean publishConfiguration() throws Exception {
        ExportProjectTemplateOperation operation = new ExportProjectTemplateOperation(this.viewBuilder);
        PublishProgressMonitorDialog dlg = new PublishProgressMonitorDialog(Display.getCurrent().getActiveShell(), this.viewBuilder);
        boolean success = UserInteractionHelper.runWithProgress((IRunnableWithProgress)operation, (ProgressMonitorDialog)dlg, (boolean)true, (String)ExportMspResources.getString("ExportMspUI.exportTemplateProgressDialog.title"));
        if (operation.getException() != null) {
            throw operation.getException();
        }
        return success && !dlg.getProgressMonitor().isCanceled();
    }
}

