/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal;

import org.eclipse.core.commands.ParameterizedCommand;
import org.eclipse.core.commands.common.CommandException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.help.ILiveHelpAction;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.ICommandService;

public class ExecuteCommandAction
implements ILiveHelpAction {
    private String serializedCommand;
    static /* synthetic */ Class class$0;

    public void setInitializationString(String data) {
        this.serializedCommand = data;
    }

    public void run() {
        if (this.serializedCommand == null) {
            return;
        }
        IWorkbench workbench = null;
        try {
            workbench = PlatformUI.getWorkbench();
        }
        catch (IllegalStateException illegalStateException) {}
        if (workbench == null) {
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    MessageDialog.openError(null, (String)Messages.Help_Error, (String)Messages.NoWorkbenchForExecuteCommand_msg);
                }
            });
            return;
        }
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                ExecuteCommandAction.this.forceDialogsOnTop();
                ExecuteCommandAction.this.executeSerializedCommand();
            }
        });
    }

    private void forceDialogsOnTop() {
        Display display = PlatformUI.getWorkbench().getDisplay();
        Shell windowShell = null;
        Shell[] shells = display.getShells();
        int i = 0;
        while (i < shells.length) {
            Object data = shells[i].getData();
            if (data != null && data instanceof IWorkbenchWindow) {
                windowShell = shells[i];
                break;
            }
            ++i;
        }
        if (windowShell != null) {
            windowShell.forceActive();
            if (Platform.getWS().equals("win32")) {
                windowShell.setVisible(false);
                windowShell.setMinimized(true);
                windowShell.setVisible(true);
                windowShell.setMinimized(false);
            }
        }
    }

    private void executeSerializedCommand() {
        try {
            ICommandService commandService = ExecuteCommandAction.getCommandService();
            ParameterizedCommand command = commandService.deserialize(this.serializedCommand);
            command.executeWithChecks(null, null);
        }
        catch (CommandException commandException) {}
    }

    private static ICommandService getCommandService() {
        Object serviceObject;
        IWorkbench workbench = PlatformUI.getWorkbench();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.commands.ICommandService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((serviceObject = workbench.getAdapter((Class)clazz)) != null) {
            ICommandService service = (ICommandService)serviceObject;
            return service;
        }
        return null;
    }
}

