/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.ui.internal.browser.embedded;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.help.internal.base.BaseHelpSystem;
import org.eclipse.help.internal.base.HelpBasePlugin;
import org.eclipse.help.ui.internal.HelpUIPlugin;
import org.eclipse.help.ui.internal.Messages;
import org.eclipse.help.ui.internal.browser.embedded.IBrowserCloseListener;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.CloseWindowListener;
import org.eclipse.swt.browser.LocationEvent;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.OpenWindowListener;
import org.eclipse.swt.browser.TitleEvent;
import org.eclipse.swt.browser.TitleListener;
import org.eclipse.swt.browser.VisibilityWindowListener;
import org.eclipse.swt.browser.WindowEvent;
import org.eclipse.swt.events.ControlEvent;
import org.eclipse.swt.events.ControlListener;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.osgi.framework.Bundle;

public class EmbeddedBrowser {
    private static final String BROWSER_X = "browser.x";
    private static final String BROWSER_Y = "browser.y";
    private static final String BROWSER_WIDTH = "browser.w";
    private static final String BROWSER_HEIGTH = "browser.h";
    private static final String BROWSER_MAXIMIZED = "browser.maximized";
    private Preferences store;
    private static String initialTitle = EmbeddedBrowser.getWindowTitle();
    private Shell shell;
    private Browser browser;
    private int x;
    private int y;
    private int w;
    private int h;
    private long modalRequestTime = 0L;
    private Vector closeListeners = new Vector(1);

    public EmbeddedBrowser() {
        this.store = HelpUIPlugin.getDefault().getPluginPreferences();
        int style = 1264;
        style = BaseHelpSystem.isRTL() ? (style |= 0x4000000) : (style |= 0x2000000);
        this.shell = new Shell(style);
        EmbeddedBrowser.initializeShell(this.shell);
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = location.x;
                    EmbeddedBrowser.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = size.x;
                    EmbeddedBrowser.this.h = size.y;
                }
            }
        });
        this.shell.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_X, Integer.toString(EmbeddedBrowser.this.x));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_Y, Integer.toString(EmbeddedBrowser.this.y));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_WIDTH, Integer.toString(EmbeddedBrowser.this.w));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_HEIGTH, Integer.toString(EmbeddedBrowser.this.h));
                EmbeddedBrowser.this.store.setValue(EmbeddedBrowser.BROWSER_MAXIMIZED, new Boolean(EmbeddedBrowser.this.shell.getMaximized()).toString());
                EmbeddedBrowser.this.notifyCloseListners();
            }
        });
        this.browser = new Browser((Composite)this.shell, 0);
        this.initialize(this.browser);
        this.x = this.store.getInt(BROWSER_X);
        this.y = this.store.getInt(BROWSER_Y);
        this.w = this.store.getInt(BROWSER_WIDTH);
        this.h = this.store.getInt(BROWSER_HEIGTH);
        if (this.w == 0 || this.h == 0) {
            this.w = 1024;
            this.h = 768;
            this.x = this.shell.getLocation().x;
            this.y = this.shell.getLocation().y;
        }
        EmbeddedBrowser.setSafeBounds(this.shell, this.x, this.y, this.w, this.h);
        if (this.store.getBoolean(BROWSER_MAXIMIZED)) {
            this.shell.setMaximized(true);
        }
        this.shell.addControlListener(new ControlListener(){

            public void controlMoved(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point location = EmbeddedBrowser.this.shell.getLocation();
                    EmbeddedBrowser.this.x = location.x;
                    EmbeddedBrowser.this.y = location.y;
                }
            }

            public void controlResized(ControlEvent e) {
                if (!EmbeddedBrowser.this.shell.getMaximized()) {
                    Point size = EmbeddedBrowser.this.shell.getSize();
                    EmbeddedBrowser.this.w = size.x;
                    EmbeddedBrowser.this.h = size.y;
                }
            }
        });
        this.shell.open();
        this.browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (e.location != null && e.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
                if (!e.doit && e.location != null && e.location.startsWith("https://")) {
                    try {
                        BaseHelpSystem.getHelpBrowser((boolean)true).displayURL(e.location);
                    }
                    catch (Exception exception) {}
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    public EmbeddedBrowser(WindowEvent event, Shell parent) {
        if (parent == null) {
            int style = 1264;
            style = BaseHelpSystem.isRTL() ? (style |= 0x4000000) : (style |= 0x2000000);
            this.shell = new Shell(style);
        } else {
            this.shell = new Shell(parent, 34912);
        }
        EmbeddedBrowser.initializeShell(this.shell);
        Browser browser = new Browser((Composite)this.shell, 0);
        this.initialize(browser);
        event.browser = browser;
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                EmbeddedBrowser.this.modalRequestTime = 0L;
                if (e.location != null && e.location.startsWith("javascript://needModal")) {
                    EmbeddedBrowser.this.modalRequestTime = System.currentTimeMillis();
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    private static void initializeShell(Shell s) {
        s.setText(initialTitle);
        Image[] shellImages = EmbeddedBrowser.createImages();
        if (shellImages != null) {
            s.setImages(shellImages);
        }
        s.setLayout((Layout)new FillLayout());
    }

    private void initialize(Browser browser) {
        browser.addOpenWindowListener(new OpenWindowListener(){

            public void open(WindowEvent event) {
                if (System.currentTimeMillis() - EmbeddedBrowser.this.modalRequestTime <= 1000L) {
                    new EmbeddedBrowser(event, EmbeddedBrowser.this.shell);
                } else {
                    new EmbeddedBrowser(event, null);
                }
            }
        });
        browser.addVisibilityWindowListener(new VisibilityWindowListener(){

            public void hide(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.setVisible(false);
            }

            public void show(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                if (event.location != null) {
                    shell.setLocation(event.location);
                }
                if (event.size != null) {
                    Point size = event.size;
                    shell.setSize(shell.computeSize(size.x, size.y));
                }
                shell.open();
            }
        });
        browser.addCloseWindowListener(new CloseWindowListener(){

            public void close(WindowEvent event) {
                Browser browser = (Browser)event.widget;
                Shell shell = browser.getShell();
                shell.close();
            }
        });
        browser.addTitleListener(new TitleListener(){

            public void changed(TitleEvent event) {
                if (event.title != null && event.title.length() > 0) {
                    Browser browser = (Browser)event.widget;
                    Shell shell = browser.getShell();
                    shell.setText(event.title);
                }
            }
        });
        browser.addLocationListener(new LocationListener(){

            public void changing(LocationEvent e) {
                if (!e.doit && e.location != null && e.location.startsWith("https://")) {
                    try {
                        BaseHelpSystem.getHelpBrowser((boolean)true).displayURL(e.location);
                    }
                    catch (Exception exception) {}
                }
            }

            public void changed(LocationEvent e) {
            }
        });
    }

    public void displayUrl(String url) {
        this.browser.setUrl(url);
        this.shell.setMinimized(false);
        this.shell.forceActive();
    }

    public boolean isDisposed() {
        return this.shell.isDisposed();
    }

    private static String getWindowTitle() {
        if ("true".equalsIgnoreCase(HelpBasePlugin.getDefault().getPluginPreferences().getString("windowTitlePrefix"))) {
            return NLS.bind((String)Messages.browserTitle, (Object)BaseHelpSystem.getProductName());
        }
        return BaseHelpSystem.getProductName();
    }

    private static Image[] createImages() {
        String[] productImageURLs = EmbeddedBrowser.getProductImageURLs();
        if (productImageURLs != null) {
            ArrayList<Image> shellImgs = new ArrayList<Image>();
            int i = 0;
            while (i < productImageURLs.length) {
                if (!"".equals(productImageURLs[i])) {
                    URL imageURL;
                    block7: {
                        imageURL = null;
                        try {
                            imageURL = new URL(productImageURLs[i]);
                        }
                        catch (MalformedURLException malformedURLException) {
                            Bundle productBundle;
                            IProduct product = Platform.getProduct();
                            if (product == null || (productBundle = product.getDefiningBundle()) == null) break block7;
                            imageURL = FileLocator.find((Bundle)productBundle, (IPath)new Path(productImageURLs[i]), null);
                        }
                    }
                    Image image = null;
                    if (imageURL != null) {
                        image = ImageDescriptor.createFromURL((URL)imageURL).createImage();
                    }
                    if (image != null) {
                        shellImgs.add(image);
                    }
                }
                ++i;
            }
            return shellImgs.toArray(new Image[shellImgs.size()]);
        }
        return new Image[0];
    }

    private static String[] getProductImageURLs() {
        IProduct product = Platform.getProduct();
        if (product != null) {
            String url = product.getProperty("windowImages");
            if (url != null && url.length() > 0) {
                return url.split(",\\s*");
            }
            url = product.getProperty("windowImage");
            if (url != null && url.length() > 0) {
                return new String[]{url};
            }
        }
        return null;
    }

    public void close() {
        if (!this.shell.isDisposed()) {
            this.shell.dispose();
        }
    }

    private static void setSafeBounds(Shell s, int x, int y, int width, int height) {
        Rectangle clientArea = s.getDisplay().getClientArea();
        width = Math.min(clientArea.width, width);
        height = Math.min(clientArea.height, height);
        x = Math.min(x + width, clientArea.x + clientArea.width) - width;
        y = Math.min(y + height, clientArea.y + clientArea.height) - height;
        x = Math.max(x, clientArea.x);
        y = Math.max(y, clientArea.y);
        s.setBounds(x, y, width, height);
    }

    public void setLocation(int x, int y) {
        this.shell.setLocation(x, y);
    }

    public void setSize(int width, int height) {
        this.shell.setSize(this.w, this.h);
    }

    private void notifyCloseListners() {
        Iterator it = this.closeListeners.iterator();
        while (it.hasNext()) {
            IBrowserCloseListener listener = (IBrowserCloseListener)it.next();
            listener.browserClosed();
        }
    }

    public void addCloseListener(IBrowserCloseListener listener) {
        if (!this.closeListeners.contains(listener)) {
            this.closeListeners.add(listener);
        }
    }

    public void removeCloseListener(IBrowserCloseListener listener) {
        this.closeListeners.remove(listener);
    }
}

