/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.impl;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.Diagram;
import com.ibm.uma.GraphEdge;
import com.ibm.uma.GraphNode;
import com.ibm.uma.MethodElement;
import com.ibm.uma.SemanticModelBridge;
import com.ibm.uma.SimpleSemanticModelElement;
import com.ibm.uma.UMASemanticModelBridge;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.notify.NotificationChain;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.InternalEList;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.epf.diagram.model.ActivityDiagram;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.ModelPackage;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.NodeContainer;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.impl.DiagramImpl;
import org.eclipse.epf.diagram.model.impl.NamedNodeImpl;
import org.eclipse.epf.diagram.model.impl.NodeImpl;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener;
import org.eclipse.epf.diagram.model.util.IAdapterFactoryFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;

public class ActivityDiagramImpl
extends DiagramImpl
implements ActivityDiagram {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    protected ActivityDiagramImpl() {
        this.diagramChangeListener = new ActivityDiagramChangeListener();
    }

    protected Class getDiagramChangeListenerType() {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.diagram.model.util.IActivityDiagramChangeListener");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz;
    }

    protected EClass eStaticClass() {
        return ModelPackage.eINSTANCE.getActivityDiagram();
    }

    public NotificationChain eInverseAdd(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getIncomingConnections()).basicAdd((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getOutgoingConnections()).basicAdd((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseAdd(otherEnd, featureID, baseClass, msgs);
        }
        if (this.eContainer != null) {
            msgs = this.eBasicRemoveFromContainer(msgs);
        }
        return this.eBasicSetContainer(otherEnd, featureID, msgs);
    }

    public NotificationChain eInverseRemove(InternalEObject otherEnd, int featureID, Class baseClass, NotificationChain msgs) {
        if (featureID >= 0) {
            switch (this.eDerivedStructuralFeatureID(featureID, baseClass)) {
                case 4: {
                    return ((InternalEList)this.getIncomingConnections()).basicRemove((Object)otherEnd, msgs);
                }
                case 5: {
                    return ((InternalEList)this.getOutgoingConnections()).basicRemove((Object)otherEnd, msgs);
                }
                case 7: {
                    return ((InternalEList)this.getNodes()).basicRemove((Object)otherEnd, msgs);
                }
            }
            return this.eDynamicInverseRemove(otherEnd, featureID, baseClass, msgs);
        }
        return this.eBasicSetContainer(null, featureID, msgs);
    }

    public Object eGet(EStructuralFeature eFeature, boolean resolve) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return this.getObject();
            }
            case 1: {
                return this.getLocation();
            }
            case 2: {
                return new Integer(this.getWidth());
            }
            case 3: {
                return new Integer(this.getHeight());
            }
            case 4: {
                return this.getIncomingConnections();
            }
            case 5: {
                return this.getOutgoingConnections();
            }
            case 6: {
                return this.isReadOnly() ? Boolean.TRUE : Boolean.FALSE;
            }
            case 7: {
                return this.getNodes();
            }
        }
        return this.eDynamicGet(eFeature, resolve);
    }

    public void eSet(EStructuralFeature eFeature, Object newValue) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setObject(newValue);
                return;
            }
            case 1: {
                this.setLocation((Point)newValue);
                return;
            }
            case 2: {
                this.setWidth((Integer)newValue);
                return;
            }
            case 3: {
                this.setHeight((Integer)newValue);
                return;
            }
            case 4: {
                this.getIncomingConnections().clear();
                this.getIncomingConnections().addAll((Collection)newValue);
                return;
            }
            case 5: {
                this.getOutgoingConnections().clear();
                this.getOutgoingConnections().addAll((Collection)newValue);
                return;
            }
            case 6: {
                this.setReadOnly((Boolean)newValue);
                return;
            }
            case 7: {
                this.getNodes().clear();
                this.getNodes().addAll((Collection)newValue);
                return;
            }
        }
        this.eDynamicSet(eFeature, newValue);
    }

    public void eUnset(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                this.setObject(OBJECT_EDEFAULT);
                return;
            }
            case 1: {
                this.setLocation(LOCATION_EDEFAULT);
                return;
            }
            case 2: {
                this.setWidth(-1);
                return;
            }
            case 3: {
                this.setHeight(-1);
                return;
            }
            case 4: {
                this.getIncomingConnections().clear();
                return;
            }
            case 5: {
                this.getOutgoingConnections().clear();
                return;
            }
            case 6: {
                this.setReadOnly(false);
                return;
            }
            case 7: {
                this.getNodes().clear();
                return;
            }
        }
        this.eDynamicUnset(eFeature);
    }

    public boolean eIsSet(EStructuralFeature eFeature) {
        switch (this.eDerivedStructuralFeatureID(eFeature)) {
            case 0: {
                return OBJECT_EDEFAULT == null ? this.object != null : !OBJECT_EDEFAULT.equals(this.object);
            }
            case 1: {
                return LOCATION_EDEFAULT == null ? this.location != null : !LOCATION_EDEFAULT.equals((Object)this.location);
            }
            case 2: {
                return this.width != -1;
            }
            case 3: {
                return this.height != -1;
            }
            case 4: {
                return this.incomingConnections != null && !this.incomingConnections.isEmpty();
            }
            case 5: {
                return this.outgoingConnections != null && !this.outgoingConnections.isEmpty();
            }
            case 6: {
                return this.readOnly;
            }
            case 7: {
                return this.nodes != null && !this.nodes.isEmpty();
            }
        }
        return this.eDynamicIsSet(eFeature);
    }

    protected void populateNodes() {
        Diagram diagram = this.getUMADiagram();
        ArrayList<TypedNode> typedNodes = new ArrayList<TypedNode>();
        Iterator iter = diagram.getContained().iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            int type = ActivityDiagramImpl.getType(element);
            if (type <= 0) continue;
            TypedNode node = ModelFactory.eINSTANCE.createTypedNode();
            node.setType(type);
            node.setObject(element);
            typedNodes.add(node);
        }
        this.getNodes().addAll(typedNodes);
        this.addElementNodes();
    }

    private static boolean isValidWorkOrder(WorkOrder wo, Object pred) {
        if (wo.getPred() == pred) {
            return true;
        }
        if (pred instanceof Activity) {
            Activity act = (Activity)pred;
            VariabilityElement ve = act.getVariabilityBasedOnElement();
            while (ve != null) {
                if (ve == wo.getPred()) {
                    return true;
                }
                ve = ve.getVariabilityBasedOnElement();
            }
        }
        return false;
    }

    private boolean isValid(Link link) {
        return link.getSource() != null && link.getTarget() != null && this.getNodes().contains((Object)link.getSource()) && this.getNodes().contains((Object)link.getTarget());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void populateLinks() {
        Node node;
        super.populateLinks();
        Iterator iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            Link link;
            node = (Node)iter.next();
            WorkBreakdownElement wbe = null;
            if (node.getObject() instanceof WorkBreakdownElement) {
                wbe = (WorkBreakdownElement)node.getObject();
            }
            ArrayList<Link> linksToRemove = new ArrayList<Link>();
            Iterator iterator = node.getIncomingConnections().iterator();
            while (iterator.hasNext()) {
                link = (Link)iterator.next();
                if (!this.isValid(link)) {
                    linksToRemove.add(link);
                }
                if (wbe == null || link.getSource() instanceof TypedNode) continue;
                Object pred = link.getSource().getObject();
                boolean workOrderFound = false;
                Iterator iterator1 = wbe.getLinkToPredecessor().iterator();
                while (iterator1.hasNext()) {
                    WorkOrder wo = (WorkOrder)iterator1.next();
                    if (!ActivityDiagramImpl.isValidWorkOrder(wo, pred)) continue;
                    workOrderFound = true;
                    break;
                }
                if (workOrderFound) continue;
                linksToRemove.add(link);
            }
            iterator = linksToRemove.iterator();
            while (iterator.hasNext()) {
                link = (Link)iterator.next();
                GraphicalDataHelper.removeLink(link);
            }
            linksToRemove.clear();
            iterator = node.getOutgoingConnections().iterator();
            while (iterator.hasNext()) {
                link = (Link)iterator.next();
                if (this.isValid(link)) continue;
                linksToRemove.add(link);
            }
            iterator = linksToRemove.iterator();
            while (iterator.hasNext()) {
                link = (Link)iterator.next();
                GraphicalDataHelper.removeLink(link);
            }
            linksToRemove.clear();
            linksToRemove = null;
        }
        iter = this.getNodes().iterator();
        while (iter.hasNext()) {
            node = (Node)iter.next();
            if (!(node.getObject() instanceof WorkBreakdownElement)) continue;
            Iterator iterator = new ArrayList(((WorkBreakdownElement)node.getObject()).getLinkToPredecessor()).iterator();
            while (iterator.hasNext()) {
                Object var12_16;
                Node predNode;
                WorkOrder workOrder = (WorkOrder)iterator.next();
                WorkBreakdownElement pred = workOrder.getPred();
                if (!(pred instanceof WorkBreakdownElement) || (predNode = GraphicalDataHelper.findNode((NodeContainer)this, (Object)pred, true)) == null) continue;
                boolean linkFound = false;
                Iterator iterator1 = node.getIncomingConnections().iterator();
                while (iterator1.hasNext()) {
                    Link link = (Link)iterator1.next();
                    if (link.getSource() != predNode) continue;
                    linkFound = true;
                    GraphEdge edge = (GraphEdge)link.getObject();
                    if (edge.getSemanticModel() != null) break;
                    GraphicalDataHelper.setSemanticModel(link, workOrder);
                    break;
                }
                if (linkFound || ActivityDiagramImpl.canReachAsFirstActivityNode(predNode, node)) continue;
                NamedNodeImpl nodeImpl = (NamedNodeImpl)node;
                NamedNodeImpl predNodeImpl = (NamedNodeImpl)predNode;
                boolean oldNotify = nodeImpl.notificationEnabled;
                boolean predNodeNotify = predNodeImpl.notificationEnabled;
                try {
                    nodeImpl.notificationEnabled = false;
                    predNodeImpl.notificationEnabled = false;
                    nodeImpl.addIncomingConnection((MethodElement)pred);
                    var12_16 = null;
                    nodeImpl.notificationEnabled = oldNotify;
                    predNodeImpl.notificationEnabled = predNodeNotify;
                }
                catch (Throwable throwable) {
                    var12_16 = null;
                    nodeImpl.notificationEnabled = oldNotify;
                    predNodeImpl.notificationEnabled = predNodeNotify;
                    throw throwable;
                }
            }
        }
    }

    private static boolean canReachAsFirstActivityNode(Node src, Node target) {
        Iterator iter = src.getOutgoingConnections().iterator();
        while (iter.hasNext()) {
            Link link = (Link)iter.next();
            if (link.getTarget() == target) {
                return true;
            }
            if (!(link.getTarget() instanceof TypedNode) || !ActivityDiagramImpl.canReachAsFirstActivityNode(link.getTarget(), target)) continue;
            return true;
        }
        return false;
    }

    protected Node newNode() {
        return ModelFactory.eINSTANCE.createWorkBreakdownElementNode();
    }

    private Collection getChildren() {
        BreakdownElementWrapperItemProvider adapter = null;
        ConfigurableComposedAdapterFactory adapterFactory = null;
        if (this.wrapper != null) {
            adapter = this.wrapper;
        } else if (this.filter == null) {
            ComposedAdapterFactory composedAdapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            Object object = this.getObject();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ITreeItemContentProvider)composedAdapterFactory.adapt(object, (Object)clazz);
        } else if (this.filter instanceof IAdapterFactoryFilter) {
            adapterFactory = (ConfigurableComposedAdapterFactory)((IAdapterFactoryFilter)this.filter).getWBSAdapterFactory();
            Object object = this.getObject();
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            adapter = (ITreeItemContentProvider)adapterFactory.adapt(object, (Object)clazz);
        }
        if (adapter != null) {
            ArrayList children = new ArrayList();
            this.extractChildren((ITreeItemContentProvider)adapter, this.getObject(), children);
            return children;
        }
        return Collections.EMPTY_LIST;
    }

    private void addElementNodes() {
        ArrayList<NamedNodeImpl> nodes = new ArrayList<NamedNodeImpl>();
        Iterator iter = this.getChildren().iterator();
        while (iter.hasNext()) {
            BreakdownElementWrapperItemProvider wrapper;
            Object e = iter.next();
            Object child = TngUtil.unwrap(e);
            if (!(child instanceof WorkBreakdownElement)) continue;
            NamedNodeImpl node = (NamedNodeImpl)this.toNode((MethodElement)child);
            if (e instanceof BreakdownElementWrapperItemProvider && (wrapper = (BreakdownElementWrapperItemProvider)e).isReadOnly()) {
                node.itemProvider = wrapper;
                node.readOnly = true;
            }
            nodes.add(node);
        }
        this.getNodes().addAll(nodes);
    }

    private static int getType(Object obj) {
        GraphNode node;
        SemanticModelBridge modelBridge;
        if (obj instanceof GraphNode && (modelBridge = (node = (GraphNode)obj).getSemanticModel()) instanceof SimpleSemanticModelElement) {
            String type = ((SimpleSemanticModelElement)modelBridge).getTypeInfo();
            if ("synchnonization bar".equals(type)) {
                return 1;
            }
            if ("decision node".equals(type)) {
                return 2;
            }
            if ("end node".equals(type)) {
                return 4;
            }
            if ("start node".equals(type)) {
                return 3;
            }
            if ("free text".equals(type)) {
                return 6;
            }
        }
        return -1;
    }

    protected int getType() {
        return 0;
    }

    protected List getBreakdownElementTypes() {
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("com.ibm.uma.WorkBreakdownElement");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return Collections.singletonList(clazz);
    }

    /*
     * Unable to fully structure code
     */
    private int toActivityIndex(int index) {
        if (index == -1) {
            return index;
        }
        i = index + 1;
        size = this.getNodes().size();
        if (i == size) {
            return -1;
        }
        node = (Node)this.getNodes().get(i);
        if (node != null) ** GOTO lbl12
        return -1;
lbl-1000:
        // 1 sources

        {
            node = (Node)this.getNodes().get(i);
            ++i;
lbl12:
            // 2 sources

            ** while (!(node.getObject() instanceof BreakdownElement) && i < size)
        }
lbl13:
        // 1 sources

        if (i == size) {
            return -1;
        }
        act = (Activity)this.getObject();
        return act.getBreakdownElements().indexOf(node.getObject());
    }

    protected void addToUmaModel(int position, Node addedNode) {
        if (addedNode.getObject() instanceof BreakdownElement) {
            Activity act = (Activity)this.getObject();
            int i = this.toActivityIndex(position);
            if (i == -1) {
                act.getBreakdownElements().add(addedNode.getObject());
            } else {
                act.getBreakdownElements().add(i, addedNode.getObject());
            }
        }
        super.addToUmaModel(position, addedNode);
    }

    protected Node addNode(Collection nodes, Object obj) {
        Activity act;
        VariabilityElement base;
        if (obj instanceof Activity && (base = (act = (Activity)obj).getVariabilityBasedOnElement()) != null) {
            NodeImpl baseNode = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)base);
            if (baseNode != null) {
                GraphNode graphNode = baseNode.getGraphNode();
                UMASemanticModelBridge bridge = (UMASemanticModelBridge)graphNode.getSemanticModel();
                if (bridge.getElement() != act) {
                    bridge.setElement((MethodElement)act);
                }
            } else {
                baseNode = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)act);
            }
            if (baseNode != null) {
                if (baseNode.methodElementAdapter != null) {
                    base.eAdapters().remove((Object)baseNode.methodElementAdapter);
                }
                baseNode.basicSetObject(act);
                baseNode.setReadOnly(false);
                return null;
            }
        }
        return super.addNode(nodes, obj);
    }

    protected boolean removeNode(Object obj) {
        Activity act;
        VariabilityElement base;
        if (obj instanceof Activity && (base = (act = (Activity)obj).getVariabilityBasedOnElement()) != null) {
            NodeImpl node = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)act);
            if (node != null) {
                GraphNode graphNode = node.getGraphNode();
                UMASemanticModelBridge bridge = (UMASemanticModelBridge)graphNode.getSemanticModel();
                if (bridge.getElement() != base) {
                    bridge.setElement((MethodElement)base);
                }
            } else {
                node = (NodeImpl)GraphicalDataHelper.findNode(this, (Object)base);
            }
            if (node != null) {
                if (node.methodElementAdapter != null) {
                    act.eAdapters().remove((Object)node.methodElementAdapter);
                }
                node.basicSetObject(base);
                node.setReadOnly(true);
                return false;
            }
        }
        return super.removeNode(obj);
    }

    private class ActivityDiagramChangeListener
    extends DiagramImpl.ActivityAdapter
    implements IActivityDiagramChangeListener {
        private ActivityDiagramChangeListener() {
            super(ActivityDiagramImpl.this);
        }
    }
}

