/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import java.io.File;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.epf.export.ExportPlugin;
import org.eclipse.epf.export.ExportResources;
import org.eclipse.epf.export.services.BaseExportService;
import org.eclipse.epf.export.services.ConfigurationExportData;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.library.util.ResourceHelper;

public class ConfigurationSpecsExportService
extends BaseExportService {
    private ConfigurationExportData data;

    public ConfigurationSpecsExportService(ConfigurationExportData data) {
        this.data = data;
    }

    public void run(IProgressMonitor monitor) {
        if (this.data.selectedConfigs == null || this.data.selectedConfigs.size() == 0) {
            return;
        }
        monitor.setTaskName(ExportResources.getString("Export.ConfigurationSpecsExportService.MSG0"));
        String exportLibPath = this.data.llData.getParentFolder();
        File exportLibFolder = new File(exportLibPath);
        if (!exportLibFolder.exists()) {
            exportLibFolder.mkdir();
        }
        MethodConfiguration config = (MethodConfiguration)this.data.selectedConfigs.get(0);
        MethodLibrary lib = (MethodLibrary)config.eContainer();
        URI uri = lib.eResource().getURI();
        String path = uri.toFileString();
        File libFolder = new File(path).getParentFile();
        this.getSelectedIds(this.data.selectedConfigs);
        LibraryDocument document = this.processLibraryFile(new File(libFolder, "library.xmi"), new File(exportLibFolder, "export.xmi"));
        if (document != null) {
            this.copyConfigurationFiles(document, libFolder, exportLibFolder);
        }
        monitor.setTaskName(ExportResources.getString("Export.ConfigurationSpecsExportService.MSG1"));
    }

    private void copyConfigurationFiles(LibraryDocument document, File libFolder, File exportLibFolder) {
        Iterator it = this.data.selectedConfigs.iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            String guid = config.getGuid();
            String uri = document.getResourceUri(guid);
            if (uri == null) continue;
            File src = new File(libFolder, uri);
            File target = new File(exportLibFolder, uri);
            ResourceHelper.copyFile((File)src, (File)target);
        }
    }

    private void getSelectedIds(List configs) {
        this.selectedIds.clear();
        this.selectedPluginNames.clear();
        if (configs == null || configs.size() == 0) {
            return;
        }
        Iterator it = configs.iterator();
        while (it.hasNext()) {
            MethodConfiguration config = (MethodConfiguration)it.next();
            String guid = config.getGuid();
            if (this.selectedIds.contains(guid)) continue;
            this.selectedIds.add(guid);
            EList refs = config.eCrossReferences();
            Iterator itr = refs.iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (o instanceof MethodPlugin || o instanceof MethodPackage) {
                    guid = ((MethodElement)o).getGuid();
                    if (this.selectedIds.contains(guid)) continue;
                    this.selectedIds.add(guid);
                    continue;
                }
                ExportPlugin.getDefault().getLogger().logError("Unexpected element type '" + ((MethodElement)o).getType().getName() + "' in configuration '" + config.getName() + "'");
            }
        }
    }
}

