/*
 * Decompiled with CFR 0.152.
 */
package com.rational.rpw.processview;

import com.rational.rpw.processview.BookmarkVisibilityFilter;
import java.util.Enumeration;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public class Bookmark
extends DefaultMutableTreeNode {
    static final long serialVersionUID = -3652582791326323863L;
    private String _fileName = null;
    private String _closedIconName = null;
    private String _openIconName = null;
    private String _presentationName = null;
    private boolean _isExist = true;
    private boolean _isFromContentLibrary = true;
    private String _uniqueId = null;
    private boolean _isVisible = true;
    private boolean _isEnabled = true;
    private boolean _isTransparent = false;
    private boolean _isDefault = false;
    private boolean _isCurrent = false;

    public Bookmark(String name) {
        super(name);
        this._uniqueId = null;
        this._presentationName = name;
    }

    public Bookmark(String presentationName, String uniqueId) {
        super(presentationName);
        this._presentationName = presentationName;
        this._uniqueId = uniqueId;
    }

    public Object getUserObject() {
        return this._presentationName;
    }

    public void setUserObject(Object userObject) {
        this._presentationName = (String)userObject;
        super.setUserObject(this._presentationName);
    }

    public void setPresentationName(String name) {
        this._presentationName = name;
        super.setUserObject(this._presentationName);
    }

    public String getPresentationName() {
        return this._presentationName;
    }

    public void setFileName(String name) {
        this._fileName = name;
    }

    public String getFileName() {
        return this._fileName;
    }

    public void setClosedIconName(String name) {
        this._closedIconName = name;
    }

    public String getClosedIconName() {
        return this._closedIconName;
    }

    public String getOpenIconName() {
        return this._openIconName;
    }

    public void setOpenIconName(String name) {
        this._openIconName = name;
    }

    public void setExist(boolean isExist) {
        this._isExist = isExist;
    }

    public boolean isExist() {
        return this._isExist;
    }

    public void setFromContentLibrary(boolean flag) {
        this._isFromContentLibrary = flag;
    }

    public boolean isFromContentLibrary() {
        return this._isFromContentLibrary;
    }

    public String getUniqueId() {
        return this._uniqueId;
    }

    public void setUniqueId(String uniqueId) {
        this._uniqueId = uniqueId;
    }

    public void setVisible(boolean isVisible) {
        this._isVisible = isVisible;
        int i = 0;
        while (i < super.getChildCount()) {
            Bookmark child = (Bookmark)super.getChildAt(i);
            child.setVisible(isVisible);
            ++i;
        }
    }

    public boolean isVisible() {
        return this._isVisible;
    }

    public void setEnabled(boolean isEnabled) {
        this._isEnabled = isEnabled;
        int i = 0;
        while (i < super.getChildCount()) {
            Bookmark child = (Bookmark)super.getChildAt(i);
            child.setEnabled(isEnabled);
            ++i;
        }
    }

    public boolean isEnabled() {
        return this._isEnabled;
    }

    public void setTransparency(boolean isTransparent) {
        this._isTransparent = isTransparent;
    }

    public boolean isTransparent() {
        return this._isTransparent;
    }

    public void setDefault(boolean isDefault) {
        this._isDefault = isDefault;
    }

    public boolean isDefault() {
        return this._isDefault;
    }

    public void setCurrent(boolean isCurrent) {
        this._isCurrent = isCurrent;
    }

    public boolean isCurrent() {
        return this._isCurrent;
    }

    public void add(MutableTreeNode newChild) {
        BookmarkVisibilityFilter.applyActualOnly();
        super.add(newChild);
        BookmarkVisibilityFilter.removeActualOnly();
    }

    public void remove(int index) {
        BookmarkVisibilityFilter.applyActualOnly();
        super.remove(index);
        BookmarkVisibilityFilter.removeActualOnly();
    }

    public void remove(MutableTreeNode node) {
        BookmarkVisibilityFilter.applyActualOnly();
        super.remove(node);
        BookmarkVisibilityFilter.removeActualOnly();
    }

    public void removeFromParent() {
        BookmarkVisibilityFilter.applyActualOnly();
        super.removeFromParent();
        BookmarkVisibilityFilter.removeActualOnly();
    }

    public TreeNode getChildAt(int index) {
        if (BookmarkVisibilityFilter.isActualOnly()) {
            return this.getActualChildAt(index);
        }
        boolean isApplyFilter = BookmarkVisibilityFilter.isApplyVisibilityFilter();
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("This bookmark has no children.");
        }
        int realIndex = -1;
        int visibleIndex = -1;
        Enumeration<TreeNode> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            if (isApplyFilter) {
                if (bookmark.isVisible() && bookmark.isEnabled() && !bookmark.isTransparent()) {
                    ++visibleIndex;
                }
            } else if (bookmark.isEnabled() && !bookmark.isTransparent()) {
                ++visibleIndex;
            }
            ++realIndex;
            if (visibleIndex != index) continue;
            return this.children.elementAt(realIndex);
        }
        return super.getChildAt(index);
    }

    public TreeNode getActualChildAt(int index) {
        return super.getChildAt(index);
    }

    public int getChildCount() {
        if (BookmarkVisibilityFilter.isActualOnly()) {
            return this.getActualChildCount();
        }
        boolean isApplyFilter = BookmarkVisibilityFilter.isApplyVisibilityFilter();
        if (this.children == null) {
            return 0;
        }
        int count = 0;
        Enumeration<TreeNode> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            if (isApplyFilter) {
                if (!bookmark.isVisible() || !bookmark.isEnabled() || bookmark.isTransparent()) continue;
                ++count;
                continue;
            }
            if (!bookmark.isEnabled() || bookmark.isTransparent()) continue;
            ++count;
        }
        return count;
    }

    public int getActualChildCount() {
        return super.getChildCount();
    }

    public int getIndex(TreeNode node) {
        if (BookmarkVisibilityFilter.isActualOnly()) {
            return this.getActualIndex(node);
        }
        boolean isApplyFilter = BookmarkVisibilityFilter.isApplyVisibilityFilter();
        if (this.children == null) {
            throw new ArrayIndexOutOfBoundsException("This bookmark has no children.");
        }
        int realIndex = -1;
        int visibleIndex = -1;
        Enumeration<TreeNode> enumeration = this.children.elements();
        while (enumeration.hasMoreElements()) {
            Bookmark bookmark = (Bookmark)enumeration.nextElement();
            if (isApplyFilter) {
                if (bookmark.isVisible() && bookmark.isEnabled() && !bookmark.isTransparent()) {
                    ++visibleIndex;
                }
            } else if (bookmark.isEnabled() && !bookmark.isTransparent()) {
                ++visibleIndex;
            }
            ++realIndex;
            if (!bookmark.equals((Bookmark)node)) continue;
            return visibleIndex;
        }
        return super.getIndex(node);
    }

    public int getActualIndex(TreeNode node) {
        return super.getIndex(node);
    }

    /*
     * Unable to fully structure code
     */
    public DefaultMutableTreeNode getPreviousSibling() {
        block4: {
            isApplyFilter = BookmarkVisibilityFilter.isApplyVisibilityFilter();
            parent = (Bookmark)super.getParent();
            indexOfNode = parent.getActualIndex(this);
            levelToMove = indexOfNode - 1;
            upBookmark = null;
            try {
                upBookmark = (Bookmark)parent.getActualChildAt(levelToMove);
                if (!isApplyFilter) ** GOTO lbl14
                while (!(upBookmark == null || upBookmark.isVisible() && upBookmark.isEnabled() && !upBookmark.isTransparent())) {
                    upBookmark = (Bookmark)parent.getActualChildAt(--levelToMove);
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    upBookmark = (Bookmark)parent.getActualChildAt(--levelToMove);
lbl14:
                    // 2 sources

                    ** while (upBookmark != null && (!upBookmark.isEnabled() || upBookmark.isTransparent()))
                }
lbl15:
                // 1 sources

            }
            catch (ArrayIndexOutOfBoundsException ae) {
                return null;
            }
        }
        return upBookmark;
    }

    /*
     * Unable to fully structure code
     */
    public DefaultMutableTreeNode getNextSibling() {
        block4: {
            isApplyFilter = BookmarkVisibilityFilter.isApplyVisibilityFilter();
            parent = (Bookmark)super.getParent();
            indexOfNode = parent.getActualIndex(this);
            levelToMove = indexOfNode + 1;
            downBookmark = null;
            try {
                downBookmark = (Bookmark)parent.getActualChildAt(levelToMove);
                if (!isApplyFilter) ** GOTO lbl14
                while (!(downBookmark == null || downBookmark.isVisible() && downBookmark.isEnabled() && !downBookmark.isTransparent())) {
                    downBookmark = (Bookmark)parent.getActualChildAt(++levelToMove);
                }
                break block4;
lbl-1000:
                // 1 sources

                {
                    downBookmark = (Bookmark)parent.getActualChildAt(++levelToMove);
lbl14:
                    // 2 sources

                    ** while (downBookmark != null && (!downBookmark.isEnabled() || downBookmark.isTransparent()))
                }
lbl15:
                // 1 sources

            }
            catch (ArrayIndexOutOfBoundsException ae) {
                return null;
            }
        }
        return downBookmark;
    }

    public Bookmark findBookmark(String uniqueId) {
        Bookmark foundBookmark = null;
        if (uniqueId != null && uniqueId.equals(this.getUniqueId())) {
            return foundBookmark;
        }
        int i = 0;
        while (i < super.getChildCount()) {
            Bookmark childBookmark = (Bookmark)super.getChildAt(i);
            foundBookmark = this.findBookmark(childBookmark, uniqueId);
            if (foundBookmark != null) {
                return foundBookmark;
            }
            ++i;
        }
        return foundBookmark;
    }

    private Bookmark findBookmark(Bookmark bookmark, String uniqueId) {
        Bookmark foundBookmark = null;
        String tempUniqueId = bookmark.getUniqueId();
        if (tempUniqueId != null && tempUniqueId.equals(uniqueId)) {
            foundBookmark = bookmark;
            return foundBookmark;
        }
        int i = 0;
        while (i < bookmark.getActualChildCount()) {
            Bookmark childBookmark = (Bookmark)bookmark.getActualChildAt(i);
            foundBookmark = this.findBookmark(childBookmark, uniqueId);
            if (foundBookmark != null) {
                return foundBookmark;
            }
            ++i;
        }
        return foundBookmark;
    }

    public Object clone() {
        Bookmark bookmark = new Bookmark(this._presentationName, this._uniqueId);
        bookmark.setFileName(this._fileName);
        bookmark.setClosedIconName(this._closedIconName);
        bookmark.setOpenIconName(this._openIconName);
        bookmark.setExist(this._isExist);
        bookmark.setFromContentLibrary(this._isFromContentLibrary);
        bookmark.setVisible(this._isVisible);
        bookmark.setEnabled(this._isEnabled);
        bookmark.setTransparency(this._isTransparent);
        bookmark.setDefault(this._isDefault);
        bookmark.setCurrent(this._isCurrent);
        int i = 0;
        while (i < super.getChildCount()) {
            Bookmark child = (Bookmark)((Bookmark)this.getActualChildAt(i)).clone();
            int childCount = bookmark.getActualChildCount();
            bookmark.insert(child, childCount);
            ++i;
        }
        return bookmark;
    }
}

