/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import java.io.File;
import java.io.IOException;
import org.eclipse.epf.dataexchange.util.BaseResourceHandler;
import org.eclipse.epf.dataexchange.util.UrlInfo;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.xml.uma.MethodElement;

public class ExportResourceHandler
extends BaseResourceHandler {
    public ExportResourceHandler(File sourceLibRoot, File targetLibRoot) {
        super(sourceLibRoot, targetLibRoot);
    }

    protected UrlInfo loadUrlInfoWithFixedPath(Object owner, String srcUrl) {
        UrlInfo info = new UrlInfo();
        info.sourceUrl = srcUrl;
        info.targetUrl = srcUrl;
        String srcFile = this.getFileRelPath(owner, srcUrl);
        if (srcFile != null) {
            info.sourceFile = new File(this.sourceLibRoot, srcFile);
            info.targetFile = new File(this.targetLibRoot, srcFile);
            info.targetUrl = srcFile.replace(File.separatorChar, '/');
        }
        return info;
    }

    private String getFileRelPath(Object owner, String srcUrl) {
        try {
            if (owner instanceof MethodElement) {
                String id = ((MethodElement)owner).getId();
                com.ibm.uma.MethodElement e = LibraryProcessor.getInstance().getElement(id);
                if (e != null) {
                    File f = new File(new File(this.sourceLibRoot, ResourceHelper.getElementPath((com.ibm.uma.MethodElement)e)), srcUrl);
                    String path = f.getCanonicalPath();
                    return path.substring(this.sourceLibRoot.getCanonicalPath().length() + 1);
                }
            }
        }
        catch (IOException iOException) {}
        return null;
    }

    protected UrlInfo loadUrlInfoWithRelativePath(Object owner, String srcUrl) {
        UrlInfo info = new UrlInfo();
        try {
            info.sourceUrl = srcUrl;
            info.targetUrl = srcUrl;
            if (owner instanceof MethodElement) {
                String id = ((MethodElement)owner).getId();
                com.ibm.uma.MethodElement e = LibraryProcessor.getInstance().getElement(id);
                if (e != null) {
                    File f = new File(new File(this.sourceLibRoot, ResourceHelper.getElementPath((com.ibm.uma.MethodElement)e)), srcUrl);
                    info.sourceFile = f = f.getCanonicalFile();
                }
            }
            info.targetFile = new File(this.targetLibRoot, srcUrl).getCanonicalFile();
        }
        catch (IOException iOException) {}
        return info;
    }

    private File getTargetFileFromUrl(Object owner, String url) {
        try {
            return new File(this.targetLibRoot, url).getCanonicalFile();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }
}

