/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.actions;

import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.resources.IStorage;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.core.history.IFileRevision;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.history.AbstractHistoryCategory;
import org.eclipse.team.internal.ui.history.FileRevisionEditorInput;
import org.eclipse.team.ui.history.HistoryPage;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.BaseSelectionListenerAction;
import org.eclipse.ui.progress.IProgressService;

public class OpenRevisionAction
extends BaseSelectionListenerAction {
    private IStructuredSelection selection;
    private HistoryPage page;
    static /* synthetic */ Class class$0;

    public OpenRevisionAction(String text) {
        super(text);
    }

    public void run() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        int i = 0;
        while (i < objArray.length) {
            Object tempRevision = objArray[i];
            if (!(tempRevision instanceof AbstractHistoryCategory)) {
                final IFileRevision revision = (IFileRevision)tempRevision;
                if (revision == null || !revision.exists()) {
                    MessageDialog.openError((Shell)this.page.getSite().getShell(), (String)TeamUIMessages.OpenRevisionAction_DeletedRevTitle, (String)TeamUIMessages.OpenRevisionAction_DeletedRevMessage);
                } else {
                    IRunnableWithProgress runnable = new IRunnableWithProgress(){

                        public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
                            try {
                                IStorage file = revision.getStorage(monitor);
                                String id = OpenRevisionAction.this.getEditorID(file.getName(), file.getContents());
                                FileRevisionEditorInput fileRevEditorInput = new FileRevisionEditorInput(revision);
                                if (!OpenRevisionAction.this.editorAlreadyOpenOnContents(fileRevEditorInput)) {
                                    OpenRevisionAction.this.page.getSite().getPage().openEditor((IEditorInput)fileRevEditorInput, id);
                                }
                            }
                            catch (CoreException e) {
                                throw new InvocationTargetException(e);
                            }
                        }
                    };
                    IProgressService progressService = PlatformUI.getWorkbench().getProgressService();
                    try {
                        progressService.run(false, false, runnable);
                    }
                    catch (InvocationTargetException e) {
                        Utils.handleError(this.page.getSite().getShell(), e, TeamUIMessages.OpenRevisionAction_ErrorTitle, TeamUIMessages.OpenRevisionAction_ErrorMessage);
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            ++i;
        }
    }

    String getEditorID(String fileName, InputStream contents) {
        IEditorDescriptor descriptor;
        IWorkbench workbench = TeamUIPlugin.getPlugin().getWorkbench();
        IEditorRegistry registry = workbench.getEditorRegistry();
        IContentType type = null;
        if (contents != null) {
            try {
                type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
            }
            catch (IOException iOException) {}
        }
        if (type == null) {
            type = Platform.getContentTypeManager().findContentTypeFor(fileName);
        }
        String id = (descriptor = registry.getDefaultEditor(fileName, type)) == null || descriptor.isOpenExternal() ? "org.eclipse.ui.DefaultTextEditor" : descriptor.getId();
        return id;
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        this.selection = selection;
        return this.shouldShow();
    }

    public void setPage(HistoryPage page) {
        this.page = page;
    }

    private boolean shouldShow() {
        IStructuredSelection structSel = this.selection;
        Object[] objArray = structSel.toArray();
        if (objArray.length == 0) {
            return false;
        }
        int i = 0;
        while (i < objArray.length) {
            if (objArray[i] instanceof AbstractHistoryCategory) {
                return false;
            }
            IFileRevision revision = (IFileRevision)objArray[i];
            if (revision != null && !revision.exists()) {
                return false;
            }
            ++i;
        }
        return true;
    }

    private boolean editorAlreadyOpenOnContents(FileRevisionEditorInput input) {
        IEditorReference[] editorRefs = this.page.getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorRefs.length) {
            IEditorPart part = editorRefs[i].getEditor(false);
            if (part != null && part.getEditorInput() instanceof FileRevisionEditorInput) {
                IFileRevision editorRevision;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.team.core.history.IFileRevision");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                IFileRevision inputRevision = (IFileRevision)input.getAdapter(clazz);
                IEditorInput iEditorInput = part.getEditorInput();
                Class<?> clazz2 = class$0;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.team.core.history.IFileRevision");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if (inputRevision.equals(editorRevision = (IFileRevision)iEditorInput.getAdapter((Class)clazz2))) {
                    this.page.getSite().getPage().activate((IWorkbenchPart)part);
                    return true;
                }
            }
            ++i;
        }
        return false;
    }
}

