/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceMapping;
import org.eclipse.core.resources.mapping.ResourceMappingContext;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.DecoratingLabelProvider;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.team.core.mapping.ISynchronizationScopeManager;
import org.eclipse.team.core.mapping.provider.SynchronizationScopeManager;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;
import org.eclipse.team.internal.ui.Utils;
import org.eclipse.team.internal.ui.synchronize.GlobalRefreshElementSelectionPage;
import org.eclipse.team.ui.TeamUI;
import org.eclipse.ui.IWorkingSet;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.dialogs.ContainerCheckedTreeViewer;
import org.eclipse.ui.navigator.INavigatorContentExtension;
import org.eclipse.ui.navigator.INavigatorContentService;
import org.eclipse.ui.navigator.INavigatorContentServiceListener;
import org.eclipse.ui.navigator.NavigatorContentServiceFactory;
import org.eclipse.ui.views.navigator.ResourceSorter;

public class ModelElementSelectionPage
extends GlobalRefreshElementSelectionPage
implements INavigatorContentServiceListener {
    private INavigatorContentService service;
    private ISynchronizationScopeManager manager;

    public ModelElementSelectionPage(IResource[] roots) {
        super("elementSelection");
        this.setDescription(TeamUIMessages.GlobalRefreshResourceSelectionPage_2);
        this.setTitle(TeamUIMessages.GlobalRefreshResourceSelectionPage_3);
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        int i = 0;
        while (i < roots.length) {
            IResource resource = roots[i];
            result.add(Utils.getResourceMapping(resource));
            ++i;
        }
        this.manager = new SynchronizationScopeManager(TeamUIMessages.ModelElementSelectionPage_0, result.toArray(new ResourceMapping[result.size()]), ResourceMappingContext.LOCAL_CONTEXT, true);
        try {
            this.manager.initialize((IProgressMonitor)new NullProgressMonitor());
        }
        catch (CoreException e) {
            Utils.handleError(this.getShell(), (Exception)((Object)e), null, null);
        }
    }

    protected ContainerCheckedTreeViewer createViewer(Composite top) {
        ContainerCheckedTreeViewer fViewer = new ContainerCheckedTreeViewer(top, 2048);
        this.service = NavigatorContentServiceFactory.INSTANCE.createContentService("org.eclipse.team.ui.navigatorViewer", (StructuredViewer)fViewer);
        this.service.bindExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.manager.getScope()), true);
        this.service.getActivationService().activateExtensions(TeamUI.getTeamContentProviderManager().getContentProviderIds(this.manager.getScope()), true);
        this.service.addListener((INavigatorContentServiceListener)this);
        GridData data = new GridData(1808);
        data.heightHint = 100;
        fViewer.getControl().setLayoutData((Object)data);
        fViewer.setContentProvider((IContentProvider)this.service.createCommonContentProvider());
        fViewer.setLabelProvider((IBaseLabelProvider)new DecoratingLabelProvider(this.service.createCommonLabelProvider(), PlatformUI.getWorkbench().getDecoratorManager().getLabelDecorator()));
        fViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                ModelElementSelectionPage.this.updateOKStatus();
            }
        });
        fViewer.setSorter((ViewerSorter)new ResourceSorter(1));
        fViewer.setInput((Object)this.manager.getScope());
        return fViewer;
    }

    public ResourceMapping[] getSelectedMappings() {
        if (this.isWorkingSetSelected()) {
            ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
            IWorkingSet[] sets = this.getWorkingSets();
            int i = 0;
            while (i < sets.length) {
                IWorkingSet set = sets[i];
                result.add(Utils.getResourceMapping(set));
                ++i;
            }
            return result.toArray(new ResourceMapping[result.size()]);
        }
        if (this.isWorkspaceSelected()) {
            try {
                ModelProvider provider = ModelProvider.getModelProviderDescriptor((String)"org.eclipse.core.resources.modelProvider").getModelProvider();
                ResourceMapping mapping = Utils.getResourceMapping(provider);
                if (mapping != null) {
                    return new ResourceMapping[]{mapping};
                }
            }
            catch (CoreException e) {
                TeamUIPlugin.log(e);
            }
            ResourceMapping[] mappings = this.manager.getScope().getMappings("org.eclipse.core.resources.modelProvider");
            return mappings;
        }
        ArrayList<ResourceMapping> result = new ArrayList<ResourceMapping>();
        Object[] objects = this.getRootElement();
        int i = 0;
        while (i < objects.length) {
            Object object = objects[i];
            ResourceMapping mapping = Utils.getResourceMapping(object);
            if (mapping != null) {
                result.add(mapping);
            }
            ++i;
        }
        return result.toArray(new ResourceMapping[result.size()]);
    }

    public void dispose() {
        this.service.dispose();
        super.dispose();
    }

    protected void checkAll() {
        this.getViewer().setCheckedElements((Object[])this.manager.getScope().getModelProviders());
    }

    protected void checkWorkingSetElements() {
    }

    public void onLoad(INavigatorContentExtension anExtension) {
        anExtension.getStateModel().setProperty("org.eclipse.team.ui.synchronizationScope", (Object)this.manager.getScope());
    }
}

