/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ui.mapping;

import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.mapping.ModelProvider;
import org.eclipse.core.resources.mapping.ResourceTraversal;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.viewers.TreePath;
import org.eclipse.osgi.util.NLS;
import org.eclipse.team.core.diff.IDiff;
import org.eclipse.team.core.mapping.IResourceDiffTree;
import org.eclipse.team.core.mapping.ISynchronizationContext;
import org.eclipse.team.core.mapping.provider.ResourceDiffTree;
import org.eclipse.team.internal.core.subscribers.DiffChangeSet;
import org.eclipse.team.internal.ui.TeamUIMessages;
import org.eclipse.team.internal.ui.TeamUIPlugin;

public class ResourceModelTraversalCalculator {
    public static final String PROP_TRAVERSAL_CALCULATOR = "org.eclipse.team.ui.resourceModelraversalCalculator";

    public int getLayoutDepth(IResource resource, TreePath path) {
        if (resource.getType() == 4) {
            return 2;
        }
        if (resource.getType() == 1) {
            return 0;
        }
        if (path != null && this.hasNonResource(path)) {
            return 2;
        }
        if (this.getLayout().equals("org.eclipse.team.ui.flay_layout")) {
            return 0;
        }
        if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout")) {
            return 1;
        }
        return 2;
    }

    public String getLayout() {
        return TeamUIPlugin.getPlugin().getPreferenceStore().getString("org.eclipse.team.ui.default_layout");
    }

    public Object[] filterChildren(IResourceDiffTree diffTree, IResource resource, Object parentOrPath, Object[] children) {
        TreePath tp;
        if (parentOrPath instanceof TreePath && this.hasNonResource(tp = (TreePath)parentOrPath)) {
            return this.getTreeChildren(diffTree, resource, children);
        }
        if (this.getLayout().equals("org.eclipse.team.ui.flay_layout") && resource.getType() == 4) {
            return this.getFlatChildren(diffTree, resource);
        }
        if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 4) {
            return this.getCompressedChildren(diffTree, (IProject)resource, children);
        }
        if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2) {
            return this.getCompressedChildren(diffTree, (IFolder)resource, children);
        }
        return this.getTreeChildren(diffTree, resource, children);
    }

    private boolean hasNonResource(TreePath parentPath) {
        int i = 0;
        while (i < parentPath.getSegmentCount()) {
            Object o = parentPath.getSegment(i);
            if (!(o instanceof IResource) && !(o instanceof ModelProvider)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private Object[] getCompressedChildren(IResourceDiffTree diffTree, IProject project, Object[] children) {
        HashSet<Object> result = new HashSet<Object>();
        IDiff[] diffs = diffTree.getDiffs((IResource)project, 2);
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            IResource resource = diffTree.getResource(diff);
            if (resource.getType() == 1) {
                IContainer parent = resource.getParent();
                if (parent.getType() == 2) {
                    result.add(parent);
                } else {
                    result.add(resource);
                }
            } else if (resource.getType() == 2) {
                result.add(resource);
            }
            ++i;
        }
        return result.toArray();
    }

    private Object[] getCompressedChildren(IResourceDiffTree diffTree, IFolder folder, Object[] children) {
        HashSet<IResource> result = new HashSet<IResource>();
        int i = 0;
        while (i < children.length) {
            IResource resource;
            Object object = children[i];
            if (object instanceof IResource && (resource = (IResource)object).getType() == 1) {
                result.add(resource);
            }
            ++i;
        }
        IDiff[] diffs = diffTree.getDiffs((IResource)folder, 1);
        int i2 = 0;
        while (i2 < diffs.length) {
            IDiff diff = diffs[i2];
            IResource resource = diffTree.getResource(diff);
            if (resource.getType() == 1) {
                result.add(resource);
            }
            ++i2;
        }
        return result.toArray();
    }

    private Object[] getFlatChildren(IResourceDiffTree diffTree, IResource resource) {
        IDiff[] diffs = diffTree.getDiffs(resource, 2);
        ArrayList<IResource> result = new ArrayList<IResource>();
        int i = 0;
        while (i < diffs.length) {
            IDiff diff = diffs[i];
            result.add(diffTree.getResource(diff));
            ++i;
        }
        Object[] allChildren = result.toArray();
        return allChildren;
    }

    private Object[] getTreeChildren(IResourceDiffTree diffTree, IResource resource, Object[] children) {
        HashSet<Object> result = new HashSet<Object>();
        int i = 0;
        while (i < children.length) {
            Object object = children[i];
            result.add(object);
            ++i;
        }
        IResource[] setChildren = ResourceModelTraversalCalculator.getChildren(diffTree, resource);
        int i2 = 0;
        while (i2 < setChildren.length) {
            IResource child = setChildren[i2];
            result.add(child);
            ++i2;
        }
        Object[] allChildren = result.toArray(new Object[result.size()]);
        return allChildren;
    }

    public static IResource[] getChildren(IResourceDiffTree diffTree, IResource resource) {
        HashSet<IResource> result = new HashSet<IResource>();
        IPath[] childPaths = diffTree.getChildren(resource.getFullPath());
        int i = 0;
        while (i < childPaths.length) {
            IPath path = childPaths[i];
            IDiff delta = diffTree.getDiff(path);
            Object child = delta == null ? (path.segmentCount() == 1 ? ((IWorkspaceRoot)resource).getProject(path.lastSegment()) : ((IContainer)resource).getFolder((IPath)new Path(path.lastSegment()))) : diffTree.getResource(delta);
            result.add((IResource)child);
            ++i;
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ResourceTraversal[] getTraversals(DiffChangeSet dcs, TreePath tp) {
        IResource[] resources = this.getResource(dcs, tp);
        return new ResourceTraversal[]{new ResourceTraversal(resources, 0, 0)};
    }

    private IResource[] getResource(DiffChangeSet dcs, TreePath tp) {
        if (tp.getSegmentCount() == 1 && tp.getFirstSegment() == dcs) {
            return dcs.getResources();
        }
        HashSet<IResource> result = new HashSet<IResource>();
        Object o = tp.getLastSegment();
        if (o instanceof IResource) {
            IResource resource = (IResource)o;
            int depth = this.getLayoutDepth(resource, tp);
            IDiff[] diffs = dcs.getDiffTree().getDiffs(resource, depth);
            int i = 0;
            while (i < diffs.length) {
                IDiff diff = diffs[i];
                IResource r = ResourceDiffTree.getResourceFor((IDiff)diff);
                if (r != null) {
                    result.add(r);
                }
                ++i;
            }
        }
        return result.toArray(new IResource[result.size()]);
    }

    public ResourceTraversal[] getTraversals(IResource resource, TreePath tp) {
        return new ResourceTraversal[]{new ResourceTraversal(new IResource[]{resource}, this.getLayoutDepth(resource, tp), 0)};
    }

    public boolean isResourcePath(TreePath path) {
        int i = 0;
        while (i < path.getSegmentCount()) {
            Object o = path.getSegment(i);
            if (!(o instanceof IResource)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public String getLabel(Object elementOrPath) {
        if (elementOrPath instanceof TreePath && this.hasNonResource((TreePath)elementOrPath)) {
            return null;
        }
        Object element = this.internalGetElement(elementOrPath);
        Object parent = this.internalGetElementParent(elementOrPath);
        if (element instanceof IResource) {
            IPath parentPath;
            IResource resource = (IResource)element;
            if (this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2 && (parent == null || parent instanceof IProject)) {
                return resource.getProjectRelativePath().toString();
            }
            if (this.getLayout().equals("org.eclipse.team.ui.flay_layout") && resource.getType() == 1 && (parent == null || parent instanceof IProject) && !(parentPath = resource.getProjectRelativePath().removeLastSegments(1)).isEmpty()) {
                return NLS.bind((String)TeamUIMessages.ResourceModelLabelProvider_0, (Object)resource.getName(), (Object)parentPath.toString());
            }
        }
        return null;
    }

    public boolean isCompressedFolder(Object elementOrPath) {
        if (elementOrPath instanceof TreePath && this.hasNonResource((TreePath)elementOrPath)) {
            return false;
        }
        Object element = this.internalGetElement(elementOrPath);
        Object parent = this.internalGetElementParent(elementOrPath);
        if (element instanceof IResource) {
            IResource resource = (IResource)element;
            return this.getLayout().equals("org.eclipse.team.ui.compressed_layout") && resource.getType() == 2 && (parent == null || parent instanceof IProject);
        }
        return false;
    }

    private TreePath internalGetPath(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            return (TreePath)elementOrPath;
        }
        return null;
    }

    private Object internalGetElement(Object elementOrPath) {
        if (elementOrPath instanceof TreePath) {
            TreePath tp = (TreePath)elementOrPath;
            return tp.getLastSegment();
        }
        return elementOrPath;
    }

    private Object internalGetElementParent(Object elementOrPath) {
        TreePath tp;
        if (elementOrPath instanceof TreePath && (tp = (TreePath)elementOrPath).getSegmentCount() > 1) {
            return tp.getSegment(tp.getSegmentCount() - 2);
        }
        return null;
    }

    public boolean hasChildren(ISynchronizationContext context, Object elementOrPath) {
        Object element = this.internalGetElement(elementOrPath);
        if (element instanceof IContainer) {
            IContainer container = (IContainer)element;
            if (context != null) {
                int depth = this.getLayoutDepth((IResource)container, this.internalGetPath(elementOrPath));
                if (depth == 0) {
                    return false;
                }
                IResourceDiffTree tree = context.getDiffTree();
                IResource[] members = tree.members((IResource)container);
                if (members.length > 0) {
                    if (depth == 2) {
                        return true;
                    }
                    int i = 0;
                    while (i < members.length) {
                        IResource resource = members[i];
                        if (resource.getType() == 1) {
                            return true;
                        }
                        ++i;
                    }
                }
            }
        }
        return false;
    }
}

