/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.wizards;

import com.ibm.uma.util.ContentDescriptionFactory;
import com.ibm.uma.util.IFileManager;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.epf.common.serviceability.MsgBox;
import org.eclipse.epf.importing.xml.XmlImportPlugin;
import org.eclipse.epf.importing.xml.XmlImportResources;
import org.eclipse.epf.importing.xml.services.XmlImportService;
import org.eclipse.epf.importing.xml.wizards.SelectXmlFilePage;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.wizards.LibraryBackupUtil;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.ui.IImportWizard;
import org.eclipse.ui.IWorkbench;

public class ImportXmlWizard
extends Wizard
implements IImportWizard {
    XmlImportService service = new XmlImportService();
    private SelectXmlFilePage filePage = null;

    public ImportXmlWizard() {
        this.setWindowTitle(XmlImportResources.getString("XmlImport.ImportXmlWizard.title"));
        this.setNeedsProgressMonitor(true);
    }

    public boolean performFinish() {
        LibraryBackupUtil.promptBackupLibrary(null, (File)LibraryProcessor.getInstance().getLibraryRootPath());
        IRunnableWithProgress op = new IRunnableWithProgress(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run(IProgressMonitor monitor) throws InvocationTargetException {
                try {
                    try {
                        monitor.beginTask(XmlImportResources.getString("XmlImport.importXmlProgress.text"), -1);
                        String path = ImportXmlWizard.this.filePage.getPath();
                        ImportXmlWizard.this.service.loadXml(path);
                        ImportXmlWizard.this.service.doImport(monitor);
                    }
                    catch (Exception e) {
                        throw new InvocationTargetException(e);
                    }
                }
                catch (Throwable throwable) {
                    Object var3_5 = null;
                    monitor.done();
                    throw throwable;
                }
                {
                    Object var3_6 = null;
                }
                monitor.done();
            }
        };
        try {
            this.getContainer().run(true, false, op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            Throwable realException = e.getTargetException();
            XmlImportPlugin.getDefault().getMsgDialog().displayError(XmlImportResources.getString("XmlImport.ImportXmlWizardError.title"), XmlImportResources.getString(realException.getMessage()), realException);
            return false;
        }
        String msg = String.valueOf(XmlImportResources.getString("XmlImport.ImportXmlWizard.review_log")) + this.service.getLogPath();
        MsgBox.prompt((String)msg, (int)32);
        return true;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
    }

    public void addPages() {
        IFileManager fileMgr = ContentDescriptionFactory.getFileManager();
        fileMgr.checkModify(LibraryProcessor.getInstance().getLibraryURI().toFileString(), (Object)MsgBox.getDefaultShell());
        if (LibraryProcessor.getInstance().isReadOnly()) {
            File libraryFile = new File(LibraryProcessor.getInstance().getLibraryRootPath().getAbsolutePath(), "library.xmi");
            XmlImportPlugin.getDefault().getMsgDialog().displayError(XmlImportResources.getString("XmlImport.ImportXmlWizardError.title"), XmlImportResources.getString("XmlImport.ImportXmlWizardError.msg"), XmlImportResources.getString("XmlImport.ImportXmlWizardError.reason", libraryFile.getAbsolutePath()));
            return;
        }
        this.filePage = new SelectXmlFilePage();
        this.addPage((IWizardPage)this.filePage);
    }

    public void dispose() {
        this.service.dispose();
    }
}

