/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.configuration;

import com.ibm.uma.Activity;
import com.ibm.uma.Artifact;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentElement;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodLibrary;
import com.ibm.uma.MethodPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.Practice;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.Role;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.SupportingMaterial;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.util.AssociationHelper;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.configuration.AttributeValue;
import org.eclipse.epf.library.configuration.DefaultElementRealizer;
import org.eclipse.epf.library.configuration.ElementRealizer;
import org.eclipse.epf.library.configuration.OrderedListComparator;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.uma.ecore.impl.MultiResourceEObject;
import org.eclipse.epf.uma.ecore.util.OppositeFeature;

public class ConfigurationHelper {
    public static final String ATTRIBUTE_VALUE_SEPERATOR = "<p/>";
    private static boolean debug = LibraryPlugin.getDefault().isDebugging();
    static /* synthetic */ Class class$0;

    public static boolean isDescriptionElement(MethodElement element) {
        return element instanceof ContentDescription || element.eContainer() instanceof ContentDescription;
    }

    public static boolean isGlobalPackage(MethodPackage pkg) {
        if (pkg == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: method package is null");
            }
            return false;
        }
        MethodPlugin p = LibraryUtil.getMethodPlugin((EObject)pkg);
        if (p == null) {
            if (debug) {
                System.out.println("ConfigurationHelper.isGlobalPackage: Unable to find method plug-in for " + pkg.getName() + ": " + pkg.getGuid());
            }
            return false;
        }
        return TngUtil.getAllSystemPackages((MethodPlugin)p).contains(pkg);
    }

    public static boolean inConfig(MethodElement element, MethodConfiguration config) {
        VariabilityElement ve;
        if (!ConfigurationHelper.isOwnerSelected(element, config)) {
            return false;
        }
        if (element instanceof VariabilityElement && ConfigurationHelper.isReplacer(ve = (VariabilityElement)element)) {
            VariabilityElement base = ve.getVariabilityBasedOnElement();
            if (ConfigurationHelper.inConfig((MethodElement)base, config)) {
                if (element instanceof Activity) {
                    return true;
                }
                Iterator it = AssociationHelper.getImmediateVarieties((VariabilityElement)base).iterator();
                while (it.hasNext()) {
                    VariabilityElement e = (VariabilityElement)it.next();
                    if (e == element || e.getVariabilityType() != VariabilityType.REPLACES_LITERAL || !ConfigurationHelper.isOwnerSelected((MethodElement)e, config)) continue;
                    if (debug) {
                        System.out.println("ConfigurationHelper.inConfig: Ignoring replacing element '" + LibraryUtil.getTypeName(element) + "' since its base element has more than one replacer in the configuration");
                    }
                    return false;
                }
            } else {
                return false;
            }
        }
        return true;
    }

    private static boolean isOwnerSelected(MethodElement element, MethodConfiguration config) {
        Activity base;
        if (element == null) {
            return false;
        }
        if (config == null || ConfigurationHelper.isDescriptionElement(element)) {
            return true;
        }
        if (element instanceof MethodLibrary || element instanceof MethodConfiguration) {
            return true;
        }
        if (element instanceof MethodPlugin) {
            List plugins = config.getMethodPluginSelection();
            return plugins != null && plugins.contains(element);
        }
        if (element instanceof Activity && (base = (Activity)((Activity)element).getVariabilityBasedOnElement()) != null && !ConfigurationHelper.inConfig((MethodElement)TngUtil.getOwningProcess((BreakdownElement)base), config)) {
            return false;
        }
        EObject pkg = LibraryUtil.getSelectable((EObject)element);
        if (pkg instanceof MethodPackage && ConfigurationHelper.isGlobalPackage((MethodPackage)pkg)) {
            MethodPlugin plugin = LibraryUtil.getMethodPlugin(pkg);
            return ConfigurationHelper.inConfig((MethodElement)plugin, config);
        }
        List pkgs = config.getMethodPackageSelection();
        if (pkgs == null) {
            return false;
        }
        if (pkg instanceof ProcessPackage) {
            while (pkg != null && !(pkg instanceof ProcessComponent) && !pkgs.contains(pkg)) {
                pkg = pkg.eContainer();
            }
        }
        return pkg != null && pkgs.contains(pkg);
    }

    public static boolean isContributor(VariabilityElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 1;
    }

    public static boolean isReplacer(VariabilityElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 3;
    }

    public static boolean isExtender(VariabilityElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 2;
    }

    public static VariabilityElement getReplacer(VariabilityElement element, MethodConfiguration config) {
        VariabilityElement ve = null;
        Iterator it = AssociationHelper.getImmediateVarieties((VariabilityElement)element).iterator();
        while (it.hasNext()) {
            VariabilityElement e = (VariabilityElement)it.next();
            if (e == null || e.getVariabilityType() != VariabilityType.REPLACES_LITERAL || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            if (ve != null) {
                if (debug) {
                    System.out.println("ConfigurationHelper.getReplacer: Replacer ignored for element '" + LibraryUtil.getTypeName((MethodElement)element) + "' since it has more than one replacerin the configuration");
                }
                return null;
            }
            ve = e;
        }
        return ve;
    }

    public static List getContributors(VariabilityElement element, MethodConfiguration config) {
        ArrayList<VariabilityElement> items = new ArrayList<VariabilityElement>();
        Iterator it = AssociationHelper.getImmediateVarieties((VariabilityElement)element).iterator();
        while (it.hasNext()) {
            VariabilityElement e = (VariabilityElement)it.next();
            if (e == null || e.getVariabilityType() != VariabilityType.CONTRIBUTES_LITERAL || !ConfigurationHelper.inConfig((MethodElement)e, config)) continue;
            VariabilityElement replacer = ConfigurationHelper.getReplacer(e, config);
            if (replacer != null) {
                items.add(replacer);
                continue;
            }
            items.add(e);
        }
        return items;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean canShow(MethodElement element, MethodConfiguration config) {
        block6: {
            if (element == null) {
                return false;
            }
            if (!ConfigurationHelper.inConfig(element, config)) {
                return false;
            }
            if (element instanceof Activity) {
                return true;
            }
            supressed = element.getSuppressed();
            if (supressed != null && supressed.booleanValue()) {
                return false;
            }
            if (!(element instanceof VariabilityElement)) break block6;
            e = (VariabilityElement)element;
            if (ConfigurationHelper.isExtender(e)) {
                return true;
            }
            if (!ConfigurationHelper.isContributor(e) && ConfigurationHelper.getReplacer(e, config) == null) ** GOTO lbl18
            return false;
lbl-1000:
            // 1 sources

            {
                if (!ConfigurationHelper.isContributor(e = e.getVariabilityBasedOnElement())) continue;
                return false;
lbl18:
                // 2 sources

                ** while (e != null && ConfigurationHelper.isReplacer((VariabilityElement)e))
            }
        }
        return true;
    }

    public static String getName(MethodElement element, MethodConfiguration config) {
        if (element instanceof VariabilityElement) {
            VariabilityElement e = (VariabilityElement)element;
            if (ConfigurationHelper.isContributor(e)) {
                return ConfigurationHelper.getName((MethodElement)e.getVariabilityBasedOnElement(), config);
            }
            VariabilityElement rep = ConfigurationHelper.getReplacer(e, config);
            if (rep != null) {
                return ConfigurationHelper.getName((MethodElement)rep, config);
            }
        }
        return element.getName();
    }

    public static String getPresentationName(MethodElement element, MethodConfiguration config) {
        String name = (String)ConfigurationHelper.calcAttributeFeatureValue(element, (EStructuralFeature)UmaPackage.eINSTANCE.getDescribableElement_PresentationName(), config);
        if (name == null || name.length() == 0) {
            name = TngUtil.getPresentationName((Object)element);
        }
        return name;
    }

    public static VariabilityElement getVariableOwner(MethodElement e) {
        EObject eObj;
        if (e instanceof VariabilityElement) {
            return (VariabilityElement)e;
        }
        if (e instanceof ContentDescription && (eObj = e.eContainer()) instanceof VariabilityElement) {
            return (VariabilityElement)eObj;
        }
        return null;
    }

    public static boolean isMergableAttribute(EStructuralFeature feature) {
        if (!feature.getEType().getInstanceClassName().equals("java.lang.String")) {
            return false;
        }
        return feature != UmaPackage.eINSTANCE.getMethodElement_Guid() && feature != UmaPackage.eINSTANCE.getNamedElement_Name() && feature != UmaPackage.eINSTANCE.getWorkProductDescription_ExternalId();
    }

    public static boolean is01Feature(EStructuralFeature feature) {
        return feature.getEType() instanceof EClass && !feature.isMany();
    }

    public static boolean is0nFeature(EStructuralFeature feature) {
        return feature.getEType() instanceof EClass && feature.isMany();
    }

    private static void calculateFeature(MethodElement element, MethodElement OwnerElement, EStructuralFeature feature, MethodConfiguration config, List values, ElementRealizer realizer) {
        List items;
        boolean mergeable;
        VariabilityElement ve = ConfigurationHelper.getVariableOwner(OwnerElement == null ? element : OwnerElement);
        Object value = element.eGet(feature);
        if (ConfigurationHelper.is0nFeature(feature)) {
            if (value instanceof List) {
                Iterator it = ((List)value).iterator();
                while (it.hasNext()) {
                    MethodElement e = (MethodElement)it.next();
                    MethodElement ce = realizer.realize(e);
                    if (ce == null || values.contains(ce)) continue;
                    values.add(ce);
                }
            }
        } else if (value != null) {
            if (ConfigurationHelper.is01Feature(feature)) {
                if (ConfigurationHelper.isContributor(ve)) {
                    if (values.size() == 0) {
                        values.add(value);
                    }
                } else {
                    values.clear();
                    values.add(value);
                }
            } else if (!(value instanceof String) || value.toString().trim().length() > 0) {
                values.add(new AttributeValue(element, value.toString()));
            }
        }
        if (config == null) {
            return;
        }
        if (ve == null) {
            return;
        }
        if (ve instanceof ContentElement && feature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
            ConfigurationHelper.orderSections((ContentElement)ve, values);
        }
        boolean bl = mergeable = !(element instanceof Activity) && (!(OwnerElement instanceof Activity) || !(element instanceof ContentDescription)) && !(element.eContainer() instanceof Activity);
        if (mergeable) {
            boolean bl2 = mergeable = ConfigurationHelper.isMergableAttribute(feature) && feature != UmaPackage.eINSTANCE.getDescribableElement_PresentationName() || ConfigurationHelper.is0nFeature(feature);
        }
        if (mergeable && (items = ConfigurationHelper.getContributors(ve, config)) != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e;
                MethodElement o = e = (MethodElement)it.next();
                if (element instanceof ContentDescription) {
                    e = ((DescribableElement)e).getPresentation();
                }
                ConfigurationHelper.calculateFeature(e, o, feature, config, values, realizer);
            }
        }
        if (ConfigurationHelper.isExtender(ve)) {
            boolean mergebase = false;
            if (ConfigurationHelper.is0nFeature(feature)) {
                mergebase = true;
            } else if (ConfigurationHelper.is01Feature(feature)) {
                mergebase = values.size() == 0;
            } else {
                boolean bl3 = mergebase = ConfigurationHelper.isMergableAttribute(feature) && values.size() == 0;
            }
            if (mergebase) {
                MethodElement e;
                MethodElement o = e = ConfigurationHelper.getCalculatedElement((MethodElement)ve.getVariabilityBasedOnElement(), config);
                if (ve != e && ConfigurationHelper.inConfig(e, config)) {
                    if (element instanceof ContentDescription) {
                        try {
                            e = ((DescribableElement)e).getPresentation();
                        }
                        catch (Exception e1) {
                            e1.printStackTrace();
                        }
                    }
                    ConfigurationHelper.calculateFeature(e, o, feature, config, values, realizer);
                    if (ve instanceof ContentElement && feature == UmaPackage.eINSTANCE.getContentDescription_Sections()) {
                        ConfigurationHelper.orderSections((ContentElement)ve, values);
                    }
                }
            }
        }
    }

    public static void calculateOppositeFeature(MethodElement element, OppositeFeature feature, ElementRealizer realizer, List values) {
        if (!(element instanceof MultiResourceEObject)) {
            return;
        }
        MethodConfiguration config = realizer.getConfiguration();
        VariabilityElement ve = ConfigurationHelper.getVariableOwner(element);
        Object value = ((MultiResourceEObject)element).getOppositeFeatureValue(feature);
        if (feature.isMany()) {
            if (value instanceof List) {
                Iterator it = ((List)value).iterator();
                while (it.hasNext()) {
                    MethodElement ce;
                    boolean isValueReplaced;
                    MethodElement e = (MethodElement)it.next();
                    boolean bl = isValueReplaced = e instanceof VariabilityElement && ConfigurationHelper.getReplacer((VariabilityElement)e, config) != null;
                    if (isValueReplaced || (ce = ConfigurationHelper.getCalculatedElement(e, realizer)) == null || values.contains(ce)) continue;
                    values.add(ce);
                }
            }
        } else if (value != null) {
            if (value instanceof MethodElement) {
                boolean isValueReplaced;
                MethodElement e = (MethodElement)value;
                boolean bl = isValueReplaced = e instanceof VariabilityElement && ConfigurationHelper.getReplacer((VariabilityElement)e, config) != null;
                if (!(isValueReplaced || (e = ConfigurationHelper.getCalculatedElement(e, realizer)) == null || values.size() != 0 && ConfigurationHelper.isContributor(ve))) {
                    values.clear();
                    values.add(value);
                }
            } else if (!(value instanceof String) || value.toString().trim().length() > 0) {
                values.add(value);
            }
        }
        if (element instanceof VariabilityElement && config != null) {
            VariabilityElement ce = (VariabilityElement)element;
            List items = ConfigurationHelper.getContributors(ce, config);
            if (items != null && items.size() > 0) {
                Iterator it = items.iterator();
                while (it.hasNext()) {
                    MethodElement e = (MethodElement)it.next();
                    ConfigurationHelper.calculateOppositeFeature(e, feature, realizer, values);
                }
            }
            boolean mergebase = false;
            boolean isReplacer = ConfigurationHelper.isReplacer(ce);
            if (isReplacer) {
                boolean bl = mergebase = value instanceof List || values.size() == 0;
            }
            if (mergebase) {
                DefaultElementRealizer realizer2 = new DefaultElementRealizer(config, !isReplacer, !isReplacer);
                MethodElement e = ConfigurationHelper.getCalculatedElement((MethodElement)ce.getVariabilityBasedOnElement(), realizer2);
                if (e == null) {
                    e = ce.getVariabilityBasedOnElement();
                }
                if (e != ce && ConfigurationHelper.inConfig(e, config)) {
                    ConfigurationHelper.calculateOppositeFeature(e, feature, realizer, values);
                }
            }
        }
    }

    public static List getCalculatedElements(List elements, MethodConfiguration config) {
        ArrayList<MethodElement> values = new ArrayList<MethodElement>();
        Iterator it = elements.iterator();
        while (it.hasNext()) {
            MethodElement e = (MethodElement)it.next();
            if ((e = ConfigurationHelper.getCalculatedElement(e, config)) == null || values.contains(e)) continue;
            values.add(e);
        }
        return values;
    }

    public static MethodElement getCalculatedElement(MethodElement element, MethodConfiguration config) {
        DefaultElementRealizer realizer = new DefaultElementRealizer(config, true, true);
        return ConfigurationHelper.getCalculatedElement(element, realizer);
    }

    public static MethodElement getCalculatedElement(MethodElement element, ElementRealizer realizer) {
        MethodElement e2;
        MethodElement e = element;
        while ((e2 = realizer.realize(e)) != e) {
            e = e2;
        }
        return e;
    }

    public static MethodElement calc01FeatureValue(MethodElement element, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc01FeatureValue(element, null, feature, realizer);
    }

    public static MethodElement calc01FeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        Object v = element.eGet(feature);
        if (v instanceof ContentDescription) {
            return (MethodElement)v;
        }
        ArrayList values = new ArrayList();
        ConfigurationHelper.calculateFeature(element, ownerElement, feature, realizer.getConfiguration(), values, realizer);
        if (values.size() > 0 && (v = (MethodElement)values.get(0)) instanceof MethodElement) {
            return ConfigurationHelper.getCalculatedElement((MethodElement)v, realizer.getConfiguration());
        }
        return null;
    }

    public static boolean isContainmentFeature(EStructuralFeature feature) {
        return feature == UmaPackage.eINSTANCE.getArtifact_ContainedArtifacts() || feature == UmaPackage.eINSTANCE.getPractice_SubPractices();
    }

    public static boolean isContainmentElement(Object element) {
        return element instanceof Artifact || element instanceof Practice;
    }

    private static List getContainers(MethodElement element, MethodConfiguration config) {
        ArrayList<MethodElement> items = new ArrayList<MethodElement>();
        MethodElement o = element;
        while (o != null && (o = o.eContainer()) != null && o.getClass().isInstance(element)) {
            if (o instanceof VariabilityElement) {
                o = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)o), config);
            }
            if (o == null || items.contains(o)) continue;
            items.add(o);
        }
        return items;
    }

    public static OppositeFeature get01OppositeFeature(EStructuralFeature feature) {
        if (feature == UmaPackage.eINSTANCE.getDiscipline_Tasks()) {
            return AssociationHelper.Task_Discipline;
        }
        if (feature == UmaPackage.eINSTANCE.getRole_ResponsibleFor()) {
            return AssociationHelper.WorkProduct_ResponsibleRole;
        }
        return null;
    }

    public static List calc0nFeatureValue(MethodElement element, EStructuralFeature feature, ElementRealizer realizer) {
        return ConfigurationHelper.calc0nFeatureValue(element, null, feature, realizer);
    }

    public static List calc0nFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, ElementRealizer realizer) {
        OppositeFeature of;
        List values;
        MethodElement e;
        Iterator it;
        ArrayList v2;
        ArrayList v = new ArrayList();
        MethodConfiguration config = realizer.getConfiguration();
        if (element instanceof Role && feature == UmaPackage.eINSTANCE.getRole_Modifies()) {
            v2 = new ArrayList();
            ConfigurationHelper.calculateOppositeFeature(element, AssociationHelper.Role_Primary_Tasks, realizer, v2);
            if (v2.size() > 0) {
                it = v2.iterator();
                while (it.hasNext()) {
                    e = (MethodElement)it.next();
                    ConfigurationHelper.calculateFeature(e, ownerElement, (EStructuralFeature)UmaPackage.eINSTANCE.getTask_Output(), config, v, realizer);
                }
            }
        } else if (element instanceof RoleDescriptor && feature == UmaPackage.eINSTANCE.getRoleDescriptor_Modifies()) {
            v2 = new ArrayList();
            ConfigurationHelper.calculateFeature(element, null, (EStructuralFeature)UmaPackage.eINSTANCE.getRoleDescriptor_PerformsAsOwner(), config, v2, realizer);
            if (v2.size() > 0) {
                it = v2.iterator();
                while (it.hasNext()) {
                    e = (MethodElement)it.next();
                    ConfigurationHelper.calculateFeature(e, ownerElement, (EStructuralFeature)UmaPackage.eINSTANCE.getTaskDescriptor_Output(), config, v, realizer);
                }
            }
        } else {
            ConfigurationHelper.calculateFeature(element, ownerElement, feature, config, v, realizer);
        }
        if ((values = ConfigurationHelper.getCalculatedElements(v, config)).contains(element)) {
            values.remove(element);
        }
        if ((of = ConfigurationHelper.get01OppositeFeature(feature)) != null) {
            int i = 0;
            while (i < values.size()) {
                MethodElement o = (MethodElement)values.get(i);
                MethodElement oo = ConfigurationHelper.calc01FeatureValue(o, of, realizer);
                if (oo != element) {
                    values.remove(i);
                    continue;
                }
                ++i;
            }
        }
        if (ConfigurationHelper.isContainmentFeature(feature)) {
            List containers = ConfigurationHelper.getContainers(element, config);
            int i = 0;
            while (i < values.size()) {
                Object o = values.get(i);
                if (o == element || containers.contains(o)) {
                    values.remove(i);
                    continue;
                }
                ++i;
            }
        }
        return realizer.realize(element, feature, values);
    }

    public static boolean isContainerInList(MethodElement element, List items, MethodConfiguration config) {
        MethodElement o = element;
        while (o != null && (o = o.eContainer()) != null && o.getClass().isInstance(element)) {
            if (items.contains(o)) {
                return true;
            }
            if (o instanceof VariabilityElement) {
                o = ConfigurationHelper.getCalculatedElement((MethodElement)((VariabilityElement)o), config);
            }
            if (o == null || !items.contains(o)) continue;
            return true;
        }
        return false;
    }

    public static Object calcAttributeFeatureValue(MethodElement element, EStructuralFeature feature, MethodConfiguration config) {
        return ConfigurationHelper.calcAttributeFeatureValue(element, null, feature, config);
    }

    public static Object calcAttributeFeatureValue(MethodElement element, MethodElement ownerElement, EStructuralFeature feature, MethodConfiguration config) {
        if (ConfigurationHelper.isMergableAttribute(feature)) {
            ArrayList values = new ArrayList();
            ConfigurationHelper.calculateFeature(element, ownerElement, feature, config, values, new DefaultElementRealizer(config));
            StringBuffer buffer = new StringBuffer();
            Iterator it = values.iterator();
            while (it.hasNext()) {
                AttributeValue av = (AttributeValue)it.next();
                if (av.text == null || av.text.length() == 0) continue;
                if (feature == UmaPackage.eINSTANCE.getDescribableElement_PresentationName()) {
                    if (values.size() > 1 && debug) {
                        System.out.println("ConfigurationHelper.calcAttributeFeatureValue: Presentation Name get more then one entry: " + LibraryUtil.getTypeName(element));
                    }
                    return av.text;
                }
                if (buffer.length() > 0) {
                    buffer.append(ATTRIBUTE_VALUE_SEPERATOR);
                }
                if (av.element == element) {
                    buffer.append(av.text);
                    continue;
                }
                String contentPath = ResourceHelper.getElementPath(av.element instanceof ContentDescription ? (MethodElement)av.element.eContainer() : av.element);
                String backPath = ResourceHelper.getBackPath(element instanceof ContentDescription ? (ownerElement != null ? ownerElement : (MethodElement)element.eContainer()) : element);
                buffer.append(ResourceHelper.fixContentUrlPath(av.text, contentPath, backPath));
            }
            return buffer.toString();
        }
        return element.eGet(feature);
    }

    public static List calc0nFeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        ArrayList values = new ArrayList();
        ConfigurationHelper.calculateOppositeFeature(element, feature, realizer, values);
        return values;
    }

    public static MethodElement calc01FeatureValue(MethodElement element, OppositeFeature feature, ElementRealizer realizer) {
        ArrayList values = new ArrayList();
        ConfigurationHelper.calculateOppositeFeature(element, feature, realizer, values);
        if (values.size() > 0) {
            return ConfigurationHelper.getCalculatedElement((MethodElement)values.get(0), realizer);
        }
        return null;
    }

    public static void orderSections(ContentElement element, List values) {
        String orderingGuide = element.getOrderingGuide();
        if (orderingGuide == null || orderingGuide.trim().length() == 0) {
            return;
        }
        SectionList slist = new SectionList(element, 2);
        if (ConfigurationHelper.isSameList(values, (List)slist)) {
            values.clear();
            values.addAll(slist);
            return;
        }
        OrderedListComparator comp = new OrderedListComparator(new ArrayList(values), (List)slist);
        TreeSet s = new TreeSet(comp);
        s.addAll(values);
        values.clear();
        values.addAll(s);
    }

    private static boolean isSameList(List l1, List l2) {
        if (l1.size() != l2.size()) {
            return false;
        }
        Iterator it = l1.iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (l2.contains(o)) continue;
            return false;
        }
        return true;
    }

    private static void calculateCopyright(MethodElement element, MethodConfiguration config, List values) {
        MethodElement e;
        VariabilityElement ve;
        SupportingMaterial copyright = (SupportingMaterial)ConfigurationHelper.getCalculatedElement((MethodElement)LibraryUtil.getCopyright(element), config);
        if (copyright != null && !values.contains(copyright)) {
            values.add(copyright);
        }
        if ((ve = ConfigurationHelper.getVariableOwner(element)) == null) {
            return;
        }
        if (config == null) {
            return;
        }
        List items = ConfigurationHelper.getContributors(ve, config);
        if (items != null && items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                MethodElement e2 = (MethodElement)it.next();
                ConfigurationHelper.calculateCopyright(e2, config, values);
            }
        }
        if (ConfigurationHelper.isExtender(ve) && ve != (e = ConfigurationHelper.getCalculatedElement((MethodElement)ve.getVariabilityBasedOnElement(), config)) && ConfigurationHelper.inConfig(e, config)) {
            ArrayList baseItems = new ArrayList();
            ConfigurationHelper.calculateCopyright(e, config, baseItems);
            if (baseItems.size() > 0) {
                int i = 0;
                while (i < values.size()) {
                    if (baseItems.contains(values.get(i))) {
                        values.remove(i);
                        continue;
                    }
                    ++i;
                }
                values.addAll(0, baseItems);
            }
        }
    }

    public static String getCopyrightText(MethodElement element, MethodConfiguration config) {
        StringBuffer copyrights = new StringBuffer();
        ArrayList items = new ArrayList();
        ConfigurationHelper.calculateCopyright(element, config, items);
        if (items.size() > 0) {
            Iterator it = items.iterator();
            while (it.hasNext()) {
                SupportingMaterial copyright = (SupportingMaterial)it.next();
                String statement = (String)ConfigurationHelper.calcAttributeFeatureValue((MethodElement)copyright.getPresentation(), (MethodElement)copyright, (EStructuralFeature)UmaPackage.eINSTANCE.getContentDescription_MainDescription(), config);
                if (statement == null || statement.length() <= 0) continue;
                String contentPath = ResourceHelper.getElementPath((MethodElement)copyright);
                String backPath = ResourceHelper.getBackPath(element);
                statement = ResourceHelper.fixContentUrlPath(statement, contentPath, backPath);
                if (copyrights.length() > 0) {
                    copyrights.append(ATTRIBUTE_VALUE_SEPERATOR);
                }
                copyrights.append(statement);
            }
        }
        return copyrights.toString();
    }

    public static String getActivityStringAttribute(MethodElement e, EAttribute attrib) {
        ArrayList<Object> values;
        block23: {
            Object str;
            boolean concat;
            boolean isDesc;
            VariabilityElement ve;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.lang.String");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if (!clazz.isAssignableFrom(attrib.getEAttributeType().getInstanceClass())) {
                throw new IllegalArgumentException("The specified attribute is not of type String: " + attrib);
            }
            if (e instanceof ContentDescription) {
                ve = (VariabilityElement)e.eContainer();
                isDesc = true;
            } else {
                ve = (VariabilityElement)e;
                isDesc = false;
            }
            if (attrib == UmaPackage.eINSTANCE.getMethodElement_Guid() || attrib == UmaPackage.eINSTANCE.getNamedElement_Name()) {
                return (String)e.eGet((EStructuralFeature)attrib);
            }
            values = new ArrayList<Object>();
            boolean bl = concat = attrib != UmaPackage.eINSTANCE.getDescribableElement_PresentationName();
            while (true) {
                VariabilityElement base;
                if ((base = ve.getVariabilityBasedOnElement()) == null) {
                    str = isDesc ? ((DescribableElement)ve).getPresentation().eGet((EStructuralFeature)attrib) : ve.eGet((EStructuralFeature)attrib);
                    if (str == null || str.toString().length() == 0) {
                        if (values.isEmpty()) {
                            values.add(str);
                        }
                    } else {
                        values.add(0, str);
                    }
                    break block23;
                }
                str = isDesc ? ((DescribableElement)ve).getPresentation().eGet((EStructuralFeature)attrib) : ve.eGet((EStructuralFeature)attrib);
                VariabilityType variabilityType = ve.getVariabilityType();
                if (variabilityType == VariabilityType.EXTENDS_LITERAL) {
                    if (str == null || str.toString().length() == 0) {
                        ve = base;
                        continue;
                    }
                    values.add(0, str);
                    break block23;
                }
                if (variabilityType == VariabilityType.CONTRIBUTES_LITERAL) {
                    if (str != null && str.toString().length() > 0) {
                        values.add(0, str);
                        if (!concat) break block23;
                    }
                    ve = base;
                    continue;
                }
                if (variabilityType == VariabilityType.REPLACES_LITERAL) break;
            }
            values.add(0, str);
        }
        if (values.size() == 0) {
            return "";
        }
        if (values.size() == 1) {
            return (String)values.get(0);
        }
        StringBuffer buffer = new StringBuffer();
        Iterator it = values.iterator();
        while (it.hasNext()) {
            if (buffer.length() > 0) {
                buffer.append(ATTRIBUTE_VALUE_SEPERATOR);
            }
            buffer.append(it.next());
        }
        return buffer.toString();
    }

    public static List getAllProcesses(MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List plugins = config.getMethodPluginSelection();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            List items = TngUtil.getAllProcesses((MethodPlugin)((MethodPlugin)it.next()));
            Iterator itp = items.iterator();
            while (itp.hasNext()) {
                Process p = (Process)itp.next();
                if (!ConfigurationHelper.inConfig((MethodElement)p, config) || processes.contains(p)) continue;
                processes.add(p);
            }
        }
        return processes;
    }

    public static List getAllProcesses(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator itp = items.iterator();
        while (itp.hasNext()) {
            Process p = (Process)itp.next();
            if (!ConfigurationHelper.inConfig((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List getAllDeliveryProcesses(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator itp = items.iterator();
        while (itp.hasNext()) {
            Process p = (Process)itp.next();
            if (!(p instanceof DeliveryProcess) || !ConfigurationHelper.inConfig((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }

    public static List getAllCapabilityPatterns(MethodPlugin plugin, MethodConfiguration config) {
        ArrayList<Process> processes = new ArrayList<Process>();
        List items = TngUtil.getAllProcesses((MethodPlugin)plugin);
        Iterator itp = items.iterator();
        while (itp.hasNext()) {
            Process p = (Process)itp.next();
            if (!(p instanceof CapabilityPattern) || !ConfigurationHelper.inConfig((MethodElement)p, config) || processes.contains(p)) continue;
            processes.add(p);
        }
        return processes;
    }
}

