/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.core.util;

import com.ibm.icu.text.SimpleDateFormat;
import com.ibm.icu.util.TimeZone;
import java.text.ParseException;
import java.util.Date;
import java.util.Locale;

public class CVSDateFormatter {
    private static final String ENTRYLINE_FORMAT = "E MMM dd HH:mm:ss yyyy";
    private static final String SERVER_FORMAT = "dd MMM yyyy HH:mm:ss";
    private static final int ENTRYLINE_TENS_DAY_OFFSET = 8;
    private static final SimpleDateFormat serverFormat = new SimpleDateFormat("dd MMM yyyy HH:mm:ss", Locale.US);
    private static SimpleDateFormat entryLineFormat = new SimpleDateFormat("E MMM dd HH:mm:ss yyyy", Locale.US);

    static {
        entryLineFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
    }

    public static synchronized Date serverStampToDate(String text) throws ParseException {
        serverFormat.setTimeZone(CVSDateFormatter.getTimeZone(text));
        Date date = serverFormat.parse(text);
        return date;
    }

    public static synchronized Date entryLineToDate(String text) throws ParseException {
        try {
            if (text.charAt(8) == ' ') {
                StringBuffer buf = new StringBuffer(text);
                buf.setCharAt(8, '0');
                text = buf.toString();
            }
        }
        catch (StringIndexOutOfBoundsException e) {
            throw new ParseException(e.getMessage(), 8);
        }
        return entryLineFormat.parse(text);
    }

    public static synchronized String dateToEntryLine(Date date) {
        if (date == null) {
            return "";
        }
        String passOne = entryLineFormat.format(date);
        if (passOne.charAt(8) != '0') {
            return passOne;
        }
        StringBuffer passTwo = new StringBuffer(passOne);
        passTwo.setCharAt(8, ' ');
        return passTwo.toString();
    }

    public static synchronized String dateToNotifyServer(Date date) {
        serverFormat.setTimeZone(TimeZone.getTimeZone((String)"GMT"));
        return String.valueOf(serverFormat.format(date)) + " GMT";
    }

    private static TimeZone getTimeZone(String dateFromServer) {
        if (dateFromServer.lastIndexOf("0000") != -1) {
            return TimeZone.getTimeZone((String)"GMT");
        }
        String tz = null;
        StringBuffer resultTz = new StringBuffer("GMT");
        if (dateFromServer.indexOf("-") != -1) {
            resultTz.append("-");
            tz = dateFromServer.substring(dateFromServer.indexOf("-"));
        } else if (dateFromServer.indexOf("+") != -1) {
            resultTz.append('+');
            tz = dateFromServer.substring(dateFromServer.indexOf("+"));
        }
        try {
            if (tz != null) {
                resultTz.append(String.valueOf(tz.substring(1, 3)) + ":" + tz.substring(3, 5));
                return TimeZone.getTimeZone((String)resultTz.toString());
            }
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            return TimeZone.getTimeZone((String)"GMT");
        }
        return TimeZone.getTimeZone((String)"GMT");
    }
}

