/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal.search;

import java.io.IOException;
import java.io.Reader;
import java.net.URL;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.help.internal.search.HTMLDocParser;
import org.eclipse.help.internal.search.ParsedDocument;
import org.eclipse.help.search.ISearchIndex;
import org.eclipse.help.search.LuceneSearchParticipant;

public class HTMLSearchParticipant
extends LuceneSearchParticipant {
    private HTMLDocParser parser = new HTMLDocParser();
    private String indexPath;

    public HTMLSearchParticipant(String indexPath) {
        this.indexPath = indexPath;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IStatus addDocument(ISearchIndex index, String pluginId, String name, URL url, String id, Document doc) {
        try {
            try {
                try {
                    this.parser.openDocument(url);
                }
                catch (IOException iOException) {
                    Status status = new Status(4, "org.eclipse.help.base", 4, "Help document " + name + " cannot be opened.", null);
                    Object var9_8 = null;
                    this.parser.closeDocument();
                    return status;
                }
                ParsedDocument parsed = new ParsedDocument(this.parser.getContentReader());
                doc.add(Field.Text((String)"contents", (Reader)parsed.newContentReader()));
                doc.add(Field.Text((String)"exact_contents", (Reader)parsed.newContentReader()));
                String title = this.parser.getTitle();
                doc.add(Field.UnStored((String)"title", (String)title));
                doc.add(Field.UnStored((String)"exact_title", (String)title));
                doc.add(Field.UnIndexed((String)"raw_title", (String)title));
                doc.add(Field.UnIndexed((String)"summary", (String)this.parser.getSummary(title)));
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.parser.closeDocument();
                throw throwable;
            }
            {
                Object var9_10 = null;
                this.parser.closeDocument();
                return Status.OK_STATUS;
            }
        }
        catch (IOException e) {
            return new Status(4, "org.eclipse.help.base", 4, "IO exception occurred while adding document " + name + " to index " + this.indexPath + ".", (Throwable)e);
        }
    }
}

