/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.search2.internal.ui;

import com.ibm.icu.text.MessageFormat;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.search.internal.ui.SearchPluginImages;
import org.eclipse.search.ui.ISearchQuery;
import org.eclipse.search.ui.ISearchResult;
import org.eclipse.search2.internal.ui.InternalSearchUI;
import org.eclipse.search2.internal.ui.RemoveAllSearchesAction;
import org.eclipse.search2.internal.ui.SearchMessages;
import org.eclipse.search2.internal.ui.SearchView;
import org.eclipse.search2.internal.ui.ShowSearchHistoryDialogAction;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.MenuItem;

class SearchHistoryDropDownAction
extends Action
implements IMenuCreator {
    public static final int RESULTS_IN_DROP_DOWN = 10;
    private Menu fMenu;
    private SearchView fSearchView;

    public SearchHistoryDropDownAction(SearchView searchView) {
        this.setText(SearchMessages.SearchDropDownAction_label);
        this.setToolTipText(SearchMessages.SearchDropDownAction_tooltip);
        SearchPluginImages.setImageDescriptors((IAction)this, "lcl16/", "org.eclipse.search.ui.search_history.gif");
        this.fSearchView = searchView;
        this.setMenuCreator(this);
    }

    public void updateEnablement() {
        boolean hasQueries = InternalSearchUI.getInstance().getSearchManager().hasQueries();
        this.setEnabled(hasQueries);
    }

    public void dispose() {
        this.disposeMenu();
    }

    void disposeMenu() {
        if (this.fMenu != null) {
            this.fMenu.dispose();
        }
    }

    public Menu getMenu(Menu parent) {
        return null;
    }

    public Menu getMenu(Control parent) {
        ISearchResult currentSearch = this.fSearchView.getCurrentSearchResult();
        this.disposeMenu();
        this.fMenu = new Menu(parent);
        ISearchQuery[] searches = InternalSearchUI.getInstance().getSearchManager().getQueries();
        if (searches.length > 0) {
            int i = 0;
            while (i < searches.length) {
                ISearchResult search = searches[i].getSearchResult();
                ShowSearchFromHistoryAction action = new ShowSearchFromHistoryAction(search);
                action.setChecked(search.equals(currentSearch));
                this.addActionToMenu(this.fMenu, action);
                ++i;
            }
            new MenuItem(this.fMenu, 2);
            this.addActionToMenu(this.fMenu, new ShowSearchHistoryDialogAction(this.fSearchView));
            this.addActionToMenu(this.fMenu, new RemoveAllSearchesAction());
        }
        return this.fMenu;
    }

    protected void addActionToMenu(Menu parent, Action action) {
        ActionContributionItem item = new ActionContributionItem((IAction)action);
        item.fill(parent, -1);
    }

    public void run() {
        new ShowSearchHistoryDialogAction(this.fSearchView).run();
    }

    private class ShowSearchFromHistoryAction
    extends Action {
        private ISearchResult fSearch;

        public ShowSearchFromHistoryAction(ISearchResult search) {
            this.fSearch = search;
            String label = this.escapeAmp(search.getLabel());
            if (InternalSearchUI.getInstance().isQueryRunning(search.getQuery())) {
                label = MessageFormat.format((String)SearchMessages.SearchDropDownAction_running_message, (Object[])new String[]{label});
            }
            if (label.indexOf(64) >= 0) {
                label = String.valueOf(label) + '@';
            }
            this.setText(label);
            this.setImageDescriptor(search.getImageDescriptor());
            this.setToolTipText(search.getTooltip());
        }

        private String escapeAmp(String label) {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < label.length()) {
                char ch = label.charAt(i);
                buf.append(ch);
                if (ch == '&') {
                    buf.append('&');
                }
                ++i;
            }
            return buf.toString();
        }

        public void runWithEvent(Event event) {
            InternalSearchUI.getInstance().showSearchResult(SearchHistoryDropDownAction.this.fSearchView, this.fSearch, event.stateMask == 262144);
        }

        public void run() {
            InternalSearchUI.getInstance().showSearchResult(SearchHistoryDropDownAction.this.fSearchView, this.fSearch, false);
        }
    }
}

