/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.migration;

import com.ibm.uma.Activity;
import com.ibm.uma.ContentDescription;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.DescribableElement;
import com.ibm.uma.ProcessElement;
import com.ibm.uma.ProcessPackage;
import com.ibm.uma.UmaFactory;
import com.ibm.uma.UmaPackage;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkOrder;
import com.ibm.uma.WorkOrderType;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xmi.XMLResource;
import org.eclipse.emf.ecore.xmi.impl.BasicResourceHandler;
import org.eclipse.emf.ecore.xml.type.AnyType;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;

public class UMA2UMAResourceHandler
extends BasicResourceHandler {
    private static final boolean DEBUG = true;
    private List moveInfos = new ArrayList();
    private Set procMovedFeatureNames;
    private Map guidToPresentationMap = new HashMap();
    private Set classNamesToSavePresentationURI;

    public UMA2UMAResourceHandler() {
        this.procMovedFeatureNames = new HashSet<String>(Arrays.asList("purpose", "keyConsiderations", "alternatives", "howtoStaff", "usageGuidance", "externalId", "scope", "usageNotes", "scale", "projectCharacteristics", "riskLevel", "estimatingTechnique", "projectMemberExpertise", "typeOfContract", "techniques", "mainDescription"));
    }

    public void postLoad(XMLResource resource, InputStream inputStream, Map options) {
        if (!resource.getEObjectToExtensionMap().isEmpty()) {
            System.out.println("UMA2UMAResourceHandler.postLoad(): " + resource.getURI());
            System.out.println("---- Start unknown features ----");
            Iterator iter = resource.getEObjectToExtensionMap().entrySet().iterator();
            while (iter.hasNext()) {
                Map.Entry entry = iter.next();
                if (!(entry.getKey() instanceof EObject)) continue;
                this.handleMovedData((EObject)entry.getKey(), entry.getValue());
            }
            System.out.println("---- End unknown features ----");
        }
    }

    private static String getText(AnyType value) {
        block3: {
            if (value != null) break block3;
            return null;
        }
        FeatureMap.Entry entry = (FeatureMap.Entry)value.getMixed().get(0);
        return (String)entry.getValue();
    }

    private static EAttribute getEAttribute(EClass eClass, String name) {
        Iterator iterator = eClass.getEAllAttributes().iterator();
        while (iterator.hasNext()) {
            EAttribute attrib = (EAttribute)iterator.next();
            if (!attrib.getName().equals(name)) continue;
            return attrib;
        }
        return null;
    }

    protected EStructuralFeature getNewFeature(EObject owner, String featureName) {
        ContentDescription content;
        EAttribute attrib;
        if ("presentationName".equals(featureName) && owner instanceof ContentDescription) {
            return UmaPackage.eINSTANCE.getDescribableElement_PresentationName();
        }
        if (this.procMovedFeatureNames.contains(featureName) && owner instanceof ProcessElement && (attrib = UMA2UMAResourceHandler.getEAttribute((content = ((ProcessElement)owner).getPresentation()).eClass(), featureName)) != null) {
            return attrib;
        }
        if ("WorkOrder".equals(featureName) && owner instanceof ProcessPackage) {
            return UmaPackage.eINSTANCE.getProcessPackage_ProcessElements();
        }
        return null;
    }

    protected EObject getNewOwner(EObject oldOwner, String featureName) {
        if ("presentationName".equals(featureName) && oldOwner instanceof ContentDescription) {
            DescribableElement de = (DescribableElement)oldOwner.eContainer();
            if (de instanceof Activity) {
                return null;
            }
            return de;
        }
        if (this.procMovedFeatureNames.contains(featureName) && oldOwner instanceof ProcessElement) {
            return ((ProcessElement)oldOwner).getPresentation();
        }
        if ("WorkOrder".equals(featureName) && oldOwner instanceof ProcessPackage) {
            return oldOwner;
        }
        return null;
    }

    protected Object getNewValue(EObject oldOwner, String featureName, AnyType value) {
        if ("WorkOrder".equals(featureName) && oldOwner instanceof ProcessPackage) {
            WorkOrder workOrder = UmaFactory.eINSTANCE.createWorkOrder();
            workOrder.setGuid((String)UMA2UMAResourceHandler.getSingleValue(value.getAnyAttribute(), "guid"));
            String predGuid = (String)UMA2UMAResourceHandler.getSingleValue(value.getAnyAttribute(), "pred");
            if (predGuid == null) {
                InternalEObject obj = (InternalEObject)UMA2UMAResourceHandler.getSingleValue(value.getMixed(), "pred");
                predGuid = obj.eProxyURI().authority();
            }
            MultiFileResourceSetImpl resourceSet = (MultiFileResourceSetImpl)oldOwner.eResource().getResourceSet();
            WorkBreakdownElement pred = (WorkBreakdownElement)resourceSet.getEObject(predGuid);
            workOrder.setPred(pred);
            workOrder.setLinkType(WorkOrderType.FINISH_TO_FINISH_LITERAL);
            return workOrder;
        }
        return UMA2UMAResourceHandler.getText(value);
    }

    public void moveData() {
        Iterator iter = this.moveInfos.iterator();
        while (iter.hasNext()) {
            MoveInfo info = (MoveInfo)iter.next();
            EObject newOwner = this.getNewOwner(info.oldOwner, info.oldFeatureName);
            if (newOwner == null) continue;
            UMA2UMAResourceHandler.setValue(newOwner, info.newFeature, info.value);
        }
    }

    public static void setValue(EObject eObject, EStructuralFeature feature, Object value) {
        if (!feature.isMany()) {
            eObject.eSet(feature, value);
        } else {
            Collection values = (Collection)eObject.eGet(feature);
            if (value instanceof Collection) {
                values.addAll((Collection)value);
            } else {
                values.add(value);
            }
        }
    }

    private void handleMovedData(EObject owner, FeatureMap featureMap) {
        Iterator iter = featureMap.iterator();
        while (iter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
            EStructuralFeature f = entry.getEStructuralFeature();
            EStructuralFeature newFeature = this.getNewFeature(owner, f.getName());
            if (newFeature == null) continue;
            MoveInfo moveInfo = new MoveInfo();
            moveInfo.oldOwner = owner;
            moveInfo.oldFeatureName = f.getName();
            moveInfo.newFeature = newFeature;
            moveInfo.value = entry.getValue() instanceof AnyType ? this.getNewValue(owner, f.getName(), (AnyType)entry.getValue()) : entry.getValue();
            this.moveInfos.add(moveInfo);
            System.out.println(moveInfo);
            System.out.println();
            iter.remove();
        }
    }

    protected void handleMovedData(EObject e, Object movedData) {
        AnyType anyType = (AnyType)movedData;
        this.handleMovedData(e, anyType.getMixed());
        this.handleMovedData(e, anyType.getAnyAttribute());
        if (this.classNamesToSavePresentationURI != null && e instanceof ContentPackage) {
            Iterator iter = UMA2UMAResourceHandler.getValue(anyType.getMixed(), "contentElements").iterator();
            while (iter.hasNext()) {
                Object presentation;
                AnyType value = (AnyType)iter.next();
                if (value == null || !this.classNamesToSavePresentationURI.contains(value.eClass().getName()) || (presentation = UMA2UMAResourceHandler.getSingleValue(value.getMixed(), "presentation")) == null) continue;
                Object guid = UMA2UMAResourceHandler.getSingleValue(value.getAnyAttribute(), "guid");
                URI uri = ((InternalEObject)presentation).eProxyURI();
                this.guidToPresentationMap.put(guid, uri);
            }
        }
    }

    public void savePresentationURIFor(Set classNames) {
        this.classNamesToSavePresentationURI = classNames;
    }

    public URI getPresentationURI(String guid) {
        return (URI)this.guidToPresentationMap.get(guid);
    }

    public static Object getSingleValue(FeatureMap featureMap, String featureName) {
        Iterator iter = featureMap.iterator();
        while (iter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
            if (!entry.getEStructuralFeature().getName().equals(featureName)) continue;
            return entry.getValue();
        }
        return null;
    }

    private static Collection getValue(FeatureMap featureMap, String featureName) {
        ArrayList<Object> list = new ArrayList<Object>();
        Iterator iter = featureMap.iterator();
        while (iter.hasNext()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)iter.next();
            if (!entry.getEStructuralFeature().getName().equals(featureName)) continue;
            list.add(entry.getValue());
        }
        return list;
    }

    public void clearMoveInfos() {
        this.moveInfos.clear();
    }

    private static class MoveInfo {
        EObject oldOwner;
        String oldFeatureName;
        EStructuralFeature newFeature;
        Object value;

        private MoveInfo() {
        }

        public String toString() {
            return this.getClass().getName() + "(\n" + "  oldFeatureName: " + this.oldFeatureName + '\n' + "  newFeature: " + this.newFeature + '\n' + "  value: " + this.value + '\n' + ")";
        }
    }
}

