/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.services;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodPlugin;
import java.io.File;
import java.io.FileFilter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.tools.ant.Project;
import org.apache.tools.ant.taskdefs.Copy;
import org.apache.tools.ant.types.FileSet;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.epf.common.plugin.AbstractPlugin;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.export.services.LibraryDocument;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.DirCopy;
import org.eclipse.epf.importing.services.FileModifyChecker;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.services.SafeUpdateController;
import org.eclipse.epf.library.util.ResourceHelper;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class PluginImportingService {
    private PluginImportData data;
    LibraryDocument importingLibDoc;
    IStatus fileCheckedOutStatus = null;

    public PluginImportingService(PluginImportData data) {
        this.data = data;
    }

    public void validate(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.getString("Import.PluginImportingService.MSG0"));
            }
            if (this.data == null) {
                return;
            }
            this.data.clear();
            File importingLibPath = new File(String.valueOf(this.data.llData.getParentFolder()) + File.separator + "export.xmi");
            if (!importingLibPath.exists()) {
                this.data.getErrorInfo().addError(ImportResources.getString("Import.PluginImportingService.MSG1", importingLibPath.toString()));
                return;
            }
            this.importingLibDoc = new LibraryDocument(importingLibPath);
            this.scanLibraryFile(this.importingLibDoc);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    /*
     * Exception decompiling
     */
    public void performImport(IProgressMonitor monitor) throws Exception {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 48->52)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void __doImport(IProgressMonitor monitor) {
        try {
            if (monitor != null) {
                monitor.setTaskName(ImportResources.getString("Import.PluginImportingService.MSG3"));
            }
            List unlockedPlugins = this.unlockPlugins();
            File libFile = new File(LibraryProcessor.getInstance().getLibraryURI().toFileString());
            LibraryDocument targetLibDoc = new LibraryDocument(libFile);
            if (this.importEntries(targetLibDoc)) {
                targetLibDoc.save();
                this.fixLibraryGuid(libFile.getParentFile(), this.importingLibDoc.getLibraryGuid(), targetLibDoc.getLibraryGuid());
                LibraryProcessor.getInstance().openLibrary(libFile.getAbsolutePath());
                if (unlockedPlugins.size() > 0) {
                    this.lockUnlockedPlugins(unlockedPlugins);
                    LibraryProcessor.getInstance().saveLibrary();
                }
            }
            LibraryProcessor.getInstance().openLibrary();
            LibraryProcessor.getInstance().refreshResources(monitor);
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private List unlockPlugins() {
        ArrayList<String> pluginIds = new ArrayList<String>();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (info.existingPlugin == null || !info.selected || info.existingPlugin.getUserChangeable().booleanValue()) continue;
            info.existingPlugin.setUserChangeable(new Boolean(true));
            pluginIds.add(info.existingPlugin.getGuid());
        }
        return pluginIds;
    }

    private void lockUnlockedPlugins(List unlockedPlugins) {
        List plugins = LibraryProcessor.getInstance().getLibrary().getMethodPlugins();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (!unlockedPlugins.contains(plugin.getGuid())) continue;
            plugin.setUserChangeable(new Boolean(false));
        }
    }

    private boolean importEntries(LibraryDocument targetLibDoc) {
        ArrayList<String> importList = new ArrayList<String>();
        ArrayList<String> newList = new ArrayList<String>();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (!info.selected) continue;
            if (info.existingPlugin == null) {
                newList.add(info.guid);
            }
            importList.add(info.guid);
        }
        Iterator it2 = this.data.getConfigs().iterator();
        while (it2.hasNext()) {
            PluginImportData.ConfiguarationInfo cinfo = (PluginImportData.ConfiguarationInfo)it2.next();
            if (!cinfo.selected) continue;
            if (cinfo.existingConfig == null) {
                newList.add(cinfo.guid);
            }
            importList.add(cinfo.guid);
        }
        this.importLibEntries(targetLibDoc, newList);
        return this.copyFiles(targetLibDoc, importList, newList);
    }

    private void importLibEntries(LibraryDocument targetLibDoc, List newList) {
        String guid;
        Element node;
        if (newList == null || newList.size() == 0) {
            return;
        }
        NodeList nodes = this.importingLibDoc.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getGuid((Element)node);
            if (newList.contains(guid)) {
                targetLibDoc.addPlugin(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getConfigurations();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getGuid((Element)node);
            if (newList.contains(guid)) {
                targetLibDoc.addConfiguration(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getResourceDescriptors();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = node.getAttribute("id");
            node.getAttribute("uri");
            if (newList.contains(guid)) {
                targetLibDoc.addResource(node);
            }
            ++i;
        }
        nodes = this.importingLibDoc.getResourceSubManagers();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            guid = LibraryDocument.getSubManagerBaseGuid((String)node.getAttribute("href"));
            if (newList.contains(guid)) {
                targetLibDoc.addResource(node);
            }
            ++i;
        }
    }

    private boolean copyFiles(LibraryDocument targetLibDoc, List importList, List newList) {
        Iterator it = importList.iterator();
        while (it.hasNext()) {
            String guid = (String)it.next();
            String src_uri = this.importingLibDoc.getResourceUri(guid);
            if (src_uri == null || src_uri.length() == 0) continue;
            String target_uri = newList.contains(guid) ? src_uri : targetLibDoc.getResourceUri(guid);
            final File src_file = this.importingLibDoc.getFileFromUri(src_uri);
            if (!src_file.exists()) continue;
            final File target_file = targetLibDoc.getFileFromUri(target_uri);
            if (this.data.getPluginInfo(guid) != null) {
                if (target_file.exists()) {
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            DirCopy copy = new DirCopy(src_file.getParentFile(), target_file.getParentFile());
                            PluginImportingService.this.fileCheckedOutStatus = copy.execute();
                        }
                    });
                } else {
                    PluginImportingService.copyDir(src_file.getParentFile(), target_file.getParentFile());
                }
            } else if (this.data.getConfigInfo(guid) != null) {
                final ArrayList<String> files = new ArrayList<String>();
                if (target_file.exists()) {
                    files.add(target_file.getAbsolutePath());
                    SafeUpdateController.syncExec((Runnable)new Runnable(){

                        public void run() {
                            PluginImportingService.this.fileCheckedOutStatus = FileModifyChecker.checkModify(files);
                        }
                    });
                }
                if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) {
                    ResourceHelper.copyFile((File)src_file, (File)target_file);
                }
            }
            if (this.fileCheckedOutStatus == null || this.fileCheckedOutStatus.isOK()) continue;
            SafeUpdateController.syncExec((Runnable)new Runnable(){

                public void run() {
                    String title = ImportResources.getString("Import.importPluginsWizard.title");
                    String msg = ImportResources.getString("Import.importPluginsWizard.ERR_Import_plugin");
                    new MsgDialog((AbstractPlugin)ImportPlugin.getDefault()).displayError(title, msg, PluginImportingService.this.fileCheckedOutStatus);
                }
            });
            return false;
        }
        return true;
    }

    public static void copyDir(File fromDir, File toDir) {
        Copy cp = new Copy();
        cp.setOverwrite(true);
        FileSet set = new FileSet();
        set.setDir(fromDir);
        cp.addFileset(set);
        cp.setTodir(toDir);
        cp.setProject(new Project());
        cp.execute();
    }

    public String validateSelection() {
        this.data.getErrorInfo().clear();
        List plugins = LibraryProcessor.getInstance().getMethodModels();
        ArrayList<String> pluginids = new ArrayList<String>();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            pluginids.add(((MethodPlugin)it.next()).getGuid());
        }
        ArrayList basePlugins = new ArrayList();
        ArrayList<String> newPlugins = new ArrayList<String>();
        Iterator it2 = this.data.getPlugins().iterator();
        while (it2.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it2.next();
            if (!info.selected || info.existingPlugin != null) continue;
            newPlugins.add(info.guid);
            Iterator itb = info.usedPlugins.iterator();
            while (itb.hasNext()) {
                Object base = itb.next();
                if (basePlugins.contains(base)) continue;
                basePlugins.add(base);
            }
        }
        if (newPlugins.size() > 0) {
            it2 = basePlugins.iterator();
            while (it2.hasNext()) {
                String guid = (String)it2.next();
                String uri = (String)this.data.basePluginUrlMap.get(guid);
                if (newPlugins.contains(guid) || pluginids.contains(guid)) continue;
                String message = uri != null && uri.length() > 0 ? ImportResources.getString("Import.PluginImportingService.MSG5", uri) : ImportResources.getString("Import.PluginImportingService.MSG6");
                this.data.getErrorInfo().addError(message);
                if (uri == null || uri.length() == 0) break;
            }
        }
        return this.data.getErrorInfo().getError();
    }

    private void scanLibraryFile(LibraryDocument document) {
        this.visitLibTag(document);
        this.visitResourceTag(document);
        this.data.validatePlugins();
        Iterator it = this.data.getPlugins().iterator();
        while (it.hasNext()) {
            PluginImportData.PluginInfo info = (PluginImportData.PluginInfo)it.next();
            if (info.existingPlugin != null) continue;
            Iterator itbase = info.usedPlugins.iterator();
            while (itbase.hasNext()) {
                String guid = (String)itbase.next();
                if (this.data.basePluginUrlMap.containsKey(guid)) continue;
                this.data.basePluginUrlMap.put(guid, "");
            }
        }
    }

    private void visitLibTag(LibraryDocument document) {
        Element node;
        NodeList nodes = document.getPlugins();
        int i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            PluginImportData.PluginInfo pi = this.data.new PluginImportData.PluginInfo();
            pi.guid = LibraryDocument.getGuid((Element)node);
            this.data.getPlugins().add(pi);
            this.loadExistingPluginInfo(pi);
            ++i;
        }
        nodes = document.getConfigurations();
        i = 0;
        while (i < nodes.getLength()) {
            node = (Element)nodes.item(i);
            PluginImportData.ConfiguarationInfo ci = this.data.new PluginImportData.ConfiguarationInfo();
            ci.guid = LibraryDocument.getGuid((Element)node);
            ci.name = node.getAttribute("name");
            this.data.getConfigs().add(ci);
            this.loadExistingConfigInfo(ci);
            ++i;
        }
    }

    private void visitResourceTag(LibraryDocument document) {
        NodeList nodes = document.getResourceDescriptors();
        int i = 0;
        while (i < nodes.getLength()) {
            Element node = (Element)nodes.item(i);
            String guid = node.getAttribute("id");
            String uri = node.getAttribute("uri");
            File file = document.getFileFromUri(uri);
            PluginImportData.PluginInfo pi = this.data.getPluginInfo(guid);
            if (pi != null) {
                if (file.exists()) {
                    this.loadPluginInfo(file, pi);
                } else {
                    this.data.removePluginInfo(guid);
                }
            } else {
                PluginImportData.ConfiguarationInfo ci = this.data.getConfigInfo(guid);
                if (ci != null && file.exists()) {
                    this.loadConfigInfo(file, ci);
                }
            }
            ++i;
        }
    }

    protected void loadConfigInfo(File source, PluginImportData.ConfiguarationInfo info) {
        try {
            Document document = XMLUtil.loadXml((File)source);
            Element root = document.getDocumentElement();
            Element configTag = null;
            if (root.getTagName().equals("com.ibm.uma:MethodConfiguration")) {
                configTag = root;
            } else {
                NodeList nodes = root.getElementsByTagName("com.ibm.uma:MethodConfiguration");
                if (nodes.getLength() > 0) {
                    configTag = (Element)nodes.item(0);
                }
            }
            if (configTag != null) {
                info.name = configTag.getAttribute("name");
            }
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    protected void loadPluginInfo(File source, PluginImportData.PluginInfo info) {
        try {
            NodeList nodes;
            Document document = XMLUtil.loadXml((File)source);
            Element root = document.getDocumentElement();
            Element pluginTag = null;
            if (root.getTagName().equals("com.ibm.uma:MethodPlugin")) {
                pluginTag = root;
            } else {
                nodes = root.getElementsByTagName("com.ibm.uma:MethodPlugin");
                if (nodes.getLength() > 0) {
                    pluginTag = (Element)nodes.item(0);
                }
            }
            if (pluginTag != null) {
                info.name = pluginTag.getAttribute("name");
                info.version = LibraryDocument.getChildValue((Element)pluginTag, (String)"version");
                info.brief_desc = LibraryDocument.getChildValue((Element)pluginTag, (String)"briefDescription");
                info.authors = LibraryDocument.getChildValue((Element)pluginTag, (String)"authors");
                info.changeDate = LibraryDocument.getChildValue((Element)pluginTag, (String)"changeDate");
                info.url = source.toString();
                nodes = pluginTag.getElementsByTagName("bases");
                int i = 0;
                while (i < nodes.getLength()) {
                    Element node = (Element)nodes.item(i);
                    String guid = node.getAttribute("href");
                    int indx = guid.indexOf("#");
                    if (indx > 0) {
                        guid = guid.substring(indx + 1);
                    } else {
                        indx = guid.indexOf("uma://");
                        if (indx >= 0) {
                            guid = guid.substring(indx + 6);
                        }
                    }
                    info.usedPlugins.add(guid);
                    ++i;
                }
            }
        }
        catch (Exception e) {
            ImportPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    private void loadExistingPluginInfo(PluginImportData.PluginInfo info) {
        List plugins = LibraryProcessor.getInstance().getMethodModels();
        Iterator it = plugins.iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            if (!plugin.getGuid().equals(info.guid)) continue;
            info.existingPlugin = plugin;
        }
    }

    private void loadExistingConfigInfo(PluginImportData.ConfiguarationInfo info) {
        MethodConfiguration[] configs = LibraryProcessor.getInstance().getConfigurations();
        if (configs == null || configs.length == 0) {
            return;
        }
        int i = 0;
        while (i < configs.length) {
            MethodConfiguration config = configs[i];
            if (config.getGuid().equals(info.guid)) {
                info.existingConfig = config;
            }
            ++i;
        }
    }

    private void fixLibraryGuid(File path, String oldGuid, String newGuid) {
        if (!path.isDirectory()) {
            return;
        }
        File[] files = path.listFiles(new FileFilter(){

            public boolean accept(File f) {
                if (f.isDirectory()) {
                    return true;
                }
                String name = f.getName();
                return name.equals("library.xmi") || name.equals("plugin.xmi") || name.equals("model.xmi");
            }
        });
        if (files == null || files.length == 0) {
            return;
        }
        int i = 0;
        while (i < files.length) {
            if (files[i].isDirectory()) {
                this.fixLibraryGuid(files[i], oldGuid, newGuid);
            } else {
                try {
                    String source = FileUtil.readFile((File)files[i], (String)"UTF-8").toString();
                    if (source.indexOf(oldGuid) >= 0) {
                        source = source.replaceAll(oldGuid, newGuid);
                        FileUtil.writeUTF8File((String)files[i].getAbsolutePath(), (String)source);
                    }
                }
                catch (IOException e) {
                    ImportPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
            ++i;
        }
    }
}

