/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.wizards;

import java.io.File;
import org.eclipse.core.runtime.Status;
import org.eclipse.epf.export.wizards.DestinationCommonPage;
import org.eclipse.epf.importing.ImportPlugin;
import org.eclipse.epf.importing.ImportResources;
import org.eclipse.epf.importing.services.PluginImportData;
import org.eclipse.epf.importing.services.PluginImportingService;
import org.eclipse.epf.importing.wizards.ImportPluginWizard;
import org.eclipse.epf.importing.wizards.ImportUIPreferences;
import org.eclipse.epf.importing.wizards.SelectPluginsToImport;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Text;

public class SelectImportPluginSource
extends DestinationCommonPage {
    public static final String PAGE_NAME;
    private static final Status OK_STATUS;
    private PluginImportData data;
    private PluginImportingService service;
    private Status status = OK_STATUS;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.importing.wizards.SelectImportPluginSource");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        PAGE_NAME = clazz.getName();
        OK_STATUS = new Status(0, ImportResources.getString("Import.SelectImportPluginSource.not_used"), 0, "", null);
    }

    public SelectImportPluginSource(PluginImportData data, PluginImportingService service) {
        super(PAGE_NAME, data.llData);
        this.setTitle(ImportResources.getString("Import.selectPluginsDirWizardPage.title"));
        this.setDescription(ImportResources.getString("Import.selectPluginsDirWizardPage.text"));
        this.setImageDescriptor(ImportPlugin.getDefault().getImageDescriptor("full/wizban/ImportMethodPlugins.gif"));
        this.service = service;
        this.data = data;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        String savedPath = ImportUIPreferences.getLastImportPluginPath();
        if (savedPath != null && savedPath.length() > 0) {
            this.ctrl_exportPath.setText(savedPath);
            this.ctrl_exportPath.setEditable(true);
            this.ctrl_browse_button.setEnabled(true);
            this.ctrl_default_checkbox.setSelection(false);
        }
        this.ctrl_default_checkbox.addListener(13, (Listener)this);
    }

    public void handleEvent(Event event) {
        super.handleEvent(event);
        Wizard wizard = (Wizard)this.getWizard();
        if (event.widget == this.ctrl_default_checkbox && !this.ctrl_default_checkbox.getSelection()) {
            this.ctrl_name.setText("");
            String savedPath = ImportUIPreferences.getLastImportPluginPath();
            if (savedPath != null && savedPath.length() > 0) {
                this.ctrl_exportPath.setText(savedPath);
            }
            this.ctrl_exportPath.setEditable(true);
            this.ctrl_browse_button.setEnabled(true);
        }
        this.setPageComplete(this.isPageComplete());
        wizard.getContainer().updateButtons();
    }

    public boolean isPageComplete() {
        boolean returnValue = false;
        this.status = OK_STATUS;
        if (SelectImportPluginSource.isTextNonEmpty((Text)this.ctrl_name) && SelectImportPluginSource.isTextNonEmpty((Text)this.ctrl_exportPath)) {
            this.saveToDataModel();
            File libDir = new File(this.ctrl_exportPath.getText());
            if (!libDir.exists()) {
                this.status = new Status(4, ImportResources.getString("Import.SelectImportPluginSource.not_used"), 0, ImportResources.getString("Import.SelectImportPluginSource.no_path"), null);
            } else {
                returnValue = true;
            }
        }
        this.applyToStatusLine();
        return returnValue;
    }

    protected void saveToDataModel() {
        super.saveToDataModel();
        this.data.llData.setLibName(this.ctrl_name.getText());
        this.data.llData.setParentFolder(this.ctrl_exportPath.getText());
    }

    public IWizardPage getNextPage() {
        this.saveToDataModel();
        this.service.validate(null);
        String error = this.data.getErrorInfo().getError();
        if (error != null && error.length() > 0) {
            super.setErrorMessage(error);
            return this;
        }
        SelectPluginsToImport page = ((ImportPluginWizard)this.getWizard()).page2;
        page.onEnterPage();
        return page;
    }

    public boolean canFlipToNextPage() {
        return this.isPageComplete();
    }

    private void applyToStatusLine() {
        if (this.status != OK_STATUS) {
            this.setErrorMessage(this.status.getMessage());
        } else {
            this.setErrorMessage(null);
        }
    }
}

