/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.ContentElement;
import com.ibm.uma.ContentPackage;
import com.ibm.uma.MethodPlugin;
import com.ibm.uma.NamedElement;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.util.UmaUtil;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import java.util.regex.Pattern;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorter;
import org.eclipse.epf.authoring.ui.dialogs.FilterSorterForAll;
import org.eclipse.epf.authoring.ui.filters.DescriptorConfigurationFilter;
import org.eclipse.epf.library.configuration.ConfigurationFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.FilterHelper;
import org.eclipse.epf.library.edit.itemsfilter.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.IProcessFilter;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.DialogSettings;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.internal.WorkbenchPlugin;

public class ItemsFilterDialog
extends Dialog
implements ISelectionChangedListener,
IDoubleClickListener {
    protected Button okButton;
    protected Button cancelButton;
    protected Text ctrl_pattern;
    protected Text ctrl_brief_desc;
    private String pattern;
    private String filterTypeStr;
    protected Combo filterType;
    private String dialogTitle;
    private String tabStr;
    private Object contentElement;
    private ArrayList selectedList = new ArrayList();
    private boolean viewerSelectionSingle = false;
    private String viewerLabel = null;
    private TreeViewer treeViewer;
    protected IStructuredContentProvider contentProvider;
    protected ILabelProvider labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

        public String getText(Object object) {
            if (object instanceof VariabilityElement) {
                return TngUtil.getLabel((VariabilityElement)((VariabilityElement)object), (String)"", (boolean)true);
            }
            return super.getText(object);
        }
    };
    private AdapterFactory adapterFactory;
    private ComposedAdapterFactory composedAdapterFactory;
    private List alreadySelectedList = new ArrayList();
    private org.eclipse.epf.library.edit.IFilter filter;
    Pattern regexPattern;
    protected FilterHelper helper;
    private String STORE_EXPANDED_LEVEL_ID = ".LEVEL_ID";
    private String DIALOG_NAME;
    private Button expandButton;
    private Button collapseButton;
    private Object input;
    private String[] types;

    public ItemsFilterDialog(Shell parentShell, Object contentElement, String tabStr, List alreadyExists) {
        super(parentShell);
        this.contentElement = contentElement;
        this.tabStr = tabStr;
        this.filter = null;
        this.alreadySelectedList = alreadyExists;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, this.alreadySelectedList);
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, String tabStr, List alreadyExists, Object input) {
        this(parentShell, filter, null, tabStr, alreadyExists);
        this.input = input;
    }

    public ItemsFilterDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, Object contentElement, String tabStr) {
        super(parentShell);
        this.filter = filter;
        this.tabStr = tabStr;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, null);
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell parentShell, org.eclipse.epf.library.edit.IFilter filter, Object contentElement, String tabStr, List alreadyExists) {
        super(parentShell);
        this.filter = filter;
        this.tabStr = tabStr;
        this.alreadySelectedList = alreadyExists;
        this.helper = new FilterHelper(contentElement, tabStr, null, null, alreadyExists);
        this.contentElement = contentElement;
        this.initProviderForTabs();
    }

    public ItemsFilterDialog(Shell parentShell) {
        super(parentShell);
        this.helper = new FilterHelper(null, null, null, null, null);
    }

    protected void buttonPressed(int buttonId) {
        if (buttonId == 0) {
            this.saveValues();
        }
        super.buttonPressed(buttonId);
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    public void setTitle(String dialogTitle) {
        this.dialogTitle = dialogTitle;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.dialogTitle == null) {
            this.dialogTitle = this.tabStr;
        }
        shell.setText(String.valueOf(AuthoringUIResources.getString("AuthoringUI.FilterDialog.title")) + this.dialogTitle);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        super.createButtonsForButtonBar(parent);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        composite.setFont(parent.getFont());
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        GridData gD = (GridData)composite.getLayoutData();
        layout.numColumns = 3;
        Label typeLabel = new Label(composite, 0);
        typeLabel.setText(AuthoringUIResources.getString("AuthoringUI.FilterDialog.Type.text"));
        GridData gD1 = new GridData(1);
        typeLabel.setLayoutData((Object)gD1);
        this.filterType = new Combo(composite, 12);
        gD1 = new GridData(1);
        gD1.horizontalSpan = 2;
        gD1.widthHint = 390;
        this.filterType.setLayoutData((Object)gD1);
        if (this.types == null) {
            this.fillFilterTypeCombo();
        } else {
            this.filterType.setItems(this.types);
            if (this.helper != null) {
                this.filterTypeStr = this.filterType.getItem(0);
                this.helper.setFilterTypeStr(this.filterType.getItem(0));
                if (this.tabStr == null) {
                    this.tabStr = this.filterTypeStr;
                    this.helper.setTabStr(this.tabStr);
                }
            }
        }
        this.filterType.select(0);
        Label ctrl_patternLabel = new Label(composite, 0);
        ctrl_patternLabel.setText(AuthoringUIResources.getString("AuthoringUI.FilterDialog.Pattern.text"));
        gD.horizontalSpan = 3;
        ctrl_patternLabel.setLayoutData((Object)gD);
        this.ctrl_pattern = new Text(composite, 2048);
        GridData gD12 = new GridData(768);
        gD12.horizontalSpan = 3;
        this.ctrl_pattern.setLayoutData((Object)gD12);
        Label ctrl_patternLabel1 = new Label(composite, 0);
        ctrl_patternLabel1.setText(AuthoringUIResources.getString("AuthoringUI.FilterDialog.Pattern.description"));
        ctrl_patternLabel1.setLayoutData((Object)gD);
        Composite buttonsComposite = new Composite(composite, 0);
        GridData gd2 = new GridData(896);
        gd2.horizontalSpan = 2;
        buttonsComposite.setLayoutData((Object)gd2);
        GridLayout buttonsLayout = new GridLayout();
        buttonsLayout.numColumns = 2;
        buttonsLayout.marginRight = 0;
        buttonsComposite.setLayout((Layout)buttonsLayout);
        this.expandButton = new Button(buttonsComposite, 524288);
        this.expandButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("expandall.gif"));
        this.expandButton.setToolTipText(AuthoringUIResources.getString("AuthoringUI.FilterDialog.ExpandAll"));
        gd2 = new GridData(544);
        this.expandButton.setLayoutData((Object)gd2);
        this.collapseButton = new Button(buttonsComposite, 8);
        this.collapseButton.setImage(AuthoringUIPlugin.getDefault().getSharedImage("collapseall.gif"));
        this.collapseButton.setToolTipText(AuthoringUIResources.getString("AuthoringUI.FilterDialog.CollapseAll"));
        gd2 = new GridData(128);
        this.collapseButton.setLayoutData((Object)gd2);
        this.createLine(composite, 3);
        this.createViewerLabel(composite);
        this.createViewer(composite);
        this.restoreLastSettings();
        new Label(composite, 0).setText(AuthoringUIResources.getString("AuthoringUI.FilterDialog.BriefDescription"));
        this.ctrl_brief_desc = new Text(composite, 2634);
        GridData gd = new GridData(768);
        gd.horizontalSpan = 3;
        gd.heightHint = 60;
        this.ctrl_brief_desc.setLayoutData((Object)gd);
        this.createLine(composite, 3);
        this.addListener();
        return composite;
    }

    private void createViewer(Composite parent) {
        this.treeViewer = this.viewerSelectionSingle ? new TreeViewer(parent, 2820) : new TreeViewer(parent, 2818);
        this.treeViewer.setLabelProvider((IBaseLabelProvider)this.labelProvider);
        this.treeViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.treeViewer.setUseHashlookup(true);
        if (this.input != null) {
            this.treeViewer.setInput(this.input);
        } else if (this.contentElement != null) {
            if (this.contentElement instanceof Activity) {
                if (this.contentElement instanceof Process) {
                    if (((Process)this.contentElement).eContainer() instanceof ProcessComponent) {
                        if (this.tabStr.equals(FilterConstants.GUIDANCE) || this.tabStr.equals(FilterConstants.ROADMAP) || this.tabStr.equals(FilterConstants.SUPPORTING_MATERIALS)) {
                            this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
                        } else {
                            this.treeViewer.setInput((Object)((Process)this.contentElement).eContainer());
                        }
                    } else {
                        this.treeViewer.setInput(this.contentElement);
                    }
                } else {
                    this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
                }
            } else {
                this.treeViewer.setInput((Object)UmaUtil.getMethodLibrary((EObject)((EObject)this.contentElement)));
            }
        } else {
            this.treeViewer.setInput((Object)LibraryProcessor.getInstance().getLibrary());
        }
        this.treeViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.treeViewer.addDoubleClickListener((IDoubleClickListener)this);
        this.treeViewer.getTree().setFont(parent.getFont());
        if (this.tabStr.equalsIgnoreCase(FilterConstants.ALL_ELEMENTS)) {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorterForAll());
        } else {
            this.treeViewer.setSorter((ViewerSorter)new FilterSorter());
        }
        GridData spec = new GridData(1808);
        spec.widthHint = 300;
        spec.heightHint = 300;
        spec.horizontalSpan = 3;
        this.treeViewer.getControl().setLayoutData((Object)spec);
    }

    private void createLine(Composite parent, int ncol) {
        Label line = new Label(parent, 259);
        GridData gridData = new GridData(768);
        gridData.horizontalSpan = ncol;
        line.setLayoutData((Object)gridData);
    }

    private void createViewerLabel(Composite parent) {
        if (this.viewerLabel != null) {
            Label label = new Label(parent, 0);
            label.setText(this.viewerLabel);
        }
    }

    public void setViewerSelectionSingle(boolean single) {
        this.viewerSelectionSingle = single;
    }

    public void doubleClick(DoubleClickEvent event) {
        IStructuredSelection s = (IStructuredSelection)event.getSelection();
        Object element = s.getFirstElement();
        if ((element = LibraryUtil.unwrap((Object)element)) instanceof ContentElement || element instanceof Process) {
            this.selectedList.add(element);
        } else if (element instanceof ProcessComponent) {
            this.selectedList.add(element);
        } else if (element instanceof BreakdownElement) {
            this.selectedList.add(element);
        }
        this.saveLastSettings();
        this.close();
        if (this.composedAdapterFactory != null) {
            this.composedAdapterFactory.dispose();
        }
    }

    protected IDialogSettings getDialogSettings() {
        DialogSettings dialogSettings = (DialogSettings)WorkbenchPlugin.getDefault().getDialogSettings();
        DialogSettings section = (DialogSettings)dialogSettings.getSection(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        if (section == null) {
            section = (DialogSettings)dialogSettings.addNewSection(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        }
        return section;
    }

    protected void restoreLastSettings() {
        this.DIALOG_NAME = this.tabStr;
        DialogSettings dialogSettings = (DialogSettings)this.getDialogSettings();
        List elements = (List)FilterConstants.hashMap.get(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID);
        if (elements == null || elements.isEmpty()) {
            this.treeViewer.expandAll();
            return;
        }
        String temp = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + ".Pattern");
        if (temp != null && !temp.equalsIgnoreCase("")) {
            this.pattern = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + ".Pattern");
            this.filterTypeStr = dialogSettings.get(String.valueOf(this.DIALOG_NAME) + ".Type");
            this.filterType.setText(this.filterTypeStr);
            this.ctrl_pattern.setText(this.pattern);
            try {
                this.regexPattern = Pattern.compile(this.pattern, 2);
            }
            catch (Exception exception) {
                this.pattern = ".*";
                this.regexPattern = Pattern.compile(this.pattern, 2);
            }
            if (this.helper != null) {
                this.helper.setPattern(this.pattern);
                this.helper.setRegexPattern(this.regexPattern);
                this.helper.setFilterTypeStr(this.filterTypeStr);
            }
            this.initProviderForTabs();
            this.treeViewer.refresh();
        }
        if (elements != null && !elements.isEmpty()) {
            try {
                this.treeViewer.setExpandedElements(elements.toArray());
            }
            catch (Exception exception) {
                this.treeViewer.expandAll();
            }
        }
    }

    public void traverseTree(TreeItem[] items, List list) {
        int i = 0;
        while (i < items.length) {
            TreeItem[] itemsx = items[i].getItems();
            if (itemsx.length > 1) {
                list.add(items[i].getData());
                this.traverseTree(itemsx, list);
            } else {
                list.add(items[i].getData());
            }
            ++i;
        }
    }

    protected void saveValues() {
        IStructuredSelection selection = (IStructuredSelection)this.treeViewer.getSelection();
        if (selection.size() > 0) {
            Object[] objectArr = selection.toArray();
            int i = 0;
            while (i < objectArr.length) {
                Object obj = LibraryUtil.unwrap((Object)objectArr[i]);
                if (obj instanceof ContentElement) {
                    this.selectedList.add(obj);
                } else if (obj instanceof Process) {
                    this.selectedList.add(obj);
                } else if (obj instanceof ProcessComponent) {
                    this.selectedList.add(obj);
                } else if (obj instanceof BreakdownElement) {
                    this.selectedList.add(obj);
                }
                ++i;
            }
        }
        this.saveLastSettings();
    }

    public void saveLastSettings() {
        IDialogSettings settings = this.getDialogSettings();
        this.DIALOG_NAME = this.tabStr;
        Object[] expandedElements = this.treeViewer.getExpandedElements();
        ArrayList<Object> expandList = new ArrayList<Object>();
        int i = 0;
        while (i < expandedElements.length) {
            Object obj = expandedElements[i];
            if (obj instanceof NamedElement) {
                expandList.add(expandedElements[i]);
            }
            ++i;
        }
        settings.put(String.valueOf(this.DIALOG_NAME) + ".Pattern", this.pattern);
        settings.put(String.valueOf(this.DIALOG_NAME) + ".Type", this.filterTypeStr);
        FilterConstants.hashMap.put(String.valueOf(this.DIALOG_NAME) + this.STORE_EXPANDED_LEVEL_ID, expandList);
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.updateSelection(event);
        this.updateButtons();
    }

    protected void updateButtons() {
    }

    public Object getParentObject(Object contentElement) {
        return MethodElementUtil.getMethodModel((Object)contentElement);
    }

    protected void updateSelection(SelectionChangedEvent event) {
        IStructuredSelection sel = (IStructuredSelection)event.getSelection();
        if (sel.getFirstElement() instanceof ContentElement) {
            this.ctrl_brief_desc.setText(((ContentElement)sel.getFirstElement()).getBriefDescription());
        }
        if (sel.getFirstElement() instanceof ContentPackage) {
            this.ctrl_brief_desc.setText(((ContentPackage)sel.getFirstElement()).getBriefDescription());
        }
        if (sel.getFirstElement() instanceof MethodPlugin) {
            this.ctrl_brief_desc.setText(((MethodPlugin)sel.getFirstElement()).getBriefDescription());
        }
    }

    public void fillFilterTypeCombo() {
        if (this.filter instanceof ConfigurationFilter) {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.categoryStrs.contains(this.tabStr)) {
            String[] str = new String[]{this.tabStr, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.CUSTOM_CATEGORIES.equalsIgnoreCase(this.tabStr)) {
            String[] str = new String[]{this.tabStr, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.breakdownElements.contains(this.tabStr)) {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.contentElementStrs.contains(this.tabStr)) {
            String[] str = new String[]{this.tabStr, FilterConstants.CONTENT_PACKAGES, FilterConstants.METHO_PLUGINS};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.ALL_ELEMENTS.equals(this.tabStr)) {
            String space = "-";
            String[] str = new String[14];
            int i = 0;
            str[i++] = FilterConstants.ALL_ELEMENTS;
            str[i++] = FilterConstants.CONTENT_PACKAGES;
            str[i++] = String.valueOf(space) + FilterConstants.ROLES;
            str[i++] = String.valueOf(space) + FilterConstants.TASKS;
            str[i++] = String.valueOf(space) + FilterConstants.WORKPRODUCTS;
            str[i++] = String.valueOf(space) + FilterConstants.GUIDANCE;
            str[i++] = FilterConstants.DISCIPLINES;
            str[i++] = FilterConstants.ROLESETS;
            str[i++] = FilterConstants.WORKPRODUCTTYPES;
            str[i++] = FilterConstants.DOMAINS;
            str[i++] = FilterConstants.TOOLS;
            str[i++] = FilterConstants.CUSTOM_CATEGORIES;
            str[i++] = FilterConstants.PROCESSES;
            str[i++] = FilterConstants.METHO_PLUGINS;
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else if (FilterConstants.CONFIG_CONTENT_ELEMENT.equals(this.tabStr)) {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        } else {
            String[] str = new String[]{this.tabStr};
            this.filterType.setItems(str);
            this.filterTypeStr = str[0];
        }
    }

    public void addListener() {
        this.ctrl_pattern.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                int j;
                if (ItemsFilterDialog.this.ctrl_pattern.getText() != null && ItemsFilterDialog.this.ctrl_pattern.getText().trim().length() > 0) {
                    ItemsFilterDialog.this.pattern = ItemsFilterDialog.this.ctrl_pattern.getText().trim();
                } else {
                    ItemsFilterDialog.this.pattern = "*";
                }
                if (ItemsFilterDialog.this.pattern == null) {
                    ItemsFilterDialog.this.initProviderForTabs();
                    ItemsFilterDialog.this.treeViewer.refresh();
                    return;
                }
                boolean begin = false;
                if (ItemsFilterDialog.this.pattern.startsWith("*")) {
                    ItemsFilterDialog.this.pattern = ".*" + ItemsFilterDialog.this.pattern.substring(1, ItemsFilterDialog.this.pattern.length());
                    begin = true;
                }
                if (ItemsFilterDialog.this.pattern.endsWith("*")) {
                    ItemsFilterDialog.this.pattern = String.valueOf(ItemsFilterDialog.this.pattern.substring(0, ItemsFilterDialog.this.pattern.length() - 1)) + ".*";
                    begin = true;
                }
                if (!begin) {
                    StringTokenizer st1 = new StringTokenizer(ItemsFilterDialog.this.pattern, "*");
                    String element1 = "";
                    while (st1.hasMoreElements()) {
                        element1 = String.valueOf(element1) + st1.nextToken() + ".*";
                    }
                    ItemsFilterDialog.this.pattern = element1;
                }
                if ((j = ItemsFilterDialog.this.pattern.indexOf("?")) > -1) {
                    if (j == ItemsFilterDialog.this.pattern.length() - 1) {
                        ItemsFilterDialog.this.pattern = ItemsFilterDialog.this.pattern.substring(0, j);
                        ItemsFilterDialog itemsFilterDialog = ItemsFilterDialog.this;
                        itemsFilterDialog.pattern = String.valueOf(itemsFilterDialog.pattern) + "[a-zA-Z]";
                    } else {
                        StringTokenizer st = new StringTokenizer(ItemsFilterDialog.this.pattern, "?");
                        String element = "";
                        while (st.hasMoreTokens()) {
                            element = String.valueOf(element) + st.nextToken() + "[a-zA-Z]";
                        }
                        ItemsFilterDialog.this.pattern = element;
                    }
                }
                try {
                    ItemsFilterDialog.this.regexPattern = Pattern.compile(ItemsFilterDialog.this.pattern, 2);
                }
                catch (Exception exception) {
                    ItemsFilterDialog.this.pattern = ".*";
                    ItemsFilterDialog.this.regexPattern = Pattern.compile(ItemsFilterDialog.this.pattern, 2);
                }
                if (ItemsFilterDialog.this.helper != null) {
                    ItemsFilterDialog.this.helper.setPattern(ItemsFilterDialog.this.pattern);
                    ItemsFilterDialog.this.helper.setRegexPattern(ItemsFilterDialog.this.regexPattern);
                    ItemsFilterDialog.this.helper.setFilterTypeStr(ItemsFilterDialog.this.filterTypeStr);
                    ItemsFilterDialog.this.helper.setTabStr(ItemsFilterDialog.this.filterTypeStr);
                }
                ItemsFilterDialog.this.treeViewer.refresh();
                ItemsFilterDialog.this.treeViewer.expandAll();
            }
        });
        this.filterType.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (ItemsFilterDialog.this.filterType.getSelectionIndex() > -1) {
                    ItemsFilterDialog.this.filterTypeStr = ItemsFilterDialog.this.filterType.getItem(ItemsFilterDialog.this.filterType.getSelectionIndex());
                }
                ItemsFilterDialog.this.filterTypeStr.trim();
                if (ItemsFilterDialog.this.helper != null) {
                    ItemsFilterDialog.this.helper.setPattern(ItemsFilterDialog.this.pattern);
                    ItemsFilterDialog.this.helper.setRegexPattern(ItemsFilterDialog.this.regexPattern);
                    ItemsFilterDialog.this.helper.setFilterTypeStr(ItemsFilterDialog.this.filterTypeStr);
                    ItemsFilterDialog.this.helper.setTabStr(ItemsFilterDialog.this.filterTypeStr);
                }
                ItemsFilterDialog.this.treeViewer.refresh();
                ItemsFilterDialog.this.treeViewer.expandAll();
            }

            public void widgetDefaultSelected(SelectionEvent selectionevent) {
            }
        });
        this.expandButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsFilterDialog.this.treeViewer.expandAll();
            }
        });
        this.collapseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ItemsFilterDialog.this.treeViewer.collapseAll();
            }
        });
    }

    public ArrayList getSelectedItems() {
        return this.selectedList;
    }

    private void initProviderForTabs() {
        if (this.filter != null) {
            if (this.filter instanceof IFilter) {
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            }
        }
        if (this.filter instanceof IProcessFilter) {
            if (this.tabStr.equalsIgnoreCase(FilterConstants.WORK_PRODUCT_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getPBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory());
            } else if (this.tabStr.equalsIgnoreCase(FilterConstants.ROLE_DESCRIPTORS)) {
                this.adapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_AdapterFactory(this.filter);
                this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
                this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getOBSFilter_ComposedAdapterFactory();
                this.labelProvider = new AdapterFactoryLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory());
            }
        } else {
            this.adapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory(this.filter);
            this.contentProvider = new AdapterFactoryContentProvider(this.adapterFactory);
            this.composedAdapterFactory = TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory();
        }
    }

    public void setExistingElements(List list) {
        this.alreadySelectedList = list;
        if (this.helper != null) {
            this.helper.setAlreadySelectedList(list);
        }
    }

    public FilterHelper getHelper() {
        return this.helper;
    }

    public String[] getFilterTypeArray() {
        return null;
    }

    public void setContentProvider(IStructuredContentProvider contentProvider, ComposedAdapterFactory composedAdapterFactory) {
        this.contentProvider = contentProvider;
        this.composedAdapterFactory = composedAdapterFactory;
    }

    public void setTypes(String[] str) {
        this.types = str;
    }

    public void setFilter(org.eclipse.epf.library.edit.IFilter filter) {
        this.filter = filter;
        if (this.helper != null) {
            if (this.filter instanceof IFilter) {
                ((IFilter)this.filter).setHelper(this.helper);
            } else if (this.filter instanceof DescriptorConfigurationFilter) {
                ((DescriptorConfigurationFilter)this.filter).setHelper(this.helper);
            }
        }
    }

    public void setInput(Object input) {
        if (input != null) {
            this.input = input;
        }
    }

    public void setViewerLabel(String viewerLabel) {
        this.viewerLabel = viewerLabel;
    }
}

