/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.MethodPlugin;
import java.io.File;
import java.util.ArrayList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.AddLinkFilter;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.ui.LibraryUIResources;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.RichTextEditor;
import org.eclipse.epf.richtext.dialogs.AddLinkDialog;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class MethodAddLinkDialog
extends AddLinkDialog {
    private static final int LINK_URL = 0;
    private static final int LINK_FILE = 1;
    private static final int LINK_ELEMENT_LINK_WITH_TYPE = 3;
    private static final int LINK_ELEMENT_LINK_WITH_USER_TEXT = 4;
    private static final String[] ELEMENT_TYPE_LABELS = new String[]{LibraryUIResources.getString((String)"LibraryUI.linkToURL.name"), LibraryUIResources.getString((String)"LibraryUI.linkToFile.name"), LibraryUIResources.getString((String)"LibraryUI.elementLink.name"), LibraryUIResources.getString((String)"LibraryUI.elementLinkWithType.name"), LibraryUIResources.getString((String)"LibraryUI.elementLinkWithUserText.name")};
    private static final String OPEN_LINK_IN_NEW_WINDOW_ATTRIBUTE = "target=\"_blank\"";
    private IMethodRichText richText;
    private MethodElement methodElement;
    private Combo linkTypeCombo;
    private Button browseButton;
    private Button openLinkCheckbox;
    private int linkType;
    private boolean openLinkInNewWindow = true;
    private File fileToCopy;

    public MethodAddLinkDialog(Shell parent, IMethodRichText richText) {
        super(parent, richText.getBasePath());
        this.richText = richText;
        this.methodElement = richText.getMethodElement();
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        GridLayout layout = (GridLayout)composite.getLayout();
        layout.numColumns = 3;
        Label linkTypeLabel = new Label(composite, 0);
        linkTypeLabel.setText(AuthoringUIResources.getString("AuthoringUI.addLinkDialog.linkType"));
        linkTypeLabel.moveAbove((Control)this.urlLabel);
        this.linkTypeCombo = new Combo(composite, 2056);
        GridData comboGridData = new GridData(768);
        comboGridData.horizontalSpan = 2;
        this.linkTypeCombo.setLayoutData((Object)comboGridData);
        this.linkTypeCombo.setItems(ELEMENT_TYPE_LABELS);
        this.linkTypeCombo.setText(ELEMENT_TYPE_LABELS[0]);
        this.linkTypeCombo.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent event) {
                MethodAddLinkDialog.this.linkType = MethodAddLinkDialog.this.linkTypeCombo.getSelectionIndex();
                MethodAddLinkDialog.this.browseButton.setEnabled(MethodAddLinkDialog.this.linkType != 0);
                MethodAddLinkDialog.this.openLinkCheckbox.setEnabled(MethodAddLinkDialog.this.linkType == 0 || MethodAddLinkDialog.this.linkType == 1);
                MethodAddLinkDialog.this.urlText.setText("");
                if (MethodAddLinkDialog.this.linkType != 1) {
                    MethodAddLinkDialog.this.fileToCopy = null;
                }
            }

            public void widgetDefaultSelected(SelectionEvent event) {
            }
        });
        this.linkTypeCombo.moveAbove((Control)this.urlLabel);
        this.browseButton = new Button(composite, 8);
        this.browseButton.setLayoutData((Object)new GridData());
        this.browseButton.setText(AuthoringUIText.BROWSE_BUTTON_TEXT);
        this.browseButton.setEnabled(false);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                if (MethodAddLinkDialog.this.linkType == 1) {
                    FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                    dialog.setFilterPath(MethodAddLinkDialog.this.basePath);
                    String attachFile = dialog.open();
                    if (attachFile != null && attachFile.length() > 0) {
                        try {
                            MethodAddLinkDialog.this.fileToCopy = new File(dialog.getFilterPath(), dialog.getFileName());
                            String path = ResourceHelper.getURLForAttachment((File)MethodAddLinkDialog.this.fileToCopy, (MethodElement)MethodAddLinkDialog.this.methodElement, (boolean)false);
                            String url = "<a href=\"";
                            url = Platform.getOS().equals("win32") ? String.valueOf(url) + NetUtil.encodeFileURL((String)("file:/" + path)) : String.valueOf(url) + NetUtil.encodeFileURL((String)("./" + path));
                            url = String.valueOf(url) + "\"" + (MethodAddLinkDialog.this.openLinkInNewWindow ? " target=\"_blank\"" : "") + ">" + MethodAddLinkDialog.this.fileToCopy.getName() + "</a>";
                            MethodAddLinkDialog.this.urlText.setText(url);
                        }
                        catch (Exception e) {
                            ((BaseDialog)MethodAddLinkDialog.this).logger.logError((Throwable)e);
                        }
                    }
                } else {
                    AddLinkFilter filter = new AddLinkFilter(this){
                        final /* synthetic */ 2 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        protected boolean childAccept(Object obj) {
                            if (obj instanceof MethodPlugin) {
                                return true;
                            }
                            return !(obj instanceof MethodConfiguration);
                        }
                    };
                    ItemsFilterDialog fd = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell(), (IFilter)filter, MethodAddLinkDialog.this.methodElement, FilterConstants.ALL_ELEMENTS);
                    fd.setBlockOnOpen(true);
                    fd.setTitle(FilterConstants.ALL_ELEMENTS);
                    fd.open();
                    ArrayList sel = fd.getSelectedItems();
                    if (sel.size() > 0) {
                        MethodElement selectedElement = (MethodElement)sel.get(0);
                        String url = null;
                        String href = ResourceHelper.getUrl((MethodElement)selectedElement, (MethodElement)MethodAddLinkDialog.this.methodElement, (String)"html");
                        if (MethodAddLinkDialog.this.linkType == 4) {
                            String linkName = ((RichTextEditor)MethodAddLinkDialog.this.richText).getSelectedText();
                            if (linkName.trim().length() == 0) {
                                linkName = selectedElement.getName();
                            }
                            url = ResourceHelper.getElementLink((MethodElement)selectedElement, (String)linkName, (String)("file://" + href));
                        } else {
                            boolean withType = MethodAddLinkDialog.this.linkType == 3;
                            url = ResourceHelper.getElementLink((MethodElement)selectedElement, (boolean)withType, (String)("file://" + href));
                        }
                        MethodAddLinkDialog.this.urlText.setText(url);
                    }
                }
            }
        });
        this.openLinkCheckbox = new Button(composite, 32);
        GridData checkBoxGridData = new GridData();
        checkBoxGridData.horizontalSpan = 2;
        this.openLinkCheckbox.setLayoutData((Object)checkBoxGridData);
        this.openLinkCheckbox.setText(AuthoringUIResources.getString("AuthoringUI.openLinkCheckbox.text"));
        this.openLinkCheckbox.setSelection(true);
        this.openLinkCheckbox.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                MethodAddLinkDialog.this.openLinkInNewWindow = MethodAddLinkDialog.this.openLinkCheckbox.getSelection();
            }
        });
        return composite;
    }

    public File getFileToCopy() {
        return this.fileToCopy;
    }

    public boolean getOpenLinkInNewWindow() {
        return this.openLinkInNewWindow;
    }

    protected void okPressed() {
        String url = this.urlText.getText();
        if (url != null && url.length() > 0) {
            if (this.linkType == 0) {
                String fullURL = "<a href=\"" + (url.startsWith("http") ? url : "http://" + url) + "\"" + (this.openLinkInNewWindow ? " target=\"_blank\"" : "") + ">" + url + "</a>";
                this.link.setURL(fullURL);
            } else {
                this.link.setURL(url);
            }
        }
        this.urlText.setText("");
        super.okPressed();
    }
}

