/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import com.ibm.uma.Activity;
import com.ibm.uma.BreakdownElement;
import com.ibm.uma.CapabilityPattern;
import com.ibm.uma.DeliveryProcess;
import com.ibm.uma.Descriptor;
import com.ibm.uma.Diagram;
import com.ibm.uma.MethodConfiguration;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Milestone;
import com.ibm.uma.Process;
import com.ibm.uma.ProcessComponent;
import com.ibm.uma.ProcessContribution;
import com.ibm.uma.RoleDescriptor;
import com.ibm.uma.TaskDescriptor;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkBreakdownElement;
import com.ibm.uma.WorkProductDescriptor;
import com.ibm.uma.edit.domain.TraceableAdapterFactoryEditingDomain;
import com.ibm.uma.util.UmaUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandStack;
import org.eclipse.emf.common.command.CommandStackListener;
import org.eclipse.emf.common.notify.Adapter;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.common.notify.Notifier;
import org.eclipse.emf.common.notify.impl.AdapterImpl;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.BasicEList;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.edit.command.CreateChildCommand;
import org.eclipse.emf.edit.command.SetCommand;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.AdapterFactoryTreeIterator;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.provider.IChangeNotifier;
import org.eclipse.emf.edit.provider.ITreeItemContentProvider;
import org.eclipse.emf.edit.provider.ReflectiveItemProviderAdapterFactory;
import org.eclipse.emf.edit.provider.ViewerNotification;
import org.eclipse.emf.edit.provider.resource.ResourceItemProviderAdapterFactory;
import org.eclipse.emf.edit.ui.action.CommandActionHandler;
import org.eclipse.emf.edit.ui.action.CopyAction;
import org.eclipse.emf.edit.ui.action.CutAction;
import org.eclipse.emf.edit.ui.action.DeleteAction;
import org.eclipse.emf.edit.ui.action.EditingDomainActionBarContributor;
import org.eclipse.emf.edit.ui.action.PasteAction;
import org.eclipse.emf.edit.ui.dnd.LocalTransfer;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.actions.IWorkbenchPartAction;
import org.eclipse.epf.authoring.ui.actions.MethodLibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.actions.ProcessAutoSynchronizeAction;
import org.eclipse.epf.authoring.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.authoring.ui.actions.SynchronizationAction;
import org.eclipse.epf.authoring.ui.actions.UpdateSuppressionFromBaseAction;
import org.eclipse.epf.authoring.ui.dialogs.DialogHelper;
import org.eclipse.epf.authoring.ui.dialogs.UserDefinedDiagramDialog;
import org.eclipse.epf.authoring.ui.dnd.EditingDomainTableTreeViewerDropAdapter;
import org.eclipse.epf.authoring.ui.editors.AbstractDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.ActivityDetailDiagramEditor;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ColumnDescriptor;
import org.eclipse.epf.authoring.ui.editors.GraphicalWorkflowEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.editors.ProcessEditorInput;
import org.eclipse.epf.authoring.ui.forms.DeliveryProcessDescription;
import org.eclipse.epf.authoring.ui.forms.ProcessBreakdownStructureFormPage;
import org.eclipse.epf.authoring.ui.forms.ProcessDescription;
import org.eclipse.epf.authoring.ui.properties.TNGPropertySheetPage;
import org.eclipse.epf.authoring.ui.views.LibraryView;
import org.eclipse.epf.authoring.ui.views.ProcessViewer;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.diagram.model.util.GraphicalDataManager;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.CommandStackChangedEvent;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.process.ActivityWrapperItemProvider;
import org.eclipse.epf.library.edit.process.BreakdownElementWrapperItemProvider;
import org.eclipse.epf.library.edit.process.IBSItemProvider;
import org.eclipse.epf.library.edit.process.command.ActivityDropCommand;
import org.eclipse.epf.library.edit.ui.IActionTypeProvider;
import org.eclipse.epf.library.edit.util.ConfigurableComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.EditingDomainComposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ExposedAdapterFactory;
import org.eclipse.epf.library.edit.util.ProcessUtil;
import org.eclipse.epf.library.edit.util.Suppression;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.epf.library.ui.LibraryUIImages;
import org.eclipse.epf.library.util.ResourceUtil;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileXMIResourceImpl;
import org.eclipse.epf.persistence.refresh.RefreshJob;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.dnd.DropTargetEvent;
import org.eclipse.swt.dnd.DropTargetListener;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Widget;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.dialogs.ListSelectionDialog;
import org.eclipse.ui.forms.editor.IFormPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheet;
import org.eclipse.ui.views.properties.tabbed.ITabbedPropertySheetPageContributor;

public class ProcessEditor
extends MethodElementEditor
implements IEditingDomainProvider,
IMenuListener,
ISelectionProvider,
IViewerProvider,
ITabbedPropertySheetPageContributor {
    public static final String EDITOR_ID;
    public static final String WORKFLOW_EDITOR_ID;
    public static final String ACTIVITY_DETAIL_DIAGRAM_EDITOR_ID;
    public static final String WPDEPENDENCY_EDITOR_ID;
    public static final ColumnDescriptor COL_DESC_NAME;
    public static final ColumnDescriptor COL_DESC_ID;
    public static final ColumnDescriptor COL_DESC_PREFIX;
    public static final ColumnDescriptor COL_DESC_MODEL_INFO;
    public static final ColumnDescriptor COL_DESC_TYPE;
    public static final ColumnDescriptor COL_DESC_PREDECESSORS;
    public static final ColumnDescriptor COL_DESC_IS_REPEATABLE;
    public static final ColumnDescriptor COL_DESC_IS_ONGOING;
    public static final ColumnDescriptor COL_DESC_IS_EVENT_DRIVEN;
    public static final ColumnDescriptor COL_DESC_TEAM;
    public static final ColumnDescriptor COL_DESC_ENTRY_STATE;
    public static final ColumnDescriptor COL_DESC_EXIT_STATE;
    public static final ColumnDescriptor COL_DESC_PRESENTATION_NAME;
    public static final ColumnDescriptor COL_DESC_DELIVERABLE;
    public static final ColumnDescriptor COL_DESC_IS_OPTIONAL;
    public static final ColumnDescriptor COL_DESC_IS_PLANNED;
    public static final ColumnDescriptor COL_DESC_HAS_MULTIPLE_OCCURRENCES;
    public static final String WBS_FORM_ID = "wbs";
    public static final String TA_FORM_ID = "tbs";
    public static final String WPBS_FORM_ID = "wpbs";
    public static final String CONSOLIDATED_FORM_ID = "consolidated";
    public static final List DEFAULT_TBS_COLUMNS;
    public static final List DEFAULT_WPBS_COLUMNS;
    public static final List DEFAULT_WBS_COLUMNS;
    public static final List ALL_WBS_COLUMNS;
    public static final List ALL_TBS_COLUMNS;
    public static final List ALL_WPBS_COLUMNS;
    public static final Map idToColumnDescriptorMap;
    private ComposedAdapterFactory adapterFactory;
    private AdapterFactoryEditingDomain editingDomain;
    private Viewer currentViewer;
    private ISelectionChangedListener selectionChangedListener;
    private Collection selectionChangedListeners = new ArrayList();
    private ISelection viewSelection;
    private ProcessComponent selectedProcessComponent;
    private Process selectedProcess;
    private Adapter processComponentListener = new AdapterImpl(){

        public void notifyChanged(Notification msg) {
            Class<?> clazz = class$4;
            if (clazz == null) {
                try {
                    clazz = class$4 = Class.forName("com.ibm.uma.ProcessComponent");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            switch (msg.getFeatureID((Class)clazz)) {
                case 0: {
                    String name = msg.getNewStringValue();
                    if (name == null) {
                        name = "";
                    }
                    ProcessEditor.this.setPartName(name);
                    if (ProcessEditor.this.pages == null) break;
                    Iterator iter = ProcessEditor.this.pages.iterator();
                    while (iter.hasNext()) {
                        Object page = iter.next();
                        if (!(page instanceof ProcessDescription)) continue;
                        ((ProcessDescription)((Object)page)).refreshElementName(name);
                    }
                    break;
                }
            }
        }
    };
    private AdapterFactoryContentProvider propContentProvider;
    private MethodConfiguration currentConfig;
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void libraryChanged(int option, Collection collection) {
            MethodConfiguration config;
            switch (option) {
                case 8: {
                    if (collection == null) return;
                    if (!collection.contains(ProcessEditor.this.currentConfig)) return;
                    config = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                    try {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(ProcessEditor.this.currentConfig);
                        ProcessEditor.this.refreshAll();
                    }
                    catch (Throwable throwable) {
                        Object var4_5 = null;
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(config);
                        throw throwable;
                    }
                }
                {
                    Object var4_6 = null;
                }
                ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(config);
                return;
                case 64: {
                    ProcessEditor.this.configChanged();
                    return;
                }
            }
        }
    };
    private ProcessBreakdownStructureFormPage WBSTab;
    private ProcessBreakdownStructureFormPage OBSTab;
    private ProcessBreakdownStructureFormPage PBSTab;
    private ProcessBreakdownStructureFormPage procTab;
    private ProcessBreakdownStructureFormPage[] bsPages;
    private TNGPropertySheetPage propertySheetPage;
    public Collection resourcesToSave = new ArrayList();
    private IPartListener partActivationListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ProcessEditor.this.removePropertiesDropDownMenu(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ProcessEditor.this.propertySheetPage = null;
            }
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
            if (part instanceof PropertySheet) {
                ProcessEditor.this.removePropertiesDropDownMenu(part);
            }
        }
    };
    private IPropertyChangeListener prefStoreListener;
    private Suppression suppression;
    private boolean synchronizingSelection;
    private boolean inputChanged;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.authoring.ui.editors.ProcessEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        EDITOR_ID = clazz.getName();
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.epf.authoring.ui.editors.GraphicalWorkflowEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WORKFLOW_EDITOR_ID = clazz2.getName();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("org.eclipse.epf.authoring.ui.editors.ActivityDetailDiagramEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ACTIVITY_DETAIL_DIAGRAM_EDITOR_ID = clazz3.getName();
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("org.eclipse.epf.authoring.ui.editors.GraphicalWPDependencyEditor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        WPDEPENDENCY_EDITOR_ID = clazz4.getName();
        COL_DESC_NAME = new ColumnDescriptor("name", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Name"), 3, 200, true, 1);
        COL_DESC_ID = new ColumnDescriptor("id", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Index"), 0, 40, true, 0);
        COL_DESC_PREFIX = new ColumnDescriptor("prefix", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Prefix"), 0, 80, true, 1);
        COL_DESC_MODEL_INFO = new ColumnDescriptor("model_info", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.ModelInfo"), 0, 120, true, 0);
        COL_DESC_TYPE = new ColumnDescriptor("type", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Type"), 0, 80, true, 0);
        COL_DESC_PREDECESSORS = new ColumnDescriptor("predecessors", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Predecessors"), 2, 100, true, 1);
        COL_DESC_IS_REPEATABLE = new ColumnDescriptor("is_repeatable", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Repetable"), 1, 60, true, 3);
        COL_DESC_IS_ONGOING = new ColumnDescriptor("is_ongoing", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Ongoing"), 1, 60, true, 3);
        COL_DESC_IS_EVENT_DRIVEN = new ColumnDescriptor("is_event_driven", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.EventDriven"), 1, 60, true, 3);
        COL_DESC_TEAM = new ColumnDescriptor("teams", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Team"), 1, 100, true, 1);
        COL_DESC_ENTRY_STATE = new ColumnDescriptor("entry_state", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.EntryState"), 1, 60, true, 1);
        COL_DESC_EXIT_STATE = new ColumnDescriptor("exit_state", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.ExitState"), 1, 60, true, 1);
        COL_DESC_PRESENTATION_NAME = new ColumnDescriptor("presentation_name", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.PresentationName"), 3, 200, true, 1);
        COL_DESC_DELIVERABLE = new ColumnDescriptor("deliverable", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Deliverable"), 1, 100, true, 1);
        COL_DESC_IS_OPTIONAL = new ColumnDescriptor("is_optional", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Optional"), 1, 60, true, 3);
        COL_DESC_IS_PLANNED = new ColumnDescriptor("is_planned", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Planned"), 1, 60, true, 3);
        COL_DESC_HAS_MULTIPLE_OCCURRENCES = new ColumnDescriptor("has_multiple_occurrences", AuthoringUIResources.getString("AuthoringUI.ProcessEditor.MultipleOccurrences"), 1, 60, true, 3);
        DEFAULT_TBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_PREFIX, COL_DESC_MODEL_INFO, COL_DESC_TYPE, COL_DESC_TEAM, COL_DESC_IS_OPTIONAL, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES);
        DEFAULT_WPBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_PREFIX, COL_DESC_MODEL_INFO, COL_DESC_TYPE, COL_DESC_DELIVERABLE, COL_DESC_ENTRY_STATE, COL_DESC_EXIT_STATE, COL_DESC_IS_OPTIONAL, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES);
        DEFAULT_WBS_COLUMNS = Arrays.asList(COL_DESC_PRESENTATION_NAME, COL_DESC_ID, COL_DESC_PREFIX, COL_DESC_MODEL_INFO, COL_DESC_TYPE, COL_DESC_PREDECESSORS, COL_DESC_IS_REPEATABLE, COL_DESC_IS_ONGOING, COL_DESC_IS_EVENT_DRIVEN, COL_DESC_IS_OPTIONAL, COL_DESC_IS_PLANNED, COL_DESC_HAS_MULTIPLE_OCCURRENCES);
        ALL_WBS_COLUMNS = new ArrayList(DEFAULT_WBS_COLUMNS);
        ALL_TBS_COLUMNS = new ArrayList(DEFAULT_TBS_COLUMNS);
        ALL_WPBS_COLUMNS = new ArrayList(DEFAULT_WPBS_COLUMNS);
        idToColumnDescriptorMap = new HashMap();
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_NAME.id, COL_DESC_NAME);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_ID.id, COL_DESC_ID);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PREFIX.id, COL_DESC_PREFIX);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_MODEL_INFO.id, COL_DESC_MODEL_INFO);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_TYPE.id, COL_DESC_TYPE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PREDECESSORS.id, COL_DESC_PREDECESSORS);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_REPEATABLE.id, COL_DESC_IS_REPEATABLE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_ONGOING.id, COL_DESC_IS_ONGOING);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_EVENT_DRIVEN.id, COL_DESC_IS_EVENT_DRIVEN);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_TEAM.id, COL_DESC_TEAM);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_ENTRY_STATE.id, COL_DESC_ENTRY_STATE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_EXIT_STATE.id, COL_DESC_EXIT_STATE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_PRESENTATION_NAME.id, COL_DESC_PRESENTATION_NAME);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_DELIVERABLE.id, COL_DESC_DELIVERABLE);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_OPTIONAL.id, COL_DESC_IS_OPTIONAL);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_IS_PLANNED.id, COL_DESC_IS_PLANNED);
        idToColumnDescriptorMap.put(ProcessEditor.COL_DESC_HAS_MULTIPLE_OCCURRENCES.id, COL_DESC_HAS_MULTIPLE_OCCURRENCES);
        ALL_WBS_COLUMNS.add(COL_DESC_NAME);
        ALL_TBS_COLUMNS.add(COL_DESC_NAME);
        ALL_WPBS_COLUMNS.add(COL_DESC_NAME);
    }

    protected void inputChanged(Object newInput) {
        this.inputChanged = false;
        if (!(newInput instanceof MethodElementEditorInput)) {
            return;
        }
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)newInput;
        MethodElement obj = methodElementInput.getMethodElement();
        if (obj instanceof ProcessComponent) {
            this.selectedProcessComponent = (ProcessComponent)obj;
            this.selectedProcess = (Process)ProcessUtil.getTopBreakdownElement((ProcessComponent)this.selectedProcessComponent);
            this.suppression = Suppression.getSuppression((Process)this.selectedProcess);
            this.WBSTab.setProcess(this.selectedProcess);
            this.OBSTab.setProcess(this.selectedProcess);
            this.PBSTab.setProcess(this.selectedProcess);
            this.procTab.setProcess(this.selectedProcess);
        }
    }

    private Image getProcTitleImage() {
        MethodElement obj;
        IEditorInput input = this.getEditorInput();
        if (input instanceof MethodElementEditorInput && (obj = ((MethodElementEditorInput)input).getMethodElement()) instanceof ProcessComponent) {
            ProcessComponent pc = (ProcessComponent)obj;
            Process proc = pc.getProcess();
            if (proc instanceof CapabilityPattern) {
                return LibraryUIImages.IMG_CAPABILITY_PATTERN;
            }
            if (proc instanceof DeliveryProcess) {
                return LibraryUIImages.IMG_DELIVERY_PROCESS;
            }
            if (proc instanceof ProcessContribution) {
                return LibraryUIImages.IMG_PROCESS_CONTRIBUTION;
            }
        }
        return LibraryUIImages.IMG_PROCESS;
    }

    private void removePropertiesDropDownMenu(IWorkbenchPart part) {
        if (part instanceof PropertySheet) {
            IViewSite view = ((PropertySheet)part).getViewSite();
            IMenuManager menuMgr = view.getActionBars().getMenuManager();
            menuMgr.removeAll();
            menuMgr.updateAll(true);
        }
    }

    public void init(IEditorSite site, IEditorInput input) throws PartInitException {
        super.init(site, input);
        ArrayList<Object> factories = new ArrayList<Object>();
        factories.add(new ResourceItemProviderAdapterFactory());
        factories.add(new ReflectiveItemProviderAdapterFactory());
        this.adapterFactory = new ComposedAdapterFactory(factories);
        CommandStack commandStack = this.actionMgr.getCommandStack();
        commandStack.addCommandStackListener(new CommandStackListener(){

            public void commandStackChanged(EventObject event) {
                boolean run = false;
                if (event instanceof CommandStackChangedEvent) {
                    switch (((CommandStackChangedEvent)event).getType()) {
                        case 2: 
                        case 4: {
                            run = true;
                        }
                    }
                } else {
                    run = true;
                }
                if (run) {
                    Display.getCurrent().asyncExec(new Runnable(this, event){
                        final /* synthetic */ 39 this$1;
                        private final /* synthetic */ EventObject val$event;
                        {
                            this.this$1 = var1_1;
                            this.val$event = eventObject;
                        }

                        public void run() {
                            39.access$0(this.this$1).firePropertyChange(257);
                            Command mostRecentCommand = ((CommandStack)this.val$event.getSource()).getMostRecentCommand();
                            if (mostRecentCommand != null) {
                                if (mostRecentCommand instanceof CreateChildCommand && ProcessEditor.access$7(39.access$0(this.this$1)) instanceof ProcessViewer) {
                                    Object[] arr = mostRecentCommand.getAffectedObjects().toArray();
                                    if (arr.length == 1) {
                                        ProcessViewer viewer = (ProcessViewer)ProcessEditor.access$7(39.access$0(this.this$1));
                                        viewer.editElement(arr[0], 0);
                                    }
                                } else if (!(TngUtil.unwrap((Command)mostRecentCommand) instanceof SetCommand)) {
                                    39.access$0(this.this$1).setSelectionToViewer(mostRecentCommand.getAffectedObjects());
                                }
                            }
                        }
                    });
                }
            }

            static /* synthetic */ ProcessEditor access$0(39 var0) {
                return var0.ProcessEditor.this;
            }
        });
        this.editingDomain = new TraceableAdapterFactoryEditingDomain((AdapterFactory)this.adapterFactory, commandStack);
        LibraryProcessor.getInstance().listenTo(commandStack);
        LibraryProcessor.getInstance().addListener(this.libraryListener);
        LibraryProcessor.getInstance().listenToProcessEditor();
        this.setPartName(input.getName());
        this.setTitleImage(this.getProcTitleImage());
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.elementObj = methodElementInput.getMethodElement();
        if (this.elementObj instanceof ProcessComponent) {
            this.selectedProcessComponent = (ProcessComponent)this.elementObj;
            this.selectedProcess = this.selectedProcessComponent.getProcess();
        }
        if (this.selectedProcessComponent != null) {
            this.selectedProcessComponent.eAdapters().add((Object)this.processComponentListener);
        }
        this.getSite().getWorkbenchWindow().getPartService().addPartListener(this.partActivationListener);
        if (this.prefStoreListener == null) {
            this.prefStoreListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    ProcessBreakdownStructureFormPage page = null;
                    if (event.getProperty().equals("org.eclipse.epf.library.edit.wbs_columns")) {
                        page = ProcessEditor.this.WBSTab;
                    } else if (event.getProperty().equals("org.eclipse.epf.library.edit.tbs_columns")) {
                        page = ProcessEditor.this.OBSTab;
                    } else if (event.getProperty().equals("org.eclipse.epf.library.edit.wpbs_columns")) {
                        page = ProcessEditor.this.PBSTab;
                    }
                    if (page != null) {
                        ColumnDescriptor[] cols = ProcessEditor.toColumnDescriptors(AuthoringUIPlugin.getDefault().getPreferenceStore().getString(event.getProperty()));
                        page.updateColumns(cols);
                        if (page == ProcessEditor.this.WBSTab) {
                            ProcessEditor.this.procTab.updateColumns(cols);
                        }
                    }
                }
            };
        }
        AuthoringUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.prefStoreListener);
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    if (ProcessEditor.this.currentViewer != null) {
                        ProcessEditor.this.currentViewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public EditingDomainActionBarContributor getActionBarContributor() {
        return (EditingDomainActionBarContributor)this.getEditorSite().getActionBarContributor();
    }

    public void dispose() {
        AuthoringUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener(this.prefStoreListener);
        this.adapterFactory.dispose();
        if (this.getActionBarContributor().getActiveEditor() == this) {
            this.getActionBarContributor().setActiveEditor(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        LibraryProcessor.getInstance().removeListener(this.libraryListener);
        LibraryProcessor.getInstance().stopListeningTo(this.editingDomain.getCommandStack());
        if (this.selectedProcessComponent != null) {
            this.selectedProcessComponent.eAdapters().remove((Object)this.processComponentListener);
        }
        this.getSite().getWorkbenchWindow().getPartService().removePartListener(this.partActivationListener);
        boolean saveNeeded = this.isDirty();
        super.dispose();
    }

    private void addDescriptionPage() throws PartInitException {
        if (this.selectedProcess instanceof DeliveryProcess) {
            this.addPage(0, (IFormPage)new DeliveryProcessDescription(this));
        } else {
            this.addPage(0, (IFormPage)new ProcessDescription(this));
        }
    }

    protected void addPages() {
        try {
            this.addDescriptionPage();
            IPreferenceStore store = AuthoringUIPlugin.getDefault().getPreferenceStore();
            this.WBSTab = new ProcessBreakdownStructureFormPage(this, WBS_FORM_ID, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.WorkBreakdownStructure"));
            ColumnDescriptor[] columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.wbs_columns"));
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            this.currentConfig = LibraryProcessor.getInstance().getCurrentMethodConfiguration();
            ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(this.currentConfig);
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.WBSTab.setAdapterFactory((AdapterFactory)adapterFactory);
            this.WBSTab.setColumnDescriptors(columnDescriptors);
            int id = this.addPage(this.WBSTab.createControl(this.getContainer()));
            this.setPageText(id, this.WBSTab.getTitle());
            this.WBSTab.setTabIndex(id);
            StructuredViewer viewer = (StructuredViewer)this.WBSTab.getViewer();
            this.createContextMenuFor(viewer);
            this.OBSTab = new ProcessBreakdownStructureFormPage(this, TA_FORM_ID, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.TeamAllocation"));
            columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.tbs_columns"));
            adapterFactory = TngAdapterFactory.INSTANCE.getOBS_ComposedAdapterFactory();
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.OBSTab.setAdapterFactory((AdapterFactory)adapterFactory);
            this.OBSTab.setColumnDescriptors(columnDescriptors);
            id = this.addPage(this.OBSTab.createControl(this.getContainer()));
            this.setPageText(id, this.OBSTab.getTitle());
            this.OBSTab.setTabIndex(id);
            viewer = (StructuredViewer)this.OBSTab.getViewer();
            this.createContextMenuFor(viewer);
            this.PBSTab = new ProcessBreakdownStructureFormPage(this, WPBS_FORM_ID, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.WorkProductUsage"));
            columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.wpbs_columns"));
            adapterFactory = TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory();
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.PBSTab.setAdapterFactory((AdapterFactory)adapterFactory);
            this.PBSTab.setColumnDescriptors(columnDescriptors);
            id = this.addPage(this.PBSTab.createControl(this.getContainer()));
            this.setPageText(id, this.PBSTab.getTitle());
            this.PBSTab.setTabIndex(id);
            viewer = (StructuredViewer)this.PBSTab.getViewer();
            this.createContextMenuFor(viewer);
            this.procTab = new ProcessBreakdownStructureFormPage(this, CONSOLIDATED_FORM_ID, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.ConsolidatedView"));
            this.procTab.setReadOnly(true);
            adapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            if (adapterFactory instanceof ConfigurableComposedAdapterFactory) {
                ((ConfigurableComposedAdapterFactory)adapterFactory).setFilter((IFilter)ProcessAuthoringConfigurator.INSTANCE);
            }
            this.procTab.setAdapterFactory((AdapterFactory)adapterFactory);
            columnDescriptors = ProcessEditor.toColumnDescriptors(store.getString("org.eclipse.epf.library.edit.wbs_columns"));
            this.procTab.setColumnDescriptors(columnDescriptors);
            id = this.addPage(this.procTab.createControl(this.getContainer()));
            this.setPageText(id, this.procTab.getTitle());
            this.procTab.setTabIndex(id);
            viewer = (StructuredViewer)this.procTab.getViewer();
            this.createContextMenuFor(viewer);
            this.bsPages = new ProcessBreakdownStructureFormPage[]{this.WBSTab, this.OBSTab, this.PBSTab, this.procTab};
            this.inputChanged(this.getEditorInput());
        }
        catch (PartInitException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            e.printStackTrace();
        }
    }

    protected void setActivePage(int pageIndex) {
        Viewer viewer;
        Object selection;
        super.setActivePage(pageIndex);
        this.handlePageChange();
        if (pageIndex > 0 && this.bsPages.length <= pageIndex && ((selection = (viewer = this.bsPages[pageIndex].getViewer()).getSelection()) == null || selection.isEmpty())) {
            ISelection initialSelection = null;
            if (this.getEditorInput() instanceof ProcessEditorInput) {
                initialSelection = ((ProcessEditorInput)this.getEditorInput()).getInitialSelection();
            }
            selection = initialSelection == null ? new StructuredSelection((Object)this.selectedProcess) : initialSelection;
            viewer.setSelection(selection, true);
        }
    }

    private void handlePageChange() {
        int id = this.getActivePage();
        if (id != -1) {
            Object page = this.pages.get(id);
            if (page instanceof ProcessDescription) {
                ((ProcessDescription)((Object)page)).setFormText();
            }
            if (page == this.WBSTab.getViewer().getControl()) {
                this.setCurrentViewer(this.WBSTab.getViewer());
            } else if (page == this.OBSTab.getViewer().getControl()) {
                this.setCurrentViewer(this.OBSTab.getViewer());
            } else if (page == this.PBSTab.getViewer().getControl()) {
                this.setCurrentViewer(this.PBSTab.getViewer());
            } else if (page == this.procTab.getViewer().getControl()) {
                this.setCurrentViewer(this.procTab.getViewer());
            } else {
                this.setCurrentViewer(null);
            }
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        }
    }

    protected void pageChange(int newPageIndex) {
        super.pageChange(newPageIndex);
        this.handlePageChange();
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
        viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                ProcessEditor.this.setSelection((ISelection)sel);
            }
        });
        int dndOperations = 5;
        Transfer[] transfers = new Transfer[]{LocalTransfer.getInstance()};
        viewer.addDropSupport(dndOperations, transfers, (DropTargetListener)new ProcessEditorDropAdapter((EditingDomain)this.editingDomain, (Viewer)viewer));
    }

    private void setCurrentViewer(Viewer viewer) {
        if (this.currentViewer != viewer) {
            IContentProvider contentProvider;
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        ProcessEditor.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            if (this.currentViewer != null) {
                this.currentViewer.removeSelectionChangedListener(this.selectionChangedListener);
            }
            if (viewer != null) {
                viewer.addSelectionChangedListener(this.selectionChangedListener);
            }
            this.currentViewer = viewer;
            if (this.currentViewer instanceof ProcessViewer && (contentProvider = ((ProcessViewer)this.currentViewer).getContentProvider()) instanceof AdapterFactoryContentProvider) {
                AdapterFactoryContentProvider adapterFactoryContentProvider = (AdapterFactoryContentProvider)contentProvider;
                AdapterFactory adapterFactory = adapterFactoryContentProvider.getAdapterFactory();
                if (adapterFactory instanceof EditingDomainComposedAdapterFactory) {
                    ((EditingDomainComposedAdapterFactory)adapterFactory).setEditingDomain((EditingDomain)this.editingDomain);
                } else {
                    this.editingDomain.setAdapterFactory(adapterFactory);
                }
                if (this.propContentProvider != null) {
                    this.propContentProvider.setAdapterFactory(adapterFactory);
                }
            }
            this.setSelection((ISelection)(this.currentViewer == null ? StructuredSelection.EMPTY : this.currentViewer.getSelection()));
        }
    }

    private static Activity getParentActivity(BreakdownElement e, AdapterFactory adapterFactory) {
        Activity act = UmaUtil.getParentActivity((BreakdownElement)e);
        if (act != null) {
            return act;
        }
        return null;
    }

    private static AdapterFactory getAdapterFactory(StructuredViewer viewer) {
        return ((AdapterFactoryContentProvider)viewer.getContentProvider()).getAdapterFactory();
    }

    private static void setSelectionToViewer(Viewer viewer, IStructuredSelection otherSel, boolean alternateSelection) {
        if (alternateSelection) {
            IStructuredSelection sel = (IStructuredSelection)viewer.getSelection();
            Object currentSelection = null;
            if (sel.size() == 1) {
                Activity act;
                currentSelection = sel.getFirstElement();
                if (currentSelection instanceof BreakdownElement && (act = ProcessEditor.getParentActivity((BreakdownElement)currentSelection, ProcessEditor.getAdapterFactory((StructuredViewer)viewer))) != otherSel.getFirstElement()) {
                    viewer.setSelection((ISelection)otherSel, true);
                }
            } else {
                viewer.setSelection((ISelection)otherSel, true);
            }
        } else {
            viewer.setSelection((ISelection)otherSel, true);
        }
    }

    public void setSelection(ISelection selection) {
        if (this.synchronizingSelection) {
            return;
        }
        this.viewSelection = selection;
        ArrayList listenerList = new ArrayList(this.selectionChangedListeners);
        int i = 0;
        while (i < listenerList.size()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)listenerList.get(i);
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
            ++i;
        }
        this.synchronizeSelection(selection, this.currentViewer);
    }

    private boolean refreshOutOfSynch(ISelection selection) {
        if (this.currentViewer != null && selection instanceof IStructuredSelection) {
            boolean refreshRequired = false;
            IStructuredSelection sel = (IStructuredSelection)selection;
            HashSet<Resource> resources = new HashSet<Resource>();
            Iterator iter = sel.iterator();
            while (iter.hasNext()) {
                Resource resource;
                Object e = TngUtil.unwrap(iter.next());
                if (!(e instanceof EObject)) continue;
                EObject eObject = (EObject)e;
                if (eObject.eIsProxy()) {
                    eObject = RefreshJob.getInstance().resolve(eObject);
                    refreshRequired = true;
                }
                if ((resource = eObject.eResource()) == null) continue;
                resources.add(resource);
            }
            if (!resources.isEmpty()) {
                boolean ret;
                ArrayList removedResources = new ArrayList();
                ArrayList changedResources = new ArrayList();
                ResourceUtil.checkOutOfSynchResources(resources, removedResources, changedResources);
                if (!(removedResources.isEmpty() && changedResources.isEmpty() || !(ret = this.promptReloadFiles()))) {
                    if (!removedResources.isEmpty()) {
                        Iterator iter2 = removedResources.iterator();
                        while (iter2.hasNext()) {
                            MultiFileXMIResourceImpl resource = (MultiFileXMIResourceImpl)iter2.next();
                            try {
                                resource.unloadWithoutRemove();
                            }
                            catch (Exception e) {
                                CommonPlugin.INSTANCE.log((Object)e);
                            }
                        }
                    }
                    Collection reloadedResources = null;
                    if (!changedResources.isEmpty()) {
                        reloadedResources = LibraryProcessor.getInstance().getResourceManager().reloadResources(changedResources);
                    }
                    if (!removedResources.isEmpty() || reloadedResources != null) {
                        refreshRequired = true;
                    }
                    Iterator iter3 = changedResources.iterator();
                    while (iter3.hasNext()) {
                        FileManager.getInstance().refresh((Resource)iter3.next());
                    }
                }
            }
            if (refreshRequired) {
                this.currentViewer.refresh();
                return true;
            }
        }
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void synchronizeSelection(ISelection selection, Viewer currentViewer) {
        try {
            block30: {
                Viewer viewer;
                AdapterFactory adapterFactory;
                ArrayList<Object> selectedPath;
                boolean alternateSelection;
                IStructuredSelection otherSel;
                Object selected;
                block31: {
                    block33: {
                        block32: {
                            IStructuredSelection sel;
                            this.synchronizingSelection = true;
                            if (currentViewer == null || !(selection instanceof IStructuredSelection) || (sel = (IStructuredSelection)selection).size() != 1) break block30;
                            selected = sel.getFirstElement();
                            otherSel = null;
                            alternateSelection = false;
                            selectedPath = null;
                            adapterFactory = ProcessEditor.getAdapterFactory((StructuredViewer)currentViewer);
                            if (!(selected instanceof BreakdownElementWrapperItemProvider)) break block31;
                            if (!((BreakdownElementWrapperItemProvider)selected).isReadOnly()) break block32;
                            if (adapterFactory == null) break block31;
                            break block33;
                        }
                        if (this.procTab.getViewer() == currentViewer) {
                            selected = TngUtil.unwrap((Object)selected);
                            selection = new StructuredSelection(selected);
                        }
                        break block31;
                    }
                    Object e = TngUtil.unwrap((Object)selected);
                    selectedPath = new ArrayList<Object>();
                    ITreeItemContentProvider adapter = (ITreeItemContentProvider)selected;
                    while (true) {
                        selectedPath.add(0, e);
                        Object parent = adapter.getParent(e);
                        if (parent == null) break;
                        if (parent instanceof BreakdownElementWrapperItemProvider) {
                            adapter = (ITreeItemContentProvider)parent;
                            e = TngUtil.unwrap((Object)parent);
                            continue;
                        }
                        Class<?> clazz = class$5;
                        if (clazz == null) {
                            try {
                                clazz = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                            }
                            catch (ClassNotFoundException classNotFoundException) {
                                throw new NoClassDefFoundError(classNotFoundException.getMessage());
                            }
                        }
                        adapter = (ITreeItemContentProvider)adapterFactory.adapt(parent, (Object)clazz);
                        e = parent;
                    }
                }
                if (selected instanceof BreakdownElement) {
                    if (this.procTab.getViewer() != currentViewer) {
                        this.procTab.getViewer().setSelection(selection, true);
                    }
                    if (selected instanceof Activity || selected instanceof Milestone) {
                        otherSel = (IStructuredSelection)selection;
                    } else {
                        Activity act = ProcessEditor.getParentActivity((BreakdownElement)selected, adapterFactory);
                        if (act != null) {
                            otherSel = new StructuredSelection((Object)act);
                            alternateSelection = true;
                        }
                    }
                }
                if (otherSel != null) {
                    viewer = this.WBSTab.getViewer();
                    if (viewer != currentViewer) {
                        if (selected instanceof WorkBreakdownElement) {
                            viewer.setSelection(selection, true);
                        } else {
                            ProcessEditor.setSelectionToViewer(viewer, otherSel, alternateSelection);
                        }
                    }
                    if ((viewer = this.OBSTab.getViewer()) != currentViewer) {
                        if (selected instanceof RoleDescriptor) {
                            viewer.setSelection(selection, true);
                        } else {
                            ProcessEditor.setSelectionToViewer(viewer, otherSel, alternateSelection);
                        }
                    }
                    if ((viewer = this.PBSTab.getViewer()) != currentViewer) {
                        if (selected instanceof WorkProductDescriptor) {
                            viewer.setSelection(selection, true);
                        } else {
                            ProcessEditor.setSelectionToViewer(viewer, otherSel, alternateSelection);
                        }
                    }
                } else if (selectedPath != null) {
                    viewer = this.WBSTab.getViewer();
                    if (viewer != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.WBSTab.getAdapterFactory()));
                        viewer.setSelection(selection, true);
                    }
                    if ((viewer = this.OBSTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.OBSTab.getAdapterFactory()));
                        viewer.setSelection(selection, true);
                    }
                    if ((viewer = this.PBSTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.PBSTab.getAdapterFactory()));
                        viewer.setSelection(selection, true);
                    }
                    if ((viewer = this.procTab.getViewer()) != currentViewer) {
                        selection = new StructuredSelection(ProcessEditor.findSelection(selectedPath, this.procTab.getAdapterFactory()));
                        viewer.setSelection(selection, true);
                    }
                }
            }
            Object var12_14 = null;
            this.synchronizingSelection = false;
            return;
        }
        catch (Throwable throwable) {
            Object var12_13 = null;
            this.synchronizingSelection = false;
            throw throwable;
        }
    }

    private static Object findSelection(List selectedPath, AdapterFactory adapterFactory) {
        Object e;
        int size = selectedPath.size();
        if (size == 0) {
            return null;
        }
        Object selection = e = selectedPath.get(0);
        Class<?> clazz = class$5;
        if (clazz == null) {
            try {
                clazz = class$5 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ITreeItemContentProvider adapter = (ITreeItemContentProvider)adapterFactory.adapt(e, (Object)clazz);
        Collection children = adapter.getChildren(e);
        int i = 1;
        block4: while (i < size) {
            e = selectedPath.get(i);
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                Object child = iter.next();
                Object element = TngUtil.unwrap(child);
                if (element != e) continue;
                selection = child;
                Class<?> clazz2 = class$5;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                adapter = (ITreeItemContentProvider)adapterFactory.adapt(child, (Object)clazz2);
                children = adapter.getChildren(e);
                ++i;
                continue block4;
            }
            break block4;
        }
        return selection;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.add(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.selectionChangedListeners.remove(listener);
    }

    public ISelection getSelection() {
        return this.viewSelection;
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public Viewer getViewer() {
        return this.currentViewer;
    }

    public AdapterFactory getAdapterFactory() {
        IFormPage page = this.getActivePageInstance();
        if (page instanceof ProcessBreakdownStructureFormPage) {
            return ((ProcessBreakdownStructureFormPage)page).getAdapterFactory();
        }
        return null;
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        ((IMenuListener)this.getEditorSite().getActionBarContributor()).menuAboutToShow(menuManager);
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new TNGPropertySheetPage(this);
            if (this.currentViewer != null) {
                AdapterFactoryContentProvider contentProvider = (AdapterFactoryContentProvider)((ProcessViewer)this.currentViewer).getContentProvider();
                this.propContentProvider = new AdapterFactoryContentProvider(contentProvider.getAdapterFactory());
                this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)this.propContentProvider);
            }
        }
        return this.propertySheetPage;
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$6;
        if (clazz == null) {
            try {
                clazz = class$6 = Class.forName("org.eclipse.ui.views.properties.IPropertySheetPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this.getPropertySheetPage();
        }
        Class<?> clazz2 = class$7;
        if (clazz2 == null) {
            try {
                clazz2 = class$7 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz2)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public String getContributorId() {
        return this.getSite().getId();
    }

    public static EList toColumnDescriptorList(String str) {
        BasicEList columnDescriptors = new BasicEList();
        StringTokenizer tokens = new StringTokenizer(str, ",");
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            Object columnDescriptor = idToColumnDescriptorMap.get(token);
            if (columnDescriptor == null) continue;
            columnDescriptors.add(columnDescriptor);
        }
        return columnDescriptors;
    }

    public static ColumnDescriptor[] toColumnDescriptors(String str) {
        EList list = ProcessEditor.toColumnDescriptorList(str);
        ColumnDescriptor[] columns = new ColumnDescriptor[list.size()];
        list.toArray(columns);
        return columns;
    }

    public int getCurrentPage() {
        return super.getCurrentPage();
    }

    public Suppression getSuppression() {
        return this.suppression;
    }

    private void configChanged() {
        MethodConfiguration config = LibraryProcessor.getInstance().getCurrentMethodConfiguration();
        if (config != this.currentConfig) {
            boolean refresh;
            IWorkbenchPart activePart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
            boolean bl = refresh = activePart == this;
            if (!refresh && activePart instanceof AbstractDiagramEditor) {
                BreakdownElementEditorInput input = (BreakdownElementEditorInput)((IEditorPart)activePart).getEditorInput();
                boolean bl2 = refresh = input.getSuppression().getProcess() == this.selectedProcess;
            }
            if (refresh) {
                this.currentConfig = config;
                this.refreshAll();
            }
        }
    }

    protected void setInput(IEditorInput input) {
        if (input != this.getEditorInput()) {
            this.inputChanged = true;
        }
        super.setInput(input);
    }

    protected void updatePages() {
        Resource modelResource = this.selectedProcess.eResource();
        Resource contentResource = this.selectedProcess.getPresentation().eResource();
        if (this.changedResources.contains(modelResource) || contentResource != null && this.changedResources.contains(contentResource)) {
            this.removePage(0);
            try {
                this.addDescriptionPage();
            }
            catch (PartInitException e) {
                AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.refreshErrorTitle"), AuthoringUIResources.getString("AuthoringUI.ProcessEditor.refreshErrorMsg"), (Throwable)e);
            }
        }
        if (this.inputChanged) {
            this.inputChanged(this.getEditorInput());
            if (this.propertySheetPage != null) {
                this.propertySheetPage.refresh();
            }
        } else {
            this.refreshAll();
        }
    }

    private void refreshAll() {
        BusyIndicator.showWhile((Display)this.getSite().getShell().getDisplay(), (Runnable)new Runnable(){

            public void run() {
                ProcessEditor.this.doRefreshAll(true);
            }
        });
    }

    public void doRefreshAll(boolean updateIDs) {
        if (updateIDs) {
            ComposedAdapterFactory adapterFactory = TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory();
            ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)this.selectedProcess);
            ProcessUtil.refreshPredeccessorLists((AdapterFactory)adapterFactory, (Process)this.selectedProcess);
            adapterFactory = TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory();
            ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)this.selectedProcess);
        }
        this.WBSTab.getViewer().refresh();
        this.OBSTab.getViewer().refresh();
        this.PBSTab.getViewer().refresh();
        this.procTab.getViewer().refresh();
        if (this.propertySheetPage != null) {
            this.propertySheetPage.refresh();
        }
    }

    public void refreshAllProcessEditors() {
        IEditorReference[] editorReferences = this.getSite().getPage().getEditorReferences();
        int i = 0;
        while (i < editorReferences.length) {
            IEditorReference reference = editorReferences[i];
            IEditorPart editor = reference.getEditor(true);
            if (editor instanceof ProcessEditor) {
                ((ProcessEditor)editor).doRefreshAll(false);
            }
            ++i;
        }
    }

    public IFormPage getActivePageInstance() {
        int index = this.getActivePage();
        if (index == -1) {
            return null;
        }
        if (index == 0) {
            return super.getActivePageInstance();
        }
        return this.bsPages[index - 1];
    }

    protected Collection getModifiedResources() {
        Collection modifiedResources = super.getModifiedResources();
        if (this.suppression.isSaveNeeded() && !modifiedResources.contains(this.selectedProcessComponent.eResource())) {
            modifiedResources.add(this.selectedProcessComponent.eResource());
        }
        modifiedResources.addAll(this.resourcesToSave);
        return modifiedResources;
    }

    public void doSave(IProgressMonitor monitor) {
        this.suppression.saveToModel();
        super.doSave(monitor);
        this.suppression.saveIsDone();
        this.resourcesToSave.clear();
        this.firePropertyChange(257);
    }

    public boolean isDirty() {
        if (this.suppression.isSaveNeeded()) {
            return true;
        }
        return super.isDirty();
    }

    public void firePropertyChange(int propertyId) {
        super.firePropertyChange(propertyId);
    }

    public Collection getUsedResources() {
        MethodConfiguration config;
        HashSet<Resource> usedResources = new HashSet<Resource>();
        Resource resource = this.elementObj.eResource();
        if (resource != null) {
            usedResources.add(resource);
        }
        if ((resource = this.selectedProcess.getPresentation().eResource()) != null) {
            usedResources.add(resource);
        }
        if ((config = this.selectedProcess.getDefaultContext()) != null && (resource = config.eResource()) != null) {
            usedResources.add(resource);
        }
        AdapterFactory adapterFactory = this.WBSTab.getAdapterFactory();
        AdapterFactoryTreeIterator iter = new AdapterFactoryTreeIterator(adapterFactory, (Object)this.selectedProcess);
        while (iter.hasNext()) {
            Object obj = TngUtil.unwrap(iter.next());
            if (!(obj instanceof EObject) || (resource = ((EObject)obj).eResource()) == null) continue;
            usedResources.add(resource);
        }
        this.lastUsedResources = usedResources;
        return usedResources;
    }

    public static boolean canReveal(Collection selection, AdapterFactory adapterFactory, Suppression suppression) {
        String msg = suppression.checkDuplicateNameAfterReveal(selection, adapterFactory);
        if (msg != null) {
            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Reveal"), msg);
            return false;
        }
        Collection duplicates = ProcessUtil.getDuplicateDescriptorsAfterReveal((Collection)selection);
        if (!duplicates.isEmpty()) {
            MultiStatus status = new MultiStatus(AuthoringUIPlugin.getDefault().getId(), 0, "", null);
            Iterator iter = duplicates.iterator();
            while (iter.hasNext()) {
                Descriptor desc = (Descriptor)iter.next();
                String descTxt = String.valueOf(TngUtil.getTypeText((EObject)desc)) + ": " + desc.getPresentationName();
                status.add((IStatus)new Status(1, AuthoringUIPlugin.getDefault().getId(), 0, descTxt, null));
            }
            if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Reveal"), AuthoringUIResources.getString("AuthoringUI.ProcessEditor.promptToDeleteBeforeReveal"), (IStatus)status) == 1) {
                return false;
            }
            try {
                ProcessDeleteAction.delete(duplicates);
            }
            catch (OperationCanceledException operationCanceledException) {
                return false;
            }
        }
        return true;
    }

    private static boolean hasInherited(Collection selection) {
        Iterator iter = selection.iterator();
        while (iter.hasNext()) {
            Object element = iter.next();
            if (!ProcessUtil.isInherited(element)) continue;
            return true;
        }
        return false;
    }

    static /* synthetic */ ProcessBreakdownStructureFormPage[] access$9(ProcessEditor processEditor) {
        return processEditor.bsPages;
    }

    static /* synthetic */ boolean access$10(Collection collection) {
        return ProcessEditor.hasInherited(collection);
    }

    public static class BSActionBarContributor
    extends MethodLibraryActionBarContributor {
        private Collection registeredActions = new ArrayList();
        private boolean locked;
        private IAction rollupAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.RollUp")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                boolean wasRolledUp = BSActionBarContributor.access$0(this.this$1).isRolledUp();
                BSActionBarContributor.access$0(this.this$1).setRolledUp(!BSActionBarContributor.access$0(this.this$1).isRolledUp());
                ((IChangeNotifier)BSActionBarContributor.access$0(this.this$1)).fireNotifyChanged((Notification)new ViewerNotification((Notification)new ENotificationImpl((InternalEObject)BSActionBarContributor.access$1(this.this$1), 3, null, null, null, false), (Object)BSActionBarContributor.access$1(this.this$1), true, false));
                if (wasRolledUp) {
                    ProcessViewer viewer = (ProcessViewer)ProcessEditor.access$7((ProcessEditor)BSActionBarContributor.access$2(this.this$1));
                    viewer.expandToLevel(BSActionBarContributor.access$1(this.this$1), -1);
                    this.this$1.doRefresh();
                }
            }
        };
        private IAction moveUpAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.MoveUp"), AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/move_up.gif")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                BSActionBarContributor.access$0(this.this$1).moveUp((Object)BSActionBarContributor.access$3(this.this$1), BSActionBarContributor.access$4(this.this$1));
                BSActionBarContributor.access$5(this.this$1);
            }
        };
        private IAction moveDownAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.MoveDown"), AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/move_down.gif")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                BSActionBarContributor.access$0(this.this$1).moveDown((Object)BSActionBarContributor.access$3(this.this$1), BSActionBarContributor.access$4(this.this$1));
                BSActionBarContributor.access$5(this.this$1);
            }
        };
        private IAction openBaseActivity = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.OpenBaseActivity")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                VariabilityElement base = BSActionBarContributor.access$1(this.this$1).getVariabilityBasedOnElement();
                Process proc = TngUtil.getOwningProcess((BreakdownElement)((BreakdownElement)base));
                try {
                    int id = ProcessEditor.access$8((ProcessEditor)BSActionBarContributor.access$2(this.this$1));
                    StructuredSelection selection = new StructuredSelection((Object)base);
                    MethodElementEditorInput input = new MethodElementEditorInput((MethodElement)proc.eContainer());
                    ProcessEditor editor = (ProcessEditor)this.this$1.getPage().openEditor((IEditorInput)input, EDITOR_ID);
                    editor.setActivePage(id);
                    ProcessEditor.access$9(editor)[id - 1].getViewer().setSelection((ISelection)selection, true);
                }
                catch (PartInitException e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        };
        private IAction openWorkflowEditorAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.OpenActivityDiagram")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                try {
                    try {
                        IEditorPart parent = this.this$1.getPage().getActiveEditor();
                        GraphicalWorkflowEditor.EditorInput input = new GraphicalWorkflowEditor.EditorInput(BSActionBarContributor.access$6(this.this$1), BSActionBarContributor.access$7(this.this$1));
                        IEditorPart part = this.this$1.getPage().openEditor((IEditorInput)input, WORKFLOW_EDITOR_ID);
                        if (part instanceof AbstractDiagramEditor) {
                            AbstractDiagramEditor editor = (AbstractDiagramEditor)part;
                            editor.setParentEditor(parent);
                        }
                    }
                    catch (PartInitException exception) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)exception);
                    }
                }
                catch (RuntimeException e) {
                    AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                }
            }
        };
        private IAction openWorkflowDetailEditorAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.OpenActivityDetailDiagram")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                try {
                    try {
                        IEditorPart parent = this.this$1.getPage().getActiveEditor();
                        ActivityDetailDiagramEditor.EditorInput input = new ActivityDetailDiagramEditor.EditorInput(BSActionBarContributor.access$6(this.this$1), BSActionBarContributor.access$7(this.this$1));
                        IEditorPart part = this.this$1.getPage().openEditor((IEditorInput)input, ACTIVITY_DETAIL_DIAGRAM_EDITOR_ID);
                        if (part instanceof AbstractDiagramEditor) {
                            AbstractDiagramEditor editor = (AbstractDiagramEditor)part;
                            editor.setParentEditor(parent);
                        }
                    }
                    catch (PartInitException exception) {
                        exception.printStackTrace();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
        private IAction openWPDependencyEditorAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.OpenWorkProductDependencyDiagram")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                try {
                    try {
                        IEditorPart parent = this.this$1.getPage().getActiveEditor();
                        BreakdownElementEditorInput input = new BreakdownElementEditorInput(this, BSActionBarContributor.access$6(this.this$1), BSActionBarContributor.access$7(this.this$1)){
                            final /* synthetic */ 10 this$2;
                            {
                                super($anonymous0, $anonymous1);
                                this.this$2 = var1_1;
                            }
                        };
                        IEditorPart part = this.this$1.getPage().openEditor((IEditorInput)input, WPDEPENDENCY_EDITOR_ID);
                        if (part instanceof AbstractDiagramEditor) {
                            AbstractDiagramEditor editor = (AbstractDiagramEditor)part;
                            editor.setParentEditor(parent);
                        }
                    }
                    catch (PartInitException exception) {
                        exception.printStackTrace();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }
        };
        private IAction replaceAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Replace")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 88->92)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.ClassFileField.dump(ClassFileField.java:76)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:66)
                 *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        private IAction contributeAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Contribute")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            /*
             * Exception decompiling
             */
            public void run() {
                /*
                 * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
                 * 
                 * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 3[TRYBLOCK] [2 : 88->92)] java.lang.Throwable
                 *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
                 *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
                 *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
                 *     at org.benf.cfr.reader.entities.Method.dump(Method.java:598)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperAnonymousInner.dumpWithArgs(ClassFileDumperAnonymousInner.java:87)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.ConstructorInvokationAnonymousInner.dumpInner(ConstructorInvokationAnonymousInner.java:82)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dumpWithOuterPrecedence(AbstractExpression.java:142)
                 *     at org.benf.cfr.reader.bytecode.analysis.parse.expression.AbstractExpression.dump(AbstractExpression.java:98)
                 *     at org.benf.cfr.reader.state.TypeUsageCollectingDumper.dump(TypeUsageCollectingDumper.java:194)
                 *     at org.benf.cfr.reader.entities.ClassFileField.dump(ClassFileField.java:76)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:66)
                 *     at org.benf.cfr.reader.entities.ClassFile.dumpNamedInnerClasses(ClassFile.java:1161)
                 *     at org.benf.cfr.reader.entities.classfilehelpers.ClassFileDumperNormal.dump(ClassFileDumperNormal.java:71)
                 *     at org.benf.cfr.reader.entities.ClassFile.dump(ClassFile.java:1167)
                 *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:952)
                 *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
                 *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
                 *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
                 *     at org.benf.cfr.reader.Main.main(Main.java:54)
                 */
                throw new IllegalStateException("Decompilation failed");
            }
        };
        private IAction suppressAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Suppress")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                Collection duplicates = ProcessUtil.getDuplicateDescriptorsAfterSuppress((Collection)BSActionBarContributor.access$8(this.this$1));
                if (!duplicates.isEmpty()) {
                    MultiStatus status = new MultiStatus(AuthoringUIPlugin.getDefault().getId(), 0, "", null);
                    Iterator<E> iter = duplicates.iterator();
                    while (iter.hasNext()) {
                        Descriptor desc = (Descriptor)iter.next();
                        String descTxt = String.valueOf(TngUtil.getTypeText((EObject)desc)) + ": " + desc.getPresentationName();
                        status.add((IStatus)new Status(1, AuthoringUIPlugin.getDefault().getId(), 0, descTxt, null));
                    }
                    if (AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(this.getText(), AuthoringUIResources.getString("AuthoringUI.ProcessEditor.promptToDeleteBeforeSuppress"), (IStatus)status) == 1) {
                        return;
                    }
                    try {
                        ProcessDeleteAction.delete(duplicates);
                    }
                    catch (OperationCanceledException operationCanceledException) {
                        return;
                    }
                }
                ProcessEditor editor = (ProcessEditor)this.this$1.getActiveEditor();
                BusyIndicator.showWhile((Display)this.this$1.getActiveEditor().getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(this, editor){
                    final /* synthetic */ 14 this$2;
                    private final /* synthetic */ ProcessEditor val$editor;
                    {
                        this.this$2 = var1_1;
                        this.val$editor = processEditor;
                    }

                    public void run() {
                        if (BSActionBarContributor.access$7(14.access$0(this.this$2)).suppress(BSActionBarContributor.access$8(14.access$0(this.this$2)))) {
                            if (ProcessEditor.access$10(BSActionBarContributor.access$8(14.access$0(this.this$2)))) {
                                this.val$editor.refreshAllProcessEditors();
                            } else {
                                this.val$editor.doRefreshAll(false);
                            }
                        }
                        this.val$editor.firePropertyChange(257);
                    }
                });
                BSActionBarContributor.access$9(this.this$1).setEnabled(BSActionBarContributor.access$7(this.this$1).canReveal((Collection)BSActionBarContributor.access$8(this.this$1)));
                BSActionBarContributor.access$10(this.this$1).setEnabled(BSActionBarContributor.access$7(this.this$1).canSuppress((Collection)BSActionBarContributor.access$8(this.this$1)));
                BSActionBarContributor.access$11(this.this$1).setEnabled(BSActionBarContributor.access$11(this.this$1).updateSelection((IStructuredSelection)new StructuredSelection(BSActionBarContributor.access$8(this.this$1).toArray())));
                BSActionBarContributor.access$12(this.this$1).setEnabled(BSActionBarContributor.access$12(this.this$1).updateSelection((IStructuredSelection)new StructuredSelection(BSActionBarContributor.access$8(this.this$1).toArray())));
            }

            static /* synthetic */ BSActionBarContributor access$0(14 var0) {
                return var0.this$1;
            }
        };
        private UpdateSuppressionFromBaseAction updateSuppressionFromBaseAction = new UpdateSuppressionFromBaseAction();
        private IAction revealAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Reveal")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                if (ProcessEditor.canReveal(BSActionBarContributor.access$8(this.this$1), BSActionBarContributor.access$13(this.this$1), BSActionBarContributor.access$7(this.this$1))) {
                    ProcessEditor editor = (ProcessEditor)this.this$1.getActiveEditor();
                    BusyIndicator.showWhile((Display)this.this$1.getActiveEditor().getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(this, editor){
                        final /* synthetic */ 16 this$2;
                        private final /* synthetic */ ProcessEditor val$editor;
                        {
                            this.this$2 = var1_1;
                            this.val$editor = processEditor;
                        }

                        public void run() {
                            if (BSActionBarContributor.access$7(16.access$0(this.this$2)).reveal(BSActionBarContributor.access$8(16.access$0(this.this$2)))) {
                                if (ProcessEditor.access$10(BSActionBarContributor.access$8(16.access$0(this.this$2)))) {
                                    this.val$editor.refreshAllProcessEditors();
                                } else {
                                    this.val$editor.doRefreshAll(false);
                                }
                            }
                            this.val$editor.firePropertyChange(257);
                        }
                    });
                    BSActionBarContributor.access$9(this.this$1).setEnabled(BSActionBarContributor.access$7(this.this$1).canReveal((Collection)BSActionBarContributor.access$8(this.this$1)));
                    BSActionBarContributor.access$10(this.this$1).setEnabled(BSActionBarContributor.access$7(this.this$1).canSuppress((Collection)BSActionBarContributor.access$8(this.this$1)));
                    BSActionBarContributor.access$11(this.this$1).setEnabled(BSActionBarContributor.access$11(this.this$1).updateSelection((IStructuredSelection)new StructuredSelection(BSActionBarContributor.access$8(this.this$1).toArray())));
                    BSActionBarContributor.access$12(this.this$1).setEnabled(BSActionBarContributor.access$12(this.this$1).updateSelection((IStructuredSelection)new StructuredSelection(BSActionBarContributor.access$8(this.this$1).toArray())));
                }
            }

            static /* synthetic */ BSActionBarContributor access$0(16 var0) {
                return var0.this$1;
            }
        };
        private IBSItemProvider bsItemProvider = null;
        private Object selectedElement = null;
        private Activity selectedActivity = null;
        private BreakdownElement selectedBreakdownElement = null;
        private List selection;
        private IAction suppressDiagramAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Suppress2")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public boolean isEnabled() {
                if (!super.isEnabled()) {
                    return false;
                }
                return !(BSActionBarContributor.access$0(this.this$1) instanceof BreakdownElementWrapperItemProvider) || !((BreakdownElementWrapperItemProvider)BSActionBarContributor.access$0(this.this$1)).isReadOnly();
            }

            public void run() {
                if (!BSActionBarContributor.access$14(this.this$1)) {
                    return;
                }
                ArrayContentProvider contentProvider = new ArrayContentProvider();
                AdapterFactoryLabelProvider labelProvider = new AdapterFactoryLabelProvider(this, (AdapterFactory)TngUtil.umaItemProviderAdapterFactory){
                    final /* synthetic */ 18 this$2;
                    {
                        super($anonymous0);
                        this.this$2 = var1_1;
                    }

                    public String getColumnText(Object object, int columnIndex) {
                        return GraphicalDataHelper.getDiagramTypeText((Diagram)((Diagram)object));
                    }
                };
                Collection diagrams = GraphicalDataHelper.getDiagrams((Activity)BSActionBarContributor.access$1(this.this$1));
                ArrayList<Diagram> unsuppressedDiagrams = new ArrayList<Diagram>();
                Iterator<E> iter = diagrams.iterator();
                while (iter.hasNext()) {
                    Diagram diagram = (Diagram)iter.next();
                    if (diagram.getSuppressed().booleanValue()) continue;
                    unsuppressedDiagrams.add(diagram);
                }
                ListSelectionDialog dlg = new ListSelectionDialog(BSActionBarContributor.access$2(this.this$1).getEditorSite().getShell(), (Object)diagrams, (IStructuredContentProvider)contentProvider, (ILabelProvider)labelProvider, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.SuppressDialog.Message"));
                dlg.setInitialElementSelections(unsuppressedDiagrams);
                dlg.setTitle(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.SuppressDialog.Title"));
                dlg.setBlockOnOpen(true);
                dlg.open();
                Object[] diagramsToReveal = dlg.getResult();
                if (diagramsToReveal == null) {
                    return;
                }
                boolean changed = true;
                if (diagramsToReveal.length == unsuppressedDiagrams.size()) {
                    int i = 0;
                    while (i < diagramsToReveal.length) {
                        if (!unsuppressedDiagrams.contains(diagramsToReveal[i])) {
                            changed = false;
                            break;
                        }
                        ++i;
                    }
                }
                if (changed) {
                    Diagram diagram;
                    Iterator<E> iter2 = diagrams.iterator();
                    while (iter2.hasNext()) {
                        diagram = (Diagram)iter2.next();
                        diagram.setSuppressed(Boolean.TRUE);
                    }
                    int i = 0;
                    while (i < diagramsToReveal.length) {
                        diagram = (Diagram)diagramsToReveal[i];
                        diagram.setSuppressed(Boolean.FALSE);
                        ++i;
                    }
                    BSActionBarContributor.access$15(this.this$1);
                }
            }
        };
        private IAction suppressAllDiagrams = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.SuppressAll")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                BSActionBarContributor.access$16(this.this$1, true);
            }
        };
        private IAction revealAllDiagrams = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.RevealAll")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                BSActionBarContributor.access$16(this.this$1, false);
            }
        };
        private IAction addAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Add")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                AdapterFactory adapterFactory = BSActionBarContributor.access$13(this.this$1);
                if (adapterFactory != null) {
                    Adapter adapter;
                    List selection;
                    MethodConfiguration config = LibraryProcessor.getInstance().getCurrentMethodConfiguration();
                    if (config == null) {
                        config = TngUtil.getOwningProcess((BreakdownElement)BSActionBarContributor.access$3(this.this$1)).getDefaultContext();
                    }
                    if ((selection = DialogHelper.selectElementsFor(BSActionBarContributor.access$3(this.this$1), config, adapterFactory)) == null || selection.isEmpty()) {
                        return;
                    }
                    BreakdownElement breakdownElement = BSActionBarContributor.access$3(this.this$1);
                    Class<?> clazz = BSActionBarContributor.class$0;
                    if (clazz == null) {
                        try {
                            clazz = BSActionBarContributor.class$0 = Class.forName("org.eclipse.emf.edit.provider.IEditingDomainItemProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((adapter = adapterFactory.adapt((Notifier)breakdownElement, (Object)clazz)) instanceof IBSItemProvider) {
                        IResourceAwareCommand cmd = ((IBSItemProvider)adapter).createDropCommand((Object)BSActionBarContributor.access$3(this.this$1), selection);
                        BSActionBarContributor.access$4(this.this$1).execute(cmd);
                    }
                }
            }
        };
        private IAction copyActivityAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Copy")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                List selection;
                MethodConfiguration config = LibraryProcessor.getInstance().getCurrentMethodConfiguration();
                if (config == null) {
                    config = TngUtil.getOwningProcess((BreakdownElement)BSActionBarContributor.access$1(this.this$1)).getDefaultContext();
                }
                if ((selection = DialogHelper.selectActivitiesFor(BSActionBarContributor.access$1(this.this$1), config, 1)) == null || selection.isEmpty()) {
                    return;
                }
                ActivityDropCommand cmd = new ActivityDropCommand(BSActionBarContributor.access$1(this.this$1), selection, null, BSActionBarContributor.access$13(this.this$1));
                cmd.setType(1);
                BSActionBarContributor.access$4(this.this$1).execute((IResourceAwareCommand)cmd);
            }
        };
        private IAction extendActivityAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Extend")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                List selection;
                MethodConfiguration config = LibraryProcessor.getInstance().getCurrentMethodConfiguration();
                if (config == null) {
                    config = TngUtil.getOwningProcess((BreakdownElement)BSActionBarContributor.access$1(this.this$1)).getDefaultContext();
                }
                if ((selection = DialogHelper.selectActivitiesFor(BSActionBarContributor.access$1(this.this$1), config, 2)) == null || selection.isEmpty()) {
                    return;
                }
                ActivityDropCommand cmd = new ActivityDropCommand(BSActionBarContributor.access$1(this.this$1), selection, null, BSActionBarContributor.access$13(this.this$1));
                cmd.setType(2);
                BSActionBarContributor.access$4(this.this$1).execute((IResourceAwareCommand)cmd);
            }
        };
        private IAction deepCopyActivityAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.action.deepCopy")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                List selection;
                MethodConfiguration config = LibraryProcessor.getInstance().getCurrentMethodConfiguration();
                if (config == null) {
                    config = TngUtil.getOwningProcess((BreakdownElement)BSActionBarContributor.access$1(this.this$1)).getDefaultContext();
                }
                if ((selection = DialogHelper.selectActivitiesFor(BSActionBarContributor.access$1(this.this$1), config, 3)) == null || selection.isEmpty()) {
                    return;
                }
                ActivityDropCommand cmd = new ActivityDropCommand(BSActionBarContributor.access$1(this.this$1), selection, null, BSActionBarContributor.access$13(this.this$1));
                cmd.setType(3);
                BSActionBarContributor.access$4(this.this$1).execute((IResourceAwareCommand)cmd);
            }
        };
        private Object selectedObject;
        private IAction expandAllAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessFormEditor.expanAllActionLabel")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                Viewer viewer = ProcessEditor.access$7((ProcessEditor)BSActionBarContributor.access$2(this.this$1));
                if (viewer instanceof TreeViewer) {
                    ((TreeViewer)viewer).expandToLevel(BSActionBarContributor.access$6(this.this$1), -1);
                }
            }
        };
        private IAction collapseAllAction = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessFormEditor.collapseAllActionLabel")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                Viewer viewer = ProcessEditor.access$7((ProcessEditor)BSActionBarContributor.access$2(this.this$1));
                if (viewer instanceof TreeViewer) {
                    ((TreeViewer)viewer).collapseToLevel(BSActionBarContributor.access$6(this.this$1), -1);
                }
            }
        };
        private SynchronizationAction manualSynchronizeAction = new SynchronizationAction();
        private ProcessAutoSynchronizeAction autoSynchronize = new ProcessAutoSynchronizeAction(this){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(this.getText(), AuthoringUIResources.getString("AuthoringUI.ProcessEditor.confirmAutoSynch"))) {
                    return;
                }
                super.run();
            }
        };
        private IAction showInLibraryView = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.ShowLinkedElementinLibraryView"), AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/show_linked_element.gif")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                MethodElement linkedElement = ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)BSActionBarContributor.access$3(this.this$1)));
                if (linkedElement != null) {
                    Display.getCurrent().asyncExec(new Runnable(this, linkedElement){
                        final /* synthetic */ 29 this$2;
                        private final /* synthetic */ Object val$linkedElement;
                        {
                            this.this$2 = var1_1;
                            this.val$linkedElement = object;
                        }

                        public void run() {
                            LibraryView.getView().setSelectionToViewer(this.val$linkedElement);
                        }
                    });
                }
            }
        };
        private IAction assignUserDiagram = new Action(this, AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.AssignUserDiagram")){
            final /* synthetic */ BSActionBarContributor this$1;
            {
                this.this$1 = bSActionBarContributor;
            }

            public void run() {
                UserDefinedDiagramDialog dialog = new UserDefinedDiagramDialog(Display.getCurrent().getActiveShell(), BSActionBarContributor.access$2(this.this$1), BSActionBarContributor.access$1(this.this$1), BSActionBarContributor.access$17(this.this$1).getDefaultContext());
                dialog.open();
            }
        };
        private boolean oldLocked;
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;

        public BSActionBarContributor() {
            super(AuthoringUIResources.getString("AuthoringUI.ProcessEditor"));
            this.moveUpAction.setDisabledImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/move_up_disabled.gif"));
            this.moveDownAction.setDisabledImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/move_down_disabled.gif"));
            this.showInLibraryView.setDisabledImageDescriptor(AuthoringUIPlugin.getDefault().getImageDescriptor("full/etool16/show_linked_element_disabled.gif"));
        }

        protected void registerAction(IAction action) {
            if (action != null && !this.registeredActions.contains(action)) {
                this.registeredActions.add(action);
            }
        }

        private void registerActions() {
            this.registerAction((IAction)this.autoSynchronize);
            this.registerAction((IAction)this.manualSynchronizeAction);
            this.registerAction((IAction)this.updateSuppressionFromBaseAction);
        }

        public void update() {
            super.update();
            ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
            ISelection selection = selectionProvider.getSelection();
            StructuredSelection structuredSelection = selection instanceof IStructuredSelection ? (IStructuredSelection)selection : StructuredSelection.EMPTY;
            Iterator iter = this.registeredActions.iterator();
            while (iter.hasNext()) {
                Object action = iter.next();
                if (!(action instanceof CommandActionHandler)) continue;
                ((CommandActionHandler)action).updateSelection((IStructuredSelection)structuredSelection);
            }
        }

        public void activate() {
            this.manualSynchronizeAction.setProcess(this.getProcess());
            ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
            Iterator iter = this.registeredActions.iterator();
            while (iter.hasNext()) {
                Object action = iter.next();
                if (action instanceof IWorkbenchPartAction) {
                    ((IWorkbenchPartAction)action).setActiveWorkbenchPart((IWorkbenchPart)this.activeEditor);
                }
                if (!(action instanceof ISelectionChangedListener)) continue;
                selectionProvider.addSelectionChangedListener((ISelectionChangedListener)action);
            }
            super.activate();
            this.setActivePage(this.activeEditor);
        }

        public void deactivate() {
            super.deactivate();
            ISelectionProvider selectionProvider = this.activeEditor instanceof ISelectionProvider ? (ISelectionProvider)this.activeEditor : this.activeEditor.getEditorSite().getSelectionProvider();
            Iterator iter = this.registeredActions.iterator();
            while (iter.hasNext()) {
                Object action = iter.next();
                if (action instanceof IWorkbenchPartAction) {
                    ((IWorkbenchPartAction)action).setActiveWorkbenchPart(null);
                }
                if (!(action instanceof ISelectionChangedListener)) continue;
                selectionProvider.removeSelectionChangedListener((ISelectionChangedListener)action);
            }
        }

        public void init(IActionBars actionBars) {
            super.init(actionBars);
            this.registerActions();
            this.contributeToToolBar(actionBars.getToolBarManager());
        }

        private IActionManager getActionManager() {
            return ((MethodElementEditor)this.activeEditor).getActionManager();
        }

        private AdapterFactory getAdapterFactory() {
            return ((ProcessEditor)this.activeEditor).getAdapterFactory();
        }

        private void setAllDiagramSuppressed(boolean suppressed) {
            String title = AuthoringUIResources.getString("AuthoringUI.processFormEditorSaveDialog.title");
            String message = AuthoringUIResources.getString("AuthoringUI.processFormEditorSaveDialog.message1");
            if (!AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, message)) {
                return;
            }
            BusyIndicator.showWhile((Display)this.activeEditor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(this, suppressed){
                final /* synthetic */ BSActionBarContributor this$1;
                private final /* synthetic */ boolean val$suppressed;
                {
                    this.this$1 = bSActionBarContributor;
                    this.val$suppressed = bl;
                }

                public void run() {
                    GraphicalDataHelper.setAllDiagramSuppressed((Process)BSActionBarContributor.access$17(this.this$1), (boolean)this.val$suppressed);
                    BSActionBarContributor.access$18(this.this$1);
                }
            });
        }

        private boolean promptSaveActiveEditor() {
            String title = AuthoringUIResources.getString("AuthoringUI.processFormEditorSaveDialog.title");
            String message = AuthoringUIResources.getString("AuthoringUI.processFormEditorSaveDialog.message2");
            if (this.activeEditor.isDirty()) {
                return AuthoringUIPlugin.getDefault().getMsgDialog().displayConfirmation(title, message);
            }
            return true;
        }

        private void saveActiveEditor() {
            BusyIndicator.showWhile((Display)this.activeEditor.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                final /* synthetic */ BSActionBarContributor this$1;
                {
                    this.this$1 = bSActionBarContributor;
                }

                public void run() {
                    BSActionBarContributor.access$18(this.this$1);
                }
            });
        }

        private void doSaveActiveEditor() {
            ((ProcessEditor)this.activeEditor).resourcesToSave.add(this.getProcess().eResource());
            this.activeEditor.doSave((IProgressMonitor)new NullProgressMonitor());
        }

        protected DeleteAction createDeleteAction() {
            return new ProcessDeleteAction(this){
                final /* synthetic */ BSActionBarContributor this$1;
                {
                    this.this$1 = bSActionBarContributor;
                }

                protected void saveCurrentEditor() {
                    if (BSActionBarContributor.access$2(this.this$1).isDirty()) {
                        BusyIndicator.showWhile((Display)BSActionBarContributor.access$2(this.this$1).getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                            final /* synthetic */ 34 this$2;
                            {
                                this.this$2 = var1_1;
                            }

                            public void run() {
                                BSActionBarContributor.access$2(34.access$0(this.this$2)).doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                    }
                }

                static /* synthetic */ BSActionBarContributor access$0(34 var0) {
                    return var0.this$1;
                }
            };
        }

        protected CutAction createCutAction() {
            return new CutAction(this){
                final /* synthetic */ BSActionBarContributor this$1;
                {
                    this.this$1 = bSActionBarContributor;
                }

                public boolean updateSelection(IStructuredSelection selection) {
                    return super.updateSelection(ProcessDeleteAction.filterSelection(selection));
                }
            };
        }

        protected PasteAction createPasteAction() {
            return new PasteAction(this){
                final /* synthetic */ BSActionBarContributor this$1;
                {
                    this.this$1 = bSActionBarContributor;
                }

                public boolean updateSelection(IStructuredSelection selection) {
                    return super.updateSelection(ProcessDeleteAction.filterSelection(selection));
                }
            };
        }

        protected CopyAction createCopyAction() {
            return new CopyAction(this){
                final /* synthetic */ BSActionBarContributor this$1;
                {
                    this.this$1 = bSActionBarContributor;
                }

                public void run() {
                    if (this.domain instanceof TraceableAdapterFactoryEditingDomain) {
                        ((TraceableAdapterFactoryEditingDomain)this.domain).resetCopyMaps();
                    }
                    super.run();
                }

                public boolean updateSelection(IStructuredSelection selection) {
                    return super.updateSelection(selection);
                }
            };
        }

        protected void addGlobalActions(IMenuManager menuManager) {
            super.addGlobalActions(menuManager);
            menuManager.insertAfter("additions", (IContributionItem)new Separator("fixed-additions"));
        }

        public void contributeToToolBar(IToolBarManager toolBarManager) {
            super.contributeToToolBar(toolBarManager);
            this.moveUpAction.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.MoveUp"));
            this.moveDownAction.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.MoveDown"));
            this.showInLibraryView.setToolTipText(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.ShowLinkedElementinLibraryView"));
            toolBarManager.add(this.moveUpAction);
            toolBarManager.add(this.moveDownAction);
            toolBarManager.add(this.showInLibraryView);
        }

        public void menuAboutToShow(IMenuManager menuManager) {
            IFormPage activePage = ((ProcessEditor)this.activeEditor).getActivePageInstance();
            if (activePage instanceof ProcessBreakdownStructureFormPage && ((ProcessBreakdownStructureFormPage)activePage).basicIsReadOnly()) {
                menuManager.add((IContributionItem)new Separator("additions"));
                if (this.showInLibraryView.isEnabled()) {
                    menuManager.add(this.showInLibraryView);
                }
                if (this.bsItemProvider != null) {
                    menuManager.add(this.expandAllAction);
                    menuManager.add(this.collapseAllAction);
                }
                menuManager.add((IContributionItem)new Separator());
                this.refreshViewerAction.setEnabled(this.refreshViewerAction.isEnabled());
                menuManager.add(this.refreshViewerAction);
                menuManager.add(this.showPropertiesViewAction);
                return;
            }
            ISelectionProvider selectionProvider = (ISelectionProvider)this.activeEditor;
            if (this.selectedActivity == null && (selectionProvider.getSelection() == null || selectionProvider.getSelection().isEmpty())) {
                this.selectionChanged(new SelectionChangedEvent(selectionProvider, (ISelection)new StructuredSelection((Object)this.getProcess())));
            }
            boolean isRolledUP = this.bsItemProvider != null && this.bsItemProvider.isRolledUp();
            super.setEnabled(!isRolledUP);
            super.menuAboutToShow(menuManager);
            menuManager.insertAfter("fixed-additions", (IContributionItem)new Separator("open"));
            if (this.bsItemProvider instanceof BreakdownElementWrapperItemProvider && TngUtil.unwrap((Object)this.bsItemProvider) instanceof Activity) {
                menuManager.insertBefore("additions", this.contributeAction);
                menuManager.insertBefore("additions", this.replaceAction);
            }
            if (!isRolledUP && this.createChildActions != null && !this.createChildActions.isEmpty()) {
                menuManager.insertBefore("additions", this.addAction);
            }
            if (this.revealAction.isEnabled()) {
                menuManager.insertBefore("fixed-additions", this.revealAction);
            }
            if (this.suppressAction.isEnabled()) {
                menuManager.insertBefore("fixed-additions", this.suppressAction);
            }
            if (this.updateSuppressionFromBaseAction.isEnabled()) {
                menuManager.insertBefore("fixed-additions", (IAction)this.updateSuppressionFromBaseAction);
            }
            if (this.selectedBreakdownElement != null && this.bsItemProvider != null) {
                if (this.moveUpAction.isEnabled()) {
                    menuManager.insertBefore("fixed-additions", this.moveUpAction);
                }
                if (this.moveDownAction.isEnabled()) {
                    menuManager.insertBefore("fixed-additions", this.moveDownAction);
                }
            }
            if (this.showInLibraryView.isEnabled()) {
                menuManager.appendToGroup("open", this.showInLibraryView);
            }
            if (this.selectedActivity != null && this.bsItemProvider != null) {
                if (this.bsItemProvider.isRolledUp()) {
                    this.rollupAction.setText(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.RollDown"));
                } else {
                    this.rollupAction.setText(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.RollUp"));
                }
                menuManager.appendToGroup("open", this.rollupAction);
            }
            if (this.selectedObject instanceof Activity) {
                MenuManager reuseSubMenu = new MenuManager(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.ApplyPattern"));
                reuseSubMenu.add(this.copyActivityAction);
                reuseSubMenu.add(this.extendActivityAction);
                menuManager.insertBefore("additions", (IContributionItem)reuseSubMenu);
            }
            if (this.autoSynchronize.isEnabled()) {
                menuManager.insertBefore("additions", (IAction)this.autoSynchronize);
            }
            if (this.manualSynchronizeAction.isEnabled()) {
                menuManager.insertBefore("additions", (IAction)this.manualSynchronizeAction);
            }
            if (!(this.selectedElement instanceof Milestone)) {
                MenuManager diagramSubMenu = new MenuManager(AuthoringUIResources.getString("AuthoringUI.ProcessEditor.Action.Diagrams"));
                if (this.selectedActivity != null) {
                    if (this.selectedActivity.getVariabilityBasedOnElement() != null) {
                        menuManager.appendToGroup("open", this.openBaseActivity);
                    }
                    diagramSubMenu.add(this.openWorkflowEditorAction);
                    diagramSubMenu.add(this.openWorkflowDetailEditorAction);
                    diagramSubMenu.add(this.openWPDependencyEditorAction);
                    diagramSubMenu.add(this.suppressDiagramAction);
                    diagramSubMenu.add(this.assignUserDiagram);
                }
                if (this.selectedActivity == this.getProcess()) {
                    diagramSubMenu.add(this.suppressAllDiagrams);
                    diagramSubMenu.add(this.revealAllDiagrams);
                }
                menuManager.appendToGroup("open", (IContributionItem)diagramSubMenu);
            }
            if (this.bsItemProvider != null) {
                menuManager.appendToGroup("open", this.expandAllAction);
                menuManager.appendToGroup("open", this.collapseAllAction);
            }
        }

        private Process getProcess() {
            return ((ProcessComponent)((MethodElementEditorInput)this.activeEditor.getEditorInput()).getMethodElement()).getProcess();
        }

        private Suppression getSuppression() {
            return ((ProcessEditor)this.activeEditor).suppression;
        }

        private void depopulateDynamicMenuItems() {
            if (this.createChildMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createChildMenuManager, this.createChildActions);
            }
            if (this.createSiblingMenuManager != null) {
                this.depopulateManager((IContributionManager)this.createSiblingMenuManager, this.createSiblingActions);
            }
            this.createChildActions = null;
            this.createSiblingActions = null;
        }

        private void setActionState() {
            if (this.locked) {
                this.pasteAction.setEnabled(false);
                this.cutAction.setEnabled(false);
                this.deleteAction.setEnabled(false);
                this.autoSynchronize.setEnabled(false);
                this.manualSynchronizeAction.setEnabled(false);
                this.updateSuppressionFromBaseAction.setEnabled(false);
            } else if (!this.oldLocked) {
                IStructuredSelection selection = (IStructuredSelection)this.selectionProvider.getSelection();
                this.cutAction.setEnabled(this.cutAction.updateSelection(selection));
                this.pasteAction.setEnabled(this.pasteAction.updateSelection(selection));
                this.deleteAction.setEnabled(this.deleteAction.updateSelection(selection));
                this.autoSynchronize.setEnabled(this.autoSynchronize.updateSelection(selection));
                this.manualSynchronizeAction.setEnabled(this.manualSynchronizeAction.updateSelection(selection));
                this.updateSuppressionFromBaseAction.setEnabled(this.updateSuppressionFromBaseAction.updateSelection(selection));
            }
            boolean enabled = !this.locked;
            this.addAction.setEnabled(enabled);
            this.contributeAction.setEnabled(enabled);
            this.replaceAction.setEnabled(enabled);
            this.revealAllDiagrams.setEnabled(enabled);
            this.suppressAllDiagrams.setEnabled(enabled);
            this.suppressDiagramAction.setEnabled(enabled);
            this.copyActivityAction.setEnabled(enabled);
            this.extendActivityAction.setEnabled(enabled);
            this.deepCopyActivityAction.setEnabled(enabled);
        }

        protected Collection generateCreateChildActions(Collection descriptors, ISelection selection) {
            if (this.locked) {
                return null;
            }
            return super.generateCreateChildActions(descriptors, selection);
        }

        protected Collection generateCreateSiblingActions(Collection descriptors, ISelection selection) {
            if (this.locked) {
                return null;
            }
            return super.generateCreateSiblingActions(descriptors, selection);
        }

        public void selectionChanged(SelectionChangedEvent event) {
            ISelection sel = event.getSelection();
            if (sel instanceof IStructuredSelection) {
                IStructuredSelection structuredSelection = (IStructuredSelection)sel;
                this.oldLocked = this.locked;
                this.locked = ViewHelper.isLocked(structuredSelection);
                this.selection = ((IStructuredSelection)sel).toList();
                if (this.selection.size() == 1) {
                    this.selectedObject = ((IStructuredSelection)sel).getFirstElement();
                    Object obj = TngUtil.unwrap((Object)this.selectedObject);
                    super.selectionChanged(event);
                    this.selectedElement = obj;
                    this.selectedActivity = obj instanceof Activity ? (Activity)obj : null;
                    AdapterFactoryEditingDomain domain = (AdapterFactoryEditingDomain)((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
                    AdapterFactory adapterFactory = domain.getAdapterFactory();
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.emf.edit.provider.ITreeItemContentProvider");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this.bsItemProvider = (IBSItemProvider)adapterFactory.adapt(this.selectedObject, (Object)clazz);
                    this.selectedBreakdownElement = obj instanceof BreakdownElement ? (BreakdownElement)obj : null;
                } else {
                    this.depopulateDynamicMenuItems();
                    this.bsItemProvider = null;
                    this.selectedElement = null;
                    this.selectedActivity = null;
                    this.selectedBreakdownElement = null;
                    this.selectedObject = null;
                }
                this.updateActions();
            } else {
                this.depopulateDynamicMenuItems();
                this.bsItemProvider = null;
                this.selectedElement = null;
                this.selectedActivity = null;
                this.selectedBreakdownElement = null;
            }
        }

        private void updateActions() {
            this.showInLibraryView.setEnabled(this.selectedBreakdownElement instanceof Descriptor && ProcessUtil.getAssociatedElement((Descriptor)((Descriptor)this.selectedBreakdownElement)) != null);
            if (!this.locked && this.selection != null && !this.selection.isEmpty()) {
                if (this.selection.size() == 1) {
                    if (this.getSuppression().canReveal((Collection)this.selection)) {
                        this.revealAction.setEnabled(true);
                        this.suppressAction.setEnabled(false);
                    } else if (this.getSuppression().canSuppress((Collection)this.selection)) {
                        this.suppressAction.setEnabled(true);
                        this.revealAction.setEnabled(false);
                    } else {
                        this.revealAction.setEnabled(false);
                        this.suppressAction.setEnabled(false);
                    }
                } else {
                    this.revealAction.setEnabled(this.getSuppression().canReveal((Collection)this.selection));
                    this.suppressAction.setEnabled(this.getSuppression().canSuppress((Collection)this.selection));
                }
            } else {
                this.revealAction.setEnabled(false);
                this.suppressAction.setEnabled(false);
            }
            if (!this.locked && this.selectedBreakdownElement != null && this.bsItemProvider != null) {
                this.moveUpAction.setEnabled(!this.bsItemProvider.isFirstElement((Object)this.selectedBreakdownElement));
                this.moveDownAction.setEnabled(!this.bsItemProvider.isLastElement((Object)this.selectedBreakdownElement));
            } else {
                this.moveUpAction.setEnabled(false);
                this.moveDownAction.setEnabled(false);
            }
            if (this.selectedObject instanceof Activity || this.selectedObject instanceof ActivityWrapperItemProvider) {
                this.setActionStateForADD();
            }
            this.setActionState();
        }

        public void setActivePage(IEditorPart part) {
            if (this.activeEditor != null) {
                int page = ((ProcessEditor)this.activeEditor).getActivePage();
                IActionBars actionBars = this.activeEditor.getEditorSite().getActionBars();
                if (page == 0) {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), null);
                    actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), null);
                } else {
                    actionBars.setGlobalActionHandler(ActionFactory.DELETE.getId(), (IAction)this.deleteAction);
                    actionBars.setGlobalActionHandler(ActionFactory.CUT.getId(), (IAction)this.cutAction);
                    actionBars.setGlobalActionHandler(ActionFactory.COPY.getId(), (IAction)this.copyAction);
                    actionBars.setGlobalActionHandler(ActionFactory.PASTE.getId(), (IAction)this.pasteAction);
                    actionBars.setGlobalActionHandler(ActionFactory.UNDO.getId(), (IAction)this.undoAction);
                    actionBars.setGlobalActionHandler(ActionFactory.REDO.getId(), (IAction)this.redoAction);
                }
                actionBars.updateActionBars();
            }
        }

        protected void doRefresh() {
            AdapterFactory adapterFactory = this.getAdapterFactory();
            if (adapterFactory == TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory() || adapterFactory == TngAdapterFactory.INSTANCE.getProcessComposedAdapterFactory()) {
                Process proc = this.getProcess();
                ProcessUtil.updateIDs((AdapterFactory)adapterFactory, (Process)proc);
                ProcessUtil.refreshPredeccessorLists((AdapterFactory)adapterFactory, (Process)proc);
            }
            super.doRefresh();
        }

        private void refreshMoveButtonActions() {
            if (this.selectedBreakdownElement != null && this.bsItemProvider != null) {
                if (!this.bsItemProvider.isFirstElement((Object)this.selectedBreakdownElement)) {
                    this.moveUpAction.setEnabled(true);
                } else {
                    this.moveUpAction.setEnabled(false);
                }
                if (!this.bsItemProvider.isLastElement((Object)this.selectedBreakdownElement)) {
                    this.moveDownAction.setEnabled(true);
                } else {
                    this.moveDownAction.setEnabled(false);
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        private void setActionStateForADD() {
            block9: {
                this.openWorkflowDetailEditorAction.setEnabled(false);
                this.openWorkflowEditorAction.setEnabled(true);
                this.openWPDependencyEditorAction.setEnabled(true);
                if (this.selectedObject == null) break block9;
                activity = null;
                list = new ArrayList<E>();
                if (this.selectedObject instanceof Activity) {
                    activity = this.selectedActivity;
                } else if (this.selectedObject instanceof ActivityWrapperItemProvider) {
                    activity = (Activity)((ActivityWrapperItemProvider)this.selectedObject).getValue();
                }
                if (activity != null) ** GOTO lbl19
                return;
lbl-1000:
                // 1 sources

                {
                    ve = activity.getVariabilityBasedOnElement();
                    list.addAll(activity.getBreakdownElements());
                    if (ve == null || !(ve instanceof Activity)) break;
                    activity = (Activity)ve;
lbl19:
                    // 2 sources

                    ** while (!activity.getVariabilityType().equals((Object)VariabilityType.NA_LITERAL))
                }
lbl20:
                // 2 sources

                if ((diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 0, false)) == null && this.selectedObject instanceof ActivityWrapperItemProvider) {
                    this.openWorkflowEditorAction.setEnabled(false);
                }
                if ((diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 1, false)) == null && this.selectedObject instanceof ActivityWrapperItemProvider) {
                    this.openWPDependencyEditorAction.setEnabled(false);
                }
                list.addAll(activity.getBreakdownElements());
                diagram = GraphicalDataManager.getInstance().getUMADiagram(activity, 2, false);
                if (diagram == null && this.selectedObject instanceof ActivityWrapperItemProvider) {
                    this.openWorkflowDetailEditorAction.setEnabled(false);
                } else {
                    iterator = list.iterator();
                    while (iterator.hasNext()) {
                        obj = iterator.next();
                        if (!(obj instanceof TaskDescriptor) || this.getSuppression().isSuppressed(obj)) continue;
                        e = ((TaskDescriptor)obj).getPerformedPrimarilyBy();
                        domain = (AdapterFactoryEditingDomain)((IEditingDomainProvider)this.activeEditorPart).getEditingDomain();
                        factory = domain.getAdapterFactory();
                        if (!(factory instanceof ExposedAdapterFactory) || (filter = ((ExposedAdapterFactory)factory).getFilter()) == null || !filter.accept((Object)e) || this.getSuppression().isSuppressed((Object)e)) continue;
                        this.openWorkflowDetailEditorAction.setEnabled(true);
                        break;
                    }
                }
            }
        }

        static /* synthetic */ IBSItemProvider access$0(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.bsItemProvider;
        }

        static /* synthetic */ Activity access$1(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.selectedActivity;
        }

        static /* synthetic */ IEditorPart access$2(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.activeEditor;
        }

        static /* synthetic */ BreakdownElement access$3(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.selectedBreakdownElement;
        }

        static /* synthetic */ IActionManager access$4(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.getActionManager();
        }

        static /* synthetic */ void access$5(BSActionBarContributor bSActionBarContributor) {
            bSActionBarContributor.refreshMoveButtonActions();
        }

        static /* synthetic */ Object access$6(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.selectedObject;
        }

        static /* synthetic */ Suppression access$7(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.getSuppression();
        }

        static /* synthetic */ List access$8(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.selection;
        }

        static /* synthetic */ IAction access$9(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.revealAction;
        }

        static /* synthetic */ IAction access$10(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.suppressAction;
        }

        static /* synthetic */ ProcessAutoSynchronizeAction access$11(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.autoSynchronize;
        }

        static /* synthetic */ SynchronizationAction access$12(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.manualSynchronizeAction;
        }

        static /* synthetic */ AdapterFactory access$13(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.getAdapterFactory();
        }

        static /* synthetic */ boolean access$14(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.promptSaveActiveEditor();
        }

        static /* synthetic */ void access$15(BSActionBarContributor bSActionBarContributor) {
            bSActionBarContributor.saveActiveEditor();
        }

        static /* synthetic */ void access$16(BSActionBarContributor bSActionBarContributor, boolean bl) {
            bSActionBarContributor.setAllDiagramSuppressed(bl);
        }

        static /* synthetic */ Process access$17(BSActionBarContributor bSActionBarContributor) {
            return bSActionBarContributor.getProcess();
        }

        static /* synthetic */ void access$18(BSActionBarContributor bSActionBarContributor) {
            bSActionBarContributor.doSaveActiveEditor();
        }
    }

    private class ProcessEditorDropAdapter
    extends EditingDomainTableTreeViewerDropAdapter {
        public ProcessEditorDropAdapter(EditingDomain domain, Viewer viewer) {
            super(domain, viewer);
        }

        protected Object getDropTarget(Widget item) {
            Object target = super.getDropTarget(item);
            if (target == null && ProcessEditor.this.selectedProcessComponent != null) {
                target = ProcessEditor.this.selectedProcessComponent.getProcess();
            }
            return target;
        }

        public void drop(DropTargetEvent event) {
            if (ProcessEditor.this.currentViewer instanceof IActionTypeProvider) {
                ((IActionTypeProvider)ProcessEditor.this.currentViewer).setInputData((Object)new Point(event.x, event.y));
            }
            super.drop(event);
        }
    }
}

