/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.preferences;

import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.preferences.CommonPrefPage;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class DebugPrefPage
extends CommonPrefPage
implements IWorkbenchPreferencePage {
    int NUM_COLUMN = 3;
    private Composite composite_tab;
    private Button enableHealthCheck;

    protected Control createContents(Composite parent) {
        this.composite_tab = this.createComposite(parent, this.NUM_COLUMN);
        this.createLabel(this.composite_tab, " ", this.NUM_COLUMN);
        this.enableHealthCheck = new Button(this.composite_tab, 32);
        this.enableHealthCheck.setText(AuthoringUIResources.getString("AuthoringUI.enableHealthCheck.text"));
        this.createLabel(this.composite_tab, " ", this.NUM_COLUMN);
        this.createLine(this.composite_tab, this.NUM_COLUMN);
        this.initializeValues();
        return this.composite_tab;
    }

    public void init(IWorkbench workbench) {
    }

    protected void performDefaults() {
        super.performDefaults();
        this.initializeDefaults();
    }

    public boolean performOk() {
        this.storeValues();
        LibraryPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return LibraryPlugin.getDefault().getPreferenceStore();
    }

    private void storeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        store.setValue("org.eclipse.epf.library.edit.enable_health_check", this.enableHealthCheck.getSelection());
    }

    private void initializeDefaults() {
        IPreferenceStore store = this.getPreferenceStore();
        this.enableHealthCheck.setSelection(store.getDefaultBoolean("org.eclipse.epf.library.edit.enable_health_check"));
    }

    private void initializeValues() {
        IPreferenceStore store = this.getPreferenceStore();
        this.enableHealthCheck.setSelection(store.getBoolean("org.eclipse.epf.library.edit.enable_health_check"));
    }

    private Composite createComposite(Composite parent, int numColumns) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = numColumns;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        return composite;
    }
}

