/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.util;

import com.ibm.uma.ContentElement;
import com.ibm.uma.Deliverable;
import com.ibm.uma.Guidance;
import com.ibm.uma.MethodElement;
import com.ibm.uma.Practice;
import com.ibm.uma.VariabilityElement;
import com.ibm.uma.VariabilityType;
import com.ibm.uma.WorkProduct;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.ui.forms.widgets.FormToolkit;
import org.eclipse.ui.forms.widgets.ScrolledForm;

public class UIHelper {
    public static void setItems(Table table, ArrayList items) {
        table.removeAll();
        int i = 0;
        while (i < items.size()) {
            TableItem item = new TableItem(table, 0);
            item.setText((String)items.get(i));
            ++i;
        }
    }

    public static org.eclipse.swt.widgets.List createList(FormToolkit toolkit, Composite parent, int style) {
        org.eclipse.swt.widgets.List list = new org.eclipse.swt.widgets.List(parent, style);
        toolkit.adapt((Control)list, true, true);
        return list;
    }

    public static Object[] getSelectedGuidances(ContentElement contentElement) {
        List list = MethodElementUtil.getSelectedGuidances((EObject)contentElement);
        Iterator it = list.iterator();
        while (it.hasNext()) {
            Object obj = it.next();
            if (!(obj instanceof Practice)) continue;
            it.remove();
        }
        return list.toArray();
    }

    public static boolean isContributor(ContentElement element) {
        int type;
        if (element == null || element.getVariabilityBasedOnElement() == null) {
            return false;
        }
        VariabilityType vtype = element.getVariabilityType();
        return vtype != null && (type = vtype.getValue()) == 1;
    }

    private static String getFormPageTitlePrefixFor(MethodElement methodElement) {
        String elementLabel = LibraryUIText.getUIText((MethodElement)methodElement);
        if (methodElement instanceof WorkProduct) {
            return String.valueOf(LibraryUIText.TEXT_WORK_PRODUCT) + " (" + elementLabel + ")";
        }
        if (methodElement instanceof Guidance) {
            return String.valueOf(LibraryUIText.TEXT_GUIDANCE) + " (" + elementLabel + ")";
        }
        return elementLabel;
    }

    public static void setFormText(ScrolledForm form, MethodElement element) {
        if (form != null && !form.isDisposed()) {
            StringBuffer str = new StringBuffer();
            str.append(String.valueOf(UIHelper.getFormPageTitlePrefixFor(element)) + ": ");
            if (element instanceof VariabilityElement) {
                str.append(TngUtil.getLabel((VariabilityElement)((VariabilityElement)element), (String)"", (boolean)true));
            } else if (element.getName() != null) {
                str.append(element.getName());
            }
            form.setText(str.toString());
        }
    }

    public static boolean checkCircularDeliverables(Deliverable toBePart, Deliverable deliverable) {
        List deliverables = toBePart.getDeliveredWorkProducts();
        if (deliverables != null && deliverables.size() > 0) {
            if (deliverables.contains(deliverable)) {
                return false;
            }
            Iterator iterator = deliverables.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Deliverable)) continue;
                return UIHelper.checkCircularDeliverables((Deliverable)obj, deliverable);
            }
        }
        return true;
    }

    public static void deliverablePartsChain(Deliverable e, List roots) {
        List list = e.getDeliveredWorkProducts();
        if (list != null && list.size() > 0) {
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                Object obj = iterator.next();
                if (!(obj instanceof Deliverable)) continue;
                roots.add(obj);
                UIHelper.deliverablePartsChain((Deliverable)obj, roots);
            }
        }
    }
}

