/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import com.ibm.uma.MethodLibrary;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.ui.viewer.IViewerProvider;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.emf.edit.domain.EditingDomain;
import org.eclipse.emf.edit.domain.IEditingDomainProvider;
import org.eclipse.emf.edit.provider.ComposedAdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.actions.ILibraryActionBarContributor;
import org.eclipse.epf.authoring.ui.views.SaveableLibraryViewPart;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.services.LibraryProcessor;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IStatusLineManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.ide.IGotoMarker;
import org.eclipse.ui.part.IPage;
import org.eclipse.ui.views.properties.IPropertySheetPage;
import org.eclipse.ui.views.properties.IPropertySourceProvider;
import org.eclipse.ui.views.properties.PropertySheetPage;

public abstract class AbstractBaseView
extends SaveableLibraryViewPart
implements IEditingDomainProvider,
ISelectionProvider,
IMenuListener,
IViewerProvider,
IGotoMarker {
    protected AdapterFactoryEditingDomain editingDomain;
    protected PropertySheetPage propertySheetPage;
    protected UIActionDispatcher actionDispatcher = null;
    protected ILibraryChangeListener libListener = null;
    protected AdapterFactory adapterFactory;
    protected ILibraryActionBarContributor actionBarContributor;
    protected ISelectionChangedListener selectionChangedListener;
    protected IPartListener partListener = new IPartListener(){

        public void partActivated(IWorkbenchPart part) {
            if (part == AbstractBaseView.this) {
                AbstractBaseView.this.handleActivate(part);
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partOpened(IWorkbenchPart part) {
        }
    };
    static /* synthetic */ Class class$0;

    protected void handleActivate(IWorkbenchPart part) {
        this.editingDomain.setAdapterFactory(this.adapterFactory);
        if (this.editingDomain.getResourceToReadOnlyMap() != null) {
            this.editingDomain.getResourceToReadOnlyMap().clear();
            this.setSelection(this.getSelection());
        }
    }

    protected boolean handleDirtyConflict() {
        String title = AuthoringUIResources.getString("_UI_FileConflict_label");
        String msg = AuthoringUIResources.getString("_WARN_FileConflict");
        return AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(title, msg);
    }

    protected void handleChangedResources() {
        System.out.println("AbstractBaseView.handleChangedResources()");
    }

    public void createPartControl(Composite parent) {
        this.init();
        this.actionDispatcher = new UIActionDispatcher((Object)this);
        this.createViewer(parent);
        try {
            this.actionBarContributor = this.createActionBarContributor();
            this.actionBarContributor.init(this.getViewSite().getActionBars(), this.getSite().getPage());
        }
        catch (Exception e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            if (this.selectionChangedListener == null) {
                this.selectionChangedListener = new ISelectionChangedListener(){

                    public void selectionChanged(SelectionChangedEvent selectionChangedEvent) {
                        AbstractBaseView.this.setSelection(selectionChangedEvent.getSelection());
                    }
                };
            }
            viewer.addSelectionChangedListener(this.selectionChangedListener);
        }
        this.libListener = new ILibraryChangeListener(){

            public void libraryChanged(int option, Collection changedItems) {
                switch (option) {
                    case 1: 
                    case 4: {
                        AbstractBaseView.this.setInputForViewer(LibraryProcessor.getInstance().getLibrary());
                        AbstractBaseView.this.actionBarContributor.setActiveView((IViewPart)AbstractBaseView.this);
                        LibraryProcessor.getInstance().updateShellTitle();
                        break;
                    }
                    case 128: {
                        AbstractBaseView.this.setInputForViewer(null);
                        if (!(AbstractBaseView.this.adapterFactory instanceof ComposedAdapterFactory)) break;
                        ((ComposedAdapterFactory)AbstractBaseView.this.adapterFactory).dispose();
                    }
                }
            }
        };
        LibraryProcessor.getInstance().addListener(this.libListener);
        MethodLibrary library = LibraryProcessor.getInstance().getLibrary();
        if (library != null) {
            this.setInputForViewer(library);
            LibraryProcessor.getInstance().updateShellTitle();
        }
    }

    private void init() {
        this.editingDomain = LibraryProcessor.getInstance().getEditingDomain();
        this.adapterFactory = (ComposedAdapterFactory)this.editingDomain.getAdapterFactory();
        IViewSite site = (IViewSite)this.getSite();
        site.setSelectionProvider((ISelectionProvider)this);
        site.getPage().addPartListener(this.partListener);
    }

    public void createContextMenuFor(StructuredViewer viewer) {
        MenuManager contextMenu = new MenuManager("#PopUp");
        contextMenu.add((IContributionItem)new Separator("additions"));
        contextMenu.setRemoveAllWhenShown(true);
        contextMenu.addMenuListener((IMenuListener)this);
        Menu menu = contextMenu.createContextMenu(viewer.getControl());
        viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(contextMenu, (ISelectionProvider)viewer);
    }

    public void menuAboutToShow(IMenuManager menuManager) {
        try {
            this.actionBarContributor.setActiveView((IViewPart)this);
            this.actionBarContributor.menuAboutToShow(menuManager);
        }
        catch (RuntimeException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
            throw e;
        }
    }

    public void setFocus() {
    }

    public EditingDomain getEditingDomain() {
        return this.editingDomain;
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.actionDispatcher.addSelectionChangedListener(listener);
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.actionDispatcher.removeSelectionChangedListener(listener);
    }

    public Object getAdapter(Class key) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.ide.IGotoMarker");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (key.equals(clazz)) {
            return this;
        }
        return super.getAdapter(key);
    }

    public ISelection getSelection() {
        return this.actionDispatcher.getSelection();
    }

    public void setSelection(ISelection selection) {
        this.setSelection(this, selection);
    }

    private void setSelection(ISelectionProvider source, ISelection selection) {
        this.actionDispatcher.setSelection(source, selection);
        UIActionDispatcher.getInstance().setSelection(source, selection);
    }

    public void dispose() {
        this.getSite().getPage().removePartListener(this.partListener);
        if (this.adapterFactory instanceof ComposedAdapterFactory) {
            ((ComposedAdapterFactory)this.adapterFactory).dispose();
        }
        if (this.actionBarContributor.getActiveView() == this) {
            this.actionBarContributor.setActiveView(null);
        }
        if (this.propertySheetPage != null) {
            this.propertySheetPage.dispose();
        }
        if (this.libListener != null) {
            LibraryProcessor.getInstance().removeListener(this.libListener);
            this.libListener = null;
        }
        super.dispose();
    }

    public IPropertySheetPage getPropertySheetPage() {
        if (this.propertySheetPage == null) {
            this.propertySheetPage = new PropertySheetPage(){

                public void makeContributions(IMenuManager menuManager, IToolBarManager toolBarManager, IStatusLineManager statusLineManager) {
                    super.makeContributions(menuManager, toolBarManager, statusLineManager);
                }

                public void setActionBars(IActionBars actionBars) {
                    super.setActionBars(actionBars);
                    if (AbstractBaseView.this.actionBarContributor != null) {
                        AbstractBaseView.this.actionBarContributor.shareGlobalActions((IPage)this, actionBars);
                    }
                }
            };
            this.propertySheetPage.setPropertySourceProvider((IPropertySourceProvider)new AdapterFactoryContentProvider(this.adapterFactory));
        }
        return this.propertySheetPage;
    }

    public void gotoMarker(IMarker marker) {
        try {
            String uriAttribute;
            if (marker.getType().equals("org.eclipse.emf.ecore.diagnostic") && (uriAttribute = marker.getAttribute("uri", null)) != null) {
                URI uri = URI.createURI((String)uriAttribute);
                EObject eObject = this.editingDomain.getResourceSet().getEObject(uri, true);
                if (eObject != null) {
                    this.setSelectionToViewer(Collections.singleton(this.editingDomain.getWrapper((Object)eObject)));
                }
            }
        }
        catch (CoreException e) {
            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
        }
    }

    public void setSelectionToViewer(Collection collection) {
        final Collection theSelection = collection;
        if (theSelection != null && !theSelection.isEmpty()) {
            Runnable runnable = new Runnable(){

                public void run() {
                    Viewer viewer = AbstractBaseView.this.getViewer();
                    if (viewer != null) {
                        viewer.setSelection((ISelection)new StructuredSelection(theSelection.toArray()), true);
                    }
                }
            };
            runnable.run();
        }
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return new AdapterFactoryContentProvider(this.adapterFactory);
    }

    public abstract Viewer getViewer();

    public abstract void createViewer(Composite var1);

    public abstract ILibraryActionBarContributor createActionBarContributor();

    public abstract void setInputForViewer(Object var1);
}

