/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.views;

import com.ibm.uma.MethodElement;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryLabelProvider;
import org.eclipse.emf.edit.ui.provider.ExtendedImageRegistry;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.library.configuration.ElementDependencyError;
import org.eclipse.epf.library.configuration.ErrorInfo;
import org.eclipse.epf.library.services.ElementReference;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.PlatformUI;

public class MessageLabelProvider
extends AdapterFactoryLabelProvider {
    public MessageLabelProvider(AdapterFactory adapterFactory) {
        super(adapterFactory);
    }

    public Image getImage(Object object) {
        ErrorInfo error;
        String msg;
        boolean is_error = false;
        boolean is_warning = false;
        if (object instanceof ElementDependencyError) {
            ElementDependencyError error2 = (ElementDependencyError)object;
            is_error = error2.isError() || error2.isChildError();
            is_warning = error2.isWarning() || error2.isChildWarning();
        } else if (object instanceof ErrorInfo && (msg = (error = (ErrorInfo)object).getErrorMessage()) != null && msg.length() > 0) {
            is_error = error.isError() || error.isChildError();
            boolean bl = is_warning = error.isWarning() || error.isChildWarning();
        }
        if (is_error) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        if (is_warning) {
            return PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_WARN_TSK");
        }
        return null;
    }

    protected Image getImageFromObject(Object object) {
        return ExtendedImageRegistry.getInstance().getImage(object);
    }

    public Image getColumnImage(Object object, int columnIndex) {
        if (columnIndex == 0) {
            return this.getImage(object);
        }
        return null;
    }

    private String getString(Object element) {
        if (element instanceof MethodElement) {
            return this.getName((MethodElement)element);
        }
        String text = element.toString();
        int index = text.indexOf("(");
        int index2 = text.lastIndexOf(")");
        if (index >= 0 && index2 > 0) {
            return text.substring(index, index2 + 1);
        }
        return text;
    }

    private String getName(MethodElement e) {
        return e == null ? "" : e.getName();
    }

    public String getColumnText(Object object, int columnIndex) {
        ElementDependencyError error;
        String text = "";
        MethodElement element = null;
        if (object instanceof ElementDependencyError) {
            error = (ElementDependencyError)object;
            Object e = error.getErrorElement();
            Object[] refs = error.getCauseElements();
            if (columnIndex == 1) {
                text = this.getString(e);
            } else if (columnIndex == 2) {
                if (refs != null) {
                    StringBuffer b = new StringBuffer();
                    int i = 0;
                    while (i < refs.length) {
                        if (i > 0) {
                            b.append(", ");
                        }
                        b.append(this.getString(refs[i]));
                        ++i;
                    }
                    text = b.toString();
                }
            } else if (error.isError() || error.isWarning()) {
                text = AuthoringUIResources.formatString("AuthoringUI.MessageLabelProvider.unselectedpackages", new String[]{this.getString(e)});
            } else if (error.isChildError() || error.isChildWarning()) {
                text = AuthoringUIResources.getString("AuthoringUI.MessageLabelProvider.errchildpkgs");
            }
        }
        if (object instanceof ErrorInfo) {
            error = (ErrorInfo)object;
            if (columnIndex == 1) {
                element = (MethodElement)error.getOwnerElement();
            } else if (columnIndex == 2) {
                element = (MethodElement)error.getCauseElement();
            }
            if (element != null) {
                text = this.getName(element);
                if (columnIndex != 0 && !LibraryUtil.selectable((EObject)element)) {
                    text = "      " + text;
                }
            } else {
                text = error.getErrorMessage();
            }
        } else if (object instanceof ElementReference) {
            ElementReference ref = (ElementReference)object;
            if (columnIndex == 1) {
                element = (MethodElement)ref.getElement();
                text = "      " + this.getName(element);
            } else if (columnIndex == 2) {
                element = (MethodElement)ref.getRefElement();
                text = "      " + this.getName(element);
            }
        }
        if (text == null) {
            text = "";
        }
        return text;
    }

    public String getText(Object object) {
        return this.getColumnText(object, 0);
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

