/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.help.internal;

import java.io.IOException;
import java.io.InputStream;
import java.util.Locale;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.help.IHelpContentProducer;
import org.eclipse.help.internal.HelpPlugin;
import org.eclipse.help.internal.util.ResourceLocator;
import org.eclipse.help.internal.xhtml.UAContentParser;
import org.eclipse.help.internal.xhtml.UATransformManager;
import org.eclipse.help.internal.xhtml.XHTMLSupport;
import org.osgi.framework.Bundle;
import org.w3c.dom.Document;

public class DynamicContentProducer
implements IHelpContentProducer {
    public InputStream getInputStream(String pluginID, String href, Locale locale) {
        String file = href;
        int qloc = href.indexOf(63);
        if (qloc != -1) {
            file = href.substring(0, qloc);
        }
        if (DynamicContentProducer.isXHTML(pluginID, href, locale)) {
            boolean filter = true;
            if (qloc != -1 && qloc < href.length() - 1) {
                String query = href.substring(qloc + 1);
                filter = query.indexOf("filter=false") == -1;
            }
            return DynamicContentProducer.openXHTMLFromPlugin(pluginID, file, locale.toString(), filter);
        }
        return null;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static boolean isXHTML(String pluginID, String href, Locale locale) {
        IContentType type;
        block9: {
            int lastSlash;
            String file = href;
            int qloc = href.indexOf(63);
            if (qloc != -1) {
                file = href.substring(0, qloc);
            }
            String fileName = (lastSlash = file.lastIndexOf(47)) != -1 ? file.substring(lastSlash + 1) : file;
            InputStream contents = DynamicContentProducer.openXHTMLFromPluginRaw(pluginID, file, locale.toString());
            type = null;
            try {
                try {
                    type = Platform.getContentTypeManager().findContentTypeFor(contents, fileName);
                }
                catch (IOException e) {
                    HelpPlugin.logError("An error occured in DynamicContentProducer while trying to determine the content type", e);
                }
            }
            catch (Throwable throwable) {
                Object var10_11 = null;
                if (contents == null) throw throwable;
                try {
                    contents.close();
                    throw throwable;
                }
                catch (IOException iOException) {}
                throw throwable;
            }
            {
                Object var10_12 = null;
                if (contents == null) break block9;
            }
            try {}
            catch (IOException iOException) {}
            contents.close();
        }
        if (type == null) return false;
        return "org.eclipse.help.xhtml".equals(type.getId());
    }

    private static InputStream openXHTMLFromPlugin(String pluginID, String file, String locale, boolean filter) {
        InputStream inputStream = DynamicContentProducer.openXHTMLFromPluginRaw(pluginID, file, locale);
        if (inputStream != null) {
            UAContentParser parser = new UAContentParser(inputStream);
            Document dom = parser.getDocument();
            XHTMLSupport support = new XHTMLSupport(pluginID, file, dom, locale);
            dom = support.processDOM(filter);
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
            return UATransformManager.getAsInputStream(dom);
        }
        return null;
    }

    private static InputStream openXHTMLFromPluginRaw(String pluginID, String file, String locale) {
        Bundle bundle = Platform.getBundle((String)pluginID);
        if (bundle != null) {
            InputStream inputStream = ResourceLocator.openFromZip(bundle, "doc.zip", file, locale);
            if (inputStream == null) {
                inputStream = ResourceLocator.openFromPlugin(bundle, file, locale);
            }
            return inputStream;
        }
        return null;
    }
}

