/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.persistence.util;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.filebuffers.FileBuffers;
import org.eclipse.core.filebuffers.ITextFileBuffer;
import org.eclipse.core.filebuffers.ITextFileBufferManager;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.resources.WorkspaceJob;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.epf.persistence.FileManager;
import org.eclipse.epf.persistence.MultiFileResourceSetImpl;
import org.eclipse.epf.persistence.MultiFileSaveUtil;
import org.eclipse.epf.persistence.util.PatternConstructor;
import org.eclipse.epf.persistence.util.PersistenceResources;
import org.eclipse.epf.uma.ecore.IProxyResolutionListener;
import org.eclipse.epf.uma.ecore.ResolveException;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.osgi.util.NLS;

public class UnresolvedProxyMarkerManager
extends WorkspaceJob
implements IProxyResolutionListener {
    private static final long DELAY = 0L;
    public static final String PROXY_URI = "proxyURI";
    public static final String OWNER_GUID = "ownerGUID";
    private Map uriToExceptionsMap;
    private List exceptions;
    private Map resourceGUIToMarkersMap;
    private Map elementGUIToMarkersMap;
    private ResourceSet resourceSet;
    private boolean enabled;

    public UnresolvedProxyMarkerManager(ResourceSet resourceSet) {
        super("EPF Unresolved Proxy Logger");
        this.resourceSet = resourceSet;
        this.uriToExceptionsMap = new HashMap();
        this.exceptions = new ArrayList();
        this.resourceGUIToMarkersMap = new HashMap();
        this.elementGUIToMarkersMap = new HashMap();
    }

    public IMarker findMarker(IFile file, String proxyURI, int start, int end) throws CoreException {
        IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
        int i = 0;
        while (i < markers.length) {
            IMarker marker = markers[i];
            if (proxyURI.equals(marker.getAttribute(PROXY_URI)) && marker.getAttribute("charStart", -1) == start && marker.getAttribute("charEnd", -1) == end) {
                return marker;
            }
            ++i;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean addException(ResolveException re) {
        List list = this.exceptions;
        synchronized (list) {
            block5: {
                URI uri = ((InternalEObject)re.getProxy()).eProxyURI();
                HashSet<ResolveException> exceptions = (HashSet<ResolveException>)this.uriToExceptionsMap.get(uri);
                if (exceptions == null) {
                    exceptions = new HashSet<ResolveException>();
                    this.uriToExceptionsMap.put(uri, exceptions);
                }
                if (!exceptions.add(re)) break block5;
                this.exceptions.add(re);
                return true;
            }
            return false;
        }
    }

    private void addMarker(ResolveException re, IProgressMonitor monitor) {
        block10: {
            Resource resource;
            InternalEObject proxy = (InternalEObject)re.getProxy();
            URI containerURI = null;
            if (re.getResolver() != null && (resource = re.getResolver().eResource()) != null && resource.getResourceSet() != null) {
                containerURI = resource.getURI();
            }
            if (containerURI != null) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                Path path = new Path(containerURI.toFileString());
                IFile file = workspace.getRoot().getFileForLocation((IPath)path);
                if (file != null) {
                    String errMsg;
                    String location;
                    String string = location = containerURI != null ? containerURI.toFileString() : "";
                    if (re.exception() != null && re.exception().getLocalizedMessage() != null && re.exception().getLocalizedMessage().trim().length() > 0) {
                        errMsg = re.exception().getLocalizedMessage();
                    } else {
                        String string2 = errMsg = re.getMessage() == null ? NLS.bind((String)PersistenceResources.UnresolvedProxyMarkerManager_couldNotResolveProxy, (Object)proxy.eProxyURI()) : re.getMessage();
                    }
                    if (location.length() != 0) {
                        location = MessageFormat.format(PersistenceResources.marker_location, location);
                    }
                    try {
                        file.refreshLocal(0, null);
                        ITextFileBufferManager manager = FileBuffers.getTextFileBufferManager();
                        manager.connect((IPath)path, monitor);
                        ITextFileBuffer fileBuffer = manager.getTextFileBuffer((IPath)path);
                        fileBuffer.requestSynchronizationContext();
                        fileBuffer.getDocument();
                        IDocument doc = fileBuffer.getDocument();
                        if (doc != null) {
                            String uriStr = proxy.eProxyURI().toString();
                            Pattern pattern = PatternConstructor.createPattern(uriStr, true, false);
                            Matcher matcher = pattern.matcher(new DocumentCharSequence(doc));
                            while (matcher.find()) {
                                IMarker marker;
                                Resource resource2;
                                int end;
                                int start = matcher.start();
                                if (start == (end = matcher.end()) || (resource2 = re.getResolver().eResource()) == null || resource2.getResourceSet() == null || (marker = this.findMarker(file, uriStr, start, end)) != null) continue;
                                marker = file.createMarker("org.eclipse.core.resources.problemmarker");
                                marker.setAttribute("severity", 2);
                                marker.setAttribute("message", (Object)errMsg);
                                marker.setAttribute("location", (Object)location);
                                marker.setAttribute("transient", true);
                                marker.setAttribute("charStart", start);
                                marker.setAttribute("charEnd", end);
                                marker.setAttribute(PROXY_URI, (Object)uriStr);
                                marker.setAttribute(OWNER_GUID, (Object)MultiFileSaveUtil.getGuid(re.getResolver()));
                                this.cacheMarker(marker, proxy);
                            }
                        }
                        fileBuffer.releaseSynchronizationContext();
                    }
                    catch (CoreException ex) {
                        CommonPlugin.INSTANCE.log((Object)ex);
                        if (!MultiFileSaveUtil.DEBUG) break block10;
                        ex.printStackTrace();
                    }
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cacheMarker(IMarker marker, InternalEObject proxy) {
        Map map = this.elementGUIToMarkersMap;
        synchronized (map) {
            String elementGUID;
            HashSet<Object> markers;
            URI uri = proxy.eProxyURI();
            String resourceGUID = uri.authority();
            if (resourceGUID != null) {
                ValidObject vo = (ValidObject)this.resourceGUIToMarkersMap.get(resourceGUID);
                if (vo == null) {
                    vo = new ValidObject(new HashSet());
                    this.resourceGUIToMarkersMap.put(resourceGUID, vo);
                }
                markers = (Collection)vo.object;
                markers.add(marker);
            }
            if ((markers = (HashSet<Object>)this.elementGUIToMarkersMap.get(elementGUID = uri.fragment())) == null) {
                markers = new HashSet<Object>();
                this.elementGUIToMarkersMap.put(elementGUID, markers);
            }
            markers.add(new ValidObject(marker));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void clearAll() {
        boolean oldEnabled = this.enabled;
        try {
            this.enabled = false;
            this.cancel();
            Object object = this.exceptions;
            synchronized (object) {
                this.uriToExceptionsMap.clear();
                this.exceptions.clear();
            }
            object = this.elementGUIToMarkersMap;
            synchronized (object) {
                if (!this.elementGUIToMarkersMap.isEmpty()) {
                    Iterator iter = this.elementGUIToMarkersMap.values().iterator();
                    block11: while (true) {
                        if (!iter.hasNext()) {
                            this.elementGUIToMarkersMap.clear();
                            this.resourceGUIToMarkersMap.clear();
                            break;
                        }
                        Collection markers = (Collection)iter.next();
                        Iterator iter1 = markers.iterator();
                        while (true) {
                            if (!iter1.hasNext()) {
                                markers.clear();
                                continue block11;
                            }
                            ValidObject vo = (ValidObject)iter1.next();
                            IMarker marker = (IMarker)vo.object;
                            try {
                                if (!marker.exists()) continue;
                                marker.delete();
                            }
                            catch (Exception e) {
                                CommonPlugin.INSTANCE.log((Object)e);
                            }
                        }
                        break;
                    }
                }
            }
        }
        catch (Throwable throwable) {
            Object var9_10 = null;
            this.enabled = oldEnabled;
            throw throwable;
        }
        {
            Object var9_11 = null;
            this.enabled = oldEnabled;
            return;
        }
    }

    public boolean hasUnresolvedProxy() {
        return !this.elementGUIToMarkersMap.isEmpty();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ResolveException nextException() {
        List list = this.exceptions;
        synchronized (list) {
            block6: {
                if (!this.exceptions.isEmpty()) break block6;
                return null;
            }
            ResolveException e = (ResolveException)this.exceptions.remove(0);
            URI uri = ((InternalEObject)e.getProxy()).eProxyURI();
            Collection exceptions = (Collection)this.uriToExceptionsMap.get(uri);
            if (exceptions != null) {
                exceptions.remove(e);
                if (exceptions.isEmpty()) {
                    this.uriToExceptionsMap.remove(uri);
                }
            }
            return e;
        }
    }

    /*
     * Exception decompiling
     */
    public IStatus runInWorkspace(IProgressMonitor monitor) throws CoreException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean removeFromResourceGUIDToMarkersMap(String proxyURI, IMarker marker) {
        ValidObject vo;
        URI uri = URI.createURI((String)proxyURI);
        String resourceGUID = uri.authority();
        if (resourceGUID != null && (vo = (ValidObject)this.resourceGUIToMarkersMap.get(resourceGUID)) != null) {
            Collection markers = (Collection)vo.object;
            boolean ret = markers.remove(marker);
            if (markers.isEmpty()) {
                this.resourceGUIToMarkersMap.remove(resourceGUID);
            }
            return ret;
        }
        return false;
    }

    private void removeFromElementGUIDToMarkersMap(String proxyURI, IMarker marker) {
        Collection validObjects;
        URI uri = URI.createURI((String)proxyURI);
        String elementGUID = uri.fragment();
        if (elementGUID != null && (validObjects = (Collection)this.elementGUIToMarkersMap.get(elementGUID)) != null) {
            Iterator iterator1 = validObjects.iterator();
            while (iterator1.hasNext()) {
                ValidObject vo1 = (ValidObject)iterator1.next();
                if (vo1.object != marker) continue;
                iterator1.remove();
            }
            if (validObjects.isEmpty()) {
                this.elementGUIToMarkersMap.remove(elementGUID);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeMarkers(IProgressMonitor monitor) {
        Map map = this.elementGUIToMarkersMap;
        synchronized (map) {
            IMarker marker;
            Iterator iter = this.elementGUIToMarkersMap.values().iterator();
            while (iter.hasNext()) {
                Collection markers = (Collection)iter.next();
                Iterator iterator = markers.iterator();
                while (iterator.hasNext()) {
                    ValidObject vo = (ValidObject)iterator.next();
                    if (vo.valid) continue;
                    try {
                        marker = (IMarker)vo.object;
                        if (marker.exists()) {
                            String proxyURI = (String)marker.getAttribute(PROXY_URI);
                            marker.delete();
                            this.removeFromResourceGUIDToMarkersMap(proxyURI, marker);
                        }
                        iterator.remove();
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                    }
                }
            }
            iter = this.resourceGUIToMarkersMap.values().iterator();
            while (iter.hasNext()) {
                ValidObject vo = (ValidObject)iter.next();
                if (vo.valid) continue;
                vo.valid = true;
                Collection markers = (Collection)vo.object;
                Iterator iterator = markers.iterator();
                while (iterator.hasNext()) {
                    try {
                        marker = (IMarker)iterator.next();
                        if (marker.exists()) {
                            String proxyURIStr = (String)marker.getAttribute(PROXY_URI);
                            URI proxyURI = URI.createURI((String)proxyURIStr);
                            String elementGUID = proxyURI.fragment();
                            EObject o = (EObject)((MultiFileResourceSetImpl)this.resourceSet).getGuidToMethodElementMap().get(elementGUID);
                            if (o == null || o.eIsProxy()) continue;
                            marker.delete();
                            iterator.remove();
                            this.removeFromElementGUIDToMarkersMap(proxyURIStr, marker);
                            continue;
                        }
                        iterator.remove();
                    }
                    catch (Exception e) {
                        CommonPlugin.INSTANCE.log((Object)e);
                    }
                }
                if (!markers.isEmpty()) continue;
                iter.remove();
            }
        }
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void notifyException(Exception e) {
        ResolveException re;
        if (!this.enabled) {
            return;
        }
        if (e instanceof ResolveException && this.addException(re = (ResolveException)e)) {
            this.schedule(0L);
        }
    }

    public void proxyResolved(Object proxy, Object resolved) {
        if (!this.enabled) {
            return;
        }
        if (proxy instanceof InternalEObject) {
            URI uri = ((InternalEObject)proxy).eProxyURI();
            this.removeExceptions(uri);
            if (this.invalidateMarkers(uri)) {
                this.schedule(0L);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean invalidateMarkers(URI uri) {
        Map map = this.elementGUIToMarkersMap;
        synchronized (map) {
            Collection markers;
            String elementGUID;
            ValidObject vo;
            boolean ret = false;
            String resourceGUID = uri.authority();
            if (resourceGUID != null && (vo = (ValidObject)this.resourceGUIToMarkersMap.get(resourceGUID)) != null) {
                vo.valid = false;
                ret = true;
            }
            if ((elementGUID = uri.fragment()) != null && (markers = (Collection)this.elementGUIToMarkersMap.get(elementGUID)) != null && !markers.isEmpty()) {
                ret = true;
                Iterator iter = markers.iterator();
                while (iter.hasNext()) {
                    ValidObject vo2 = (ValidObject)iter.next();
                    vo2.valid = false;
                }
            }
            return ret;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeExceptions(URI uri) {
        List list = this.exceptions;
        synchronized (list) {
            Collection exceptions = (Collection)this.uriToExceptionsMap.get(uri);
            if (exceptions == null || exceptions.isEmpty()) {
                return;
            }
            this.exceptions.removeAll(exceptions);
            this.uriToExceptionsMap.remove(uri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearMarkers(Resource resource) {
        block7: {
            try {
                IResource file = FileManager.getResourceForLocation(resource.getURI().toFileString());
                if (!(file instanceof IFile)) break block7;
                IMarker[] markers = file.findMarkers("org.eclipse.core.resources.problemmarker", false, 0);
                int i = 0;
                while (i < markers.length) {
                    IMarker marker = markers[i];
                    String proxyURI = (String)marker.getAttribute(PROXY_URI);
                    if (proxyURI != null) {
                        marker.delete();
                        Map map = this.elementGUIToMarkersMap;
                        synchronized (map) {
                            this.removeFromElementGUIDToMarkersMap(proxyURI, marker);
                            this.removeFromResourceGUIDToMarkersMap(proxyURI, marker);
                        }
                    }
                    ++i;
                }
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
            }
        }
    }

    private static class ValidObject {
        boolean valid;
        Object object;

        public ValidObject(Object object) {
            this.object = object;
            this.valid = true;
        }
    }

    private static class DocumentCharSequence
    implements CharSequence {
        private IDocument fDocument;

        public DocumentCharSequence(IDocument document) {
            this.fDocument = document;
        }

        public int length() {
            return this.fDocument.getLength();
        }

        public char charAt(int index) {
            try {
                return this.fDocument.getChar(index);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }

        public CharSequence subSequence(int start, int end) {
            try {
                return this.fDocument.get(start, end - start);
            }
            catch (BadLocationException x) {
                throw new IndexOutOfBoundsException(x.getLocalizedMessage());
            }
        }
    }
}

