/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.List;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.library.IConfigurationManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.LibraryServiceUtil;
import org.eclipse.epf.library.configuration.ConfigurationClosure;
import org.eclipse.epf.library.layout.ElementLayoutManager;
import org.eclipse.epf.library.services.DependencyManager;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;

public class ConfigurationManager
implements IConfigurationManager {
    protected static boolean debug = LibraryPlugin.getDefault().isDebugging();
    protected MethodConfiguration config;
    protected MethodLibrary library;
    protected ILibraryManager libraryManager;
    protected DependencyManager dependencyManager;
    protected ElementLayoutManager layoutManager;
    protected ConfigurationClosure closure;
    protected AdapterFactoryContentProvider afcp;

    public ConfigurationManager(MethodConfiguration config) {
        this.config = config;
        this.library = LibraryServiceUtil.getMethodLibrary((MethodElement)config);
        this.libraryManager = LibraryService.getInstance().getLibraryManager(this.library);
        this.afcp = new AdapterFactoryContentProvider((AdapterFactory)this.libraryManager.getAdapterFactory());
        this.dependencyManager = new DependencyManager(this.library);
        this.layoutManager = config == null ? new ElementLayoutManager() : new ElementLayoutManager(config);
    }

    public MethodConfiguration getMethodConfiguration() {
        return this.config;
    }

    public MethodLibrary getMethodLibrary() {
        return this.library;
    }

    public AdapterFactory getAdapterFactory() {
        return this.libraryManager.getAdapterFactory();
    }

    public AdapterFactoryContentProvider getContentProvider() {
        return this.afcp;
    }

    public DependencyManager getDependencyManager() {
        return this.dependencyManager;
    }

    public ElementLayoutManager getElementLayoutManager() {
        return this.layoutManager;
    }

    public ConfigurationClosure getConfigurationClosure() {
        return this.closure;
    }

    public void makeConfigurationClosure() {
        if (this.closure != null) {
            this.closure.makeClosure();
        }
    }

    public List getMethodPlugins() {
        return this.library.getMethodPlugins();
    }

    public void dispose() {
        this.config = null;
        this.library = null;
        this.libraryManager = null;
        this.dependencyManager = null;
        this.layoutManager = null;
        this.closure = null;
    }
}

