/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.Platform;
import org.eclipse.epf.library.CreateLibraryManagerException;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.internal.LibraryManagerElement;
import org.osgi.framework.Bundle;

public class LibraryManagerFactory {
    public static final String EXTENSION_POINT_NAMESPACE = "org.eclipse.epf.library";
    public static final String EXTENSION_POINT_NAME = "libraryManagers";
    private static LibraryManagerFactory instance = null;
    private Map libraryManagerElements = new HashMap();
    static /* synthetic */ Class class$0;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static LibraryManagerFactory getInstance() {
        if (instance != null) return instance;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.epf.library.LibraryManagerFactory");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        Class<?> clazz2 = clazz;
        synchronized (clazz) {
            if (instance != null) return instance;
            instance = new LibraryManagerFactory();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    private LibraryManagerFactory() {
        this.init();
    }

    protected void init() {
        IExtensionRegistry extensionRegistry = Platform.getExtensionRegistry();
        IExtensionPoint extensionPoint = extensionRegistry.getExtensionPoint(EXTENSION_POINT_NAMESPACE, EXTENSION_POINT_NAME);
        if (extensionPoint != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                String pluginId = extension.getNamespaceIdentifier();
                Bundle bundle = Platform.getBundle((String)pluginId);
                IConfigurationElement[] configElements = extension.getConfigurationElements();
                int j = 0;
                while (j < configElements.length) {
                    IConfigurationElement configElement = configElements[j];
                    try {
                        String className = configElement.getAttribute("class");
                        String typeId = configElement.getAttribute("type");
                        String typeName = configElement.getAttribute("typeName");
                        if (className != null && className.trim().length() > 0 && typeId != null && typeId.trim().length() > 0 && typeName != null && typeName.trim().length() > 0 && !this.libraryManagerElements.containsKey(typeId)) {
                            LibraryManagerElement provider = new LibraryManagerElement(bundle, className, typeId, typeName);
                            this.libraryManagerElements.put(typeId, provider);
                        }
                    }
                    catch (Exception e) {
                        LibraryPlugin.getDefault().getLogger().logError((Throwable)e);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    public ILibraryManager createLibraryManager(String type) throws CreateLibraryManagerException {
        LibraryManagerElement provider = (LibraryManagerElement)this.libraryManagerElements.get(type);
        if (provider == null) {
            throw new CreateLibraryManagerException();
        }
        try {
            Class clazz = provider.getBundle().loadClass(provider.getClassName());
            return (ILibraryManager)clazz.newInstance();
        }
        catch (Exception e) {
            throw new CreateLibraryManagerException(e);
        }
    }

    public Map getLibraryTypes() {
        HashMap<String, String> types = new HashMap<String, String>();
        Iterator it = this.libraryManagerElements.keySet().iterator();
        while (it.hasNext()) {
            String typeId = (String)it.next();
            String typeName = ((LibraryManagerElement)this.libraryManagerElements.get(typeId)).getTypeName();
            types.put(typeId, typeName);
        }
        return types;
    }
}

