/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.layout;

import java.io.File;
import java.io.PrintStream;
import org.eclipse.epf.library.LibraryResources;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.osgi.util.NLS;

public class DefaultContentValidator
implements IContentValidator {
    protected PrintStream info;
    protected PrintStream warning;
    protected PrintStream error;
    protected String pubDir;
    protected boolean showBrokenLinks = true;

    public DefaultContentValidator() {
        this(null);
    }

    public DefaultContentValidator(String pubDir) {
        this.pubDir = pubDir;
        this.info = System.out;
        this.warning = System.out;
        this.error = System.err;
    }

    public void setPublishDir(String pubDir) {
        this.pubDir = pubDir;
    }

    public String getPublishDir() {
        return this.pubDir;
    }

    public void setShowBrokenLinks(boolean flag) {
        this.showBrokenLinks = flag;
    }

    public boolean showBrokenLinks() {
        return this.showBrokenLinks;
    }

    public LinkInfo validateLink(MethodElement owner, String attributes, String text, MethodConfiguration config) {
        LinkInfo info = new LinkInfo(owner, this, this.pubDir);
        info.validateLink(attributes, text, config);
        return info;
    }

    public void logInfo(MethodElement owner, String message) {
        this.info.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG1, (Object)(String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message)));
        this.info.flush();
    }

    public void logWarning(MethodElement owner, String message) {
        this.warning.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG4, (Object)(String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message)));
        this.warning.flush();
    }

    public void logError(MethodElement owner, String message, Throwable th) {
        this.error.println(NLS.bind((String)LibraryResources.DefaultContentValidator_MSG7, (Object)(String.valueOf(owner == null ? "" : LibraryUtil.getTypeName(owner)) + ": " + message)));
        if (th != null) {
            th.printStackTrace(this.error);
        }
        this.error.flush();
    }

    public void logInfo(String message) {
        this.logInfo(null, message);
    }

    public void logWarning(String message) {
        this.logWarning(null, message);
    }

    public void logError(String message, Throwable th) {
        this.logError(null, message, th);
    }

    public void logMissingReference(MethodElement owner, MethodElement refElement) {
        this.logWarning(owner, NLS.bind((String)LibraryResources.DefaultContentValidator_MSG10, (Object)LibraryUtil.getTypeName(refElement)));
    }

    public void logMissingReference(MethodElement owner, String guid, String linkedText) {
        this.logWarning(owner, NLS.bind((String)LibraryResources.DefaultContentValidator_MSG11, (Object)guid));
    }

    public void logMissingResource(MethodElement owner, File resourceFile, String url) {
        String msg = resourceFile != null ? NLS.bind((String)LibraryResources.DefaultContentValidator_MSG12, (Object)resourceFile.getPath(), (Object)url) : NLS.bind((String)LibraryResources.DefaultContentValidator_MSG15, (Object)url);
        this.logWarning(owner, msg);
    }

    public void logInvalidExternalLink(MethodElement owner, String url, String message) {
        String text = message != null && message.length() > 0 ? NLS.bind((String)LibraryResources.DefaultContentValidator_MSG19, (Object)url, (Object)message) : NLS.bind((String)LibraryResources.DefaultContentValidator_MSG17, (Object)url);
        this.logWarning(owner, text);
    }

    public boolean isDiscarded(MethodElement owner, Object feature, MethodElement e) {
        return false;
    }

    public void dispose() {
    }

    public void addReferencedElement(MethodElement owner, MethodElement e) {
    }

    public void setDiscardedElement(MethodElement e) {
    }
}

