/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.library.util;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URI;
import java.net.URLDecoder;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.epf.common.utils.FileUtil;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.common.utils.XMLUtil;
import org.eclipse.epf.common.xml.XSLTProcessor;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryPlugin;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ConfigurationHelper;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.layout.DefaultContentValidator;
import org.eclipse.epf.library.layout.IContentValidator;
import org.eclipse.epf.library.layout.LayoutResources;
import org.eclipse.epf.library.layout.LinkInfo;
import org.eclipse.epf.library.layout.util.XmlElement;
import org.eclipse.epf.library.layout.util.XmlHelper;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.persistence.MethodLibraryPersister;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.util.UmaUtil;

public class ResourceHelper {
    public static final String URL_BOOKMARK_INDICATOR = "#";
    public static final String URL_PARAMETER_INDICATOR = "?";
    public static final String URL_PARAMETER_PROCESS = "proc";
    public static final String URL_STR_JAVASCRIPT = "javascript:";
    public static final String URL_STR_MAILTO = "mailto:";
    public static final String URL_PARAMETER_PATH = "path";
    public static final String TAG_ATTR_NAME = "name";
    public static final String TAG_ATTR_KEY = "key";
    public static final String TAG_ATTR_TEXT = "text";
    public static final String TAG_ATTR_CLASS = "class";
    public static final String TAG_ATTR_GUID = "guid";
    public static final String TAG_ATTR_HREF = "href";
    public static final String TAG_ATTR_VALUE_INDEX = "index";
    public static final String FILE_EXT_HTML = ".html";
    public static final String FILE_EXT_HTM = ".htm";
    public static final String FILE_EXT_JPEG = ".jpeg";
    public static final String MISSING_PAGES_FOLDER = "pages_not_installed/";
    public static final String ELEMENT_LINK_CLASS_elementLink = "elementLink";
    public static final String ELEMENT_LINK_CLASS_elementLinkWithType = "elementLinkWithType";
    public static final String ELEMENT_LINK_CLASS_elementLinkWithUserText = "elementLinkWithUserText";
    public static final String RESOURCE_FOLDER = "resources";
    public static final Pattern p_html_file_name = Pattern.compile("(.*),(.*)\\.html");
    public static final Pattern p_link_ref = Pattern.compile("<a\\s+?(.*?)>(.*?)</a>", 34);
    public static final Pattern p_area_ref = Pattern.compile("<area.*?(href\\s*=\\s*\"(.*?)\")", 34);
    public static final Pattern p_link_ref_gen = Pattern.compile("<(a|area)\\s+?([^>]*)>", 34);
    public static final Pattern p_link_type_picker = Pattern.compile(" class\\s*?=\\s*?(.*?)\\s+", 34);
    public static final Pattern p_link_guid_picker = Pattern.compile(" guid\\s*?=\\s*?(.*?)\\s+", 34);
    public static final Pattern p_link_href_picker = Pattern.compile(" href\\s*?=\\s*?\"(.*?)\"\\s+", 34);
    public static final Pattern p_tag_ref = Pattern.compile("<([^>!]*)(\\n|\\r)([^>]*)>", 34);
    public static final Pattern p_image_ref = Pattern.compile("(<(img|iframe).*?src\\s*=\\s*\")(.*?)(\")", 34);
    public static final Pattern p_url_decoder = Pattern.compile("(<[^>]*?(src|href)\\s*=\\s*\")(.*?)(\"[^>]*?>)", 34);
    public static final Pattern p_tag_attributes = Pattern.compile("(.*?)\\s*=\\s*(\"?)(.*?)\\2", 34);
    public static final Pattern p_css_ref = Pattern.compile(" url\\((.*?)\\)", 34);
    public static final String DIAGRAM_TYPE_WORKFLOW = "Activity";
    public static final String DIAGRAM_TYPE_ACTIVITY_DETAIL = "ActivityDetail";
    public static final String DIAGRAM_TYPE_WP_DEPENDENCY = "WPDependency";
    public static final String FILE_PREFIX_2 = "file://";
    public static final String FILE_PREFIX_3 = "file:///";
    private static final String EXTERNAL_URL_START_WITH = LayoutResources.getString("externalUrl_startWith");
    public static final Pattern p_external_url_startWith = Pattern.compile("(" + EXTERNAL_URL_START_WITH + ")", 34);

    public static String getPluginResourcePath(MethodElement element) {
        MethodPlugin plugin = UmaUtil.getMethodPlugin((EObject)element);
        String path = plugin == null ? MethodLibraryPersister.getResourcePath((MethodElement)element) : MethodLibraryPersister.getResourcePath((MethodElement)plugin);
        return ResourceHelper.fixPath(path);
    }

    public static String getElementResourcePath(MethodElement element) {
        String path = MethodLibraryPersister.getResourcePath((MethodElement)element);
        return ResourceHelper.fixPath(path);
    }

    public static String getElementPath(MethodElement element) {
        String path;
        block3: {
            try {
                path = MethodLibraryPersister.getElementPath((MethodElement)element);
                if (path != null && !path.equals("")) break block3;
                System.out.println("Warning! No Path for Element [" + element.getType().getName() + ": " + element.getName() + "]");
                return "";
            }
            catch (RuntimeException e) {
                e.printStackTrace();
                return "";
            }
        }
        return ResourceHelper.fixPath(path);
    }

    public static String fixPath(String path) {
        if (path == null || path.equals("")) {
            return "";
        }
        if (!path.endsWith(File.separator)) {
            return String.valueOf(path) + File.separator;
        }
        return path;
    }

    public static String getBackPath(MethodElement element) {
        String backPath = "";
        String path = ResourceHelper.getElementPath(element);
        if (path != null && path.length() > 0) {
            backPath = path.replace(File.separatorChar, '/').replaceAll(".*?/", "\\.\\./");
        }
        return "./" + backPath;
    }

    public static String getFileName(MethodElement element, String ext) {
        return ResourceHelper.getFileName(element, null, null, ext);
    }

    public static String getFileName(MethodElement element, String namePrefix, String nameSuffix, String ext) {
        StringBuffer buffer = new StringBuffer();
        if (namePrefix != null) {
            buffer.append(namePrefix);
        }
        buffer.append(StrUtil.makeValidFileName((String)element.getName()));
        if (nameSuffix != null) {
            buffer.append(nameSuffix);
        }
        buffer.append("," + element.getGuid());
        if (ext != null) {
            if (ext.indexOf(".") < 0) {
                ext = "." + ext;
            }
            buffer.append(ext);
        }
        return buffer.toString();
    }

    public static String getGuidFromFileName(String fileName) {
        if (fileName == null) {
            return null;
        }
        String guid = null;
        Matcher m = p_html_file_name.matcher(fileName);
        if (m.find()) {
            guid = m.group(2);
        }
        return guid;
    }

    public static MethodElement getElementFromFileName(String fileName) {
        ILibraryManager manager;
        String guid = ResourceHelper.getGuidFromFileName(fileName);
        if (guid != null && (manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            return manager.getMethodElement(guid);
        }
        return null;
    }

    public static String getUrl(MethodElement element, MethodElement refElement, String fileExt, String old_url) {
        String url = ResourceHelper.getUrl(element, refElement, fileExt);
        if (old_url != null) {
            int indx = old_url.indexOf(URL_BOOKMARK_INDICATOR);
            if (indx < 0) {
                indx = old_url.indexOf(URL_PARAMETER_INDICATOR);
            }
            if (indx >= 0) {
                url = String.valueOf(url) + old_url.substring(indx);
            }
        }
        return url;
    }

    public static String getUrl(MethodElement element, MethodElement refElement, String fileExt) {
        if (element == null) {
            return "";
        }
        if (refElement == null) {
            return String.valueOf(ResourceHelper.getElementPath(element).replace(File.separatorChar, '/')) + ResourceHelper.getFileName(element, fileExt);
        }
        return String.valueOf((String.valueOf(ResourceHelper.getBackPath(refElement)) + ResourceHelper.getElementPath(element)).replace(File.separatorChar, '/')) + ResourceHelper.getFileName(element, fileExt);
    }

    public static String getLinkText(MethodElement e, String linkType) {
        String linkedText = null;
        if (linkType != null && !ELEMENT_LINK_CLASS_elementLinkWithUserText.equals(linkType)) {
            if (ELEMENT_LINK_CLASS_elementLinkWithType.equals(linkType)) {
                linkedText = ResourceHelper.getElementLinkText(e, true);
            } else if (ELEMENT_LINK_CLASS_elementLink.equals(linkType)) {
                linkedText = ResourceHelper.getElementLinkText(e, false);
            }
        }
        return linkedText;
    }

    public static String getElementLinkText(MethodElement element, boolean withType) {
        String text = TngUtil.getPresentationName((Object)element);
        if (withType) {
            return String.valueOf(ResourceHelper.getElementTypeText(element)) + ": " + text;
        }
        return text;
    }

    public static String getElementTypeText(MethodElement element) {
        if (element == null) {
            return "";
        }
        return TngUtil.getTypeText((EObject)element);
    }

    public static String getElementLink(MethodElement element, boolean withType, String url) {
        String text = ResourceHelper.getElementLinkText(element, withType);
        String linkClass = ELEMENT_LINK_CLASS_elementLink;
        if (withType) {
            linkClass = ELEMENT_LINK_CLASS_elementLinkWithType;
        }
        return ResourceHelper.getElementLink(element, text, url, linkClass);
    }

    public static String getElementLink(MethodElement element, String text, String url) {
        return ResourceHelper.getElementLink(element, text, url, ELEMENT_LINK_CLASS_elementLinkWithUserText);
    }

    public static String getElementLink(MethodElement element, String text, String url, String linkClass) {
        return "<a class=\"" + linkClass + "\" " + ResourceHelper.getUrlText(url) + " guid=\"" + element.getGuid() + "\" >" + text + "</a>";
    }

    private static String getUrlText(String url) {
        if ((url = url == null ? "" : url.trim()).toLowerCase().startsWith(TAG_ATTR_HREF) || url.toLowerCase().indexOf(" href") > 0) {
            return url;
        }
        return "href=\"" + url + "\"";
    }

    public static String validateContent(MethodElement element, String source) {
        return ResourceHelper.validateContent(element, source, new DefaultContentValidator(), null);
    }

    public static boolean isElementLink(String linkType) {
        if (linkType == null || linkType.length() == 0) {
            return false;
        }
        return linkType.equals(ELEMENT_LINK_CLASS_elementLink) || linkType.equals(ELEMENT_LINK_CLASS_elementLinkWithType) || linkType.equals(ELEMENT_LINK_CLASS_elementLinkWithUserText);
    }

    public static String validateContent(MethodElement element, String source, IContentValidator validator, MethodConfiguration config) {
        try {
            source = ResourceHelper.validateTag(source);
            StringBuffer sb = new StringBuffer();
            Matcher m = p_link_ref.matcher(source);
            while (m.find()) {
                String linkedText;
                String text = m.group();
                String urltext = m.group(1);
                LinkInfo info = validator.validateLink(element, urltext, linkedText = m.group(2), config);
                if (info != null) {
                    text = info.getHtml(validator.showBrokenLinks()).toString();
                    MethodElement e = info.getLinkedElement();
                    if (e != null) {
                        validator.addReferencedElement(element, e);
                    }
                }
                String replacement = text.replaceAll(FILE_PREFIX_3, "");
                replacement = replacement.replaceAll(FILE_PREFIX_2, "");
                m.appendReplacement(sb, replacement);
            }
            m.appendTail(sb);
            if (element == null) {
                return sb.toString();
            }
            source = sb.toString();
            m = p_area_ref.matcher(source);
            sb.setLength(0);
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            while (m.find()) {
                String href = m.group(2);
                String guid = ResourceHelper.getGuidFromFileName(href);
                if (guid != null) {
                    MethodElement e;
                    MethodElement methodElement = e = manager != null ? manager.getMethodElement(guid) : null;
                    if (e != null) {
                        MethodElement e1 = ConfigurationHelper.getCalculatedElement(e, config);
                        if (e1 != null) {
                            e = e1;
                        }
                        validator.addReferencedElement(element, e);
                        href = ConfigurationHelper.inConfig(e, config) && !validator.isDiscarded(element, null, e) ? ResourceHelper.getUrl(e, element, FILE_EXT_HTML, href) : (validator.showBrokenLinks() ? ResourceHelper.getDiscardedElementURL(element, e, guid, ((DefaultContentValidator)validator).getPublishDir()) : "");
                    }
                } else {
                    href = URLDecoder.decode(href, "UTF-8");
                }
                String replacement = href == null || href.length() == 0 ? String.valueOf(source.substring(m.start(), m.start(1))) + source.substring(m.end(1), m.end()) : String.valueOf(source.substring(m.start(), m.start(2))) + href + source.substring(m.end(2), m.end());
                m.appendReplacement(sb, replacement);
            }
            m.appendTail(sb);
            return ResourceHelper.decodeUrlsInContent(sb.toString());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return source;
        }
    }

    public static String decodeUrlsInContent(String content) {
        try {
            StringBuffer sb = new StringBuffer();
            Matcher m = p_url_decoder.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                url = URLDecoder.decode(url, "UTF-8");
                m.appendReplacement(sb, String.valueOf(m.group(1)) + url + m.group(4));
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
            return content;
        }
    }

    public static String fixElementUrl(MethodElement element, String urltext, MethodConfiguration config) {
        Matcher m = p_link_href_picker.matcher(" " + urltext + " ");
        StringBuffer sb = new StringBuffer();
        if (m.find()) {
            String guid;
            String url = m.group(1);
            String newurl = null;
            if (element != null && (guid = ResourceHelper.getGuidFromUrl(urltext)) != null) {
                MethodElement e;
                ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
                MethodElement methodElement = e = manager != null ? manager.getMethodElement(guid) : null;
                if (e != null) {
                    if (config != null) {
                        e = ConfigurationHelper.getCalculatedElement(e, config);
                    }
                    newurl = ResourceHelper.getUrl(e, element, FILE_EXT_HTML, url);
                }
            }
            if (newurl != null && !newurl.equals(url)) {
                String replacement = " href=\"" + newurl + "\" ";
                m.appendReplacement(sb, replacement);
                m.appendTail(sb);
                return sb.toString();
            }
        }
        return urltext;
    }

    public static String getElementLinkType(String source) {
        Matcher m = p_link_type_picker.matcher(" " + source + " ");
        if (m.find()) {
            return m.group(1).trim().replaceAll("\"", "");
        }
        return null;
    }

    public static String getGuidFromUrl(String source) {
        Matcher m = p_link_guid_picker.matcher(" " + source + " ");
        if (m.find()) {
            return m.group(1).trim().replaceAll("\"", "");
        }
        m = p_link_href_picker.matcher(" " + source + " ");
        if (m.find()) {
            String href = m.group(1).trim().replaceAll("\"", "");
            return ResourceHelper.getGuidFromFileName(href);
        }
        return null;
    }

    public static String validateTag(String source) {
        StringBuffer sb = new StringBuffer();
        Matcher m = p_tag_ref.matcher(source);
        while (m.find()) {
            String text = m.group();
            String replacement = ResourceHelper.fixTagAttribute(text);
            m.appendReplacement(sb, replacement);
        }
        m.appendTail(sb);
        return sb.toString();
    }

    public static String fixTagAttribute(String source) {
        return source.replaceAll("\\\r\\\n", " ").replaceAll("\\\r", " ").replaceAll("\\\n", " ");
    }

    public static String getResourceFileUrl(MethodElement e, File file) {
        String fileUrl = ResourceHelper.getFileUrl(file);
        fileUrl = String.valueOf(ResourceHelper.getBackPath(e)) + fileUrl;
        return fileUrl;
    }

    public static String getFileUrl(File f) {
        String path = ResourceHelper.getFileRelPath(f);
        path = path.replace(File.separatorChar, '/');
        return path;
    }

    public static URI getRelativeURI(URI uri, String rootPath) {
        return ResourceHelper.getRelativeURI(uri, new File(rootPath).toURI());
    }

    public static URI getRelativeURI(URI uri, URI relativeTo) {
        URI relUri = relativeTo.relativize(uri);
        return relUri;
    }

    public static String getFileRelPath(File f) {
        File libraryRootPath = new File(LibraryService.getInstance().getCurrentMethodLibraryPath());
        String root = libraryRootPath.getAbsolutePath();
        String path = f.getAbsolutePath();
        if (path.startsWith(root)) {
            path = path.substring(root.length());
        }
        if (path.startsWith(File.separator)) {
            path = path.substring(1);
        }
        return path;
    }

    public static URI getFileRelativeURI(File f) {
        File libraryRootPath = new File(LibraryService.getInstance().getCurrentMethodLibraryPath());
        URI libURI = libraryRootPath.toURI();
        URI fileURI = f.toURI();
        URI relUri = libURI.relativize(fileURI);
        return relUri;
    }

    public static boolean copyFile(File source, File dest) {
        if (source == null || !source.exists()) {
            return false;
        }
        boolean needCopy = true;
        if (dest.exists()) {
            boolean bl = needCopy = dest.lastModified() != source.lastModified() || dest.length() != source.length();
        }
        if (needCopy) {
            File parent = dest.getParentFile();
            if (!parent.exists()) {
                parent.mkdirs();
            }
            try {
                if (!dest.exists()) {
                    dest.createNewFile();
                }
                FileUtil.copyFile((File)source, (File)dest);
            }
            catch (Exception ex) {
                ex.printStackTrace();
                return false;
            }
        }
        return true;
    }

    public static String getURLForAttachment(File attachment, MethodElement element, boolean copyFile) throws IOException {
        String libDir = LibraryService.getInstance().getCurrentMethodLibraryPath();
        String pluginDir = new File(UmaUtil.getMethodPlugin((EObject)element).eResource().getURI().toFileString()).getParent();
        File formatFile = null;
        if (attachment.getAbsolutePath().startsWith(pluginDir)) {
            formatFile = attachment;
        } else {
            String resourceLoc = String.valueOf(libDir) + File.separator + MethodLibraryPersister.getResourcePath((MethodElement)element);
            formatFile = new File(String.valueOf(resourceLoc) + File.separator + attachment.getName());
            if (copyFile) {
                FileUtil.copyfile((File)attachment, (File)formatFile);
            }
        }
        return ResourceHelper.getRelativePathToFileFromElement(element, formatFile);
    }

    public static String getRelativePathToFileFromElement(MethodElement element, File attachment) {
        String libDir = LibraryService.getInstance().getCurrentMethodLibraryPath();
        String elementLoc = String.valueOf(libDir) + File.separator + ResourceHelper.getElementPath(element);
        return FileUtil.getRelativePath((File)attachment, (File)new File(elementLoc));
    }

    public static String getDiagramFilePathName(MethodElement e, String diagramType) {
        return String.valueOf(ResourceHelper.getElementResourcePath(e)) + StrUtil.makeValidFileName((String)e.getName()) + "_" + e.getGuid() + "_" + diagramType + FILE_EXT_JPEG;
    }

    public static String getFilePathFromUrl(String url, String contentPath) {
        if (ResourceHelper.isExternalLink(url) || url.startsWith(URL_STR_MAILTO) || url.startsWith(URL_BOOKMARK_INDICATOR)) {
            return null;
        }
        int index = url.indexOf(FILE_PREFIX_3);
        if (index == 0) {
            url = url.substring(FILE_PREFIX_3.length());
        }
        if ((index = url.indexOf(FILE_PREFIX_2)) == 0) {
            url = url.substring(FILE_PREFIX_2.length());
        }
        File f = new File(contentPath);
        int start = 0;
        index = 0;
        while (f != null && (index = url.indexOf("../", start)) >= 0) {
            f = f.getParentFile();
            start = index + 3;
        }
        String rootFolder = "";
        if (f != null) {
            rootFolder = f.getPath();
        }
        if (rootFolder.length() > 0 && !rootFolder.endsWith(File.separator)) {
            rootFolder = String.valueOf(rootFolder) + File.separator;
        }
        String path = String.valueOf(rootFolder) + url.substring(start).replace('/', File.separatorChar);
        return XMLUtil.unescape((String)NetUtil.decodedFileUrl((String)path));
    }

    public static String fixContentUrlPath(String content, String contentPath, String backPath) {
        StringBuffer sb = new StringBuffer();
        try {
            Matcher m = p_image_ref.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                if ((url = ResourceHelper.resolveUrl(url, contentPath, backPath)) == null) continue;
                m.appendReplacement(sb, String.valueOf(m.group(1)) + url + m.group(4));
            }
            m.appendTail(sb);
            content = sb.toString();
            sb = new StringBuffer();
            m = p_link_ref_gen.matcher(content);
            while (m.find()) {
                Matcher m2;
                StringBuffer sbLink = new StringBuffer();
                String urltext = " " + m.group(2) + " ";
                if (ResourceHelper.getGuidFromUrl(urltext) != null || !(m2 = p_link_href_picker.matcher(urltext)).find()) continue;
                String url = m2.group(1).trim().replaceAll("\"", "");
                if ((url = ResourceHelper.resolveUrl(url, contentPath, backPath)) == null) continue;
                m2.appendReplacement(sbLink, String.valueOf(urltext.substring(m2.start(), m2.start(1))) + url + urltext.substring(m2.end(1), m2.end()));
                m2.appendTail(sbLink);
                m.appendReplacement(sb, String.valueOf(content.substring(m.start(), m.start(2))) + sbLink.toString() + content.substring(m.end(2), m.end()));
            }
            m.appendTail(sb);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return sb.toString();
    }

    public static String resolveUrl(String url, String contentPath, String backPath) {
        if ((url = ResourceHelper.getFilePathFromUrl(url, contentPath)) != null) {
            if (backPath != null) {
                url = String.valueOf(backPath) + url;
            }
            return url.replace(File.separatorChar, '/');
        }
        return null;
    }

    public static boolean isExternalLink(String url) {
        Matcher m = p_external_url_startWith.matcher(url);
        if (m.find()) {
            return m.start(1) == 0;
        }
        return false;
    }

    public static String processResourceUrl(MethodElement owner, File resourceFile, String url, String contentPath, File sourceRootPath, File targetRootPath, List processedItems, IContentValidator validator) {
        String imageFile;
        if (url == null || ResourceHelper.isExternalLink(url) || url.startsWith(URL_STR_MAILTO) || url.toLowerCase().startsWith(URL_STR_JAVASCRIPT) || url.startsWith(URL_BOOKMARK_INDICATOR)) {
            return url;
        }
        String guid = "";
        if (owner != null) {
            guid = owner.getGuid();
        }
        if (url.indexOf(guid) >= 0) {
            return url;
        }
        int index = url.indexOf(URL_BOOKMARK_INDICATOR);
        if (index < 0) {
            index = url.indexOf(URL_PARAMETER_INDICATOR);
        }
        String url_tail = "";
        if (index > 0) {
            url_tail = url.substring(index);
            url = url.substring(0, index);
        }
        if ((imageFile = ResourceHelper.getFilePathFromUrl(url, contentPath)) == null) {
            if (validator != null) {
                validator.logMissingResource(owner, resourceFile, url);
            }
            return null;
        }
        if (imageFile.equalsIgnoreCase("index.htm") || imageFile.equalsIgnoreCase("index.html")) {
            return String.valueOf(url) + url_tail;
        }
        String newUrl = url;
        File source = new File(sourceRootPath, imageFile);
        if (!source.exists()) {
            source = new File(LibraryPlugin.getDefault().getLayoutPath(), imageFile);
        }
        File dest = new File(targetRootPath, imageFile);
        if (source.exists()) {
            ResourceHelper.copyFile(source, dest);
            if (imageFile.endsWith(FILE_EXT_HTM) || imageFile.endsWith(FILE_EXT_HTML)) {
                File f = new File(imageFile);
                try {
                    ResourceHelper.resolveResources(owner, f, FileUtil.readFile((File)source, (String)"UTF-8").toString(), f.getParent(), sourceRootPath, targetRootPath, processedItems, validator);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else if (!dest.exists() && ResourceHelper.isValidFileUrl(url) && validator != null) {
            validator.logMissingResource(owner, resourceFile, url);
        }
        return String.valueOf(newUrl) + url_tail;
    }

    private static boolean isValidFileUrl(String url) {
        return url != null && !url.equals("' + diagram_img + '");
    }

    public static void resolveResources(MethodElement owner, File resourceFile, String content, String contentPath, File sourceRootPath, File targetRootPath, List processedItems, IContentValidator validator) {
        try {
            Matcher m = p_image_ref.matcher(content);
            while (m.find()) {
                String url = m.group(3);
                if (processedItems.contains(url)) continue;
                processedItems.add(url);
                ResourceHelper.processResourceUrl(owner, resourceFile, url, contentPath, sourceRootPath, targetRootPath, processedItems, validator);
            }
            m = p_css_ref.matcher(content);
            while (m.find()) {
                String cssURL = m.group(1);
                if (processedItems.contains(cssURL)) continue;
                processedItems.add(cssURL);
                ResourceHelper.processResourceUrl(owner, resourceFile, cssURL, contentPath, sourceRootPath, targetRootPath, processedItems, null);
            }
            m = p_link_ref_gen.matcher(content);
            while (m.find()) {
                String url;
                Matcher m2;
                String urltext = m.group(2);
                if (ResourceHelper.getGuidFromUrl(urltext) != null || !(m2 = p_link_href_picker.matcher(" " + urltext + " ")).find() || processedItems.contains(url = m2.group(1).trim().replaceAll("\"", ""))) continue;
                processedItems.add(url);
                ResourceHelper.processResourceUrl(owner, resourceFile, url, contentPath, sourceRootPath, targetRootPath, processedItems, validator);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public static Map getTagAttributes(String attributesStr) {
        LinkedHashMap<String, String> attributeMap = new LinkedHashMap<String, String>(3);
        Matcher m2 = p_tag_attributes.matcher(attributesStr);
        while (m2.find()) {
            String attrName = m2.group(1).trim().toLowerCase();
            String attrValue = m2.group(3).trim();
            if (attrName.equals(TAG_ATTR_HREF)) {
                try {
                    attrValue = URLDecoder.decode(attrValue, "UTF-8");
                }
                catch (UnsupportedEncodingException e) {
                    e.printStackTrace();
                }
            }
            attributeMap.put(attrName, attrValue);
        }
        return attributeMap;
    }

    public static Map getAttributesFromLink(String link) {
        Matcher m = p_link_ref.matcher(link);
        if (m.find()) {
            String attributes = m.group(1);
            return ResourceHelper.getTagAttributes(attributes);
        }
        return null;
    }

    public static String getAttributesAsString(Map attributeMap) {
        StringBuffer buf = new StringBuffer();
        Iterator iter = attributeMap.keySet().iterator();
        while (iter.hasNext()) {
            String key = (String)iter.next();
            String value = (String)attributeMap.get(key);
            if (buf.length() > 0) {
                buf.append(" ");
            }
            buf.append(String.valueOf(key) + "=\"" + value + "\"");
        }
        return buf.toString();
    }

    private static String getDiscardedElementURL(MethodElement ownerElement, MethodElement linkElement, String guid, String pubDir) {
        StringBuffer discardedElementURL = new StringBuffer();
        discardedElementURL.append(MISSING_PAGES_FOLDER).append("pages_not_installed").append(FILE_EXT_HTML);
        File outputFile = new File(pubDir, discardedElementURL.toString());
        File dir = outputFile.getParentFile();
        if (!dir.exists()) {
            dir.mkdirs();
        }
        XmlElement xml = new XmlElement("Element");
        xml.setAttribute(TAG_ATTR_GUID, guid).setAttribute("type", linkElement.getType().getName()).setAttribute(TAG_ATTR_NAME, linkElement.getName()).setAttribute("pluginName", LibraryUtil.getMethodPlugin((EObject)linkElement).getName());
        String xslPath = LayoutResources.getXslUri("page_not_installed", null);
        try {
            StringBuffer xml2 = new StringBuffer();
            xml2.append(XmlHelper.XML_HEADER).append(xml.toXml());
            OutputStreamWriter output = new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), "utf-8");
            Properties xslParams = LibraryPlugin.getDefault().getProperties("/layout/xsl/resources.properties");
            XSLTProcessor.transform((String)xslPath, (String)xml2.toString(), (Properties)xslParams, (Writer)output);
            output.flush();
            output.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return String.valueOf(ResourceHelper.getBackPath(ownerElement).replace(File.separatorChar, '/')) + discardedElementURL.toString();
    }

    public static String validateRichTextContent(MethodElement element, String source, IContentValidator validator) {
        try {
            MethodConfiguration config = null;
            source = ResourceHelper.validateTag(source);
            StringBuffer sb = new StringBuffer();
            Matcher m = p_link_ref.matcher(source);
            while (m.find()) {
                String linkedText;
                String text = m.group();
                String urltext = m.group(1);
                LinkInfo info = validator.validateLink(element, urltext, linkedText = m.group(2), config);
                if (info != null) {
                    text = info.getHtml(validator.showBrokenLinks()).toString();
                    MethodElement e = info.getLinkedElement();
                    if (e != null) {
                        validator.addReferencedElement(element, e);
                    }
                }
                String replacement = text.replaceAll(FILE_PREFIX_3, "");
                replacement = replacement.replaceAll(FILE_PREFIX_2, "");
                m.appendReplacement(sb, replacement);
            }
            m.appendTail(sb);
            if (element == null) {
                return sb.toString();
            }
            source = sb.toString();
            m = p_area_ref.matcher(source);
            sb.setLength(0);
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            while (m.find()) {
                String href = m.group(2);
                String guid = ResourceHelper.getGuidFromFileName(href);
                if (guid != null) {
                    MethodElement e;
                    MethodElement methodElement = e = manager != null ? manager.getMethodElement(guid) : null;
                    if (e != null) {
                        MethodElement e1 = ConfigurationHelper.getCalculatedElement(e, config);
                        if (e1 != null) {
                            e = e1;
                        }
                        validator.addReferencedElement(element, e);
                        href = ConfigurationHelper.inConfig(e, config) && !validator.isDiscarded(element, null, e) ? ResourceHelper.getUrl(e, element, FILE_EXT_HTML, href) : (validator.showBrokenLinks() ? ResourceHelper.getDiscardedElementURL(element, e, guid, ((DefaultContentValidator)validator).getPublishDir()) : "");
                    }
                }
                String replacement = href == null || href.length() == 0 ? String.valueOf(source.substring(m.start(), m.start(1))) + source.substring(m.end(1), m.end()) : String.valueOf(source.substring(m.start(), m.start(2))) + href + source.substring(m.end(2), m.end());
                m.appendReplacement(sb, replacement);
            }
            m.appendTail(sb);
            return sb.toString();
        }
        catch (Exception ex) {
            LibraryPlugin.getDefault().getLogger().logError((Throwable)ex);
            return source;
        }
    }
}

