/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.diagram.model.util;

import java.util.Iterator;
import java.util.StringTokenizer;
import org.eclipse.epf.library.edit.util.ConstraintManager;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.Constraint;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.SupportingMaterial;

public class DiagramInfo {
    private static final String AD_IMAGE_URI = "ad_image_uri";
    private static final String ADD_IMAGE_URI = "add_image_uri";
    private static final String WPD_IMAGE_URI = "wpd_image_uri";
    private static final String PUBLISH_AD_IMAGE = "publish_ad_image";
    private static final String PUBLISH_ADD_IMAGE = "publish_add_image";
    private static final String PUBLISH_WPD_IMAGE = "publish_wpd_image";
    private static final String DELIMITER = "|";
    private Activity activity;
    private String AD_ImageURI;
    private String ADD_ImageURI;
    private String WPD_ImageURI;
    private boolean publishADImage;
    private boolean publishADDImage;
    private boolean publishWPDImage;
    private Constraint constraint;
    private SupportingMaterial activityDiagram;
    private SupportingMaterial activityDetailDiagram;
    private SupportingMaterial wpdDiagram;

    public DiagramInfo(Activity activity) {
        this.activity = activity;
        this.refresh();
    }

    private DiagramInfo() {
        this.WPD_ImageURI = "";
        this.ADD_ImageURI = "";
        this.AD_ImageURI = "";
    }

    private DiagramInfo load() {
        DiagramInfo info = new DiagramInfo();
        StringTokenizer tokens = new StringTokenizer(this.constraint.getBody(), DELIMITER);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken();
            int id = token.indexOf(61);
            int max = token.length() - 1;
            if (id == -1 || id >= max) continue;
            String key = token.substring(0, id);
            if (key.equalsIgnoreCase(AD_IMAGE_URI)) {
                info.AD_ImageURI = token.substring(id + 1);
                continue;
            }
            if (key.equalsIgnoreCase(ADD_IMAGE_URI)) {
                info.ADD_ImageURI = token.substring(id + 1);
                continue;
            }
            if (key.equalsIgnoreCase(WPD_IMAGE_URI)) {
                info.WPD_ImageURI = token.substring(id + 1);
                continue;
            }
            if (key.equalsIgnoreCase(PUBLISH_AD_IMAGE)) {
                info.publishADImage = Boolean.valueOf(token.substring(id + 1));
                continue;
            }
            if (key.equalsIgnoreCase(PUBLISH_ADD_IMAGE)) {
                info.publishADDImage = Boolean.valueOf(token.substring(id + 1));
                continue;
            }
            if (!key.equalsIgnoreCase(PUBLISH_WPD_IMAGE)) continue;
            info.publishWPDImage = Boolean.valueOf(token.substring(id + 1));
        }
        return info;
    }

    private void save() {
        if (this.constraint == null) {
            this.constraint = ConstraintManager.getConstraint((MethodElement)this.activity, (String)"diagram", (boolean)true);
        }
        if (this.activityDiagram != null) {
            this.AD_ImageURI = this.activityDiagram.getGuid();
        }
        if (this.activityDetailDiagram != null) {
            this.ADD_ImageURI = this.activityDetailDiagram.getGuid();
        }
        if (this.wpdDiagram != null) {
            this.WPD_ImageURI = this.wpdDiagram.getGuid();
        }
        DiagramInfo info = this.load();
        if (this.AD_ImageURI != null) {
            info.AD_ImageURI = this.AD_ImageURI;
        }
        if (this.ADD_ImageURI != null) {
            info.ADD_ImageURI = this.ADD_ImageURI;
        }
        if (this.WPD_ImageURI != null) {
            info.WPD_ImageURI = this.WPD_ImageURI;
        }
        info.publishADImage = this.publishADImage;
        info.publishADDImage = this.publishADDImage;
        info.publishWPDImage = this.publishWPDImage;
        String str = AD_IMAGE_URI + '=' + info.AD_ImageURI + DELIMITER + PUBLISH_AD_IMAGE + '=' + String.valueOf(info.publishADImage) + DELIMITER + ADD_IMAGE_URI + '=' + String.valueOf(info.ADD_ImageURI) + DELIMITER + PUBLISH_ADD_IMAGE + '=' + String.valueOf(info.publishADDImage) + DELIMITER + WPD_IMAGE_URI + '=' + String.valueOf(info.WPD_ImageURI) + DELIMITER + PUBLISH_WPD_IMAGE + '=' + String.valueOf(info.publishWPDImage);
        this.constraint.setBody(str);
    }

    public void refresh() {
        this.constraint = ConstraintManager.getConstraint((MethodElement)this.activity, (String)"diagram", (boolean)false);
        if (this.constraint == null) {
            return;
        }
        DiagramInfo info = this.load();
        this.AD_ImageURI = info.AD_ImageURI;
        this.ADD_ImageURI = info.ADD_ImageURI;
        this.WPD_ImageURI = info.WPD_ImageURI;
        this.publishADImage = info.publishADImage;
        this.publishADDImage = info.publishADDImage;
        this.publishWPDImage = info.publishWPDImage;
        this.activityDiagram = this.getSupportingMaterial(this.AD_ImageURI);
        this.activityDetailDiagram = this.getSupportingMaterial(this.ADD_ImageURI);
        this.wpdDiagram = this.getSupportingMaterial(this.WPD_ImageURI);
    }

    public String getAD_ImageURI() {
        return this.AD_ImageURI;
    }

    public String getADD_ImageURI() {
        return this.ADD_ImageURI;
    }

    public String getWPD_ImageURI() {
        return this.WPD_ImageURI;
    }

    public boolean canPublishADDImage() {
        return this.publishADDImage;
    }

    public void setPublishADDImage(boolean publishADDImage) {
        this.publishADDImage = publishADDImage;
        this.save();
    }

    public boolean canPublishADImage() {
        return this.publishADImage;
    }

    public void setPublishADImage(boolean publishADImage) {
        this.publishADImage = publishADImage;
        this.save();
    }

    public boolean canPublishWPDImage() {
        return this.publishWPDImage;
    }

    public void setPublishWPDImage(boolean publishWPDImage) {
        this.publishWPDImage = publishWPDImage;
        this.save();
    }

    public SupportingMaterial getActivityDiagram() {
        return this.activityDiagram;
    }

    public SupportingMaterial getActivityDetailDiagram() {
        return this.activityDetailDiagram;
    }

    public SupportingMaterial getWPDDiagram() {
        return this.wpdDiagram;
    }

    public void setWPDDiagram(SupportingMaterial wpdDiagram) {
        if (this.wpdDiagram != wpdDiagram) {
            SupportingMaterial old = this.wpdDiagram;
            this.wpdDiagram = wpdDiagram;
            this.update(old, wpdDiagram);
        }
    }

    public void setActivityDetailDiagram(SupportingMaterial activityDetailDiagram) {
        if (this.activityDetailDiagram != activityDetailDiagram) {
            SupportingMaterial old = this.activityDetailDiagram;
            this.activityDetailDiagram = activityDetailDiagram;
            this.update(old, activityDetailDiagram);
        }
    }

    public void setActivityDiagram(SupportingMaterial activityDiagram) {
        if (this.activityDiagram != activityDiagram) {
            SupportingMaterial old = this.activityDiagram;
            this.activityDiagram = activityDiagram;
            this.update(old, activityDiagram);
        }
    }

    private SupportingMaterial getSupportingMaterial(String diagramURI) {
        Iterator iter = this.activity.getSupportingMaterials().iterator();
        while (iter.hasNext()) {
            SupportingMaterial e = (SupportingMaterial)iter.next();
            if (!e.getGuid().equals(diagramURI)) continue;
            return e;
        }
        return null;
    }

    private void update(SupportingMaterial old, SupportingMaterial neu) {
        if (old != null) {
            this.activity.getSupportingMaterials().remove(old);
        }
        if (neu != null) {
            this.activity.getSupportingMaterials().add(neu);
        }
        this.save();
    }

    public boolean isDiagram(SupportingMaterial sm) {
        return sm != null && (sm == this.activityDiagram || sm == this.activityDetailDiagram || sm == this.wpdDiagram);
    }
}

