/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.export.xml.services;

import commonj.sdo.Type;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EDataType;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.ecore.xml.type.XMLTypeFactory;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.export.xml.XmlExportResources;
import org.eclipse.epf.export.xml.services.FeatureManager;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.xml.uma.BreakdownElement;
import org.eclipse.epf.xml.uma.ContentCategoryPackage;
import org.eclipse.epf.xml.uma.ContentPackage;
import org.eclipse.epf.xml.uma.DocumentRoot;
import org.eclipse.epf.xml.uma.MethodElement;
import org.eclipse.epf.xml.uma.MethodLibrary;
import org.eclipse.epf.xml.uma.MethodPackage;
import org.eclipse.epf.xml.uma.MethodPlugin;
import org.eclipse.epf.xml.uma.Process;
import org.eclipse.epf.xml.uma.ProcessComponent;
import org.eclipse.epf.xml.uma.ProcessPackage;
import org.eclipse.epf.xml.uma.UmaFactory;
import org.eclipse.epf.xml.uma.UmaPackage;
import org.eclipse.epf.xml.uma.VariabilityType;
import org.eclipse.epf.xml.uma.WorkOrder;
import org.eclipse.epf.xml.uma.WorkOrderType;
import org.eclipse.epf.xml.uma.util.UmaResourceFactoryImpl;
import org.eclipse.osgi.util.NLS;

public class XmlLibrary {
    private String filePath;
    private ILogger logger;
    private ContentProcessor contentProc = null;
    private MethodLibrary rootObject;
    private Map contentCategoryPkgMap = new HashMap();
    Map elementsMap = new HashMap();

    public XmlLibrary(ContentProcessor contentProc, ILogger logger, String filePath) {
        this.contentProc = contentProc;
        this.logger = logger;
        this.filePath = filePath;
    }

    public EDataObject getRoot() {
        return this.rootObject;
    }

    public String getFilePath() {
        return this.filePath;
    }

    public String[] getPluginIds() {
        EList plugins = this.rootObject.getMethodPlugin();
        String[] ids = new String[plugins.size()];
        int i = 0;
        while (i < plugins.size()) {
            ids[i] = ((MethodPlugin)plugins.get(i)).getId();
            ++i;
        }
        return ids;
    }

    public EDataObject createLibrary(String id, String name) {
        MethodLibrary root = UmaFactory.eINSTANCE.createMethodLibrary();
        return this.create(id, name, (MethodElement)root);
    }

    public void load() {
        try {
            ResourceSetImpl resourceSet = new ResourceSetImpl();
            URI fileURI = URI.createFileURI((String)this.filePath);
            Resource resource = new UmaResourceFactoryImpl().createResource(fileURI);
            resourceSet.getResources().add((Object)resource);
            resource.load(new HashMap());
            DocumentRoot root = (DocumentRoot)resource.getContents().get(0);
            Iterator itr = root.eContents().iterator();
            while (itr.hasNext()) {
                Object o = itr.next();
                if (!(o instanceof MethodLibrary)) continue;
                this.rootObject = (MethodLibrary)o;
                break;
            }
        }
        catch (IOException e) {
            this.logger.logError(NLS.bind((String)XmlExportResources.XmlLibrary_error_load_xml, (Object)this.filePath), (Throwable)e);
        }
    }

    private MethodLibrary create(String id, String name, MethodElement root) {
        ResourceSetImpl resourceSet = new ResourceSetImpl();
        URI fileURI = URI.createFileURI((String)this.filePath);
        Resource resource = new UmaResourceFactoryImpl().createResource(fileURI);
        resourceSet.getResources().add((Object)resource);
        this.setElement(id, (EDataObject)root);
        if (root != null) {
            resource.getContents().add((Object)root);
        }
        try {
            HashMap<String, String> options = new HashMap<String, String>();
            options.put("ENCODING", "UTF-8");
            resource.save(options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (root instanceof MethodLibrary) {
            this.rootObject = (MethodLibrary)root;
        }
        return this.rootObject;
    }

    public EDataObject getContentCategoryPackage(String pluginId) {
        ContentCategoryPackage pkg = (ContentCategoryPackage)this.contentCategoryPkgMap.get(pluginId);
        if (pkg != null) {
            return pkg;
        }
        MethodPlugin plugin = (MethodPlugin)this.getElement(pluginId);
        if (plugin == null) {
            this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_no_plugin, (Object)pluginId));
            return null;
        }
        pkg = UmaFactory.eINSTANCE.createContentCategoryPackage();
        pkg.setName("ContentCategories");
        this.setElement(EcoreUtil.generateUUID(), (EDataObject)pkg);
        plugin.getMethodPackage().add((Object)pkg);
        this.contentCategoryPkgMap.put(pluginId, pkg);
        return pkg;
    }

    public void save() throws Exception {
        HashMap<String, String> options = new HashMap<String, String>();
        options.put("ENCODING", "UTF-8");
        Resource resource = this.rootObject.eResource();
        resource.save(options);
    }

    public EDataObject open() {
        return this.rootObject;
    }

    public EDataObject getElement(String guid) {
        return (EDataObject)this.elementsMap.get(guid);
    }

    public EDataObject getElement(Object obj) {
        if (obj instanceof MethodElement) {
            return this.getElement(((MethodElement)obj).getId());
        }
        return null;
    }

    public String getElementId(EDataObject obj) {
        if (obj instanceof MethodElement) {
            return ((MethodElement)obj).getId();
        }
        return null;
    }

    private void setElement(String guid, EDataObject obj) {
        if (!this.elementsMap.containsKey(guid)) {
            if (obj instanceof MethodElement) {
                ((MethodElement)obj).setId(guid);
            }
            this.elementsMap.put(guid, obj);
        }
    }

    public EDataObject createElement(EDataObject container, String umaFeatureName, String umaEClassName, String umaElementType, String guid) {
        EDataObject obj;
        block17: {
            obj = this.getElement(guid);
            if (obj == null) {
                if (FeatureManager.INSTANCE.isUnneededRmcFeature(umaFeatureName)) {
                    return null;
                }
                EStructuralFeature feature = FeatureManager.INSTANCE.getXmlFeature(container.eClass(), umaFeatureName, umaElementType);
                if (feature == null) {
                    this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_no_feature, (Object)container.eClass().getName(), (Object)umaFeatureName));
                    return null;
                }
                EClass objClass = FeatureManager.INSTANCE.getXmlEClass(umaEClassName);
                if (objClass == null) {
                    this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_no_class, (Object)umaEClassName));
                    return null;
                }
                obj = (EDataObject)EcoreUtil.create((EClass)objClass);
                this.setElement(guid, obj);
                if (obj instanceof WorkOrder) {
                    return obj;
                }
                if (feature.isMany()) {
                    List values = (List)container.eGet(feature);
                    try {
                        if (feature instanceof EAttribute) {
                            values.add(guid);
                            this.addToContainer((EObject)container, (EObject)obj);
                            break block17;
                        }
                        if (feature instanceof EReference) {
                            try {
                                values.add(obj);
                            }
                            catch (RuntimeException e) {
                                e.printStackTrace();
                            }
                            break block17;
                        }
                        this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_error_create_element, (Object)feature.getName()));
                    }
                    catch (RuntimeException e) {
                        this.logger.logError(NLS.bind((String)XmlExportResources.XmlLibrary_error_set_value, (Object)obj, (Object)container), (Throwable)e);
                    }
                } else if (feature instanceof EAttribute) {
                    container.eSet(feature, (Object)guid);
                    this.addToContainer((EObject)container, (EObject)obj);
                } else if (feature instanceof EReference) {
                    container.eSet(feature, (Object)obj);
                } else {
                    this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_error_create_element, (Object)feature.getName()));
                }
            }
        }
        return obj;
    }

    private void addToContainer(EObject container, EObject obj) {
        if (container == null) {
            return;
        }
        if (container instanceof ContentPackage) {
            ((ContentPackage)container).getContentElement().add((Object)obj);
        } else if (container instanceof ProcessPackage) {
            ((ProcessPackage)container).getProcessElement().add((Object)obj);
        } else {
            this.addToContainer(container.eContainer(), obj);
        }
    }

    public void setAtributeFeatureValue(EDataObject obj, String featureName, Object value) throws Exception {
        if (obj == null || featureName == null || value == null) {
            return;
        }
        if (value instanceof List || value instanceof EDataObject) {
            this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_invalid_feature_value, (Object)featureName, (Object)value));
            return;
        }
        EStructuralFeature feature = FeatureManager.INSTANCE.getXmlFeature(obj.eClass(), featureName);
        if (feature == null) {
            if (!(obj instanceof WorkOrder)) {
                Object[] paras = new Object[]{featureName, obj, value};
                this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_error_set_value_2, (Object[])paras));
            }
            return;
        }
        if (feature instanceof EAttribute) {
            try {
                if (feature.getName().equals("variabilityType")) {
                    value = VariabilityType.get((String)value.toString());
                } else if (feature.getName().equals("linkType")) {
                    value = WorkOrderType.get((String)value.toString());
                } else if (value instanceof Date) {
                    value = this.getXmlDate((Date)value);
                } else if (this.contentProc != null && obj instanceof MethodElement && value instanceof String) {
                    value = this.contentProc.resolveResourceFiles((Object)((MethodElement)obj), (String)value);
                } else if (value instanceof java.net.URI) {
                    value = ((java.net.URI)value).getPath();
                    if (this.contentProc != null) {
                        this.contentProc.copyResource((String)value);
                    }
                }
                obj.eSet(feature, value);
            }
            catch (RuntimeException e) {
                Object[] paras = new Object[]{featureName, obj, value};
                this.logger.logError(NLS.bind((String)XmlExportResources.XmlLibrary_error_set_value_2, (Object[])paras), (Throwable)e);
            }
        } else {
            System.out.println(XmlExportResources.XmlLibrary_error_set_value_3);
        }
    }

    public void setReferenceValue(EDataObject obj, String featureName, String idValue, Type valueType) throws Exception {
        EDataObject v;
        if (obj == null || featureName == null || idValue == null) {
            return;
        }
        if (FeatureManager.INSTANCE.isUnneededRmcFeature(featureName)) {
            return;
        }
        EStructuralFeature feature = FeatureManager.INSTANCE.getXmlFeature(obj.eClass(), featureName, valueType.getName());
        if (feature == null) {
            Object[] paras = new Object[]{featureName, obj, idValue};
            this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_error_set_reference, (Object[])paras));
            return;
        }
        String str = feature.getEType().getName();
        if (str.equals("String")) {
            if (feature.isMany()) {
                List l = (List)obj.eGet(feature);
                if (!l.contains(idValue)) {
                    l.add(idValue);
                }
            } else {
                obj.eSet(feature, (Object)idValue);
            }
        } else if (feature == UmaPackage.eINSTANCE.getActivity_BreakdownElement() && (v = this.getElement(idValue)) instanceof BreakdownElement) {
            EObject old_container = v.eContainer();
            List l = (List)obj.eGet(feature);
            if (!l.contains(v)) {
                l.add(v);
            }
            if (old_container instanceof ProcessPackage && old_container.eContainer() instanceof ProcessComponent && ((ProcessPackage)old_container).getProcessElement().size() == 0) {
                ((ProcessPackage)old_container.eContainer()).getMethodPackage().remove((Object)old_container);
            }
        }
    }

    public Object getXmlDate(Date dt) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        String dtStr = sdf.format(dt);
        dtStr = dtStr.replace(' ', 'T');
        EDataType type = XMLTypePackage.eINSTANCE.getDateTime();
        return XMLTypeFactory.eINSTANCE.createFromString(type, dtStr);
    }

    private String getString(Object obj) {
        String str = "";
        if (obj instanceof MethodElement) {
            MethodElement me = (MethodElement)obj;
            str = String.valueOf(me.getType().getName()) + ":" + me.getName();
        } else if (obj != null) {
            str = obj.toString();
        }
        return str;
    }

    public void fixLibrary() {
        this.fixGuid((MethodElement)this.rootObject);
        if (this.rootObject instanceof MethodLibrary) {
            Iterator it = this.rootObject.getMethodPlugin().iterator();
            while (it.hasNext()) {
                this.fixPlugin((MethodPlugin)it.next());
            }
        } else if (this.rootObject instanceof MethodPlugin) {
            this.fixPlugin((MethodPlugin)this.rootObject);
        }
    }

    public List getReferencedPlugins() {
        ArrayList<String> externalPlugins = new ArrayList<String>();
        if (!(this.rootObject instanceof MethodLibrary)) {
            return externalPlugins;
        }
        ArrayList<String> selectedPlugins = new ArrayList<String>();
        Iterator it = this.rootObject.getMethodPlugin().iterator();
        while (it.hasNext()) {
            MethodPlugin plugin = (MethodPlugin)it.next();
            String id = plugin.getId();
            selectedPlugins.add(id);
            if (externalPlugins.contains(id)) {
                externalPlugins.remove(id);
            }
            Iterator itr = plugin.getReferencedMethodPlugin().iterator();
            while (itr.hasNext()) {
                String ref = (String)itr.next();
                if (selectedPlugins.contains(ref) || externalPlugins.contains(ref)) continue;
                externalPlugins.add(ref);
            }
        }
        return externalPlugins;
    }

    private void fixGuid(MethodElement element) {
        if (element == null) {
            return;
        }
        String id = element.getId();
        if (id == null || id.equals("")) {
            id = EcoreUtil.generateUUID();
            element.setId(id);
            String msg = NLS.bind((String)XmlExportResources.XmlLibrary_new_id, (Object)this.getString(element), (Object)id);
            this.logger.logWarning(msg);
        } else {
            EDataObject old = this.getElement(id);
            if (old != null && old != element) {
                this.logger.logWarning(NLS.bind((String)XmlExportResources.XmlLibrary_id_not_unique, (Object)id));
            }
            this.setElement(id, (EDataObject)element);
        }
        Iterator it = element.eContents().iterator();
        while (it.hasNext()) {
            Object o = it.next();
            if (!(o instanceof MethodElement)) continue;
            this.fixGuid((MethodElement)o);
        }
    }

    private void fixPlugin(MethodPlugin plugin) {
        ArrayList<EObject> procs = new ArrayList<EObject>();
        Object it = plugin.eAllContents();
        while (it.hasNext()) {
            EObject o = (EObject)it.next();
            if (!this.isProcess(o)) continue;
            procs.add(o);
        }
        if (procs.size() > 0) {
            it = procs.iterator();
            while (it.hasNext()) {
                this.fixProcess((Process)it.next());
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    private boolean isProcess(EObject obj) {
        if (!(obj instanceof Process)) {
            return false;
        }
        if (!((obj = obj.eContainer()) instanceof ProcessComponent)) ** GOTO lbl7
        return true;
lbl-1000:
        // 1 sources

        {
            if (!(obj instanceof ProcessComponent)) continue;
            return false;
lbl7:
            // 2 sources

            ** while ((obj = obj.eContainer()) != null && obj instanceof ProcessPackage)
        }
lbl8:
        // 1 sources

        return true;
    }

    private void fixProcess(Process proc) {
        EDataObject container = (EDataObject)proc.eContainer();
        ProcessComponent pc = null;
        if (container instanceof ProcessComponent) {
            return;
        }
        if (!(container instanceof ProcessPackage)) {
            String msg = NLS.bind((String)XmlExportResources.XmlLibrary_error_process_wrong_container, (Object)proc.getName(), (Object)container.getType().getName());
            this.logger.logWarning(msg);
            return;
        }
        pc = UmaFactory.eINSTANCE.createProcessComponent();
        String id = this.getTargetParentId(proc.getId());
        if (id == null) {
            id = EcoreUtil.generateUUID();
        }
        pc.setId(id);
        pc.setName(proc.getName());
        ((ProcessPackage)container).getProcessElement().remove((Object)proc);
        ((ProcessPackage)container).getMethodPackage().add((Object)pc);
        pc.setProcess(proc);
    }

    private String getTargetParentId(String id) {
        org.eclipse.epf.uma.MethodElement obj;
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null && (obj = manager.getMethodElement(id)) != null && (obj = obj.eContainer()) instanceof org.eclipse.epf.uma.MethodElement) {
            return obj.getGuid();
        }
        return null;
    }

    public List getAllProcesses(MethodPackage pkg) {
        ArrayList processes = new ArrayList();
        this._iteratePackageForProcesses(pkg, processes);
        return processes;
    }

    private void _iteratePackageForProcesses(MethodPackage pkg, List processes) {
        Process p;
        if (pkg instanceof ProcessComponent && (p = ((ProcessComponent)pkg).getProcess()) != null && !processes.contains(p)) {
            processes.add(p);
        }
        Iterator it = pkg.getMethodPackage().iterator();
        while (it.hasNext()) {
            this._iteratePackageForProcesses((MethodPackage)it.next(), processes);
        }
    }
}

