/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.update.internal.ui.wizards;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.internal.operations.UpdateUtils;
import org.eclipse.update.internal.ui.UpdateUI;
import org.eclipse.update.internal.ui.UpdateUIMessages;
import org.eclipse.update.internal.ui.wizards.BannerPage;
import org.eclipse.update.internal.ui.wizards.ISearchProvider;
import org.eclipse.update.search.UpdateSearchRequest;

public class ModeSelectionPage
extends BannerPage
implements ISearchProvider {
    private boolean updateMode = true;
    private Button updatesButton;
    private Button newFeaturesButton;
    private UpdateSearchRequest searchRequest;
    private static final String SECTION_ID = "ModeSelectionPage";
    private static final String P_NEW_FEATURES_MODE = "new-features-mode";

    public ModeSelectionPage(UpdateSearchRequest searchRequest) {
        super("modeSelection");
        this.setTitle(UpdateUIMessages.ModeSelectionPage_title);
        this.setDescription(UpdateUIMessages.ModeSelectionPage_desc);
        this.searchRequest = searchRequest;
    }

    public UpdateSearchRequest getSearchRequest() {
        this.initializeSearch();
        return this.searchRequest;
    }

    private IDialogSettings getSettings() {
        IDialogSettings master = UpdateUI.getDefault().getDialogSettings();
        IDialogSettings section = master.getSection(SECTION_ID);
        if (section == null) {
            section = master.addNewSection(SECTION_ID);
        }
        return section;
    }

    private void initializeSearch() {
        if (this.searchRequest != null) {
            return;
        }
        this.searchRequest = UpdateUtils.createNewUpdatesRequest(null);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        composite.setLayout((Layout)layout);
        this.updatesButton = new Button(composite, 16);
        this.updatesButton.setText(UpdateUIMessages.ModeSelectionPage_updates);
        this.updateMode = !this.getSettings().getBoolean(P_NEW_FEATURES_MODE);
        this.updatesButton.setSelection(this.updateMode);
        Label updatesText = new Label(composite, 64);
        updatesText.setText(UpdateUIMessages.ModeSelectionPage_updatesText);
        GridData gd = new GridData(768);
        gd.widthHint = 100;
        updatesText.setLayoutData((Object)gd);
        this.updatesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModeSelectionPage.this.updateMode = true;
                ModeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        new Label(composite, 0);
        this.newFeaturesButton = new Button(composite, 16);
        this.newFeaturesButton.setSelection(!this.updateMode);
        this.newFeaturesButton.setText(UpdateUIMessages.ModeSelectionPage_newFeatures);
        this.newFeaturesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ModeSelectionPage.this.updateMode = false;
                ModeSelectionPage.this.getWizard().getContainer().updateButtons();
            }
        });
        Label newFeaturesText = new Label(composite, 64);
        newFeaturesText.setText(UpdateUIMessages.ModeSelectionPage_newFeaturesText);
        gd = new GridData(768);
        gd.widthHint = 100;
        newFeaturesText.setLayoutData((Object)gd);
        Dialog.applyDialogFont((Control)parent);
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)composite, "org.eclipse.update.ui.ModeSelectionPage");
        return composite;
    }

    public void saveSettings() {
        boolean updateMode = this.updatesButton.getSelection();
        this.getSettings().put(P_NEW_FEATURES_MODE, !updateMode);
    }

    public boolean isUpdateMode() {
        return this.updateMode;
    }

    public boolean isPageComplete() {
        return this.updateMode && super.isPageComplete();
    }

    protected boolean isCurrentPage() {
        return super.isCurrentPage();
    }

    public boolean canFlipToNextPage() {
        return !this.updateMode;
    }
}

