/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.importing.xml.services;

import java.net.URI;
import java.text.ParsePosition;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.emf.common.util.TreeIterator;
import org.eclipse.emf.ecore.EAttribute;
import org.eclipse.emf.ecore.EClass;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EReference;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.sdo.EDataObject;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.dataexchange.util.ContentProcessor;
import org.eclipse.epf.dataexchange.util.ILogger;
import org.eclipse.epf.export.xml.services.FeatureManager;
import org.eclipse.epf.importing.xml.XmlImportResources;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.util.ModelStructure;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.util.LibraryUtil;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.CapabilityPattern;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DeliveryProcess;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.DisciplineGrouping;
import org.eclipse.epf.uma.Domain;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.MethodPackage;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.Process;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.ProcessPackage;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.RoleSetGrouping;
import org.eclipse.epf.uma.Tool;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.epf.uma.VariabilityType;
import org.eclipse.epf.uma.WorkBreakdownElement;
import org.eclipse.epf.uma.WorkOrder;
import org.eclipse.epf.uma.WorkOrderType;
import org.eclipse.epf.uma.WorkProductType;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.osgi.util.NLS;

public class UmaLibrary {
    private ILogger logger;
    private ContentProcessor contentProc = null;
    Map elementsMap = new HashMap();
    private MethodPackage cpRoot = null;
    private MethodPackage dpRoot = null;
    private MethodPackage pcRoot = null;

    public UmaLibrary(ContentProcessor contentProc, ILogger logger) {
        this.logger = logger;
        this.contentProc = contentProc;
        this.buildElementsMap();
    }

    public MethodLibrary getRoot() {
        return LibraryService.getInstance().getCurrentMethodLibrary();
    }

    private void buildElementsMap() {
        this.elementsMap.clear();
        this.elementsMap.put(this.getRoot().getGuid(), this.getRoot());
        TreeIterator it = this.getRoot().eAllContents();
        while (it.hasNext()) {
            Object e = it.next();
            if (!(e instanceof MethodElement)) continue;
            this.elementsMap.put(((MethodElement)e).getGuid(), e);
        }
    }

    public EDataObject createContentCategory(String pluginId, String xmlEClassName, String xmlElementType, String id) {
        EDataObject obj = this.getElement(id);
        if (obj != null) {
            return obj;
        }
        MethodPlugin plugin = (MethodPlugin)this.getElement(pluginId);
        EClass objClass = FeatureManager.INSTANCE.getRmcEClass(xmlEClassName);
        if (objClass == null) {
            this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_error_no_eclass, (Object)xmlEClassName));
            return null;
        }
        obj = (EDataObject)EcoreUtil.create((EClass)objClass);
        this.setElement(id, obj);
        ContentPackage rootPkg = (ContentPackage)this.getRootPackage(plugin, obj);
        rootPkg.getContentElements().add(obj);
        return obj;
    }

    public MethodPackage getRootPackage(MethodPlugin plugin, Object obj) {
        String[] path = null;
        if (obj instanceof CustomCategory) {
            path = ModelStructure.DEFAULT.customCategoryPath;
        } else if (obj instanceof Discipline || obj instanceof DisciplineGrouping) {
            path = ModelStructure.DEFAULT.disciplineDefinitionPath;
        } else if (obj instanceof Domain) {
            path = ModelStructure.DEFAULT.domainPath;
        } else if (obj instanceof RoleSet || obj instanceof RoleSetGrouping) {
            path = ModelStructure.DEFAULT.roleSetPath;
        } else if (obj instanceof Tool) {
            path = ModelStructure.DEFAULT.toolPath;
        } else if (obj instanceof WorkProductType) {
            path = ModelStructure.DEFAULT.workProductTypePath;
        }
        if (path != null) {
            return UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])path);
        }
        this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_no_package, (Object)obj));
        return null;
    }

    public EDataObject createMethodPlugin(String id, String name) throws Exception {
        EDataObject obj = this.getElement(id);
        if (obj == null) {
            obj = org.eclipse.epf.dataexchange.importing.LibraryService.INSTANCE.createPlugin(name, id);
            this.setElement(id, obj);
        }
        return obj;
    }

    public EDataObject getContentRootPackage(EDataObject plugin) {
        if (!(plugin instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)plugin), (String[])ModelStructure.DEFAULT.coreContentPath);
    }

    public EDataObject getCapabilityPatternRootPackage(EDataObject plugin) {
        if (!(plugin instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)plugin), (String[])ModelStructure.DEFAULT.capabilityPatternPath);
    }

    public EDataObject getDeliveryProcessRootPackage(EDataObject plugin) {
        if (!(plugin instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)plugin), (String[])ModelStructure.DEFAULT.deliveryProcessPath);
    }

    public EDataObject getProcessContributionRootPackage(EDataObject plugin) {
        if (!(plugin instanceof MethodPlugin)) {
            return null;
        }
        return UmaUtil.findMethodPackage((MethodPlugin)((MethodPlugin)plugin), (String[])ModelStructure.DEFAULT.processContributionPath);
    }

    public EDataObject createElement(EDataObject container, String xmlFeatureName, String xmlEClassName, String xmlElementType, String id) {
        EDataObject obj;
        block19: {
            EStructuralFeature feature;
            block20: {
                obj = this.getElement(id);
                if (obj != null) {
                    return obj;
                }
                EClass objClass = FeatureManager.INSTANCE.getRmcEClass(xmlEClassName);
                if (objClass == null) {
                    this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_error_no_eclass, (Object)xmlEClassName));
                    return null;
                }
                obj = (EDataObject)EcoreUtil.create((EClass)objClass);
                if (obj instanceof WorkOrder) {
                    id = EcoreUtil.generateUUID();
                    ((ProcessPackage)container.eContainer()).getProcessElements().add(obj);
                }
                this.setElement(id, obj);
                if (container instanceof MethodPlugin) {
                    MethodPlugin plugin = (MethodPlugin)container;
                    if (obj instanceof ContentPackage) {
                        MethodPackage pkg_core_content = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.coreContentPath);
                        pkg_core_content.getChildPackages().add(obj);
                    } else if (obj instanceof ProcessComponent) {
                        MethodPackage pkg_cp = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
                        pkg_cp.getChildPackages().add(obj);
                    } else if (obj instanceof ProcessPackage) {
                        MethodPackage pkg_dp = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
                        pkg_dp.getChildPackages().add(obj);
                    }
                    break block19;
                }
                feature = FeatureManager.INSTANCE.getRmcFeature(container.eClass(), xmlFeatureName);
                if (feature != null) break block20;
                return null;
            }
            try {
                if (container instanceof Activity && feature == UmaPackage.eINSTANCE.getActivity_BreakdownElements() && obj instanceof BreakdownElement) {
                    EDataObject pkg = container;
                    while (pkg != null && !(pkg instanceof ProcessPackage)) {
                        pkg = pkg.eContainer();
                    }
                    if (obj instanceof Activity) {
                        List childPkgs = ((ProcessPackage)pkg).getChildPackages();
                        ProcessPackage pp = null;
                        if (childPkgs.size() == 0) {
                            pp = UmaFactory.eINSTANCE.createProcessPackage();
                            pp.setName(((MethodElement)container).getName());
                            this.setElement(EcoreUtil.generateUUID(), (EDataObject)pp);
                            childPkgs.add(pp);
                        } else {
                            pp = (ProcessPackage)childPkgs.get(0);
                        }
                        pkg = pp;
                    }
                    ((ProcessPackage)pkg).getProcessElements().add(obj);
                }
                if (feature.isMany()) {
                    List values = (List)container.eGet(feature);
                    values.add(obj);
                } else {
                    container.eSet(feature, (Object)obj);
                }
            }
            catch (RuntimeException e) {
                this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_error_create_element, (Object)e.getMessage()));
            }
        }
        return obj;
    }

    private void setElement(String guid, EDataObject obj) {
        if (!this.elementsMap.containsKey(guid)) {
            if (obj instanceof MethodElement) {
                ((MethodElement)obj).setGuid(guid);
            }
            this.elementsMap.put(guid, obj);
            this.setDirty((EObject)obj);
        }
    }

    private void setDirty(EObject obj) {
        Resource res = obj.eResource();
        if (res != null && !res.isModified()) {
            res.setModified(true);
        }
    }

    public EDataObject getElement(String guid) {
        return (EDataObject)this.elementsMap.get(guid);
    }

    private Date createDate(String dateStr) {
        dateStr = dateStr.replace('T', ' ');
        SimpleDateFormat f = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
        return f.parse(dateStr, new ParsePosition(0));
    }

    private String getString(Object obj) {
        String str = "";
        if (obj instanceof MethodElement) {
            str = LibraryUtil.getTypeName((MethodElement)((MethodElement)obj));
        } else if (obj != null) {
            str = obj.toString();
        }
        return str;
    }

    public void setAtributeFeatureValue(EDataObject obj, String featureName, Object value) throws Exception {
        if (obj == null || featureName == null || value == null) {
            return;
        }
        if (value instanceof List || value instanceof EDataObject) {
            throw new Exception(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_attribute_2, (Object)value));
        }
        EStructuralFeature feature = FeatureManager.INSTANCE.getRmcFeature(obj.eClass(), featureName);
        if (feature == null) {
            Object[] paras = new Object[]{this.getString(obj), featureName, value};
            this.logger.logWarning(String.valueOf(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_attribute, (Object[])paras)) + obj);
            return;
        }
        this.setDirty((EObject)obj);
        if (feature instanceof EReference && value instanceof String) {
            EDataObject e = this.getElement((String)value);
            if (e != null) {
                if (feature.isMany()) {
                    ((List)obj.eGet(feature)).add(e);
                } else {
                    obj.eSet(feature, (Object)e);
                }
            } else {
                Object[] paras = new Object[]{this.getString(obj), feature.getName(), value};
                String msg = NLS.bind((String)XmlImportResources.RmcLibrary_error_set_attribute, (Object[])paras);
                this.logger.logWarning(msg);
            }
        } else if (feature instanceof EAttribute) {
            try {
                if (feature.getName().equals("variabilityType")) {
                    value = VariabilityType.get((String)value.toString());
                } else if (feature.getName().equals("linkType")) {
                    value = WorkOrderType.get((String)value.toString());
                } else if (feature == UmaPackage.eINSTANCE.getMethodUnit_ChangeDate()) {
                    value = this.createDate(value.toString());
                } else if (feature.getName().equals("nodeicon") || feature.getName().equals("shapeicon")) {
                    value = new URI(value.toString());
                    this.contentProc.copyResource(((URI)value).getPath());
                } else if (this.contentProc != null && obj instanceof MethodElement && value instanceof String) {
                    value = this.contentProc.resolveResourceFiles((Object)((MethodElement)obj), (String)value);
                }
                obj.eSet(feature, value);
            }
            catch (RuntimeException e) {
                Object[] paras = new Object[]{this.getString(obj), featureName, value};
                this.logger.logError(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_attribute, (Object[])paras), (Throwable)e);
            }
        } else {
            Object[] paras = new Object[]{this.getString(obj), featureName, value};
            this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_attribute_3, (Object[])paras));
        }
    }

    public void setReferenceValue(EDataObject obj, String featureName, String id) throws Exception {
        if (obj == null || featureName == null || id == null) {
            return;
        }
        EDataObject value = this.getElement(id);
        if (value == null) {
            this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_reference, (Object)featureName, (Object)id));
            return;
        }
        EStructuralFeature feature = FeatureManager.INSTANCE.getRmcFeature(obj.eClass(), featureName);
        if (feature == null) {
            Object[] paras = new Object[]{this.getString(obj), featureName, id};
            this.logger.logWarning(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_reference_2, (Object[])paras));
            return;
        }
        if (value.eContainer() == obj) {
            return;
        }
        if (feature.isMany()) {
            try {
                List items = (List)obj.eGet(feature);
                if (!items.contains(value)) {
                    items.add(value);
                }
            }
            catch (RuntimeException e) {
                Object[] paras = new Object[]{this.getString(obj), featureName, id};
                this.logger.logError(NLS.bind((String)XmlImportResources.RmcLibrary_error_set_reference_2, (Object[])paras), (Throwable)e);
            }
        } else {
            obj.eSet(feature, (Object)value);
        }
        this.setDirty((EObject)obj);
    }

    public void setWorkOrder(Object umaWorkOrder, String predId) {
        if (umaWorkOrder instanceof WorkOrder) {
            WorkBreakdownElement e = (WorkBreakdownElement)this.getElement(predId);
            ((WorkOrder)umaWorkOrder).setPred(e);
            this.setDirty((EObject)umaWorkOrder);
        }
    }

    public void fixLibrary() {
        MethodLibrary rootObject = this.getRoot();
        Iterator it = rootObject.getMethodPlugins().iterator();
        while (it.hasNext()) {
            this.fixPlugin((MethodPlugin)it.next());
        }
    }

    private void fixPlugin(MethodPlugin plugin) {
        this.fixCustomCategories(plugin);
        ArrayList cpPkgs = new ArrayList();
        ArrayList dpPkgs = new ArrayList();
        ArrayList pcPkgs = new ArrayList();
        this.cpRoot = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.capabilityPatternPath);
        this.dpRoot = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.deliveryProcessPath);
        this.pcRoot = UmaUtil.findMethodPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.processContributionPath);
        this.getAllPackages(this.cpRoot, cpPkgs);
        this.getAllPackages(this.dpRoot, dpPkgs);
        this.getAllPackages(this.pcRoot, pcPkgs);
        ArrayList procs = new ArrayList();
        Object it = plugin.eAllContents();
        while (it.hasNext()) {
            String pName;
            Object o = it.next();
            if (o instanceof ProcessComponent) {
                procs.add(o);
            } else if (o instanceof DescribableElement && ((pName = ((DescribableElement)o).getPresentationName()) == null || pName.length() == 0)) {
                ((DescribableElement)o).setPresentationName(((DescribableElement)o).getName());
            }
            if (!(o instanceof MethodElement)) continue;
            String name = ((MethodElement)o).getName();
            ((MethodElement)o).setName(StrUtil.makeValidFileName((String)name));
        }
        if (procs.size() > 0) {
            it = procs.iterator();
            while (it.hasNext()) {
                ProcessComponent pc = (ProcessComponent)it.next();
                Process proc = pc.getProcess();
                if (proc instanceof DeliveryProcess) {
                    if (dpPkgs.contains(pc)) continue;
                    this.moveProcessComponent((ProcessPackage)pc, this.dpRoot);
                    continue;
                }
                if (!(proc instanceof CapabilityPattern) || cpPkgs.contains(pc)) continue;
                this.moveProcessComponent((ProcessPackage)pc, this.cpRoot);
            }
        }
    }

    private void getAllPackages(MethodPackage pkg, List pkgs) {
        pkgs.add(pkg);
        Iterator it = pkg.getChildPackages().iterator();
        while (it.hasNext()) {
            this.getAllPackages((MethodPackage)it.next(), pkgs);
        }
    }

    private void moveProcessComponent(ProcessPackage pkg, MethodPackage container) {
        EObject o = pkg.eContainer();
        if (o instanceof ProcessPackage && ((ProcessPackage)o).getChildPackages().size() == 1 && o != this.cpRoot && o != this.dpRoot && o != this.pcRoot) {
            this.moveProcessComponent((ProcessPackage)o, container);
        } else {
            container.getChildPackages().add(pkg);
        }
    }

    private void fixCustomCategories(MethodPlugin plugin) {
        ContentPackage pkg = UmaUtil.findContentPackage((MethodPlugin)plugin, (String[])ModelStructure.DEFAULT.customCategoryPath);
        ArrayList items = new ArrayList(pkg.getContentElements());
        ArrayList<CustomCategory> rootItems = new ArrayList<CustomCategory>();
        while (items.size() > 0) {
            CustomCategory cc = (CustomCategory)items.remove(0);
            rootItems.add(cc);
            List subs = cc.getSubCategories();
            items.removeAll(subs);
            rootItems.removeAll(subs);
            Iterator it = cc.getCategorizedElements().iterator();
            while (it.hasNext()) {
                Object item = it.next();
                if (!(item instanceof CustomCategory)) continue;
                items.remove(item);
                rootItems.remove(item);
            }
        }
        TngUtil.getRootCustomCategory((MethodPlugin)plugin).getCategorizedElements().addAll(rootItems);
    }
}

