/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import java.util.Iterator;
import java.util.List;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.commands.ReconnectLinkCommand;
import org.eclipse.epf.authoring.gef.edit.DiagramEditPart;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.SynchBarNodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.commands.Command;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.editparts.AbstractGraphicalEditPart;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;

public class DiagramActionService {
    public static final String ALIGN_HORZ_AVERAGE = "align_horizontal_to_average";
    public static final String ALIGN_HORZ_FIRST_SELECTED = "align_horizontal_to_first_selection";
    public static final String ALIGN_VERT_AVERAGE = "align_vertical_to_average";
    public static final String ALIGN_VERT_FIRST_SELECTED = "align_vertical_to_first_selection";
    private DefaultEditDomain editDomain;
    private GraphicalViewer graphicalViewer;
    private ActionRegistry actionRegistry;

    public DiagramActionService(GraphicalViewer graphicalViewer, DefaultEditDomain editDomain, ActionRegistry actionRegistry) {
        this.graphicalViewer = graphicalViewer;
        this.editDomain = editDomain;
        this.actionRegistry = actionRegistry;
    }

    public void setGraphicalViewer(GraphicalViewer graphicalViewer) {
        this.graphicalViewer = graphicalViewer;
    }

    private GraphicalViewer getGraphicalViewer() {
        return this.graphicalViewer;
    }

    protected CommandStack getCommandStack() {
        return this.getEditDomain().getCommandStack();
    }

    protected DefaultEditDomain getEditDomain() {
        return this.editDomain;
    }

    protected ActionRegistry getActionRegistry() {
        return this.actionRegistry;
    }

    public IAction registerHorizontalAlignAverageAction() {
        Action hAlignAverageAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagramEditor_hAlignAverageAction_text){

            public void run() {
                DiagramActionService.this.horizAlignToAverageSelected();
            }

            public String getId() {
                return DiagramActionService.ALIGN_HORZ_AVERAGE;
            }
        };
        this.getActionRegistry().registerAction((IAction)hAlignAverageAction);
        return hAlignAverageAction;
    }

    public IAction registerHorizontalAlignFirstSelectedAction() {
        Action hAlignFirstSelectedAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagramEditor_hAlignFirstSelectedAction_text){

            public void run() {
                DiagramActionService.this.horzAlignToFirstSelected();
            }

            public String getId() {
                return DiagramActionService.ALIGN_HORZ_FIRST_SELECTED;
            }
        };
        this.getActionRegistry().registerAction((IAction)hAlignFirstSelectedAction);
        return hAlignFirstSelectedAction;
    }

    public IAction registerVerticalAlignAverageAction() {
        Action vAlignAverageAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagramEditor_vAlignAverageAction_text){

            public void run() {
                DiagramActionService.this.verticalAlignToAverageSelected();
            }

            public String getId() {
                return DiagramActionService.ALIGN_VERT_AVERAGE;
            }
        };
        this.getActionRegistry().registerAction((IAction)vAlignAverageAction);
        return vAlignAverageAction;
    }

    public IAction registerVerticalAlignFirstSelectedAction() {
        Action vAlignFirstSelectedAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagramEditor_vAlignFirstSelectedAction_text){

            public void run() {
                DiagramActionService.this.verticalAlignToFirstSelected();
            }

            public String getId() {
                return DiagramActionService.ALIGN_VERT_FIRST_SELECTED;
            }
        };
        this.getActionRegistry().registerAction((IAction)vAlignFirstSelectedAction);
        return vAlignFirstSelectedAction;
    }

    public void horzAlignToFirstSelected() {
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart firstPart = null;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof NodeEditPart || editParts.get(a) instanceof NodeContainerEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (firstPart == null) {
                    firstPart = ep;
                } else {
                    Rectangle bounds = ep.getFigure().getBounds();
                    int offset = (int)((double)(bounds.height - firstPart.getFigure().getBounds().height) / 2.0);
                    if (!(ep.getParent() instanceof DiagramEditPart)) {
                        ep = (AbstractGraphicalEditPart)ep.getParent();
                        Rectangle parentBounds = ep.getFigure().getBounds();
                        offset += bounds.y - parentBounds.y;
                        bounds = parentBounds;
                    }
                    ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), new Point(bounds.x, firstPart.getFigure().getBounds().y - offset), bounds.width);
                    this.getCommandStack().execute((Command)c);
                }
            }
            ++a;
        }
    }

    public void horizAlignToAverageSelected() {
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart firstPart = null;
        int total = 0;
        int ysum = 0;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof NodeEditPart || editParts.get(a) instanceof NodeContainerEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (firstPart == null) {
                    firstPart = ep;
                }
                ysum += ep.getFigure().getBounds().y;
                ++total;
            }
            ++a;
        }
        int yave = (int)((double)ysum / (double)total);
        int a2 = 0;
        while (a2 < editParts.size()) {
            if (editParts.get(a2) instanceof NodeEditPart || editParts.get(a2) instanceof NodeContainerEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a2);
                Rectangle bounds = ep.getFigure().getBounds();
                int offset = (int)((double)(bounds.height - firstPart.getFigure().getBounds().height) / 2.0);
                if (!(ep.getParent() instanceof DiagramEditPart)) {
                    ep = (AbstractGraphicalEditPart)ep.getParent();
                    Rectangle parentBounds = ep.getFigure().getBounds();
                    offset += bounds.y - parentBounds.y;
                    bounds = parentBounds;
                }
                ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), new Point(bounds.x, yave - offset), bounds.width);
                this.getCommandStack().execute((Command)c);
            }
            ++a2;
        }
    }

    public void verticalAlignToAverageSelected() {
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart firstPart = null;
        int total = 0;
        int xsum = 0;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof NodeEditPart || editParts.get(a) instanceof NodeContainerEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (firstPart == null) {
                    firstPart = ep;
                }
                xsum += ep.getFigure().getBounds().x;
                ++total;
            }
            ++a;
        }
        int xave = (int)((double)xsum / (double)total);
        int a2 = 0;
        while (a2 < editParts.size()) {
            if (editParts.get(a2) instanceof NodeEditPart || editParts.get(a2) instanceof NodeContainerEditPart) {
                AbstractGraphicalEditPart ep = (AbstractGraphicalEditPart)editParts.get(a2);
                Rectangle bounds = ep.getFigure().getBounds();
                int offset = (int)((double)(bounds.width - firstPart.getFigure().getBounds().width) / 2.0);
                if (!(ep.getParent() instanceof DiagramEditPart)) {
                    ep = (AbstractGraphicalEditPart)ep.getParent();
                    Rectangle parentBounds = ep.getFigure().getBounds();
                    offset += bounds.x - parentBounds.x;
                    bounds = parentBounds;
                }
                ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), new Point(xave - offset, bounds.y), bounds.width);
                this.getCommandStack().execute((Command)c);
            }
            ++a2;
        }
    }

    public void verticalAlignToFirstSelected() {
        AbstractGraphicalEditPart ep;
        List editParts = this.getGraphicalViewer().getSelectedEditParts();
        AbstractGraphicalEditPart alignToPart = null;
        int a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof NodeEditPart || editParts.get(a) instanceof NodeContainerEditPart) {
                ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (alignToPart == null) {
                    alignToPart = ep;
                    break;
                }
            }
            ++a;
        }
        a = 0;
        while (a < editParts.size()) {
            if (editParts.get(a) instanceof NodeEditPart || editParts.get(a) instanceof NodeContainerEditPart) {
                LinkEditPart lp;
                boolean connected;
                ep = (AbstractGraphicalEditPart)editParts.get(a);
                if (ep != alignToPart && !(alignToPart instanceof SynchBarNodeEditPart)) {
                    if (!(ep instanceof SynchBarNodeEditPart)) {
                        Rectangle bounds = ep.getFigure().getBounds();
                        int offset = (int)((double)(bounds.width - alignToPart.getFigure().getBounds().width) / 2.0);
                        if (!(ep.getParent() instanceof DiagramEditPart)) {
                            ep = (AbstractGraphicalEditPart)ep.getParent();
                            Rectangle parentBounds = ep.getFigure().getBounds();
                            offset += bounds.x - parentBounds.x;
                            bounds = parentBounds;
                        }
                        ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), new Point(alignToPart.getFigure().getBounds().x - offset, bounds.y), bounds.width);
                        this.getCommandStack().execute((Command)c);
                        ep.getFigure().setLocation(new Point(alignToPart.getFigure().getBounds().x - offset, bounds.y));
                    } else {
                        Point tp = ep.getFigure().getBounds().getLocation();
                        connected = false;
                        boolean source = false;
                        Point endPoint = null;
                        lp = null;
                        List list = ((NodeEditPart)ep).getTargetConnections();
                        Iterator itor = list.iterator();
                        while (itor.hasNext()) {
                            lp = (LinkEditPart)((Object)itor.next());
                            if (!lp.getSource().equals(alignToPart)) continue;
                            endPoint = ((Link)lp.getModel()).getTargetEndPoint();
                            tp = tp.getTranslated(endPoint);
                            connected = true;
                            break;
                        }
                        if (!connected) {
                            list = ((NodeEditPart)ep).getSourceConnections();
                            itor = list.iterator();
                            while (itor.hasNext()) {
                                lp = (LinkEditPart)((Object)itor.next());
                                if (!lp.getTarget().equals(alignToPart)) continue;
                                endPoint = ((Link)lp.getModel()).getSourceEndPoint();
                                tp = tp.getTranslated(endPoint);
                                connected = true;
                                source = true;
                                break;
                            }
                        }
                        if (connected && alignToPart instanceof NodeEditPart) {
                            Point centerPoint = alignToPart.getFigure().getBounds().getCenter();
                            int delta = centerPoint.x - tp.x;
                            endPoint.x += delta;
                            ReconnectLinkCommand c = new ReconnectLinkCommand((Link)lp.getModel(), (Node)ep.getModel(), source);
                            c.setEndPoint(endPoint);
                            this.getCommandStack().execute((Command)c);
                        }
                    }
                }
                if (ep != alignToPart && alignToPart instanceof SynchBarNodeEditPart) {
                    Point tp;
                    Point sp = alignToPart.getFigure().getBounds().getLocation();
                    connected = false;
                    List list = ((NodeEditPart)alignToPart).getSourceConnections();
                    Iterator itor = list.iterator();
                    while (itor.hasNext()) {
                        lp = (LinkEditPart)((Object)itor.next());
                        if (!lp.getTarget().equals(ep)) continue;
                        Point sourceEndPoint = ((Link)lp.getModel()).getSourceEndPoint();
                        sp = sp.getTranslated(sourceEndPoint);
                        connected = true;
                        break;
                    }
                    if (!connected) {
                        list = ((NodeEditPart)alignToPart).getTargetConnections();
                        itor = list.iterator();
                        while (itor.hasNext()) {
                            lp = (LinkEditPart)((Object)itor.next());
                            if (!lp.getSource().equals(ep)) continue;
                            Point targetEndPoint = ((Link)lp.getModel()).getTargetEndPoint();
                            sp = sp.getTranslated(targetEndPoint);
                            connected = true;
                            break;
                        }
                    }
                    if (ep instanceof SynchBarNodeEditPart) {
                        tp = ((Node)ep.getModel()).getLocation().getCopy();
                        Point alignToCenter = alignToPart.getFigure().getBounds().getCenter();
                        Point centerPoint = ep.getFigure().getBounds().getCenter();
                        int delta = alignToCenter.x - centerPoint.x;
                        tp.x += delta;
                        ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), tp, ep.getFigure().getBounds().width);
                        this.getCommandStack().execute((Command)c);
                        ep.getFigure().setLocation(new Point(tp.x, tp.y));
                    } else if (ep instanceof NodeEditPart) {
                        tp = ((Node)ep.getModel()).getLocation().getCopy();
                        Point centerPoint = ep.getFigure().getBounds().getCenter();
                        int delta = sp.x - centerPoint.x;
                        tp.x += delta;
                        ChangeBoundsCommand c = new ChangeBoundsCommand((Node)ep.getModel(), tp, ep.getFigure().getBounds().width);
                        this.getCommandStack().execute((Command)c);
                        ep.getFigure().setLocation(new Point(tp.x, tp.y));
                    }
                }
            }
            ++a;
        }
    }
}

