/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.gef.edit;

import org.eclipse.draw2d.IFigure;
import org.eclipse.draw2d.Label;
import org.eclipse.draw2d.geometry.Dimension;
import org.eclipse.draw2d.geometry.Translatable;
import org.eclipse.epf.authoring.gef.edit.NamedNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.common.serviceability.MsgDialog;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.Property;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.tools.CellEditorLocator;
import org.eclipse.gef.tools.DirectEditManager;
import org.eclipse.swt.events.VerifyEvent;
import org.eclipse.swt.events.VerifyListener;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Text;

public class ValidatingFreeTextEditManager
extends DirectEditManager {
    Font scaledFont;
    protected VerifyListener verifyListener;
    protected Label activityLabel;

    public ValidatingFreeTextEditManager(GraphicalEditPart source, Class editorType, CellEditorLocator locator, Label label) {
        super(source, editorType, locator);
        this.activityLabel = label;
    }

    protected void bringDown() {
        this.bringDown(true);
    }

    protected void bringDown(boolean check) {
        GraphNode node;
        String name;
        Font disposeFont = this.scaledFont;
        this.scaledFont = null;
        super.bringDown();
        if (disposeFont != null) {
            disposeFont.dispose();
        }
        if (check && ((name = ((Property)(node = ((Node)this.getEditPart().getModel()).getGraphNode()).getProperty().get(0)).getValue()) == null || name.trim().length() == 0)) {
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NodeEditPart)this.getEditPart(), AuthoringUIResources.AuthoringUI_gef_validatingFreeTextEditManager_bringDownPrompt));
        }
    }

    protected void initCellEditor() {
        Text text = (Text)this.getCellEditor().getControl();
        this.verifyListener = new VerifyListener(){

            public void verifyText(VerifyEvent event) {
                Text text = (Text)ValidatingFreeTextEditManager.this.getCellEditor().getControl();
                String oldText = text.getText();
                String leftText = oldText.substring(0, event.start);
                String rightText = oldText.substring(event.end, oldText.length());
                GC gc = new GC((Drawable)text);
                Point size = gc.textExtent(String.valueOf(leftText) + event.text + rightText);
                gc.dispose();
                if (size.x != 0) {
                    size = text.computeSize(size.x, -1);
                }
                ValidatingFreeTextEditManager.this.getCellEditor().getControl().setSize(size.x, size.y);
            }
        };
        text.addVerifyListener(this.verifyListener);
        String initialLabelText = this.activityLabel.getText();
        this.getCellEditor().setValue((Object)initialLabelText);
        text.selectAll();
        IFigure figure = this.getEditPart().getFigure();
        this.scaledFont = figure.getFont();
        FontData data = this.scaledFont.getFontData()[0];
        Dimension fontSize = new Dimension(0, data.getHeight());
        this.activityLabel.translateToAbsolute((Translatable)fontSize);
        data.setHeight(fontSize.height);
        this.scaledFont = new Font(null, data);
        text.setFont(this.scaledFont);
    }

    protected void unhookListeners() {
        super.unhookListeners();
        if (this.getCellEditor() != null) {
            Text text = (Text)this.getCellEditor().getControl();
            text.removeVerifyListener(this.verifyListener);
            this.verifyListener = null;
        }
    }

    protected String validate(String txt) {
        return null;
    }

    protected void commit() {
        String msg = this.validate((String)this.getCellEditor().getValue());
        if (msg != null) {
            this.bringDown(false);
            Display.getCurrent().asyncExec((Runnable)new PromptEdit((NamedNodeEditPart)this.getEditPart(), msg));
            return;
        }
        super.commit();
    }

    static class PromptEdit
    implements Runnable {
        private NodeEditPart part;
        private String msg;

        PromptEdit(NodeEditPart part, String msg) {
            this.part = part;
            this.msg = msg;
        }

        public void run() {
            String title = DiagramUIResources.AuthoringUI_diagram_errorDialog_title_text0;
            String problem = DiagramUIResources.AuthoringUI_diagram_node_property_value_problem_msg;
            MsgDialog dialog = AuthoringUIPlugin.getDefault().getMsgDialog();
            dialog.displayError(title, problem, this.msg);
            this.part.performDirectEdit();
        }
    }
}

