/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.Collection;
import java.util.Iterator;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.command.CommandWrapper;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.command.CommandActionDelegate;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.editors.IEditorKeeper;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.library.edit.command.CommandStatusChecker;
import org.eclipse.epf.library.edit.command.MethodElementAddCommand;
import org.eclipse.epf.library.edit.process.command.CreateProcessComponentCommand;
import org.eclipse.epf.library.edit.util.TngUtil;

public class CreateMethodElementCommand
extends CommandWrapper
implements CommandActionDelegate {
    public CreateMethodElementCommand(Command command) {
        super(command);
    }

    public void execute() {
        Object cmd = TngUtil.unwrap((Command)this);
        super.execute();
        if (this.command instanceof CreateProcessComponentCommand) {
            IStatus status = ((CreateProcessComponentCommand)this.command).getStatus();
            if (status != null && !status.isOK()) {
                if (CommandStatusChecker.hasRollbackError((IStatus)status)) {
                    ViewHelper.reloadCurrentLibaryOnRollbackError(null);
                } else if (!CommandStatusChecker.hasSaveError((IStatus)status)) {
                    this.displayError(status);
                }
                return;
            }
        } else {
            MethodElementAddCommand addCmd;
            IStatus status;
            cmd = this;
            while (cmd instanceof CommandWrapper && !(cmd instanceof MethodElementAddCommand)) {
                cmd = ((CommandWrapper)cmd).getCommand();
            }
            if (cmd instanceof MethodElementAddCommand && (status = (addCmd = (MethodElementAddCommand)cmd).getStatus()) != null && !status.isOK()) {
                if (CommandStatusChecker.hasRollbackError((IStatus)status)) {
                    ViewHelper.reloadCurrentLibaryOnRollbackError(null);
                } else if (!CommandStatusChecker.hasSaveError((IStatus)status)) {
                    this.displayError(status);
                }
                return;
            }
        }
        Collection result = this.getCommand().getResult();
        Iterator iter = result.iterator();
        while (iter.hasNext()) {
            Object obj = TngUtil.unwrap(iter.next());
            if (!(obj instanceof EObject) || ((EObject)obj).eContainer() == null) continue;
            IEditorKeeper.REFERENCE.getEditorKeeper().openEditor(obj);
        }
    }

    public boolean canUndo() {
        return false;
    }

    public Object getImage() {
        CommandActionDelegate cmd = (CommandActionDelegate)this.getCommand();
        return cmd.getImage();
    }

    public String getText() {
        CommandActionDelegate cmd = (CommandActionDelegate)this.getCommand();
        return cmd.getText();
    }

    public String getToolTipText() {
        CommandActionDelegate cmd = (CommandActionDelegate)this.getCommand();
        return cmd.getToolTipText();
    }

    protected void displayError(IStatus status) {
        int severity = status.getSeverity();
        if (severity == 4 || severity == 2) {
            AuthoringUIPlugin.getDefault().getMsgDialog().display(this.getLabel(), AuthoringUIResources.AuthoringUI_errorDialog_createError, status);
        }
    }
}

