/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.actions;

import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.epf.authoring.ui.PerspectiveListUtil;
import org.eclipse.epf.authoring.ui.UIActionDispatcher;
import org.eclipse.epf.authoring.ui.dialogs.ContributionSelection;
import org.eclipse.epf.authoring.ui.editors.EditorChooser;
import org.eclipse.epf.authoring.ui.views.ConfigurationView;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IWorkbenchPart;

public class OpenElementActionDelegate
implements IObjectActionDelegate {
    private IWorkbenchPart targetPart;
    private ISelection selection;
    private ContributionSelection contributorSelector = new ContributionSelection();

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        this.targetPart = targetPart;
    }

    public void selectionChanged(IAction action, ISelection selection) {
        this.selection = selection;
    }

    public void run(IAction action) {
        Object element;
        Iterator objects;
        IStructuredSelection selected = (IStructuredSelection)this.selection;
        ArrayList<Object> elementList = new ArrayList<Object>();
        if (this.targetPart instanceof ConfigurationView) {
            objects = selected.iterator();
            while (objects.hasNext()) {
                element = TngUtil.unwrap(objects.next());
                if (element instanceof VariabilityElement) {
                    Object obj = this.contributorSelector.getSelectedContributor((VariabilityElement)element);
                    if (obj == null) continue;
                    elementList.add(obj);
                    continue;
                }
                elementList.add(element);
            }
        } else {
            objects = selected.iterator();
            while (objects.hasNext()) {
                element = TngUtil.unwrap(objects.next());
                if (!(element instanceof MethodElement)) continue;
                elementList.add(element);
            }
        }
        if (elementList.size() < 1) {
            return;
        }
        if (PerspectiveListUtil.isBrowsingPerspective()) {
            UIActionDispatcher.openAuthoringPerspective();
        }
        objects = elementList.iterator();
        while (objects.hasNext()) {
            element = objects.next();
            EditorChooser.getInstance().openEditor(element);
        }
    }

    public void dispose() {
    }
}

