/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.io.File;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.common.utils.NetUtil;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.util.ResourceHelper;
import org.eclipse.epf.richtext.dialogs.AddImageDialog;
import org.eclipse.epf.richtext.dialogs.BaseDialog;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MethodAddImageDialog
extends AddImageDialog {
    private static final int MAX_HEIGHT = 600;
    private static final int MAX_WIDTH = 600;
    private static final int DEFAULT_HEIGHT = 200;
    private static final int DEFAULT_WIDTH = 200;
    private MethodElement methodElement;
    private File fileToCopy;
    private String url;
    private int height = 200;
    private int width = 200;
    private String altTag = "";
    private Text heightText;
    private Text widthText;
    private Text altTagText;
    private ModifyListener modifyListener = new ModifyListener(){

        public void modifyText(ModifyEvent event) {
            if (((BaseDialog)MethodAddImageDialog.this).okButton != null) {
                try {
                    MethodAddImageDialog.this.url = MethodAddImageDialog.this.urlText.getText().trim();
                    MethodAddImageDialog.this.height = Integer.parseInt(MethodAddImageDialog.this.heightText.getText().trim());
                    MethodAddImageDialog.this.width = Integer.parseInt(MethodAddImageDialog.this.widthText.getText().trim());
                    ((BaseDialog)MethodAddImageDialog.this).okButton.setEnabled(MethodAddImageDialog.this.url.length() > 0 && MethodAddImageDialog.this.height > 0 && MethodAddImageDialog.this.width > 0);
                }
                catch (Exception exception) {
                    ((BaseDialog)MethodAddImageDialog.this).okButton.setEnabled(false);
                }
            }
        }
    };

    public MethodAddImageDialog(Shell parent, MethodElement methodElement) {
        super(parent);
        this.methodElement = methodElement;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ((GridLayout)composite.getLayout()).numColumns = 4;
        ((GridData)this.urlText.getLayoutData()).horizontalSpan = 2;
        this.urlText.removeModifyListener(this.urlTextListener);
        this.urlText.addModifyListener(this.modifyListener);
        this.browseButton.removeSelectionListener((SelectionListener)this.browseSelectionAdapter);
        this.browseButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(Display.getCurrent().getActiveShell(), 4096);
                dialog.setFilterPath(String.valueOf(LibraryService.getInstance().getCurrentMethodLibraryPath()) + File.separator + ResourceHelper.getElementPath((MethodElement)MethodAddImageDialog.this.methodElement));
                String attachFile = dialog.open();
                if (attachFile != null && attachFile.length() > 0) {
                    try {
                        MethodAddImageDialog.this.fileToCopy = new File(dialog.getFilterPath(), dialog.getFileName());
                        MethodAddImageDialog.this.url = "./" + ResourceHelper.getURLForAttachment((File)MethodAddImageDialog.this.fileToCopy, (MethodElement)MethodAddImageDialog.this.methodElement, (boolean)false);
                        MethodAddImageDialog.this.urlText.setText(MethodAddImageDialog.this.url);
                        MethodAddImageDialog.this.setImageInfo(MethodAddImageDialog.this.fileToCopy.getAbsolutePath());
                    }
                    catch (Exception e) {
                        ((BaseDialog)MethodAddImageDialog.this).logger.logError((Throwable)e);
                    }
                }
            }
        });
        Label heightLabel = new Label(composite, 0);
        heightLabel.setText(AuthoringUIResources.AuthoringUI_heightLabel_text);
        this.heightText = new Text(composite, 2048);
        this.heightText.setLayoutData((Object)new GridData());
        this.heightText.setText("200");
        this.heightText.addModifyListener(this.modifyListener);
        Label imageSizeLabel = new Label(composite, 64);
        GridData gd = new GridData(768);
        gd.widthHint = 300;
        gd.horizontalSpan = 2;
        gd.verticalSpan = 2;
        gd.horizontalIndent = 10;
        imageSizeLabel.setLayoutData((Object)gd);
        imageSizeLabel.setText(AuthoringUIResources.AuthoringUI_imageSizeLabel_text);
        Label widthLabel = new Label(composite, 0);
        widthLabel.setText(AuthoringUIResources.AuthoringUI_widthLabel_text);
        this.widthText = new Text(composite, 2048);
        this.widthText.setLayoutData((Object)new GridData());
        this.widthText.setText("200");
        this.widthText.addModifyListener(this.modifyListener);
        Label altLabel = new Label(composite, 0);
        altLabel.setText(AuthoringUIResources.AuthoringUI_altTagLabel_text);
        this.altTagText = new Text(composite, 2048);
        GridData gd2 = new GridData(768);
        gd2.horizontalSpan = 3;
        this.altTagText.setLayoutData((Object)gd2);
        this.altTagText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                MethodAddImageDialog.this.altTag = MethodAddImageDialog.this.altTagText.getText().trim();
            }
        });
        return composite;
    }

    public File getFileToCopy() {
        return this.fileToCopy;
    }

    private void setImageInfo(String imageName) {
        File imageFile = new File(imageName);
        if (imageFile.exists()) {
            ImageData imageData = new ImageData(imageName);
            this.heightText.setText(String.valueOf(imageData.height));
            this.widthText.setText(String.valueOf(imageData.width));
        } else {
            this.heightText.setText(String.valueOf(200));
            this.widthText.setText(String.valueOf(200));
        }
    }

    public String getUrl() {
        return this.url;
    }

    public int getHeight() {
        return Math.min(600, Math.max(10, this.height));
    }

    public int getWidth() {
        return Math.min(600, Math.max(10, this.width));
    }

    public String getAltTag() {
        return this.altTag;
    }

    protected void okPressed() {
        this.url = NetUtil.encodeFileURL((String)this.url);
        super.okPressed();
    }
}

