/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.dialogs;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.dialogs.ItemsFilterDialog;
import org.eclipse.epf.authoring.ui.filters.AllFilter;
import org.eclipse.epf.library.edit.IFilter;
import org.eclipse.epf.library.edit.PresentationContext;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.itemsfilter.CategorizedProcessesItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.ContentCategoriesGroupItemProvider;
import org.eclipse.epf.library.edit.itemsfilter.FilterConstants;
import org.eclipse.epf.library.edit.itemsfilter.ProcessesItemProvider;
import org.eclipse.epf.library.edit.util.MethodElementUtil;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.ContentPackage;
import org.eclipse.epf.uma.CustomCategory;
import org.eclipse.epf.uma.DescribableElement;
import org.eclipse.epf.uma.Discipline;
import org.eclipse.epf.uma.MethodPlugin;
import org.eclipse.epf.uma.ProcessComponent;
import org.eclipse.epf.uma.RoleSet;
import org.eclipse.epf.uma.VariabilityElement;
import org.eclipse.epf.uma.util.AssociationHelper;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.ui.PlatformUI;

public class VariabilitySelection {
    private HashSet filterElementList = new HashSet();

    public Object getSelectedVariability(VariabilityElement element) {
        Set elementSet = new HashSet<VariabilityElement>();
        elementSet.add(element);
        elementSet = AssociationHelper.getVariabilityElements(elementSet, (boolean)true, (boolean)true);
        this.filterElementList.addAll(elementSet);
        if (!elementSet.isEmpty()) {
            Iterator itor = elementSet.iterator();
            while (itor.hasNext()) {
                ContentElement contentElement = (ContentElement)itor.next();
                List groupings = null;
                if (contentElement instanceof Discipline) {
                    groupings = AssociationHelper.getDisciplineGroups((Discipline)((Discipline)contentElement));
                }
                if (contentElement instanceof RoleSet) {
                    groupings = AssociationHelper.getRoleSetGroups((RoleSet)((RoleSet)contentElement));
                }
                if (contentElement instanceof CustomCategory) {
                    groupings = this.getAncestors((CustomCategory)contentElement);
                }
                if (groupings == null || groupings.isEmpty()) continue;
                this.filterElementList.addAll(groupings);
            }
            VariabilityFilter filter = new VariabilityFilter();
            String[] str = new String[]{FilterConstants.CONFIG_CONTENT_ELEMENT};
            ItemsFilterDialog dlg = new ItemsFilterDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
            dlg.setFilter((IFilter)filter);
            dlg.setTitle(FilterConstants.CONFIG_CONTENT_ELEMENT);
            dlg.setViewerSelectionSingle(true);
            dlg.setTypes(str);
            dlg.setInput(UmaUtil.getMethodLibrary((EObject)element));
            dlg.setContentProvider((IStructuredContentProvider)new AdapterFactoryContentProvider(TngAdapterFactory.INSTANCE.getItemsFilter_AdapterFactory((IFilter)filter)), TngAdapterFactory.INSTANCE.getItemsFilter_ComposedAdapterFactory());
            dlg.setBlockOnOpen(true);
            String elementName = element.getName();
            if (element instanceof DescribableElement && PresentationContext.INSTANCE.isShowPresentationNames() && ((DescribableElement)element).getPresentationName().trim().length() > 0) {
                elementName = ((DescribableElement)element).getPresentationName();
            }
            dlg.setViewerLabel(AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_VariabilitySelection_filterdialog_viewerLabel, (Object[])new String[]{elementName}));
            String title = MessageFormat.format(AuthoringUIResources.AuthoringUI_VariabilitySelection_filterdialog_title, elementName);
            dlg.setTitle(title);
            dlg.setBlockOnOpen(true);
            dlg.open();
            ArrayList result = dlg.getSelectedItems();
            if (result == null || result.isEmpty()) {
                return null;
            }
            return result.get(0);
        }
        return element;
    }

    private List getAncestors(CustomCategory methodObject) {
        ArrayList ancestorList = new ArrayList();
        ArrayList<CustomCategory> objList = new ArrayList<CustomCategory>();
        objList.add(methodObject);
        this.getAncestors(ancestorList, objList);
        return ancestorList;
    }

    private List getAncestors(List ancestorList, List methodObjectList) {
        if (methodObjectList.isEmpty()) {
            return ancestorList;
        }
        ArrayList allParentCustCats = new ArrayList();
        Iterator iter = methodObjectList.iterator();
        while (iter.hasNext()) {
            CustomCategory element = (CustomCategory)iter.next();
            List parentList = AssociationHelper.getCustomCategories((DescribableElement)element);
            allParentCustCats.addAll(parentList);
        }
        ancestorList.addAll(methodObjectList);
        ArrayList nextCheckList = new ArrayList();
        Iterator iter2 = allParentCustCats.iterator();
        while (iter2.hasNext()) {
            Object element = iter2.next();
            if (ancestorList.contains(element)) continue;
            nextCheckList.add(element);
        }
        return this.getAncestors(ancestorList, nextCheckList);
    }

    private class VariabilityFilter
    extends AllFilter {
        private VariabilityFilter() {
        }

        public boolean accept(Object obj) {
            Object contentElement = this.helper.getContentElement();
            if (contentElement != null && obj.equals(this.helper.getContentElement())) {
                return false;
            }
            if (this.helper.getAlreadySelectedList() != null && (obj instanceof ProcessComponent ? this.helper.getAlreadySelectedList().contains(((ProcessComponent)obj).getProcess()) : this.helper.getAlreadySelectedList().contains(obj))) {
                return false;
            }
            if (obj instanceof CustomCategory && TngUtil.isRootCustomCategory((CustomCategory)((CustomCategory)obj)) && ((CustomCategory)obj).getCategorizedElements().isEmpty()) {
                return false;
            }
            if (!this.helper.matchPattern(obj)) {
                return false;
            }
            if (obj instanceof MethodPlugin && obj instanceof MethodPlugin) {
                if (contentElement != null) {
                    return MethodElementUtil.getAllModels((Object)contentElement).contains(obj);
                }
                return true;
            }
            if (obj instanceof ContentPackage) {
                return true;
            }
            if (obj instanceof ContentCategoriesGroupItemProvider) {
                Collection list = ((ContentCategoriesGroupItemProvider)obj).getChildren(obj);
                return !list.isEmpty();
            }
            if (obj instanceof ProcessesItemProvider) {
                Collection list = ((ProcessesItemProvider)obj).getChildren(obj);
                Iterator ior = list.iterator();
                while (ior.hasNext()) {
                    Object object = ior.next();
                    if (!((CategorizedProcessesItemProvider)object).getChildren(object).isEmpty()) continue;
                    ior.remove();
                }
                return !list.isEmpty();
            }
            return this.childAccept(obj);
        }

        public boolean childAccept(Object obj) {
            return obj instanceof ContentElement && VariabilitySelection.this.filterElementList.contains(obj);
        }
    }
}

