/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.editors;

import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.draw2d.AbsoluteBendpoint;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.emf.common.CommonPlugin;
import org.eclipse.emf.common.command.BasicCommandStack;
import org.eclipse.emf.common.command.Command;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.util.EcoreUtil;
import org.eclipse.emf.edit.domain.AdapterFactoryEditingDomain;
import org.eclipse.epf.authoring.gef.commands.ChangeBoundsCommand;
import org.eclipse.epf.authoring.gef.commands.CreateBendpointCommand;
import org.eclipse.epf.authoring.gef.commands.CreateLinkCommand;
import org.eclipse.epf.authoring.gef.commands.CreateNodeCommand;
import org.eclipse.epf.authoring.gef.commands.MoveBendpointCommand;
import org.eclipse.epf.authoring.gef.edit.DecisionNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.DiagramActionService;
import org.eclipse.epf.authoring.gef.edit.FreeTextNodeEditPart;
import org.eclipse.epf.authoring.gef.edit.LinkEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeContainerEditPart;
import org.eclipse.epf.authoring.gef.edit.NodeEditPart;
import org.eclipse.epf.authoring.gef.edit.SynchBarNodeEditPart;
import org.eclipse.epf.authoring.gef.figures.FreeTextFigure;
import org.eclipse.epf.authoring.gef.util.DiagramUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIHelpContexts;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.actions.DiagramPrintAction;
import org.eclipse.epf.authoring.ui.actions.ProcessDeleteAction;
import org.eclipse.epf.authoring.ui.editors.BreakdownElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.editors.ProcessEditor;
import org.eclipse.epf.authoring.ui.views.ViewHelper;
import org.eclipse.epf.diagram.model.Link;
import org.eclipse.epf.diagram.model.ModelFactory;
import org.eclipse.epf.diagram.model.NamedNode;
import org.eclipse.epf.diagram.model.Node;
import org.eclipse.epf.diagram.model.TypedNode;
import org.eclipse.epf.diagram.model.util.GraphicalDataHelper;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.ILibraryServiceListener;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.configuration.ProcessAuthoringConfigurator;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.uma.Activity;
import org.eclipse.epf.uma.BreakdownElement;
import org.eclipse.epf.uma.Diagram;
import org.eclipse.epf.uma.GraphNode;
import org.eclipse.epf.uma.MethodConfiguration;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.MethodLibrary;
import org.eclipse.epf.uma.Property;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.WorkProductDescriptor;
import org.eclipse.epf.uma.util.ContentDescriptionFactory;
import org.eclipse.epf.uma.util.IMethodLibraryPersister;
import org.eclipse.epf.uma.util.UmaUtil;
import org.eclipse.gef.ContextMenuProvider;
import org.eclipse.gef.DefaultEditDomain;
import org.eclipse.gef.EditDomain;
import org.eclipse.gef.EditPart;
import org.eclipse.gef.EditPartFactory;
import org.eclipse.gef.EditPartViewer;
import org.eclipse.gef.GraphicalEditPart;
import org.eclipse.gef.GraphicalViewer;
import org.eclipse.gef.KeyHandler;
import org.eclipse.gef.KeyStroke;
import org.eclipse.gef.RootEditPart;
import org.eclipse.gef.commands.CommandStack;
import org.eclipse.gef.commands.CommandStackEvent;
import org.eclipse.gef.commands.CommandStackEventListener;
import org.eclipse.gef.dnd.TemplateTransferDragSourceListener;
import org.eclipse.gef.dnd.TemplateTransferDropTargetListener;
import org.eclipse.gef.dnd.TransferDragSourceListener;
import org.eclipse.gef.editparts.ScalableFreeformRootEditPart;
import org.eclipse.gef.palette.PaletteContainer;
import org.eclipse.gef.palette.PaletteEntry;
import org.eclipse.gef.palette.PaletteRoot;
import org.eclipse.gef.requests.CreateRequest;
import org.eclipse.gef.requests.CreationFactory;
import org.eclipse.gef.ui.actions.ActionRegistry;
import org.eclipse.gef.ui.actions.CopyTemplateAction;
import org.eclipse.gef.ui.actions.DeleteAction;
import org.eclipse.gef.ui.actions.GEFActionConstants;
import org.eclipse.gef.ui.palette.FlyoutPaletteComposite;
import org.eclipse.gef.ui.palette.PaletteViewer;
import org.eclipse.gef.ui.palette.PaletteViewerProvider;
import org.eclipse.gef.ui.parts.GraphicalEditorWithFlyoutPalette;
import org.eclipse.gef.ui.parts.GraphicalViewerKeyHandler;
import org.eclipse.gef.ui.parts.ScrollingGraphicalViewer;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.util.SafeRunnable;
import org.eclipse.jface.util.TransferDropTargetListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.FontDialog;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IPartListener;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.ActionFactory;

public abstract class AbstractDiagramEditor
extends GraphicalEditorWithFlyoutPalette {
    private static final String REFRESH_FROM_BASE_ACTIVITY = "refresh_from_base_activity";
    private static final String FONT_DIALOG = "font_dialog";
    private static final String CREATE_LINK = "create_link";
    private static final String SELECT_LINK = "select_link";
    private static final String CREATE_BEND_POINT = "create_bend_point";
    protected static final String CREATE_FREE_TEXT = "create_free_text";
    public static final String MOVE = "move";
    protected static final String REFRESH = "refresh";
    protected static final String ALIGN_BEND_POINT = "align_bend_point";
    protected static final String PALETTE_DOCK_LOCATION = "Dock location";
    protected static final String PALETTE_SIZE = "Palette Size";
    protected static final String PALETTE_STATE = "Palette state";
    protected static final int DEFAULT_PALETTE_SIZE = 130;
    protected static final String DELETE_DIAGRAM = "delete_actvity_detail_diagram";
    private KeyHandler sharedKeyHandler;
    private PaletteRoot paletteRoot;
    protected EditPart editPart;
    private CommandStackEventListener cmdStackEventListener;
    protected CreationFactory freeTxtNodeCreationFactory;
    protected DiagramActionService actionService = null;
    protected IEditorPart parentEditor = null;
    protected IPartListener partListener = new IPartListener(){
        IEditorPart me;
        {
            this.me = AbstractDiagramEditor.this;
        }

        public void partOpened(IWorkbenchPart part) {
        }

        public void partDeactivated(IWorkbenchPart part) {
        }

        public void partClosed(IWorkbenchPart part) {
            if (part == this.me) {
                AbstractDiagramEditor.this.setParentEditor(null);
                IWorkbenchPage page = AbstractDiagramEditor.this.getSite().getPage();
                page.removePartListener(AbstractDiagramEditor.this.partListener);
                org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.getGraphicalViewer().getContents().getModel();
                if (diagram.isNew()) {
                    if (diagram.getUMADiagram() != null) {
                        EcoreUtil.remove((EObject)diagram.getUMADiagram());
                    }
                    if (AbstractDiagramEditor.this.isResourceChangedByOther()) {
                        AbstractDiagramEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    }
                }
            }
        }

        public void partBroughtToTop(IWorkbenchPart part) {
        }

        public void partActivated(IWorkbenchPart part) {
        }
    };
    private Font font;
    private Color color;
    private org.eclipse.gef.commands.Command refreshFromBaseCommand = new org.eclipse.gef.commands.Command(DiagramUIResources.DiagramUI_AbstractDiagramEditorrefreshfrombase){
        private ArrayList oldContent;
        {
            this.oldContent = new ArrayList();
        }

        public void execute() {
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
            this.oldContent.clear();
            this.oldContent.addAll(diagram.getUMADiagram().getContained());
            GraphicalDataHelper.refreshFromBase((Diagram)diagram.getUMADiagram());
            if (AbstractDiagramEditor.this.editPart.isActive()) {
                AbstractDiagramEditor.this.editPart.deactivate();
            }
            diagram.removeConsumer((Object)this);
            AbstractDiagramEditor.this.createEditPart();
            AbstractDiagramEditor.this.getGraphicalViewer().setContents(AbstractDiagramEditor.this.editPart);
        }

        public void undo() {
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
            diagram.getUMADiagram().getContained().clear();
            diagram.getUMADiagram().getContained().addAll(this.oldContent);
            if (AbstractDiagramEditor.this.editPart.isActive()) {
                AbstractDiagramEditor.this.editPart.deactivate();
            }
            diagram.removeConsumer((Object)this);
            AbstractDiagramEditor.this.createEditPart();
            AbstractDiagramEditor.this.getGraphicalViewer().setContents(AbstractDiagramEditor.this.editPart);
        }
    };
    protected Map templateNameToCreationFactoryMap;
    protected long changeTime = -1L;
    protected MethodConfiguration currentConfig;
    private ILibraryChangeListener libraryListener = new ILibraryChangeListener(){

        /*
         * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void libraryChanged(int option, Collection collection) {
            MethodConfiguration config;
            switch (option) {
                case 8: {
                    if (collection == null) return;
                    if (!collection.contains(AbstractDiagramEditor.this.currentConfig)) return;
                    config = ProcessAuthoringConfigurator.INSTANCE.getMethodConfiguration();
                    try {
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(AbstractDiagramEditor.this.currentConfig);
                        IAction action = AbstractDiagramEditor.this.getActionRegistry().getAction((Object)AbstractDiagramEditor.REFRESH);
                        action.run();
                        break;
                    }
                    catch (Throwable throwable) {
                        Object var5_6 = null;
                        ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(config);
                        throw throwable;
                    }
                }
                default: {
                    return;
                }
            }
            {
                Object var5_7 = null;
            }
            ProcessAuthoringConfigurator.INSTANCE.setMethodConfiguration(config);
        }
    };
    private ILibraryServiceListener libSvcListener = new ILibraryServiceListener(){

        public void configurationSet(MethodConfiguration config) {
            AbstractDiagramEditor.this.configChanged();
        }

        public void libraryClosed(MethodLibrary library) {
        }

        public void libraryCreated(MethodLibrary library) {
        }

        public void libraryOpened(MethodLibrary library) {
        }

        public void libraryReopened(MethodLibrary library) {
        }

        public void librarySet(MethodLibrary library) {
        }
    };

    public AbstractDiagramEditor() {
        this.setEditDomain(new DefaultEditDomain((IEditorPart)this));
        this.getEditDomain().setCommandStack(new CommandStack(){

            public boolean isDirty() {
                org.eclipse.gef.commands.Command cmd = this.getUndoCommand();
                if (cmd != null && !cmd.canUndo()) {
                    return false;
                }
                return super.isDirty();
            }

            public void execute(org.eclipse.gef.commands.Command command) {
                if (command == null || !command.canExecute()) {
                    return;
                }
                if (AbstractDiagramEditor.this.changeTime == -1L) {
                    AbstractDiagramEditor.this.changeTime = System.currentTimeMillis();
                }
                super.execute(command);
            }
        });
        this.cmdStackEventListener = new CommandStackEventListener(){

            public void stackChanged(CommandStackEvent event) {
                if (event.getDetail() == 8) {
                    AbstractDiagramEditor.this.firePropertyChange(257);
                }
            }
        };
        this.getEditDomain().getCommandStack().addCommandStackEventListener(this.cmdStackEventListener);
        IWorkbench wb = PlatformUI.getWorkbench();
        IWorkbenchWindow win = wb.getActiveWorkbenchWindow();
        IWorkbenchPage page = win.getActivePage();
        page.addPartListener(this.partListener);
    }

    public void dispose() {
        ILibraryManager manager;
        org.eclipse.epf.diagram.model.Diagram diagram;
        this.getCommandStack().removeCommandStackEventListener(this.cmdStackEventListener);
        if (this.isDirty()) {
            this.reverseToSaved();
        }
        if (this.editPart != null && (diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel()) != null) {
            diagram.removeConsumer((Object)this);
        }
        if (this.font != null && !this.font.isDisposed()) {
            this.font.dispose();
        }
        if (this.color != null && !this.color.isDisposed()) {
            this.color.dispose();
        }
        if ((manager = LibraryService.getInstance().getCurrentLibraryManager()) != null) {
            manager.removeListener(this.libraryListener);
        }
        LibraryService.getInstance().removeListener(this.libSvcListener);
        super.dispose();
    }

    private boolean isResourceChangedByOther() {
        Resource resource = this.getMethodElementFromInput().eResource();
        if (resource != null) {
            File file = new File(resource.getURI().toFileString());
            return file.lastModified() > this.changeTime;
        }
        return false;
    }

    private void reverseToSaved() {
        boolean saveNeeded = this.getCommandStack().isDirty() && this.isResourceChangedByOther();
        this.changeTime = -1L;
        while (this.getCommandStack().isDirty()) {
            this.getCommandStack().undo();
        }
        if (saveNeeded) {
            IMethodLibraryPersister.FailSafeMethodLibraryPersister persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
            try {
                persister.save(this.getMethodElementFromInput().eResource());
                persister.commit();
            }
            catch (Exception e) {
                CommonPlugin.INSTANCE.log((Object)e);
                try {
                    persister.rollback();
                }
                catch (Exception exception) {
                    ViewHelper.reloadCurrentLibrary(this.getSite().getShell(), null);
                }
            }
        }
    }

    protected void contributeToContextMenu(IMenuManager menu) {
        IContributionItem ci;
        boolean canModify = !this.isReadOnly();
        IAction action = this.getActionRegistry().getAction((Object)REFRESH_FROM_BASE_ACTIVITY);
        if (action.isEnabled() && canModify) {
            menu.appendToGroup("additions", action);
        }
        if ((ci = this.createAlignMenu()).isEnabled() && canModify) {
            menu.appendToGroup("additions", (IContributionItem)new Separator());
            menu.appendToGroup("additions", ci);
            menu.appendToGroup("additions", (IContributionItem)new Separator());
        }
        if ((action = this.getActionRegistry().getAction((Object)DELETE_DIAGRAM)).isEnabled() && canModify) {
            menu.appendToGroup("additions", (IContributionItem)new Separator());
            menu.appendToGroup("additions", action);
            menu.appendToGroup("additions", (IContributionItem)new Separator());
        }
    }

    protected IContributionItem createAlignMenu() {
        MenuManager alignMenuManager = new MenuManager(DiagramUIResources.DiagramUI_AbstractDiagramEditor_alignMenu_text){

            public boolean isEnabled() {
                int total = 0;
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() > 1) {
                    int a = 0;
                    while (a < editParts.size()) {
                        EditPart editPart = (EditPart)editParts.get(a);
                        if ((editPart instanceof NodeEditPart || editPart instanceof NodeContainerEditPart) && ++total > 1) break;
                        ++a;
                    }
                }
                return total > 1;
            }
        };
        alignMenuManager.add(this.getActionRegistry().getAction((Object)"align_horizontal_to_average"));
        alignMenuManager.add(this.getActionRegistry().getAction((Object)"align_horizontal_to_first_selection"));
        alignMenuManager.add(this.getActionRegistry().getAction((Object)"align_vertical_to_average"));
        alignMenuManager.add(this.getActionRegistry().getAction((Object)"align_vertical_to_first_selection"));
        return alignMenuManager;
    }

    protected void refreshFromBase() {
        this.getCommandStack().execute(this.refreshFromBaseCommand);
    }

    protected void createActions() {
        super.createActions();
        ActionRegistry registry = this.getActionRegistry();
        Object action = registry.getAction((Object)ActionFactory.DELETE.getId());
        if (action != null) {
            registry.removeAction(action);
            this.getSelectionActions().remove(action);
        }
        action = new DeleteAction((IWorkbenchPart)this){

            public boolean isEnabled() {
                return super.isEnabled();
            }

            public void run() {
                ArrayList<Object> elements = new ArrayList<Object>();
                Iterator iter = this.getSelectedObjects().iterator();
                while (iter.hasNext()) {
                    Object element;
                    Object obj;
                    Object editPart = iter.next();
                    if (!(editPart instanceof EditPart) || !((obj = ((EditPart)editPart).getModel()) instanceof NamedNode) || !((element = ((NamedNode)obj).getObject()) instanceof BreakdownElement)) continue;
                    elements.add(element);
                }
                if (!elements.isEmpty()) {
                    ProcessDeleteAction deleteAction = new ProcessDeleteAction(this){
                        final /* synthetic */ 8 this$1;
                        {
                            this.this$1 = var1_1;
                        }

                        public Command createCommand(Collection selection) {
                            this.domain = null;
                            Iterator<E> iter = selection.iterator();
                            while (iter.hasNext()) {
                                E element = iter.next();
                                if (!(element instanceof WorkProductDescriptor)) continue;
                                this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getPBS_ComposedAdapterFactory(), (org.eclipse.emf.common.command.CommandStack)new BasicCommandStack());
                                break;
                            }
                            if (this.domain == null) {
                                this.domain = new AdapterFactoryEditingDomain((AdapterFactory)TngAdapterFactory.INSTANCE.getWBS_ComposedAdapterFactory(), (org.eclipse.emf.common.command.CommandStack)new BasicCommandStack());
                            }
                            return super.createCommand(selection);
                        }
                    };
                    deleteAction.updateSelection((IStructuredSelection)new StructuredSelection(elements));
                    deleteAction.run();
                    if (deleteAction.isDeletionConfirmed()) {
                        super.run();
                        BusyIndicator.showWhile((Display)AbstractDiagramEditor.this.getEditorSite().getShell().getDisplay(), (Runnable)new Runnable(this){
                            final /* synthetic */ 8 this$1;
                            {
                                this.this$1 = var1_1;
                            }

                            public void run() {
                                8.access$0(this.this$1).doSave((IProgressMonitor)new NullProgressMonitor());
                            }
                        });
                    }
                } else {
                    super.run();
                }
            }

            static /* synthetic */ AbstractDiagramEditor access$0(8 var0) {
                return var0.AbstractDiagramEditor.this;
            }
        };
        registry.registerAction(action);
        this.getSelectionActions().add(action.getId());
        action = new CopyTemplateAction((IEditorPart)this);
        registry.registerAction(action);
        action = new Action(DiagramUIResources.DiagramUI_AbstractDiagramEditor_refreshFromBaseActivity_text){

            public String getId() {
                return AbstractDiagramEditor.REFRESH_FROM_BASE_ACTIVITY;
            }

            public void run() {
                AbstractDiagramEditor.this.refreshFromBase();
            }

            public boolean isEnabled() {
                Activity act = (Activity)AbstractDiagramEditor.this.getMethodElementFromInput();
                return act.getVariabilityBasedOnElement() != null;
            }
        };
        registry.registerAction(action);
        Action action1 = new Action(DiagramUIResources.DiagramUI_AbstractDiagramEditor_formatTextBoxActivity_text){

            public String getId() {
                return AbstractDiagramEditor.FONT_DIALOG;
            }

            public void run() {
                try {
                    try {
                        FontData fData;
                        EditPart selectedEditPart = (EditPart)AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().get(0);
                        FontDialog fd = new FontDialog(PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell());
                        fd.open();
                        if (selectedEditPart instanceof FreeTextNodeEditPart && fd.getFontList() != null && (fData = fd.getFontList()[0]) != null) {
                            if (AbstractDiagramEditor.this.font != null && !AbstractDiagramEditor.this.font.isDisposed()) {
                                AbstractDiagramEditor.this.font.dispose();
                            }
                            AbstractDiagramEditor.this.font = new Font((Device)PlatformUI.getWorkbench().getDisplay(), fData);
                            AbstractDiagramEditor.this.color = new Color(null, fd.getRGB());
                            ((FreeTextFigure)((FreeTextNodeEditPart)selectedEditPart).getFigure()).setFont(AbstractDiagramEditor.this.font);
                            ((FreeTextFigure)((FreeTextNodeEditPart)selectedEditPart).getFigure()).setForegroundColor(AbstractDiagramEditor.this.color);
                            GraphNode graphNode = ((Node)selectedEditPart.getModel()).getGraphNode();
                            List list = graphNode.getList(9);
                            String text = ((FreeTextFigure)((FreeTextNodeEditPart)selectedEditPart).getFigure()).getText();
                            Property property = this.getPropertyByKey(list, "free text");
                            if (property != null) {
                                property.setValue(text);
                                list.add(property);
                            }
                            this.setProperty(list, "property_font_name", fData.getName());
                            this.setProperty(list, "property_font_style", new Integer(fData.getStyle()).toString());
                            this.setProperty(list, "property_font_height", new Integer(fData.getHeight()).toString());
                            this.setProperty(list, "property_font_red", new Integer(fd.getRGB().red).toString());
                            this.setProperty(list, "property_font_blue", new Integer(fd.getRGB().blue).toString());
                            this.setProperty(list, "property_font_green", new Integer(fd.getRGB().green).toString());
                            selectedEditPart.refresh();
                        }
                    }
                    catch (Exception exception) {
                        exception.printStackTrace();
                    }
                }
                catch (RuntimeException e) {
                    e.printStackTrace();
                }
            }

            public boolean isEnabled() {
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() != 1) {
                    return false;
                }
                EditPart editPart = (EditPart)editParts.get(0);
                if (editPart.getModel() instanceof TypedNode) {
                    return ((TypedNode)editPart.getModel()).getType() == 6;
                }
                return false;
            }

            public Property getPropertyByKey(List list, String key) {
                if (!list.isEmpty()) {
                    Iterator iror = list.iterator();
                    while (iror.hasNext()) {
                        Property property = (Property)iror.next();
                        if (property == null) continue;
                        if (property.getKey().equals(key)) {
                            return property;
                        }
                        return null;
                    }
                }
                return null;
            }

            public void setProperty(List list, String key, String value) {
                Property property = this.getPropertyByKey(list, key);
                if (property != null) {
                    property.setValue(value);
                } else {
                    property = UmaFactory.eINSTANCE.createProperty();
                    property.setKey(key);
                    property.setValue(value);
                }
                list.add(property);
            }
        };
        this.getActionRegistry().registerAction((IAction)action1);
        this.actionService = new DiagramActionService(this.getGraphicalViewer(), this.getEditDomain(), registry);
        this.actionService.registerHorizontalAlignAverageAction();
        this.actionService.registerHorizontalAlignFirstSelectedAction();
        this.actionService.registerVerticalAlignAverageAction();
        this.actionService.registerVerticalAlignFirstSelectedAction();
        action = this.createAnAction(DiagramUIResources.DiagramUI_AbstractDiagram_FreeText_text, this.freeTxtNodeCreationFactory, CREATE_FREE_TEXT, DiagramUIResources.DiagramUI_AbstractDiagram_FreeText_tooltip, AuthoringUIPlugin.getDefault().getImageDescriptor("freetext_pal16.gif"));
        this.getActionRegistry().registerAction(action);
        action = new Action(DiagramUIResources.DiagramUI_moveAction_label){

            public void setImageDescriptor(ImageDescriptor newImage) {
                super.setImageDescriptor(newImage);
            }

            public void runWithEvent(Event event) {
                super.runWithEvent(event);
            }

            public void run() {
                super.run();
            }

            public boolean isEnabled() {
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return editParts.size() > 0;
            }

            public String getId() {
                return AbstractDiagramEditor.MOVE;
            }
        };
        this.getActionRegistry().registerAction(action);
        Action linkAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagram_Link_text){

            public void run() {
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() == 2) {
                    EditPart sourceEditPart = (EditPart)editParts.get(0);
                    EditPart targetEditPart = (EditPart)editParts.get(1);
                    List targetList = new ArrayList();
                    if (sourceEditPart instanceof FreeTextNodeEditPart || targetEditPart instanceof FreeTextNodeEditPart) {
                        return;
                    }
                    if (sourceEditPart instanceof NodeEditPart) {
                        LinkEditPart obj;
                        Iterator itor;
                        targetList = ((NodeEditPart)sourceEditPart).getSourceConnections();
                        if (!targetList.isEmpty()) {
                            itor = targetList.iterator();
                            while (itor.hasNext()) {
                                obj = (LinkEditPart)((Object)itor.next());
                                if (targetEditPart.equals(obj.getSource())) {
                                    return;
                                }
                                if (!targetEditPart.equals(obj.getTarget())) continue;
                                return;
                            }
                        }
                        if (!(targetList = ((NodeEditPart)sourceEditPart).getTargetConnections()).isEmpty()) {
                            itor = targetList.iterator();
                            while (itor.hasNext()) {
                                obj = (LinkEditPart)((Object)itor.next());
                                if (targetEditPart.equals(obj.getSource())) {
                                    return;
                                }
                                if (!targetEditPart.equals(obj.getTarget())) continue;
                                return;
                            }
                        }
                    }
                    Link link = ModelFactory.eINSTANCE.createLink();
                    if (sourceEditPart.getModel() instanceof Node) {
                        link.setSource((Node)sourceEditPart.getModel());
                    }
                    if (targetEditPart.getModel() instanceof Node) {
                        link.setTarget((Node)targetEditPart.getModel());
                    }
                    CreateLinkCommand c = new CreateLinkCommand(link, (Node)sourceEditPart.getModel());
                    AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                }
            }

            public boolean isEnabled() {
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                Iterator itor = editParts.iterator();
                while (itor.hasNext()) {
                    Object part = itor.next();
                    if (!(part instanceof FreeTextNodeEditPart)) continue;
                    return false;
                }
                return editParts.size() == 2;
            }

            public String getId() {
                return AbstractDiagramEditor.CREATE_LINK;
            }
        };
        this.getActionRegistry().registerAction((IAction)linkAction);
        Action selectLinkAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagram_Link_select){

            public void run() {
                List list;
                EditPart part;
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() == 1 && (part = (EditPart)editParts.get(0)) instanceof NodeEditPart && (list = ((NodeEditPart)part).getSourceConnections()) != null && !list.isEmpty()) {
                    LinkEditPart linkpart = (LinkEditPart)((Object)list.get(0));
                    linkpart.setSelected(1);
                    AbstractDiagramEditor.this.getGraphicalViewer().select((EditPart)linkpart);
                }
            }

            public boolean isEnabled() {
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return editParts.size() == 1;
            }

            public String getId() {
                return AbstractDiagramEditor.SELECT_LINK;
            }
        };
        this.getActionRegistry().registerAction((IAction)selectLinkAction);
        Action createBendPointAction = new Action(DiagramUIResources.DiagramUI_AbstractDiagram_BendPoint_create){

            public void run() {
                Link link;
                EList bendpoints;
                EditPart part;
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                if (editParts.size() == 1 && (part = (EditPart)editParts.get(0)) instanceof LinkEditPart && ((bendpoints = (link = (Link)((LinkEditPart)part).getModel()).getBendpoints()) == null || bendpoints.size() < 1)) {
                    Point sp = link.getSourceEndPoint();
                    Point tp = link.getTargetEndPoint();
                    if (sp == null) {
                        sp = link.getSource() == null ? ((Node)link.eContainer()).getLocation() : link.getSource().getLocation();
                    }
                    if (tp == null) {
                        tp = link.getTarget().getLocation();
                    }
                    Point bPoint = new Point();
                    bPoint.x = (sp.x + tp.x) / 2;
                    bPoint.y = (sp.y + tp.y) / 2;
                    CreateBendpointCommand c = new CreateBendpointCommand(link, bPoint, 0);
                    AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                }
            }

            public boolean isEnabled() {
                EditPart part;
                List editParts = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return editParts.size() == 1 && (part = (EditPart)editParts.get(0)) instanceof LinkEditPart;
            }

            public String getId() {
                return AbstractDiagramEditor.CREATE_BEND_POINT;
            }
        };
        this.getActionRegistry().registerAction((IAction)createBendPointAction);
        Action refreshAction = new Action(DiagramUIResources.DiagramUI_refreshAction_label){

            public void run() {
                org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
                if (AbstractDiagramEditor.this.editPart.isActive()) {
                    AbstractDiagramEditor.this.editPart.deactivate();
                }
                diagram.removeConsumer((Object)AbstractDiagramEditor.this);
                AbstractDiagramEditor.this.createEditPart();
                AbstractDiagramEditor.this.getGraphicalViewer().setContents(AbstractDiagramEditor.this.editPart);
            }

            public String getId() {
                return AbstractDiagramEditor.REFRESH;
            }
        };
        this.getActionRegistry().registerAction((IAction)refreshAction);
        Action deleteDiagramAction = new Action(DiagramUIResources.DiagramUI_DeleteDiagram_text){

            public void run() {
                if (AuthoringUIPlugin.getDefault().getMsgDialog().displayPrompt(DiagramUIResources.DiagramUI_DeleteDiagram_text, DiagramUIResources.DiagramUI_DeleteDiagram_prompt)) {
                    org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.getGraphicalViewer().getContents().getModel();
                    EcoreUtil.remove((EObject)diagram.getUMADiagram());
                    AbstractDiagramEditor.this.doSave((IProgressMonitor)new NullProgressMonitor());
                    AbstractDiagramEditor.this.getSite().getPage().closeEditor(AbstractDiagramEditor.this.getSite().getPage().getActiveEditor(), false);
                }
            }

            public boolean isEnabled() {
                return AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().size() == 0;
            }

            public String getId() {
                return AbstractDiagramEditor.DELETE_DIAGRAM;
            }
        };
        this.getActionRegistry().registerAction((IAction)deleteDiagramAction);
        Action alignBendPointAction = new Action(DiagramUIResources.DiagramUI_align_bend_point_text){

            public void run() {
                LinkEditPart linkpart;
                Link link;
                EditPart part = (EditPart)AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts().get(0);
                if (part instanceof LinkEditPart && (link = (Link)(linkpart = (LinkEditPart)part).getModel()).getBendpoints().size() > 0) {
                    LinkEditPart lp;
                    Iterator itor;
                    List list;
                    GraphicalEditPart spart = (GraphicalEditPart)linkpart.getSource();
                    GraphicalEditPart tpart = (GraphicalEditPart)linkpart.getTarget();
                    Point sp = spart.getFigure().getBounds().getCenter();
                    Point tp = tpart.getFigure().getBounds().getCenter();
                    if (spart instanceof DecisionNodeEditPart || spart instanceof SynchBarNodeEditPart) {
                        sp = ((TypedNode)spart.getModel()).getLocation();
                        list = ((NodeEditPart)spart).getSourceConnections();
                        itor = list.iterator();
                        while (itor.hasNext()) {
                            lp = (LinkEditPart)((Object)itor.next());
                            if (!lp.getTarget().equals(tpart)) continue;
                            Point sourceEndPoint = ((Link)lp.getModel()).getSourceEndPoint();
                            sp = sp.getTranslated(sourceEndPoint);
                        }
                    }
                    if (tpart instanceof DecisionNodeEditPart || tpart instanceof SynchBarNodeEditPart) {
                        tp = ((TypedNode)tpart.getModel()).getLocation();
                        list = ((NodeEditPart)tpart).getTargetConnections();
                        itor = list.iterator();
                        while (itor.hasNext()) {
                            lp = (LinkEditPart)((Object)itor.next());
                            if (!lp.getSource().equals(spart)) continue;
                            Point targetEndPoint = ((Link)lp.getModel()).getTargetEndPoint();
                            tp = tp.getTranslated(targetEndPoint);
                        }
                    }
                    int i = 0;
                    while (i < link.getBendpoints().size()) {
                        MoveBendpointCommand c;
                        AbsoluteBendpoint oldbp = (AbsoluteBendpoint)link.getBendpoints().get(i);
                        AbsoluteBendpoint bp = new AbsoluteBendpoint(new Point(-1, -1));
                        AbsoluteBendpoint previousbp = null;
                        int delta = 40;
                        int position = 0;
                        if (i == 0) {
                            position = sp.getPosition((Point)oldbp);
                        } else {
                            previousbp = (AbsoluteBendpoint)link.getBendpoints().get(i - 1);
                            position = previousbp.getPosition((Point)oldbp);
                        }
                        if (position == 4 || position == 1) {
                            if (i == 0) {
                                if (sp.x - delta < oldbp.x && sp.x + delta > oldbp.x && sp.x != oldbp.x) {
                                    bp.x = sp.x;
                                }
                            } else if (previousbp.x - delta < oldbp.x && previousbp.x + delta > oldbp.x && previousbp.x != oldbp.x) {
                                bp.x = previousbp.x;
                            }
                            if (link.getBendpoints().size() - 1 == i) {
                                if (tp.y - delta < oldbp.y && tp.y + delta > oldbp.y && tp.y != oldbp.y) {
                                    bp.y = tp.y;
                                }
                            } else {
                                bp.y = oldbp.y;
                            }
                        }
                        if (position == 16 || position == 8) {
                            if (i == 0) {
                                if (sp.y - delta < oldbp.y && sp.y + delta > oldbp.y && sp.y != oldbp.y) {
                                    bp.y = sp.y;
                                }
                            } else if (previousbp.y - delta < oldbp.y && previousbp.y + delta > oldbp.y && previousbp.y != oldbp.y) {
                                bp.y = previousbp.y;
                            }
                            if (link.getBendpoints().size() - 1 == i) {
                                if (tp.x - delta < oldbp.x && tp.x + delta > oldbp.x && tp.x != oldbp.x) {
                                    bp.x = tp.x;
                                }
                            } else {
                                bp.x = oldbp.x;
                            }
                        }
                        if (bp.x == -1 && bp.y != -1) {
                            c = new MoveBendpointCommand(link, new Point(oldbp.x, bp.y), i);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                        }
                        if (bp.x != -1 && bp.y == -1) {
                            c = new MoveBendpointCommand(link, new Point(bp.x, oldbp.y), i);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                        }
                        if (bp.x != -1 && bp.y != -1) {
                            c = new MoveBendpointCommand(link, new Point(bp.x, bp.y), i);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                        }
                        ++i;
                    }
                }
            }

            public boolean isEnabled() {
                LinkEditPart part;
                Link link;
                List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                return list.size() == 1 && list.get(0) instanceof LinkEditPart && (link = (Link)(part = (LinkEditPart)((Object)list.get(0))).getModel()).getBendpoints().size() > 0;
            }

            public String getId() {
                return AbstractDiagramEditor.ALIGN_BEND_POINT;
            }
        };
        action = new DiagramPrintAction((IWorkbenchPart)this, this.getGraphicalViewer());
        registry.registerAction(action);
        this.getActionRegistry().registerAction((IAction)alignBendPointAction);
    }

    protected IAction createAnAction(String actionName, CreationFactory creationFactory, String actionId, String tooltipString, ImageDescriptor imagedesc) {
        final CreationFactory factory = creationFactory;
        final String id = actionId;
        final String tooltip = tooltipString;
        final ImageDescriptor imagedescriptor = imagedesc;
        return new Action(actionName){

            public void run() {
                CreateRequest request = new CreateRequest();
                if (factory == null) {
                    return;
                }
                request.setFactory(factory);
                request.setLocation(new Point(10, 10));
                if (request.getNewObject() instanceof Node) {
                    Point loc = request.getLocation();
                    org.eclipse.epf.diagram.model.Diagram parent = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.this.editPart.getModel();
                    CreateNodeCommand c = new CreateNodeCommand((Node)request.getNewObject(), parent, loc);
                    AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                }
            }

            public String getId() {
                return id;
            }

            public boolean isEnabled() {
                return !TngUtil.isLocked((EObject)AbstractDiagramEditor.this.getMethodElementFromInput());
            }

            public String getToolTipText() {
                return tooltip;
            }

            public void setImageDescriptor(ImageDescriptor newImage) {
                super.setImageDescriptor(imagedescriptor);
            }

            public ImageDescriptor getImageDescriptor() {
                return imagedescriptor;
            }
        };
    }

    protected PaletteViewerProvider createPaletteViewerProvider() {
        return new PaletteViewerProvider((EditDomain)this.getEditDomain()){
            private IMenuListener menuListener;

            protected void configurePaletteViewer(PaletteViewer viewer) {
                super.configurePaletteViewer(viewer);
                viewer.addDragSourceListener((TransferDragSourceListener)new TemplateTransferDragSourceListener((EditPartViewer)viewer));
            }

            protected void hookPaletteViewer(PaletteViewer viewer) {
                super.hookPaletteViewer(viewer);
                CopyTemplateAction copy = (CopyTemplateAction)AbstractDiagramEditor.this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
                viewer.addSelectionChangedListener((ISelectionChangedListener)copy);
                if (this.menuListener == null) {
                    this.menuListener = new IMenuListener(this, copy){
                        final /* synthetic */ 21 this$1;
                        private final /* synthetic */ CopyTemplateAction val$copy;
                        {
                            this.this$1 = var1_1;
                            this.val$copy = copyTemplateAction;
                        }

                        public void menuAboutToShow(IMenuManager manager) {
                            manager.appendToGroup("org.eclipse.gef.group.copy", (IAction)this.val$copy);
                        }
                    };
                }
                viewer.getContextMenu().addMenuListener(this.menuListener);
            }
        };
    }

    protected FlyoutPaletteComposite.FlyoutPreferences getPalettePreferences() {
        return new FlyoutPaletteComposite.FlyoutPreferences(){

            public int getDockLocation() {
                return AuthoringUIPlugin.getDefault().getPreferenceStore().getInt(AbstractDiagramEditor.PALETTE_DOCK_LOCATION);
            }

            public int getPaletteState() {
                return AuthoringUIPlugin.getDefault().getPreferenceStore().getInt(AbstractDiagramEditor.PALETTE_STATE);
            }

            public int getPaletteWidth() {
                return AuthoringUIPlugin.getDefault().getPreferenceStore().getInt(AbstractDiagramEditor.PALETTE_SIZE);
            }

            public void setDockLocation(int location) {
                AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(AbstractDiagramEditor.PALETTE_DOCK_LOCATION, location);
            }

            public void setPaletteState(int state) {
                AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(AbstractDiagramEditor.PALETTE_STATE, state);
            }

            public void setPaletteWidth(int width) {
                AuthoringUIPlugin.getDefault().getPreferenceStore().setValue(AbstractDiagramEditor.PALETTE_SIZE, width);
            }
        };
    }

    protected KeyHandler getCommonKeyHandler() {
        if (this.sharedKeyHandler == null) {
            this.sharedKeyHandler = new KeyHandler(){

                public boolean keyPressed(KeyEvent event) {
                    if (event.stateMask == 262144 && event.keyCode == 0x1000004) {
                        this.move(1);
                    }
                    if (event.stateMask == 262144 && event.keyCode == 0x1000002) {
                        this.move(2);
                    }
                    if (event.stateMask == 262144 && event.keyCode == 0x1000001) {
                        this.move(3);
                    }
                    if (event.stateMask == 262144 && event.keyCode == 0x1000003) {
                        this.move(4);
                    }
                    return super.keyPressed(event);
                }

                public boolean move(int direction) {
                    List list = AbstractDiagramEditor.this.getGraphicalViewer().getSelectedEditParts();
                    GraphicalEditPart part = (GraphicalEditPart)list.get(0);
                    if (part.getModel() instanceof Node) {
                        Node node = (Node)part.getModel();
                        Point point = node.getLocation();
                        int newx = point.x;
                        int newy = point.y;
                        int presslength = 1;
                        switch (direction) {
                            case 1: {
                                newx = point.x + presslength;
                                break;
                            }
                            case 2: {
                                newy += presslength;
                                break;
                            }
                            case 3: {
                                newy -= presslength;
                                break;
                            }
                            case 4: {
                                newx -= presslength;
                                break;
                            }
                        }
                        ChangeBoundsCommand c = new ChangeBoundsCommand(node, new Point(newx, newy), node.getWidth());
                        AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                        return true;
                    }
                    if (part.getModel() instanceof Link) {
                        Link link = (Link)part.getModel();
                        EList blist = link.getBendpoints();
                        int index = 0;
                        if (blist != null && blist.size() > 0) {
                            AbsoluteBendpoint point = (AbsoluteBendpoint)blist.get(index);
                            int newx = point.x;
                            int newy = point.y;
                            int presslength = 5;
                            switch (direction) {
                                case 1: {
                                    newx = point.x + presslength;
                                    break;
                                }
                                case 2: {
                                    newy += presslength;
                                    break;
                                }
                                case 3: {
                                    newy -= presslength;
                                    break;
                                }
                                case 4: {
                                    newx -= presslength;
                                    break;
                                }
                            }
                            MoveBendpointCommand c = new MoveBendpointCommand(link, new Point(newx, newy), index);
                            AbstractDiagramEditor.this.getCommandStack().execute((org.eclipse.gef.commands.Command)c);
                        }
                    }
                    return true;
                }
            };
            this.sharedKeyHandler.put(KeyStroke.getPressed((char)'\u007f', (int)127, (int)0), this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId()));
            this.sharedKeyHandler.put(KeyStroke.getPressed((int)0x100000B, (int)0), this.getActionRegistry().getAction((Object)"org.eclipse.gef.direct_edit"));
        }
        return this.sharedKeyHandler;
    }

    protected void setGraphicalViewer(GraphicalViewer viewer) {
        super.setGraphicalViewer(viewer);
        if (this.actionService != null) {
            this.actionService.setGraphicalViewer(viewer);
        }
    }

    protected void configureGraphicalViewer() {
        IAction action;
        super.configureGraphicalViewer();
        ScrollingGraphicalViewer viewer = (ScrollingGraphicalViewer)this.getGraphicalViewer();
        ScalableFreeformRootEditPart root = new ScalableFreeformRootEditPart();
        viewer.setRootEditPart((RootEditPart)root);
        viewer.setEditPartFactory(this.createEditPartFactory());
        DiagramContextMenuProvider provider = new DiagramContextMenuProvider((EditPartViewer)this.getGraphicalViewer(), this.getActionRegistry());
        this.getGraphicalViewer().setContextMenu((MenuManager)provider);
        this.getSite().registerContextMenu("org.eclipse.epf.authoring.ui.editors.workflow.contextmenu", (MenuManager)provider, (ISelectionProvider)this.getGraphicalViewer());
        viewer.setKeyHandler(new GraphicalViewerKeyHandler((GraphicalViewer)viewer).setParent(this.getCommonKeyHandler()));
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                AbstractDiagramEditor.this.handleActivationChanged(event);
            }
        };
        this.getGraphicalControl().addListener(26, listener);
        this.getGraphicalControl().addListener(27, listener);
        this.getGraphicalControl().addListener(8, new Listener(){

            public void handleEvent(Event event) {
                AbstractDiagramEditor.this.handleDoubleClick(event);
            }
        });
        if (this.getDiagramType().equalsIgnoreCase("ActivityDetail")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getGraphicalControl(), AuthoringUIHelpContexts.FORM_EDITOR_ACTIVITY_DETAIL_DIAGRAM_CONTEXT);
        } else if (this.getDiagramType().equalsIgnoreCase("Activity")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getGraphicalControl(), AuthoringUIHelpContexts.FORM_EDITOR_ACTIVITY_DIAGRAM_CONTEXT);
        } else if (this.getDiagramType().equalsIgnoreCase("WPDependency")) {
            PlatformUI.getWorkbench().getHelpSystem().setHelp(this.getGraphicalControl(), AuthoringUIHelpContexts.FORM_EDITOR_WP_DEPENDENCY_DIAGRAM_CONTEXT);
        }
        Display display = this.getGraphicalControl().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    block4: {
                        if (AbstractDiagramEditor.this.getPaletteRoot() == null) break block4;
                        MethodElement obj = AbstractDiagramEditor.this.getMethodElementFromInput();
                        if (TngUtil.isLocked((EObject)((EObject)obj))) {
                            List list = AbstractDiagramEditor.this.getPaletteRoot().getChildren();
                            Iterator itor = list.iterator();
                            while (itor.hasNext()) {
                                PaletteEntry entry = (PaletteEntry)itor.next();
                                entry.setVisible(false);
                            }
                        } else {
                            List list = AbstractDiagramEditor.this.getPaletteRoot().getChildren();
                            Iterator itor = list.iterator();
                            while (itor.hasNext()) {
                                PaletteEntry entry = (PaletteEntry)itor.next();
                                entry.setVisible(true);
                            }
                        }
                    }
                }
            });
        }
        this.currentConfig = LibraryService.getInstance().getCurrentMethodConfiguration();
        LibraryService.getInstance().addListener(this.libSvcListener);
        ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
        if (manager != null) {
            manager.addListener(this.libraryListener);
        }
        if ((action = this.getActionRegistry().getAction((Object)ActionFactory.PRINT.getId())) instanceof DiagramPrintAction) {
            ((DiagramPrintAction)action).setViewer((GraphicalViewer)viewer);
        }
    }

    protected abstract EditPartFactory createEditPartFactory();

    protected void handleDoubleClick(Event event) {
    }

    protected void initializeGraphicalViewer() {
        super.initializeGraphicalViewer();
        this.getGraphicalViewer().setContents(this.editPart);
        TransferDropTargetListener listener = this.createDropTargetListener();
        if (listener != null) {
            this.getGraphicalViewer().addDropTargetListener(listener);
        }
    }

    protected void initializeCreationFactories() {
        this.templateNameToCreationFactoryMap = new HashMap();
        if (this.freeTxtNodeCreationFactory == null) {
            this.freeTxtNodeCreationFactory = new CreationFactory(){

                public Object getNewObject() {
                    TypedNode node = ModelFactory.eINSTANCE.createTypedNode();
                    node.setType(6);
                    node.setObject((Object)GraphicalDataHelper.newTypedGraphNode((int)6));
                    return node;
                }

                public Object getObjectType() {
                    return "free text";
                }
            };
        }
        CreationFactory creationFactory = this.freeTxtNodeCreationFactory;
        this.templateNameToCreationFactoryMap.put(creationFactory.getObjectType(), creationFactory);
    }

    protected TransferDropTargetListener createDropTargetListener() {
        return new TemplateTransferDropTargetListener((EditPartViewer)this.getGraphicalViewer()){

            protected CreationFactory getFactory(Object template) {
                return (CreationFactory)AbstractDiagramEditor.this.templateNameToCreationFactoryMap.get(template);
            }
        };
    }

    protected void handleActivationChanged(Event event) {
        IAction copy = null;
        if (event.type == 27) {
            copy = this.getActionRegistry().getAction((Object)ActionFactory.COPY.getId());
        }
        if (this.getEditorSite().getActionBars().getGlobalActionHandler(ActionFactory.COPY.getId()) != copy) {
            this.getEditorSite().getActionBars().setGlobalActionHandler(ActionFactory.COPY.getId(), copy);
            this.getEditorSite().getActionBars().updateActionBars();
        }
    }

    protected PaletteRoot getPaletteRoot() {
        if (this.paletteRoot == null) {
            this.createPaletteRoot();
        }
        return this.paletteRoot;
    }

    private void createPaletteRoot() {
        this.paletteRoot = new PaletteRoot();
        this.paletteRoot.addAll(this.createCategories(this.paletteRoot));
    }

    private List createCategories(PaletteRoot root) {
        ArrayList<PaletteContainer> categories = new ArrayList<PaletteContainer>();
        PaletteContainer paletteContainer = this.createControlGroup(root);
        if (paletteContainer != null) {
            categories.add(paletteContainer);
        }
        return categories;
    }

    protected PaletteContainer createControlGroup(PaletteRoot root) {
        return null;
    }

    protected MethodElement getMethodElementFromInput() {
        IEditorInput input = this.getEditorInput();
        if (input instanceof MethodElementEditorInput) {
            return ((MethodElementEditorInput)input).getMethodElement();
        }
        return null;
    }

    public void doSave(final IProgressMonitor monitor) {
        final MethodElement e = this.getMethodElementFromInput();
        if (e == null) {
            return;
        }
        SafeRunnable.run((ISafeRunnable)new SafeRunnable(){

            /*
             * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
             * Unable to fully structure code
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            public void run() throws Exception {
                try {
                    monitor.beginTask(DiagramUIResources.DiagramUI_AbstractDiagramEditor_Save_text, -1);
                    monitor.setTaskName(DiagramUIResources.bind(DiagramUIResources.DiagramUI_AbstractDiagramEditor_Save_message, e.eResource().getURI().toFileString()));
                    persister = ContentDescriptionFactory.getMethodLibraryPersister().getFailSafePersister();
                    try {
                        persister.save(e.eResource());
                        persister.commit();
                        diagram = (org.eclipse.epf.diagram.model.Diagram)AbstractDiagramEditor.access$0(AbstractDiagramEditor.this).getContents().getModel();
                        diagram.setNew(false);
                    }
                    catch (Exception e) {
                        AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)e);
                        try {
                            persister.rollback();
                        }
                        catch (Exception ex) {
                            AuthoringUIPlugin.getDefault().getLogger().logError((Throwable)ex);
                            ViewHelper.reloadCurrentLibaryOnRollbackError(AbstractDiagramEditor.this.getSite().getShell());
lbl20:
                            // 2 sources

                            while (true) {
                                var4_5 = null;
                                monitor.done();
                                return;
                            }
                        }
                        AuthoringUIPlugin.getDefault().getMsgDialog().displayWarning(AbstractDiagramEditor.this.getSite().getShell().getText(), DiagramUIResources.DiagramUI_diagram_saveError, e.getMessage(), (Throwable)e);
                        ** continue;
                    }
                    AbstractDiagramEditor.access$11(AbstractDiagramEditor.this).getCommandStack().markSaveLocation();
                    AbstractDiagramEditor.this.changeTime = -1L;
                    AbstractDiagramEditor.access$5(AbstractDiagramEditor.this, 257);
                }
                catch (Throwable var5_8) {
                    var4_6 = null;
                    monitor.done();
                    throw var5_8;
                }
                {
                    var4_7 = null;
                }
                monitor.done();
            }
        });
    }

    public void doSaveAs() {
    }

    public boolean isDirty() {
        return this.getEditDomain().getCommandStack().isDirty();
    }

    public boolean isSaveAsAllowed() {
        return false;
    }

    protected boolean isReadOnly() {
        if (this.editPart != null) {
            org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel();
            return diagram != null && diagram.isReadOnly();
        }
        return false;
    }

    private void createEditPart() {
        BreakdownElementEditorInput editorInput = (BreakdownElementEditorInput)this.getEditorInput();
        Object object = editorInput.getWrapper() != null ? editorInput.getWrapper() : editorInput.getMethodElement();
        this.changeTime = System.currentTimeMillis();
        this.editPart = this.createDiagramEditPart();
        org.eclipse.epf.diagram.model.Diagram diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel();
        diagram.setSuppression(editorInput.getSuppression());
        diagram.setObject(object);
        diagram.addConsumer((Object)this);
        if (!diagram.isNew()) {
            this.changeTime = -1L;
        }
    }

    protected void setInput(IEditorInput input) {
        super.setInput(input);
        MethodElement e = this.getMethodElementFromInput();
        if (e != null) {
            this.createEditPart();
            BreakdownElementEditorInput editorInput = (BreakdownElementEditorInput)this.getEditorInput();
            this.setPartName(String.valueOf(this.getPartNamePrefix()) + e.getName() + ", " + editorInput.getSuppression().getProcess().getName());
        }
    }

    protected abstract EditPart createDiagramEditPart();

    protected abstract String getPartNamePrefix();

    protected abstract String getDiagramType();

    public IEditorPart getParentEditor() {
        return this.parentEditor;
    }

    public void setParentEditor(IEditorPart parentEditor) {
        this.parentEditor = parentEditor;
    }

    private void configChanged() {
        MethodConfiguration config = LibraryService.getInstance().getCurrentMethodConfiguration();
        if (this.currentConfig != config) {
            boolean refresh;
            IWorkbenchPart activePart = this.getSite().getWorkbenchWindow().getPartService().getActivePart();
            boolean bl = refresh = activePart == this;
            if (!refresh && activePart instanceof ProcessEditor) {
                MethodElementEditorInput input = (MethodElementEditorInput)((ProcessEditor)activePart).getEditorInput();
                MethodElement procComp = input.getMethodElement();
                Diagram diagram = ((org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel()).getUMADiagram();
                refresh = UmaUtil.isContainedBy((EObject)diagram, (Object)procComp);
            }
            if (refresh) {
                this.currentConfig = config;
                IAction action = this.getActionRegistry().getAction((Object)REFRESH);
                action.run();
            }
        }
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        org.eclipse.epf.diagram.model.Diagram diagram;
        super.selectionChanged(part, selection);
        if (this.editPart != null && ((diagram = (org.eclipse.epf.diagram.model.Diagram)this.editPart.getModel()).isReadOnly() || TngUtil.isLocked((EObject)this.getMethodElementFromInput()))) {
            this.getGraphicalViewer().select(this.editPart);
        }
    }

    static /* synthetic */ DefaultEditDomain access$11(AbstractDiagramEditor abstractDiagramEditor) {
        return abstractDiagramEditor.getEditDomain();
    }

    class DiagramContextMenuProvider
    extends ContextMenuProvider {
        private ActionRegistry actionRegistry;

        public DiagramContextMenuProvider(EditPartViewer viewer, ActionRegistry registry) {
            super(viewer);
            this.setActionRegistry(registry);
        }

        public void buildContextMenu(IMenuManager menu) {
            IAction bendpointAction;
            IAction selectlinkAction;
            IAction linkAction;
            IAction createFreeTextAction;
            GEFActionConstants.addStandardActionGroups((IMenuManager)menu);
            IAction action = this.getActionRegistry().getAction((Object)ActionFactory.UNDO.getId());
            menu.appendToGroup("org.eclipse.gef.group.undo", action);
            action = this.getActionRegistry().getAction((Object)ActionFactory.REDO.getId());
            menu.appendToGroup("org.eclipse.gef.group.undo", action);
            boolean canModify = !AbstractDiagramEditor.this.isReadOnly();
            action = this.getActionRegistry().getAction((Object)ActionFactory.DELETE.getId());
            if (action.isEnabled() && canModify && !TngUtil.isLocked((EObject)AbstractDiagramEditor.this.getMethodElementFromInput())) {
                menu.appendToGroup("org.eclipse.gef.group.edit", action);
            }
            action = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.REFRESH);
            menu.appendToGroup("org.eclipse.gef.group.view", action);
            action = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.FONT_DIALOG);
            if (action.isEnabled() && canModify) {
                menu.appendToGroup("additions", action);
            }
            if ((createFreeTextAction = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.CREATE_FREE_TEXT)).isEnabled() && canModify) {
                menu.appendToGroup("additions", createFreeTextAction);
            }
            if ((linkAction = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.CREATE_LINK)).isEnabled() && canModify) {
                menu.appendToGroup("additions", linkAction);
            }
            if ((selectlinkAction = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.SELECT_LINK)).isEnabled()) {
                menu.appendToGroup("additions", selectlinkAction);
            }
            if ((bendpointAction = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.CREATE_BEND_POINT)).isEnabled() && canModify) {
                menu.appendToGroup("additions", bendpointAction);
            }
            IAction alignbendpointaction = this.getActionRegistry().getAction((Object)AbstractDiagramEditor.ALIGN_BEND_POINT);
            if (bendpointAction.isEnabled() && canModify) {
                menu.appendToGroup("additions", alignbendpointaction);
            }
            AbstractDiagramEditor.this.contributeToContextMenu(menu);
        }

        private ActionRegistry getActionRegistry() {
            return this.actionRegistry;
        }

        public void setActionRegistry(ActionRegistry registry) {
            this.actionRegistry = registry;
        }
    }
}

