/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.epf.authoring.ui.forms;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import org.eclipse.emf.common.notify.AdapterFactory;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.EStructuralFeature;
import org.eclipse.emf.edit.ui.provider.AdapterFactoryContentProvider;
import org.eclipse.epf.authoring.ui.AuthoringUIImages;
import org.eclipse.epf.authoring.ui.AuthoringUIPlugin;
import org.eclipse.epf.authoring.ui.AuthoringUIResources;
import org.eclipse.epf.authoring.ui.AuthoringUIText;
import org.eclipse.epf.authoring.ui.dialogs.SectionsOrderDialog;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditor;
import org.eclipse.epf.authoring.ui.editors.MethodElementEditorInput;
import org.eclipse.epf.authoring.ui.forms.BaseFormPage;
import org.eclipse.epf.authoring.ui.forms.MethodFormToolkit;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichText;
import org.eclipse.epf.authoring.ui.richtext.IMethodRichTextEditor;
import org.eclipse.epf.authoring.ui.util.EditorsContextHelper;
import org.eclipse.epf.common.utils.StrUtil;
import org.eclipse.epf.library.ILibraryManager;
import org.eclipse.epf.library.LibraryService;
import org.eclipse.epf.library.edit.TngAdapterFactory;
import org.eclipse.epf.library.edit.command.AddToSectionListCommand;
import org.eclipse.epf.library.edit.command.IActionManager;
import org.eclipse.epf.library.edit.command.IResourceAwareCommand;
import org.eclipse.epf.library.edit.command.MoveInSectionListCommand;
import org.eclipse.epf.library.edit.command.RemoveFromSectionList;
import org.eclipse.epf.library.edit.util.SectionList;
import org.eclipse.epf.library.edit.util.TngUtil;
import org.eclipse.epf.library.edit.util.VariabilityElementLabelProvider;
import org.eclipse.epf.library.events.ILibraryChangeListener;
import org.eclipse.epf.library.ui.LibraryUIText;
import org.eclipse.epf.richtext.RichTextListener;
import org.eclipse.epf.uma.Checklist;
import org.eclipse.epf.uma.ContentElement;
import org.eclipse.epf.uma.MethodElement;
import org.eclipse.epf.uma.Section;
import org.eclipse.epf.uma.UmaFactory;
import org.eclipse.epf.uma.UmaPackage;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorSite;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.forms.IManagedForm;
import org.eclipse.ui.forms.editor.FormEditor;
import org.eclipse.ui.forms.events.HyperlinkAdapter;
import org.eclipse.ui.forms.events.HyperlinkEvent;
import org.eclipse.ui.forms.events.IHyperlinkListener;
import org.eclipse.ui.forms.widgets.ImageHyperlink;
import org.eclipse.ui.forms.widgets.TableWrapData;

public class ChecklistItemsPage
extends BaseFormPage {
    private static final String FORM_PAGE_ID = "checklistCheckItemsPage";
    private Text ctrl_name;
    private Button ctrl_add;
    private Button ctrl_delete;
    private Button ctrl_up;
    private Button ctrl_down;
    private Button ctrl_order;
    private Table ctrl_checkItems;
    private TableViewer checkItemsTableViewer;
    private SectionList allcheckItems;
    private IMethodRichText activeControl;
    private boolean descExpandFlag = false;
    private IMethodRichTextEditor ctrl_expanded;
    private ImageHyperlink expandLink;
    private Label expandLabel;
    private org.eclipse.ui.forms.widgets.Section generalSection;
    private Composite generalComposite;
    private Composite expandedComposite;
    private IMethodRichText ctrl_maindesc;
    private IStructuredContentProvider checkItemsViewerContentProvider;
    private ILabelProvider checkItemsViewerLabelProvider;
    private Checklist checklist;
    private Section currentItem;
    private ILibraryChangeListener libListener = null;
    private MethodElementEditor.ModifyListener contentModifyListener;
    private IActionManager actionMgr;

    public ChecklistItemsPage(FormEditor editor) {
        super(editor, FORM_PAGE_ID, AuthoringUIText.CHECK_ITEMS_TEXT);
    }

    public void init(IEditorSite site, IEditorInput input) {
        super.init(site, input);
        MethodElementEditorInput methodElementInput = (MethodElementEditorInput)input;
        this.checklist = (Checklist)methodElementInput.getMethodElement();
    }

    protected void createFormContent(IManagedForm managedForm) {
        super.createFormContent(managedForm);
        String elementLabel = LibraryUIText.getUIText((MethodElement)this.methodElement);
        this.form.setText(String.valueOf(LibraryUIText.TEXT_GUIDANCE) + " (" + elementLabel + "): " + this.methodElement.getName());
        this.generalSection = this.toolkit.createSection(this.form.getBody(), 450);
        this.generalSection.setLayoutData((Object)new TableWrapData(256));
        this.generalSection.setText(AuthoringUIText.CHECK_ITEMS_SECTION_NAME);
        this.generalSection.setDescription(AuthoringUIText.CHECK_ITEMS_SECTION_DESC);
        this.generalSection.setLayout((Layout)new GridLayout());
        this.generalComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.generalComposite.setLayoutData((Object)new GridData(768));
        this.generalComposite.setLayout((Layout)new GridLayout(4, false));
        this.generalSection.setClient((Control)this.generalComposite);
        EditorsContextHelper.setHelp((Control)this.generalComposite.getParent(), this.checklist);
        Composite pane1 = this.toolkit.createComposite(this.generalComposite);
        GridData gridData = new GridData(1808);
        gridData.verticalSpan = 1;
        gridData.horizontalSpan = 3;
        pane1.setLayoutData((Object)gridData);
        pane1.setLayout((Layout)new GridLayout());
        Label l_name = this.toolkit.createLabel(pane1, AuthoringUIText.CHECK_ITEMS_TEXT);
        GridData gridData2 = new GridData(1);
        gridData2.horizontalSpan = 3;
        l_name.setLayoutData((Object)gridData2);
        this.ctrl_checkItems = this.toolkit.createTable(pane1, 2);
        gridData2 = new GridData(1808);
        gridData2.horizontalSpan = 3;
        gridData2.heightHint = 150;
        this.ctrl_checkItems.setLayoutData((Object)gridData2);
        this.initProviders();
        this.checkItemsTableViewer = new TableViewer(this.ctrl_checkItems);
        this.checkItemsTableViewer.setContentProvider((IContentProvider)this.checkItemsViewerContentProvider);
        this.checkItemsTableViewer.setLabelProvider((IBaseLabelProvider)this.checkItemsViewerLabelProvider);
        Composite pane2 = this.toolkit.createComposite(this.generalComposite);
        pane2.setLayoutData((Object)new GridData(68));
        pane2.setLayout((Layout)new GridLayout());
        this.ctrl_add = this.toolkit.createButton(pane2, AuthoringUIText.ADD_BUTTON_TEXT, 0);
        this.ctrl_add.setLayoutData((Object)new GridData(768));
        this.ctrl_delete = this.toolkit.createButton(pane2, AuthoringUIText.DELETE_BUTTON_TEXT, 0);
        this.ctrl_delete.setLayoutData((Object)new GridData(768));
        this.ctrl_delete.setEnabled(false);
        this.ctrl_up = this.toolkit.createButton(pane2, AuthoringUIText.UP_BUTTON_TEXT, 0);
        this.ctrl_up.setLayoutData((Object)new GridData(768));
        this.ctrl_up.setEnabled(false);
        this.ctrl_down = this.toolkit.createButton(pane2, AuthoringUIText.DOWN_BUTTON_TEXT, 0);
        this.ctrl_down.setLayoutData((Object)new GridData(768));
        this.ctrl_down.setEnabled(false);
        this.ctrl_order = this.toolkit.createButton(pane2, AuthoringUIText.ORDER_BUTTON_TEXT, 0);
        this.ctrl_order.setLayoutData((Object)new GridData(768));
        Label nameLabel = this.toolkit.createLabel(this.generalComposite, AuthoringUIText.NAME_TEXT);
        GridData gridData3 = new GridData(1);
        gridData3.horizontalSpan = 4;
        nameLabel.setLayoutData((Object)gridData3);
        this.ctrl_name = this.toolkit.createText(this.generalComposite, "", 4);
        gridData3 = new GridData(768);
        gridData3.horizontalSpan = 4;
        this.ctrl_name.setLayoutData((Object)gridData3);
        ChecklistItemsPage.createBlankLabel(this.toolkit, this.generalComposite, 4);
        ImageHyperlink link = this.createImageHyperlink(this.toolkit, this.generalComposite, null, AuthoringUIImages.IMG_COLLAPSED);
        link.setToolTipText(AuthoringUIResources.AuthoringUI_openRTE);
        ChecklistItemsPage.createLabel(this.toolkit, this.generalComposite, AuthoringUIText.DESCRIPTION_TEXT);
        GridData gridData4 = new GridData(1);
        gridData4.horizontalSpan = 4;
        this.ctrl_maindesc = MethodFormToolkit.createRichText(this.toolkit, this.generalComposite, "", 578, this.contentElementPath, (MethodElement)this.checklist);
        gridData4 = new GridData(768);
        gridData4.heightHint = 250;
        gridData4.widthHint = 300;
        gridData4.horizontalSpan = 4;
        this.ctrl_maindesc.setLayoutData(gridData4);
        link.setHref((Object)this.ctrl_maindesc);
        link.setData("Title", (Object)AuthoringUIText.DESCRIPTION_TEXT);
        link.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ChecklistItemsPage.this.toggle(e);
            }
        });
        this.createRichTextEditorSection();
        this.toolkit.paintBordersFor(pane1);
        this.toolkit.paintBordersFor(pane2);
        this.toolkit.paintBordersFor(this.generalComposite);
        this.toolkit.paintBordersFor(this.expandedComposite);
        this.actionMgr = ((MethodElementEditor)this.getEditor()).getActionManager();
        this.addListeners();
        this.loadData();
        this.enableControls();
    }

    public void addListeners() {
        final MethodElementEditor editor = (MethodElementEditor)this.getEditor();
        this.contentModifyListener = editor.createModifyListener((EObject)this.currentItem);
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.contentModifyListener.setDisable(true);
        this.form.addListener(26, new Listener(){

            public void handleEvent(Event e) {
                ChecklistItemsPage.this.loadData();
                if (TngUtil.isLocked((EObject)ChecklistItemsPage.this.contentElement)) {
                    ChecklistItemsPage.this.enableControls(false);
                } else {
                    ChecklistItemsPage.this.ctrl_add.setEnabled(true);
                    ChecklistItemsPage.this.checkSelection();
                }
            }
        });
        this.form.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                ChecklistItemsPage.this.deactivate();
            }
        });
        this.ctrl_name.addModifyListener((ModifyListener)this.contentModifyListener);
        this.ctrl_name.addFocusListener((FocusListener)new FocusAdapter(){

            public void focusLost(FocusEvent e) {
                if (ChecklistItemsPage.this.currentItem != null) {
                    String oldName = ChecklistItemsPage.this.currentItem.getName();
                    String newName = ChecklistItemsPage.this.ctrl_name.getText();
                    newName = StrUtil.makeValidFileName((String)newName);
                    if (ChecklistItemsPage.this.ctrl_name.getText() == null || ChecklistItemsPage.this.ctrl_name.getText().length() == 0) {
                        String title = AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_renameDialog_title, (Object)LibraryUIText.TEXT_CHECK_ITEM);
                        String msg = AuthoringUIResources.bind((String)AuthoringUIResources.AuthoringUI_emptyElementNameError_msg, (Object)StrUtil.toLower((String)LibraryUIText.TEXT_CHECK_ITEM));
                        if (oldName != null && oldName.length() > 0) {
                            AuthoringUIPlugin.getDefault().getMsgDialog().displayError(title, msg);
                        } else {
                            ChecklistItemsPage.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage(PlatformUI.getWorkbench().getSharedImages().getImage("IMG_OBJS_ERROR_TSK"), msg);
                        }
                    } else if (!oldName.equals(newName)) {
                        editor.getActionManager().doAction(1, (EObject)ChecklistItemsPage.this.currentItem, (EStructuralFeature)UmaPackage.eINSTANCE.getNamedElement_Name(), (Object)newName, -1);
                    }
                }
            }
        });
        this.ctrl_maindesc.addModifyListener(this.contentModifyListener);
        this.ctrl_maindesc.addListener(27, new Listener(){

            public void handleEvent(Event e) {
                ChecklistItemsPage.this.saveMainDescription();
            }
        });
        this.checkItemsTableViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ChecklistItemsPage.this.checkSelection();
            }
        });
        this.ctrl_add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                Section child = UmaFactory.eINSTANCE.createSection();
                String newName = MessageFormat.format(AuthoringUIText.NEW_ELEMENT_TEXT, LibraryUIText.TEXT_CHECK_ITEM);
                child.setName(newName);
                AddToSectionListCommand cmd = new AddToSectionListCommand((ContentElement)ChecklistItemsPage.this.checklist, child, ChecklistItemsPage.this.allcheckItems);
                ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                ChecklistItemsPage.this.checkItemsTableViewer.setSelection((ISelection)new StructuredSelection((Object)child));
                ChecklistItemsPage.this.ctrl_name.setFocus();
                ChecklistItemsPage.this.ctrl_name.setSelection(0, newName.length());
                ChecklistItemsPage.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("");
            }
        });
        this.ctrl_delete.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ChecklistItemsPage.this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("");
                IStructuredSelection selection = (IStructuredSelection)ChecklistItemsPage.this.checkItemsTableViewer.getSelection();
                Iterator iter = selection.toList().iterator();
                while (iter.hasNext()) {
                    Object o = iter.next();
                    if (!(o instanceof Section)) continue;
                    RemoveFromSectionList cmd = new RemoveFromSectionList((ContentElement)ChecklistItemsPage.this.checklist, (Section)o, ChecklistItemsPage.this.allcheckItems);
                    ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                }
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                ChecklistItemsPage.this.editItem(null);
            }
        });
        this.ctrl_up.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChecklistItemsPage.this.checkItemsTableViewer.getSelection();
                ArrayList moveUpItems = new ArrayList();
                moveUpItems.addAll(selection.toList());
                MoveInSectionListCommand cmd = new MoveInSectionListCommand((ContentElement)ChecklistItemsPage.this.checklist, moveUpItems, ChecklistItemsPage.this.allcheckItems, 1);
                ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(false);
                }
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() < ChecklistItemsPage.this.checkItemsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_down.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                IStructuredSelection selection = (IStructuredSelection)ChecklistItemsPage.this.checkItemsTableViewer.getSelection();
                ArrayList moveDownItems = new ArrayList();
                moveDownItems.addAll(selection.toList());
                MoveInSectionListCommand cmd = new MoveInSectionListCommand((ContentElement)ChecklistItemsPage.this.checklist, moveDownItems, ChecklistItemsPage.this.allcheckItems, 0);
                ChecklistItemsPage.this.getActionManager().execute((IResourceAwareCommand)cmd);
                ChecklistItemsPage.this.checkItemsTableViewer.refresh();
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_up.setEnabled(false);
                }
                if (ChecklistItemsPage.this.checkItemsTableViewer.getTable().getSelectionIndex() < ChecklistItemsPage.this.checkItemsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)ChecklistItemsPage.this.checklist)) {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(true);
                } else {
                    ChecklistItemsPage.this.ctrl_down.setEnabled(false);
                }
            }
        });
        this.ctrl_order.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SectionsOrderDialog dlg = new SectionsOrderDialog(Display.getCurrent().getActiveShell(), (ContentElement)ChecklistItemsPage.this.checklist, ChecklistItemsPage.this.getActionManager(), AuthoringUIResources.AuthoringUI_ChecklistOrder_title, AuthoringUIResources.AuthoringUI_ChecklistOrder_description, AuthoringUIResources.AuthoringUI_ChecklistOrder_checklistitems_text);
                dlg.open();
            }
        });
    }

    protected void enableControls(boolean editable) {
        this.ctrl_name.setEditable(editable);
        this.ctrl_maindesc.setEditable(editable);
        this.ctrl_add.setEnabled(editable);
        this.ctrl_delete.setEnabled(editable);
        this.ctrl_up.setEnabled(editable);
        this.ctrl_down.setEnabled(editable);
        this.ctrl_order.setEnabled(true);
        if (this.ctrl_expanded != null) {
            this.ctrl_expanded.setEditable(editable);
        }
    }

    protected void deactivate() {
        if (this.allcheckItems != null) {
            this.allcheckItems.apply();
        }
    }

    private void loadData() {
        this.allcheckItems = null;
        this.checkItemsTableViewer.setInput((Object)this.checklist);
        this.checkItemsTableViewer.refresh();
        this.editItem(this.currentItem);
    }

    private void editItem(Section item) {
        this.contentModifyListener.setDisable(true);
        if (this.ctrl_maindesc.getModified()) {
            this.saveMainDescription();
        }
        this.currentItem = item;
        String name = "";
        String desc = "";
        if (this.currentItem != null) {
            name = this.currentItem.getName();
            desc = this.currentItem.getSectionDescription();
            this.ctrl_name.setFocus();
            this.getEditorSite().getActionBars().getStatusLineManager().setErrorMessage("");
        }
        this.ctrl_name.setText(name == null ? "" : name);
        this.ctrl_maindesc.setText(desc == null ? "" : desc);
        this.ctrl_maindesc.setModalObject((EObject)this.currentItem);
        this.ctrl_maindesc.setModalObjectFeature((EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription());
        this.contentModifyListener.setElement((EObject)this.currentItem);
        this.contentModifyListener.setDisable(this.currentItem == null);
        this.enableControls();
    }

    private void enableControls() {
        if (this.checklist.getPresentation().getSections().contains(this.currentItem)) {
            if (!TngUtil.isLocked((EObject)this.contentElement)) {
                this.ctrl_name.setEditable(true);
                this.ctrl_maindesc.setEditable(true);
            }
        } else {
            this.ctrl_name.setEditable(false);
            this.ctrl_maindesc.setEditable(false);
        }
    }

    public void dispose() {
        if (this.libListener != null) {
            ILibraryManager manager = LibraryService.getInstance().getCurrentLibraryManager();
            if (manager != null) {
                manager.removeListener(this.libListener);
            }
            this.libListener = null;
        }
    }

    private void createRichTextEditorSection() {
        this.expandedComposite = this.toolkit.createComposite((Composite)this.generalSection);
        this.expandedComposite.setLayoutData((Object)new GridData(768));
        this.expandedComposite.setLayout((Layout)new GridLayout(2, false));
        this.expandedComposite.setVisible(false);
        this.expandLink = this.toolkit.createImageHyperlink(this.expandedComposite, 0);
        this.expandLink.setImage(AuthoringUIImages.IMG_EXPANDED);
        this.expandLink.setToolTipText(AuthoringUIResources.AuthoringUI_closeRTE);
        this.expandLink.setUnderlined(false);
        this.expandLink.addHyperlinkListener((IHyperlinkListener)new HyperlinkAdapter(){

            public void linkActivated(HyperlinkEvent e) {
                ChecklistItemsPage.this.toggle(e);
            }
        });
        this.expandLabel = ChecklistItemsPage.createLabel(this.toolkit, this.expandedComposite, "");
    }

    protected void toggle(HyperlinkEvent e) {
        if (this.currentItem == null) {
            return;
        }
        if (this.ctrl_expanded == null) {
            this.ctrl_expanded = this.createRichTextEditor(this.toolkit, this.expandedComposite, 578, 1808, 400, 400, 2);
            this.ctrl_expanded.addModifyListener(this.contentModifyListener);
        }
        if (this.descExpandFlag) {
            this.generalComposite.setVisible(true);
            this.expandedComposite.setVisible(false);
            this.generalSection.setClient((Control)this.generalComposite);
            IMethodRichText richText = this.getActiveRichTextControl();
            richText.setText(this.ctrl_expanded.getText());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.removeListener(listener.getEventType(), listener.getListener());
            }
            if (this.ctrl_expanded.getModified()) {
                ((MethodElementEditor)this.getEditor()).saveModifiedRichText(this.ctrl_expanded);
            }
            richText.setFocus();
        } else {
            this.generalComposite.setVisible(false);
            this.expandedComposite.setVisible(true);
            this.generalSection.setClient((Control)this.expandedComposite);
            this.expandLabel.setText(String.valueOf(this.currentItem.getName()) + " - " + (String)((ImageHyperlink)e.getSource()).getData("Title"));
            IMethodRichText richText = (IMethodRichText)e.getHref();
            this.ctrl_expanded.setText(richText.getText());
            this.ctrl_expanded.setModalObject(richText.getModalObject());
            this.ctrl_expanded.setModalObjectFeature(richText.getModalObjectFeature());
            Iterator i = richText.getListeners();
            while (i.hasNext()) {
                RichTextListener listener = (RichTextListener)i.next();
                this.ctrl_expanded.addListener(listener.getEventType(), listener.getListener());
            }
            boolean editable = !TngUtil.isLocked((EObject)this.contentElement);
            this.ctrl_expanded.setEditable(editable);
            if (editable) {
                this.ctrl_expanded.setFocus();
            }
            this.setActiveRichTextControl(richText);
        }
        this.generalSection.layout(true);
        this.descExpandFlag = !this.descExpandFlag;
    }

    private void setActiveRichTextControl(IMethodRichText editor) {
        this.activeControl = editor;
    }

    private IMethodRichText getActiveRichTextControl() {
        return this.activeControl;
    }

    private void initProviders() {
        this.checkItemsViewerContentProvider = new AdapterFactoryContentProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public Object[] getElements(Object object) {
                if (object != ChecklistItemsPage.this.checklist) {
                    return super.getElements(object);
                }
                if (ChecklistItemsPage.this.allcheckItems == null) {
                    ChecklistItemsPage.this.allcheckItems = new SectionList((ContentElement)ChecklistItemsPage.this.checklist, 1);
                }
                return ChecklistItemsPage.this.allcheckItems.toArray();
            }
        };
        this.checkItemsViewerLabelProvider = new VariabilityElementLabelProvider((AdapterFactory)TngAdapterFactory.INSTANCE.getNavigatorView_ComposedAdapterFactory()){

            public boolean isExternal(Object element) {
                return !ChecklistItemsPage.this.checklist.getPresentation().getSections().contains(element);
            }
        };
    }

    private void saveMainDescription() {
        if (this.currentItem != null) {
            IMethodRichText control;
            IMethodRichText iMethodRichText = control = this.descExpandFlag ? this.ctrl_expanded : this.ctrl_maindesc;
            if (!control.getModified()) {
                return;
            }
            String oldContent = this.currentItem.getSectionDescription();
            if (((MethodElementEditor)this.getEditor()).mustRestoreValue(control, oldContent)) {
                return;
            }
            String newContent = control.getText();
            if (!newContent.equals(oldContent)) {
                this.actionMgr.doAction(1, (EObject)this.currentItem, (EStructuralFeature)UmaPackage.eINSTANCE.getSection_SectionDescription(), (Object)newContent, -1);
            }
        }
    }

    protected IActionManager getActionManager() {
        FormEditor editor = this.getEditor();
        if (editor instanceof MethodElementEditor) {
            return ((MethodElementEditor)editor).getActionManager();
        }
        return null;
    }

    private void checkSelection() {
        IStructuredSelection selection = (IStructuredSelection)this.checkItemsTableViewer.getSelection();
        if (selection.size() > 0 && !TngUtil.isLocked((EObject)this.checklist)) {
            this.ctrl_delete.setEnabled(true);
            if (this.checkItemsTableViewer.getTable().getSelectionIndex() > 0 && !TngUtil.isLocked((EObject)this.checklist) && selection.size() == 1) {
                this.ctrl_up.setEnabled(true);
            } else {
                this.ctrl_up.setEnabled(false);
            }
            if (this.checkItemsTableViewer.getTable().getSelectionIndex() < this.checkItemsTableViewer.getTable().getItemCount() - 1 && !TngUtil.isLocked((EObject)this.checklist) && selection.size() == 1) {
                this.ctrl_down.setEnabled(true);
            } else {
                this.ctrl_down.setEnabled(false);
            }
        }
        if (selection.size() == 1) {
            this.editItem((Section)selection.getFirstElement());
        }
    }
}

